/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics.memory;

import java.util.Collections;
import org.apache.iotdb.commons.memory.MemoryManager;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.conf.DataNodeMemoryConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.service.metrics.memory.GlobalMemoryMetrics;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class OffHeapMemoryMetrics
implements IMetricSet {
    private static final DataNodeMemoryConfig memoryConfig = IoTDBDescriptor.getInstance().getMemoryConfig();
    private static final String DIRECT_BUFFER = "DirectBuffer";

    public void bindTo(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.MEMORY_THRESHOLD_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getDirectBufferMemoryManager(), MemoryManager::getTotalMemorySizeInBytes, new String[]{Tag.NAME.toString(), DIRECT_BUFFER, Tag.TYPE.toString(), "OffHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[1]});
        metricService.createAutoGauge(Metric.MEMORY_ACTUAL_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getDirectBufferMemoryManager(), MemoryManager::getUsedMemorySizeInBytes, new String[]{Tag.NAME.toString(), DIRECT_BUFFER, Tag.TYPE.toString(), "OffHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[1]});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        Collections.singletonList(DIRECT_BUFFER).forEach(name -> {
            metricService.remove(MetricType.AUTO_GAUGE, Metric.MEMORY_THRESHOLD_SIZE.toString(), new String[]{Tag.NAME.toString(), name, Tag.TYPE.toString(), "OffHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[1]});
            metricService.remove(MetricType.AUTO_GAUGE, Metric.MEMORY_ACTUAL_SIZE.toString(), new String[]{Tag.NAME.toString(), name, Tag.TYPE.toString(), "OffHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[1]});
        });
    }

    public static OffHeapMemoryMetrics getInstance() {
        return OffHeapMemoryMetricsHolder.INSTANCE;
    }

    private static class OffHeapMemoryMetricsHolder {
        private static final OffHeapMemoryMetrics INSTANCE = new OffHeapMemoryMetrics();

        private OffHeapMemoryMetricsHolder() {
        }
    }
}

