/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile;

import org.apache.iotdb.library.util.DoubleCircularQueue;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFMvAvg
implements UDTF {
    int windowSize;
    Type dataType;
    DoubleCircularQueue v;

    @Override
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE).validate(x -> (Integer)x > 0, "Window size should be larger than 0.", (Object)validator.getParameters().getIntOrDefault("window", 10));
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy(new RowByRowAccessStrategy()).setOutputDataType(Type.DOUBLE);
        this.dataType = parameters.getDataType(0);
        this.windowSize = parameters.getIntOrDefault("window", 10);
        this.v = new DoubleCircularQueue(this.windowSize);
    }

    @Override
    public void transform(Row row, PointCollector collector) throws Exception {
        double value;
        long t2 = row.getTime();
        double windowSum = 0.0;
        if (this.v.isFull()) {
            windowSum -= this.v.pop();
        }
        if (Double.isFinite(value = Util.getValueAsDouble(row))) {
            this.v.push(value);
            windowSum += value;
            if (this.v.isFull()) {
                collector.putDouble(t2, windowSum / (double)this.windowSize);
            }
        }
    }

    @Override
    public void terminate(PointCollector collector) throws Exception {
    }
}

