/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.source.dataregion;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.pipe.agent.task.PipeTaskAgent;
import org.apache.iotdb.commons.pipe.datastructure.pattern.IoTDBPipePatternOperations;
import org.apache.iotdb.commons.pipe.datastructure.pattern.PipePattern;
import org.apache.iotdb.commons.pipe.source.IoTDBSource;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.metric.overview.PipeDataNodeSinglePipeMetrics;
import org.apache.iotdb.db.pipe.metric.overview.PipeTsFileToTabletsMetrics;
import org.apache.iotdb.db.pipe.metric.source.PipeDataRegionSourceMetrics;
import org.apache.iotdb.db.pipe.source.dataregion.DataRegionListeningFilter;
import org.apache.iotdb.db.pipe.source.dataregion.DataRegionWatermarkInjector;
import org.apache.iotdb.db.pipe.source.dataregion.historical.PipeHistoricalDataRegionSource;
import org.apache.iotdb.db.pipe.source.dataregion.historical.PipeHistoricalDataRegionTsFileSource;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.PipeRealtimeDataRegionHeartbeatSource;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.PipeRealtimeDataRegionHybridSource;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.PipeRealtimeDataRegionLogSource;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.PipeRealtimeDataRegionSource;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.PipeRealtimeDataRegionTsFileSource;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeExtractorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.pipe.api.exception.PipeParameterNotValidException;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBDataRegionSource
extends IoTDBSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBDataRegionSource.class);
    private PipeHistoricalDataRegionSource historicalExtractor;
    private PipeRealtimeDataRegionSource realtimeExtractor;
    private DataRegionWatermarkInjector watermarkInjector;
    private boolean hasNoExtractionNeed = true;
    private boolean shouldExtractDeletion = false;

    public void validate(PipeParameterValidator validator) throws Exception {
        super.validate(validator);
        boolean forwardingPipeRequests = validator.getParameters().getBooleanOrDefault(Arrays.asList("extractor.forwarding-pipe-requests", "source.forwarding-pipe-requests"), true);
        if (!forwardingPipeRequests) {
            throw new PipeParameterNotValidException(String.format("The parameter %s cannot be set to false.", "source.forwarding-pipe-requests"));
        }
        Pair<Boolean, Boolean> insertionDeletionListeningOptionPair = DataRegionListeningFilter.parseInsertionDeletionListeningOptionPair(validator.getParameters());
        if (((Boolean)insertionDeletionListeningOptionPair.getLeft()).equals(false) && ((Boolean)insertionDeletionListeningOptionPair.getRight()).equals(false)) {
            return;
        }
        this.hasNoExtractionNeed = false;
        this.shouldExtractDeletion = (Boolean)insertionDeletionListeningOptionPair.getRight();
        if (((Boolean)insertionDeletionListeningOptionPair.getLeft()).equals(true) && IoTDBDescriptor.getInstance().getConfig().getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus")) {
            throw new PipeException("The pipe cannot transfer data when data region is using ratis consensus.");
        }
        validator.validateAttributeValueRange("extractor.pattern.format", true, new String[]{"prefix", "iotdb"}).validateAttributeValueRange("source.pattern.format", true, new String[]{"prefix", "iotdb"});
        PipePattern pattern = PipePattern.parsePipePatternFromSourceParameters((PipeParameters)validator.getParameters());
        this.validatePattern(pattern);
        validator.validateAttributeValueRange("extractor.history.enable", true, new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()}).validateAttributeValueRange("extractor.realtime.enable", true, new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()}).validateAttributeValueRange("source.history.enable", true, new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()}).validateAttributeValueRange("source.realtime.enable", true, new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()}).validate(args -> (Boolean)args[0] != false || (Boolean)args[1] != false, "Should not set both history.enable and realtime.enable to false.", new Object[]{validator.getParameters().getBooleanOrDefault(Arrays.asList("extractor.history.enable", "source.history.enable"), true), validator.getParameters().getBooleanOrDefault(Arrays.asList("extractor.realtime.enable", "source.realtime.enable"), true)});
        if (validator.getParameters().hasAnyAttributes(new String[]{"source.start-time", "extractor.start-time", "source.end-time", "extractor.end-time"}) && validator.getParameters().hasAnyAttributes(new String[]{"extractor.history.enable", "source.history.enable", "source.history.start-time", "extractor.history.start-time", "source.history.end-time", "extractor.history.end-time"})) {
            LOGGER.warn("When {}, {}, {} or {} is specified, specifying {}, {}, {}, {}, {} and {} is invalid.", new Object[]{"source.start-time", "extractor.start-time", "source.end-time", "extractor.end-time", "source.history.enable", "extractor.history.enable", "source.history.start-time", "extractor.history.start-time", "source.history.end-time", "extractor.history.end-time"});
        }
        this.constructHistoricalExtractor();
        this.constructRealtimeExtractor(validator.getParameters());
        this.historicalExtractor.validate(validator);
        this.realtimeExtractor.validate(validator);
    }

    private void validatePattern(PipePattern pattern) {
        if (!pattern.isLegal()) {
            throw new IllegalArgumentException(String.format("Pattern \"%s\" is illegal.", pattern));
        }
        if (!(!this.shouldExtractDeletion || pattern instanceof IoTDBPipePatternOperations && ((IoTDBPipePatternOperations)pattern).isPrefixOrFullPath())) {
            throw new IllegalArgumentException(String.format("The path pattern %s is not valid for the source. Only prefix or full path is allowed.", pattern));
        }
    }

    private void constructHistoricalExtractor() {
        this.historicalExtractor = new PipeHistoricalDataRegionTsFileSource();
    }

    private void constructRealtimeExtractor(PipeParameters parameters) {
        if (!parameters.getBooleanOrDefault(Arrays.asList("extractor.realtime.enable", "source.realtime.enable"), true)) {
            this.realtimeExtractor = new PipeRealtimeDataRegionHeartbeatSource();
            LOGGER.info("Pipe: '{}' ('{}') is set to false, use heartbeat realtime source.", (Object)"extractor.realtime.enable", (Object)"source.realtime.enable");
            return;
        }
        if (PipeTaskAgent.isSnapshotMode((PipeParameters)parameters)) {
            this.realtimeExtractor = new PipeRealtimeDataRegionHeartbeatSource();
            LOGGER.info("Pipe: snapshot mode is enabled, use heartbeat realtime source.");
            return;
        }
        if (this.pipeName == null || !this.pipeName.startsWith("__subscription.") && !this.pipeName.startsWith("__consensus.")) {
            this.realtimeExtractor = new PipeRealtimeDataRegionTsFileSource();
            return;
        }
        if (!parameters.hasAnyAttributes(new String[]{"extractor.realtime.mode", "source.realtime.mode"})) {
            this.realtimeExtractor = new PipeRealtimeDataRegionHybridSource();
            LOGGER.info("Pipe: '{}' is not set, use hybrid mode by default.", (Object)"extractor.realtime.mode");
            return;
        }
        switch (parameters.getStringByKeys(new String[]{"extractor.realtime.mode", "source.realtime.mode"})) {
            case "file": 
            case "batch": {
                this.realtimeExtractor = new PipeRealtimeDataRegionTsFileSource();
                break;
            }
            case "hybrid": 
            case "log": 
            case "stream": {
                this.realtimeExtractor = new PipeRealtimeDataRegionHybridSource();
                break;
            }
            case "forced-log": {
                this.realtimeExtractor = new PipeRealtimeDataRegionLogSource();
                break;
            }
            default: {
                this.realtimeExtractor = new PipeRealtimeDataRegionHybridSource();
                if (!LOGGER.isWarnEnabled()) break;
                LOGGER.warn("Pipe: Unsupported source realtime mode: {}, create a hybrid source.", (Object)parameters.getStringByKeys(new String[]{"extractor.realtime.mode", "source.realtime.mode"}));
            }
        }
    }

    public void customize(PipeParameters parameters, PipeExtractorRuntimeConfiguration configuration) throws Exception {
        long watermarkIntervalInMs;
        if (this.hasNoExtractionNeed) {
            return;
        }
        super.customize(parameters, configuration);
        this.historicalExtractor.customize(parameters, configuration);
        this.realtimeExtractor.customize(parameters, configuration);
        if (parameters.hasAnyAttributes(new String[]{"extractor.watermark-interval-ms", "source.watermark-interval-ms"}) && (watermarkIntervalInMs = parameters.getLongOrDefault(Arrays.asList("extractor.watermark-interval-ms", "source.watermark-interval-ms"), -1L)) > 0L) {
            this.watermarkInjector = new DataRegionWatermarkInjector(this.regionId, watermarkIntervalInMs);
            LOGGER.info("Pipe {}@{}: Set watermark injector with interval {} ms.", new Object[]{this.pipeName, this.regionId, this.watermarkInjector.getInjectionIntervalInMs()});
        }
        PipeDataRegionSourceMetrics.getInstance().register(this);
        PipeTsFileToTabletsMetrics.getInstance().register(this);
        PipeDataNodeSinglePipeMetrics.getInstance().register(this);
    }

    public void start() throws Exception {
        if (this.hasNoExtractionNeed || this.hasBeenStarted.get()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        LOGGER.info("Pipe {}@{}: Starting historical source {} and realtime source {}.", new Object[]{this.pipeName, this.regionId, this.historicalExtractor.getClass().getSimpleName(), this.realtimeExtractor.getClass().getSimpleName()});
        super.start();
        AtomicReference<Object> exceptionHolder = new AtomicReference<Object>(null);
        DataRegionId dataRegionIdObject = new DataRegionId(this.regionId);
        while (true) {
            if (StorageEngine.getInstance().runIfPresent(dataRegionIdObject, dataRegion -> {
                dataRegion.writeLock(String.format("Pipe: starting %s", IoTDBDataRegionSource.class.getName()));
                try {
                    this.startHistoricalExtractorAndRealtimeExtractor(exceptionHolder);
                }
                finally {
                    dataRegion.writeUnlock();
                }
            }) || StorageEngine.getInstance().runIfAbsent(dataRegionIdObject, () -> this.startHistoricalExtractorAndRealtimeExtractor(exceptionHolder))) {
                this.rethrowExceptionIfAny(exceptionHolder);
                LOGGER.info("Pipe {}@{}: Started historical source {} and realtime source {} successfully within {} ms.", new Object[]{this.pipeName, this.regionId, this.historicalExtractor.getClass().getSimpleName(), this.realtimeExtractor.getClass().getSimpleName(), System.currentTimeMillis() - startTime});
                return;
            }
            this.rethrowExceptionIfAny(exceptionHolder);
        }
    }

    private void startHistoricalExtractorAndRealtimeExtractor(AtomicReference<Exception> exceptionHolder) {
        try {
            this.realtimeExtractor.start();
            this.historicalExtractor.start();
        }
        catch (Exception e) {
            exceptionHolder.set(e);
            LOGGER.warn("Pipe {}@{}: Start historical source {} and realtime source {} error.", new Object[]{this.pipeName, this.regionId, this.historicalExtractor.getClass().getSimpleName(), this.realtimeExtractor.getClass().getSimpleName(), e});
        }
    }

    private void rethrowExceptionIfAny(AtomicReference<Exception> exceptionHolder) {
        if (exceptionHolder.get() != null) {
            throw new PipeException("failed to start sources.", (Throwable)exceptionHolder.get());
        }
    }

    public Event supply() throws Exception {
        if (this.hasNoExtractionNeed) {
            return null;
        }
        Event event = null;
        if (!this.historicalExtractor.hasConsumedAll()) {
            event = this.historicalExtractor.supply();
        } else {
            if (Objects.nonNull(this.watermarkInjector)) {
                event = this.watermarkInjector.inject();
            }
            if (Objects.isNull(event)) {
                event = this.realtimeExtractor.supply();
            }
        }
        if (Objects.nonNull(event)) {
            if (event instanceof TabletInsertionEvent) {
                PipeDataRegionSourceMetrics.getInstance().markTabletEvent(this.taskID);
            } else if (event instanceof TsFileInsertionEvent) {
                PipeDataRegionSourceMetrics.getInstance().markTsFileEvent(this.taskID);
            } else if (event instanceof PipeHeartbeatEvent) {
                PipeDataRegionSourceMetrics.getInstance().markPipeHeartbeatEvent(this.taskID);
            }
        }
        return event;
    }

    public void close() throws Exception {
        if (this.hasNoExtractionNeed || !this.hasBeenStarted.get()) {
            return;
        }
        this.historicalExtractor.close();
        this.realtimeExtractor.close();
        if (Objects.nonNull(this.taskID)) {
            PipeDataRegionSourceMetrics.getInstance().deregister(this.taskID);
        }
    }

    public int getHistoricalTsFileInsertionEventCount() {
        return this.hasBeenStarted.get() && Objects.nonNull(this.historicalExtractor) ? this.historicalExtractor.getPendingQueueSize() : 0;
    }

    public int getTabletInsertionEventCount() {
        return this.hasBeenStarted.get() ? this.realtimeExtractor.getTabletInsertionEventCount() : 0;
    }

    public int getRealtimeTsFileInsertionEventCount() {
        return this.hasBeenStarted.get() ? this.realtimeExtractor.getTsFileInsertionEventCount() : 0;
    }

    public int getPipeHeartbeatEventCount() {
        return this.hasBeenStarted.get() ? this.realtimeExtractor.getPipeHeartbeatEventCount() : 0;
    }
}

