/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class Argument
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=296");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=297");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=298");
    private final String name;
    private final NodeId dataType;
    private final Integer valueRank;
    private final UInteger[] arrayDimensions;
    private final LocalizedText description;

    public Argument(String name, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, LocalizedText description) {
        this.name = name;
        this.dataType = dataType;
        this.valueRank = valueRank;
        this.arrayDimensions = arrayDimensions;
        this.description = description;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public String getName() {
        return this.name;
    }

    public NodeId getDataType() {
        return this.dataType;
    }

    public Integer getValueRank() {
        return this.valueRank;
    }

    public UInteger[] getArrayDimensions() {
        return this.arrayDimensions;
    }

    public LocalizedText getDescription() {
        return this.description;
    }

    protected Argument(ArgumentBuilder<?, ?> b) {
        super(b);
        this.name = ((ArgumentBuilder)b).name;
        this.dataType = ((ArgumentBuilder)b).dataType;
        this.valueRank = ((ArgumentBuilder)b).valueRank;
        this.arrayDimensions = ((ArgumentBuilder)b).arrayDimensions;
        this.description = ((ArgumentBuilder)b).description;
    }

    public static ArgumentBuilder<?, ?> builder() {
        return new ArgumentBuilderImpl();
    }

    public ArgumentBuilder<?, ?> toBuilder() {
        return new ArgumentBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Argument)) {
            return false;
        }
        Argument other = (Argument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$valueRank = this.getValueRank();
        Integer other$valueRank = other.getValueRank();
        if (this$valueRank == null ? other$valueRank != null : !((Object)this$valueRank).equals(other$valueRank)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        NodeId this$dataType = this.getDataType();
        NodeId other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !((Object)this$dataType).equals(other$dataType)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getArrayDimensions(), other.getArrayDimensions())) {
            return false;
        }
        LocalizedText this$description = this.getDescription();
        LocalizedText other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !((Object)this$description).equals(other$description));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Argument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $valueRank = this.getValueRank();
        result = result * 59 + ($valueRank == null ? 43 : ((Object)$valueRank).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        NodeId $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : ((Object)$dataType).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getArrayDimensions());
        LocalizedText $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : ((Object)$description).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "Argument(name=" + this.getName() + ", dataType=" + this.getDataType() + ", valueRank=" + this.getValueRank() + ", arrayDimensions=" + Arrays.deepToString(this.getArrayDimensions()) + ", description=" + this.getDescription() + ")";
    }

    private static final class ArgumentBuilderImpl
    extends ArgumentBuilder<Argument, ArgumentBuilderImpl> {
        private ArgumentBuilderImpl() {
        }

        @Override
        protected ArgumentBuilderImpl self() {
            return this;
        }

        @Override
        public Argument build() {
            return new Argument(this);
        }
    }

    public static abstract class ArgumentBuilder<C extends Argument, B extends ArgumentBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private String name;
        private NodeId dataType;
        private Integer valueRank;
        private UInteger[] arrayDimensions;
        private LocalizedText description;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ArgumentBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(Argument instance, ArgumentBuilder<?, ?> b) {
            b.name(instance.name);
            b.dataType(instance.dataType);
            b.valueRank(instance.valueRank);
            b.arrayDimensions(instance.arrayDimensions);
            b.description(instance.description);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        public B dataType(NodeId dataType) {
            this.dataType = dataType;
            return (B)this.self();
        }

        public B valueRank(Integer valueRank) {
            this.valueRank = valueRank;
            return (B)this.self();
        }

        public B arrayDimensions(UInteger[] arrayDimensions) {
            this.arrayDimensions = arrayDimensions;
            return (B)this.self();
        }

        public B description(LocalizedText description) {
            this.description = description;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "Argument.ArgumentBuilder(super=" + super.toString() + ", name=" + this.name + ", dataType=" + this.dataType + ", valueRank=" + this.valueRank + ", arrayDimensions=" + Arrays.deepToString(this.arrayDimensions) + ", description=" + this.description + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<Argument> {
        @Override
        public Class<Argument> getType() {
            return Argument.class;
        }

        @Override
        public Argument decode(SerializationContext context, UaDecoder decoder) {
            String name = decoder.readString("Name");
            NodeId dataType = decoder.readNodeId("DataType");
            Integer valueRank = decoder.readInt32("ValueRank");
            UInteger[] arrayDimensions = decoder.readUInt32Array("ArrayDimensions");
            LocalizedText description = decoder.readLocalizedText("Description");
            return new Argument(name, dataType, valueRank, arrayDimensions, description);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, Argument value) {
            encoder.writeString("Name", value.getName());
            encoder.writeNodeId("DataType", value.getDataType());
            encoder.writeInt32("ValueRank", value.getValueRank());
            encoder.writeUInt32Array("ArrayDimensions", value.getArrayDimensions());
            encoder.writeLocalizedText("Description", value.getDescription());
        }
    }
}

