/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.client;

import com.google.common.base.Preconditions;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.ssl.SslContext;
import lombok.Generated;
import org.apache.bifromq.baserpc.BluePrint;
import org.apache.bifromq.baserpc.client.ClientChannel;
import org.apache.bifromq.baserpc.client.IRPCClient;
import org.apache.bifromq.baserpc.client.RPCClient;
import org.apache.bifromq.baserpc.trafficgovernor.IRPCServiceTrafficService;

public final class RPCClientBuilder {
    private IRPCServiceTrafficService trafficService;
    private BluePrint bluePrint;
    private int workerThreads;
    private EventLoopGroup eventLoopGroup;
    private long keepAliveInSec;
    private long idleTimeoutInSec;
    private SslContext sslContext;

    public RPCClientBuilder sslContext(SslContext sslContext) {
        if (sslContext != null) {
            Preconditions.checkArgument((boolean)sslContext.isClient(), (Object)"Client auth must be enabled");
        }
        this.sslContext = sslContext;
        return this;
    }

    public IRPCClient build() {
        return new RPCClient(this.bluePrint, ClientChannel.builder().bluePrint(this.bluePrint).trafficService(this.trafficService).eventLoopGroup(this.eventLoopGroup).sslContext(this.sslContext).workerThreads(this.workerThreads).keepAliveInSec(this.keepAliveInSec).idleTimeoutInSec(this.idleTimeoutInSec).build());
    }

    @Generated
    public RPCClientBuilder trafficService(IRPCServiceTrafficService trafficService) {
        this.trafficService = trafficService;
        return this;
    }

    @Generated
    public RPCClientBuilder bluePrint(BluePrint bluePrint) {
        this.bluePrint = bluePrint;
        return this;
    }

    @Generated
    public RPCClientBuilder workerThreads(int workerThreads) {
        this.workerThreads = workerThreads;
        return this;
    }

    @Generated
    public RPCClientBuilder eventLoopGroup(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
        return this;
    }

    @Generated
    public RPCClientBuilder keepAliveInSec(long keepAliveInSec) {
        this.keepAliveInSec = keepAliveInSec;
        return this;
    }

    @Generated
    public RPCClientBuilder idleTimeoutInSec(long idleTimeoutInSec) {
        this.idleTimeoutInSec = idleTimeoutInSec;
        return this;
    }

    @Generated
    RPCClientBuilder() {
    }
}

