/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.store.range;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolStringList;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.reactivex.rxjava3.subjects.BehaviorSubject;
import io.reactivex.rxjava3.subjects.Subject;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.bifromq.base.util.AsyncRetry;
import org.apache.bifromq.base.util.AsyncRunner;
import org.apache.bifromq.base.util.CompletableFutureUtil;
import org.apache.bifromq.baseenv.EnvProvider;
import org.apache.bifromq.baseenv.ZeroCopyParser;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.proto.CancelMerging;
import org.apache.bifromq.basekv.proto.CancelMergingReply;
import org.apache.bifromq.basekv.proto.CancelMergingRequest;
import org.apache.bifromq.basekv.proto.ChangeConfig;
import org.apache.bifromq.basekv.proto.DataMergeRequest;
import org.apache.bifromq.basekv.proto.Delete;
import org.apache.bifromq.basekv.proto.EnsureRange;
import org.apache.bifromq.basekv.proto.EnsureRangeReply;
import org.apache.bifromq.basekv.proto.KVRangeCommand;
import org.apache.bifromq.basekv.proto.KVRangeDescriptor;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.proto.KVRangeMessage;
import org.apache.bifromq.basekv.proto.KVRangeSnapshot;
import org.apache.bifromq.basekv.proto.Merge;
import org.apache.bifromq.basekv.proto.MergeDone;
import org.apache.bifromq.basekv.proto.MergeDoneReply;
import org.apache.bifromq.basekv.proto.MergeDoneRequest;
import org.apache.bifromq.basekv.proto.MergeHelpRequest;
import org.apache.bifromq.basekv.proto.MergeReply;
import org.apache.bifromq.basekv.proto.MergeRequest;
import org.apache.bifromq.basekv.proto.PrepareMergeTo;
import org.apache.bifromq.basekv.proto.PrepareMergeToReply;
import org.apache.bifromq.basekv.proto.PrepareMergeToRequest;
import org.apache.bifromq.basekv.proto.PrepareMergeWith;
import org.apache.bifromq.basekv.proto.Put;
import org.apache.bifromq.basekv.proto.SnapshotSyncRequest;
import org.apache.bifromq.basekv.proto.SplitHint;
import org.apache.bifromq.basekv.proto.SplitRange;
import org.apache.bifromq.basekv.proto.State;
import org.apache.bifromq.basekv.proto.WALRaftMessages;
import org.apache.bifromq.basekv.raft.exception.LeaderTransferException;
import org.apache.bifromq.basekv.raft.exception.SnapshotException;
import org.apache.bifromq.basekv.raft.proto.ClusterConfig;
import org.apache.bifromq.basekv.raft.proto.LogEntry;
import org.apache.bifromq.basekv.raft.proto.RaftMessage;
import org.apache.bifromq.basekv.raft.proto.RaftNodeStatus;
import org.apache.bifromq.basekv.raft.proto.Snapshot;
import org.apache.bifromq.basekv.store.api.IKVRangeCoProc;
import org.apache.bifromq.basekv.store.api.IKVRangeCoProcFactory;
import org.apache.bifromq.basekv.store.api.IKVRangeReader;
import org.apache.bifromq.basekv.store.api.IKVRangeRefreshableReader;
import org.apache.bifromq.basekv.store.exception.KVRangeException;
import org.apache.bifromq.basekv.store.option.KVRangeOptions;
import org.apache.bifromq.basekv.store.proto.ROCoProcInput;
import org.apache.bifromq.basekv.store.proto.ROCoProcOutput;
import org.apache.bifromq.basekv.store.proto.RWCoProcInput;
import org.apache.bifromq.basekv.store.proto.RWCoProcOutput;
import org.apache.bifromq.basekv.store.range.IKVRange;
import org.apache.bifromq.basekv.store.range.IKVRangeFSM;
import org.apache.bifromq.basekv.store.range.IKVRangeMessenger;
import org.apache.bifromq.basekv.store.range.IKVRangeQueryRunner;
import org.apache.bifromq.basekv.store.range.IKVRangeWritable;
import org.apache.bifromq.basekv.store.range.IKVRangeWriter;
import org.apache.bifromq.basekv.store.range.KVLoadRecorder;
import org.apache.bifromq.basekv.store.range.KVRangeDumpSession;
import org.apache.bifromq.basekv.store.range.KVRangeMetricManager;
import org.apache.bifromq.basekv.store.range.KVRangeQueryLinearizer;
import org.apache.bifromq.basekv.store.range.KVRangeQueryRunner;
import org.apache.bifromq.basekv.store.range.KVRangeRestorer;
import org.apache.bifromq.basekv.store.range.KVRangeSnapshotReceiver;
import org.apache.bifromq.basekv.store.range.KVRangeStatsCollector;
import org.apache.bifromq.basekv.store.range.LoadRecordableKVReader;
import org.apache.bifromq.basekv.store.range.SnapshotBandwidthGovernor;
import org.apache.bifromq.basekv.store.range.hinter.IKVLoadRecord;
import org.apache.bifromq.basekv.store.range.hinter.IKVRangeSplitHinter;
import org.apache.bifromq.basekv.store.stats.IStatsCollector;
import org.apache.bifromq.basekv.store.util.ExecutorServiceUtil;
import org.apache.bifromq.basekv.store.util.VerUtil;
import org.apache.bifromq.basekv.store.wal.IKVRangeWAL;
import org.apache.bifromq.basekv.store.wal.IKVRangeWALStore;
import org.apache.bifromq.basekv.store.wal.IKVRangeWALSubscriber;
import org.apache.bifromq.basekv.store.wal.IKVRangeWALSubscription;
import org.apache.bifromq.basekv.store.wal.KVRangeWAL;
import org.apache.bifromq.basekv.utils.BoundaryUtil;
import org.apache.bifromq.basekv.utils.KVRangeIdUtil;
import org.apache.bifromq.logger.MDCLogger;
import org.slf4j.Logger;

public class KVRangeFSM
implements IKVRangeFSM {
    private static final Runnable NOOP = () -> {};
    private final Logger log;
    private final KVRangeId id;
    private final String hostStoreId;
    private final IKVRange kvRange;
    private final IKVRangeWAL wal;
    private final IKVRangeWALSubscription walSubscription;
    private final IStatsCollector statsCollector;
    private final ExecutorService fsmExecutor;
    private final ExecutorService mgmtExecutor;
    private final AsyncRunner mgmtTaskRunner;
    private final IKVRangeCoProcFactory coProcFactory;
    private final IKVRangeCoProc coProc;
    private final KVRangeQueryLinearizer linearizer;
    private final IKVRangeQueryRunner queryRunner;
    private final Map<String, CompletableFuture<?>> cmdFutures = new ConcurrentHashMap();
    private final Map<String, KVRangeDumpSession> dumpSessions = Maps.newConcurrentMap();
    private final SnapshotBandwidthGovernor snapshotBandwidthGovernor;
    private final AtomicInteger taskSeqNo = new AtomicInteger();
    private final BehaviorSubject<KVRangeDescriptor> descriptorSubject = BehaviorSubject.create();
    private final Subject<List<SplitHint>> splitHintsSubject = BehaviorSubject.create().toSerialized();
    private final Subject<Any> factSubject = BehaviorSubject.create();
    private final Subject<Boolean> queryReadySubject = BehaviorSubject.createDefault((Object)true).toSerialized();
    private final KVRangeOptions opts;
    private final AtomicBoolean recovering = new AtomicBoolean();
    private final AtomicReference<Lifecycle> lifecycle = new AtomicReference<Lifecycle>(Lifecycle.Init);
    private final CompositeDisposable disposables = new CompositeDisposable();
    private final CompletableFuture<Void> closeSignal = new CompletableFuture();
    private final CompletableFuture<Boolean> quitSignal = new CompletableFuture();
    private final CompletableFuture<Void> destroyedSignal = new CompletableFuture();
    private final AtomicLong lastShrinkCheckAt = new AtomicLong();
    private final AtomicBoolean shrinkingWAL = new AtomicBoolean();
    private final KVRangeMetricManager metricManager;
    private final List<IKVRangeSplitHinter> splitHinters;
    private final StampedLock resetLock = new StampedLock();
    private final String[] tags;
    private final AtomicReference<CompletableFuture<Boolean>> quitZombie = new AtomicReference();
    private final AtomicBoolean cancelingMerge = new AtomicBoolean();
    private volatile long mergePendingAt = -1L;
    private volatile long zombieAt = -1L;
    private IKVRangeMessenger messenger;
    private KVRangeRestorer restorer;

    public KVRangeFSM(String clusterId, String hostStoreId, KVRangeId id, IKVRangeCoProcFactory coProcFactory, IKVRange kvRange, IKVRangeWALStore walStore, Executor queryExecutor, Executor bgExecutor, KVRangeOptions opts, List<IKVRangeSplitHinter> hinters, QuitListener quitListener, String ... tags) {
        this.opts = opts.toBuilder().build();
        this.id = id;
        this.hostStoreId = hostStoreId;
        this.kvRange = kvRange;
        this.tags = tags;
        this.log = MDCLogger.getLogger(KVRangeFSM.class, (String[])tags);
        this.metricManager = new KVRangeMetricManager(clusterId, hostStoreId, id);
        this.wal = new KVRangeWAL(clusterId, hostStoreId, id, walStore, opts.getWalRaftConfig(), opts.getMaxWALFatchBatchSize());
        this.fsmExecutor = ExecutorServiceMetrics.monitor((MeterRegistry)Metrics.globalRegistry, (ExecutorService)new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedTransferQueue<Runnable>(), EnvProvider.INSTANCE.newThreadFactory("basekv-range-mutator")), (String)"mutator", (String)"basekv.range", (Iterable)Tags.of((String[])tags));
        this.mgmtExecutor = ExecutorServiceMetrics.monitor((MeterRegistry)Metrics.globalRegistry, (ExecutorService)new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedTransferQueue<Runnable>(), EnvProvider.INSTANCE.newThreadFactory("basekv-range-manager")), (String)"manager", (String)"basekv.range", (Iterable)Tags.of((String[])tags));
        this.mgmtTaskRunner = new AsyncRunner("basekv.runner.rangemanager", (Executor)this.mgmtExecutor, new String[]{"rangeId", KVRangeIdUtil.toString((KVRangeId)id)});
        this.splitHinters = hinters;
        this.coProcFactory = coProcFactory;
        this.coProc = coProcFactory.createCoProc(clusterId, hostStoreId, id, this.kvRange::newReader);
        this.snapshotBandwidthGovernor = new SnapshotBandwidthGovernor(opts.getSnapshotSyncBytesPerSec());
        long lastAppliedIndex = (Long)this.kvRange.lastAppliedIndex().blockingFirst();
        this.linearizer = new KVRangeQueryLinearizer(this.wal::readIndex, queryExecutor, lastAppliedIndex, this.metricManager::recordLinearization, tags);
        this.queryRunner = new KVRangeQueryRunner(this.kvRange, this.coProc, queryExecutor, this.linearizer, this.splitHinters, this::latestDescriptor, this.resetLock, tags);
        this.statsCollector = new KVRangeStatsCollector(this.kvRange, this.wal, Duration.ofSeconds(opts.getStatsCollectIntervalSec()), bgExecutor);
        this.walSubscription = this.wal.subscribe(lastAppliedIndex, new IKVRangeWALSubscriber(){

            @Override
            public CompletableFuture<Void> apply(LogEntry log, boolean isLeader) {
                return KVRangeFSM.this.metricManager.recordLogApply(() -> KVRangeFSM.this.apply(log, isLeader));
            }

            @Override
            public CompletableFuture<Void> restore(KVRangeSnapshot snapshot, String leader, IKVRangeWALSubscriber.IAfterRestoredCallback callback) {
                return KVRangeFSM.this.metricManager.recordSnapshotInstall(() -> KVRangeFSM.this.restore(snapshot, leader, callback));
            }
        }, this.fsmExecutor);
        this.quitSignal.thenAccept(reset -> quitListener.onQuit(this, (boolean)reset));
    }

    @Override
    public KVRangeId id() {
        return this.id;
    }

    @Override
    public long ver() {
        return this.kvRange.currentVer();
    }

    @Override
    public Boundary boundary() {
        return this.kvRange.currentBoundary();
    }

    @Override
    public CompletableFuture<Void> open(IKVRangeMessenger messenger) {
        if (this.lifecycle.get() != Lifecycle.Init) {
            return CompletableFuture.completedFuture(null);
        }
        return this.mgmtTaskRunner.add(() -> {
            if (this.lifecycle.compareAndSet(Lifecycle.Init, Lifecycle.Opening)) {
                this.log.info("Opening range: appliedIndex={}, state={}, ver={}", new Object[]{this.kvRange.currentLastAppliedIndex(), ((State)this.kvRange.state().blockingFirst()).getType(), VerUtil.print(this.kvRange.currentVer())});
                this.messenger = messenger;
                this.factSubject.onNext((Object)this.reset((Boundary)this.kvRange.boundary().blockingFirst()));
                this.wal.start();
                this.restorer = new KVRangeRestorer(this.wal.latestSnapshot(), this.kvRange, messenger, this.metricManager, this.fsmExecutor, this.opts.getSnapshotSyncIdleTimeoutSec(), this.tags);
                this.disposables.add(this.wal.peerMessages().observeOn(Schedulers.io()).subscribe(messages -> {
                    for (String peerId : messages.keySet()) {
                        messenger.send(KVRangeMessage.newBuilder().setRangeId(this.id).setHostStoreId(peerId).setWalRaftMessages(WALRaftMessages.newBuilder().addAllWalMessages((Iterable)messages.get(peerId)).build()).build());
                    }
                }));
                this.disposables.add(this.descriptorSubject.subscribe(this.metricManager::report));
                this.disposables.add(Observable.combineLatestArray((ObservableSource[])new ObservableSource[]{this.kvRange.ver(), this.kvRange.state(), this.kvRange.boundary(), this.kvRange.clusterConfig(), this.wal.state().distinctUntilChanged(), this.wal.replicationStatus().distinctUntilChanged(), this.statsCollector.collect().distinctUntilChanged(), this.splitHintsSubject.distinctUntilChanged(), this.factSubject.distinctUntilChanged(), this.queryReadySubject.distinctUntilChanged().switchMap(v -> {
                    if (v.booleanValue()) {
                        return Observable.timer((long)5L, (TimeUnit)TimeUnit.SECONDS, (Scheduler)Schedulers.from((Executor)this.mgmtExecutor)).map(t -> true);
                    }
                    return Observable.just((Object)false);
                }).distinctUntilChanged()}, latest -> {
                    long ver = (Long)latest[0];
                    State state = (State)latest[1];
                    Boundary boundary = (Boundary)latest[2];
                    ClusterConfig clusterConfig = (ClusterConfig)latest[3];
                    RaftNodeStatus role = (RaftNodeStatus)latest[4];
                    Map syncStats = (Map)latest[5];
                    Map rangeStats = (Map)latest[6];
                    List splitHints = (List)latest[7];
                    Any fact = (Any)latest[8];
                    boolean readyForQuery = (Boolean)latest[9];
                    this.log.trace("Split hints: \n{}", (Object)splitHints);
                    List<SplitHint> alignedHints = splitHints.stream().map(h -> {
                        if (h.hasSplitKey()) {
                            return this.coProcFactory.toSplitKey(h.getSplitKey(), boundary).map(k -> h.toBuilder().setSplitKey(k).build()).orElseGet(() -> h.toBuilder().clearSplitKey().build());
                        }
                        return h;
                    }).toList();
                    return KVRangeDescriptor.newBuilder().setVer(ver).setId(this.id).setBoundary(boundary).setRole(role).setState(state.getType()).setConfig(clusterConfig).putAllSyncState(syncStats).putAllStatistics(rangeStats).addAllHints(alignedHints).setHlc(HLC.INST.get()).setFact(fact).setReadyForQuery(readyForQuery).build();
                }).observeOn(Schedulers.from((Executor)this.mgmtExecutor)).subscribe(arg_0 -> this.descriptorSubject.onNext(arg_0)));
                this.disposables.add(messenger.receive().subscribe(this::handleMessage));
                this.disposables.add(this.descriptorSubject.subscribe(this::detectZombieState));
                this.disposables.add(this.wal.state().observeOn(Schedulers.from((Executor)this.mgmtExecutor)).subscribe(role -> this.coProc.onLeader(role == RaftNodeStatus.Leader)));
                this.lifecycle.set(Lifecycle.Open);
                this.metricManager.reportLastAppliedIndex((Long)this.kvRange.lastAppliedIndex().blockingFirst());
                this.log.info("Range opened: appliedIndex={}, state={}, ver={}", new Object[]{this.kvRange.currentLastAppliedIndex(), ((State)this.kvRange.state().blockingFirst()).getType(), VerUtil.print(this.kvRange.currentVer())});
                if (!this.kvRange.hasCheckpoint(this.wal.latestSnapshot())) {
                    this.log.debug("Latest snapshot not available, do compaction: \n{}", (Object)this.wal.latestSnapshot());
                    this.compactWAL();
                }
            }
        });
    }

    @Override
    public void tick() {
        if (this.isNotOpening()) {
            return;
        }
        this.wal.tick();
        this.statsCollector.tick();
        this.dumpSessions.values().forEach(KVRangeDumpSession::tick);
        this.shrinkWAL();
        this.judgeZombieState();
        this.estimateSplitHint();
        this.checkMergeTimeout();
    }

    @Override
    public CompletableFuture<Void> close() {
        return this.doClose().thenCompose(v -> ExecutorServiceUtil.awaitShutdown(this.mgmtExecutor));
    }

    private CompletableFuture<Void> doClose() {
        switch (this.lifecycle.get()) {
            case Init: {
                return CompletableFuture.completedFuture(null);
            }
            case Opening: {
                return CompletableFuture.failedFuture(new IllegalStateException("Range is opening"));
            }
            case Open: {
                if (this.lifecycle.compareAndSet(Lifecycle.Open, Lifecycle.Closing)) {
                    this.log.info("Closing range");
                    this.descriptorSubject.onComplete();
                    this.disposables.dispose();
                    ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.completedFuture(null).thenComposeAsync(v -> this.walSubscription.stop(), (Executor)this.mgmtExecutor)).thenAcceptAsync(v -> {
                        try {
                            this.splitHinters.forEach(IKVRangeSplitHinter::close);
                        }
                        catch (Throwable e) {
                            this.log.error("Split hinter close error", e);
                        }
                        try {
                            this.coProc.close();
                        }
                        catch (Throwable e) {
                            this.log.error("CoProc close error", e);
                        }
                    }, (Executor)this.mgmtExecutor)).thenComposeAsync(v -> CompletableFuture.allOf((CompletableFuture[])this.dumpSessions.values().stream().map(dumpSession -> {
                        dumpSession.cancel();
                        return dumpSession.awaitDone();
                    }).toArray(CompletableFuture[]::new)), (Executor)this.mgmtExecutor)).thenComposeAsync(v -> this.restorer.awaitDone(), (Executor)this.mgmtExecutor)).thenComposeAsync(v -> this.statsCollector.stop(), (Executor)this.mgmtExecutor)).thenComposeAsync(v -> this.mgmtTaskRunner.awaitDone(), (Executor)this.mgmtExecutor)).thenComposeAsync(v -> this.wal.close(), (Executor)this.mgmtExecutor)).thenComposeAsync(v -> ExecutorServiceUtil.awaitShutdown(this.fsmExecutor), (Executor)this.mgmtExecutor)).whenComplete((v, e) -> {
                        this.kvRange.close();
                        this.metricManager.close();
                        this.cmdFutures.values().forEach(f -> f.completeExceptionally(new KVRangeException.TryLater("Range closed")));
                        this.queryRunner.close();
                        this.log.info("Range closed");
                        this.lifecycle.set(Lifecycle.Closed);
                        this.closeSignal.complete(null);
                    });
                }
                return this.closeSignal;
            }
        }
        return this.closeSignal;
    }

    @Override
    public CompletableFuture<Void> destroy() {
        if (this.lifecycle.get() == Lifecycle.Open) {
            this.log.info("Destroying range");
            ((CompletableFuture)((CompletableFuture)this.doClose().thenComposeAsync(v -> {
                if (this.lifecycle.compareAndSet(Lifecycle.Closed, Lifecycle.Destroying)) {
                    this.kvRange.destroy();
                    return this.wal.destroy();
                }
                return CompletableFuture.completedFuture(null);
            }, (Executor)this.mgmtExecutor)).whenComplete((v, e) -> {
                if (this.lifecycle.compareAndSet(Lifecycle.Destroying, Lifecycle.Destroyed)) {
                    this.log.info("Range destroyed");
                    this.destroyedSignal.complete(null);
                }
            })).thenCompose(v -> ExecutorServiceUtil.awaitShutdown(this.mgmtExecutor));
        }
        return this.destroyedSignal;
    }

    @Override
    public CompletableFuture<Void> recover() {
        return this.wal.recover();
    }

    public CompletableFuture<Boolean> quit() {
        this.quitZombie.compareAndSet(null, new CompletableFuture());
        return this.quitZombie.get();
    }

    @Override
    public CompletableFuture<Void> transferLeadership(long ver, String newLeader) {
        return this.metricManager.recordTransferLeader(() -> {
            if (ver != this.kvRange.currentVer()) {
                return CompletableFuture.failedFuture(new KVRangeException.BadVersion("Version Mismatch", this.latestLeaderDescriptor()));
            }
            this.log.info("Transferring leader[ver={}, state={}]: newLeader={}", new Object[]{VerUtil.print(ver), this.kvRange.currentState().getType(), newLeader});
            return this.wal.transferLeadership(newLeader).exceptionally(CompletableFutureUtil.unwrap(e -> {
                if (e instanceof LeaderTransferException.NotFoundOrQualifiedException) {
                    throw new KVRangeException.BadRequest("Failed to transfer leadership", this.latestDescriptor(), (Throwable)e);
                }
                throw new KVRangeException.TryLater("Failed to transfer leadership", (Throwable)e);
            }));
        });
    }

    @Override
    public CompletableFuture<Void> changeReplicaConfig(long ver, Set<String> newVoters, Set<String> newLearners) {
        if (this.isNotOpening()) {
            return CompletableFuture.failedFuture(new KVRangeException.InternalException("Range not open:" + KVRangeIdUtil.toString((KVRangeId)this.id)));
        }
        if (!this.dumpSessions.isEmpty()) {
            return CompletableFuture.failedFuture(new KVRangeException.TryLater("Range is dumping data, try later"));
        }
        return this.metricManager.recordConfigChange(() -> this.submitManagementCommand(KVRangeCommand.newBuilder().setTaskId(this.nextTaskId()).setVer(ver).setChangeConfig(ChangeConfig.newBuilder().addAllVoters((Iterable)newVoters).addAllLearners((Iterable)newLearners).build()).build()));
    }

    @Override
    public CompletableFuture<Void> split(long ver, ByteString splitKey) {
        if (!this.dumpSessions.isEmpty()) {
            return CompletableFuture.failedFuture(new KVRangeException.TryLater("Range is dumping data, try later"));
        }
        return this.metricManager.recordSplit(() -> this.submitManagementCommand(KVRangeCommand.newBuilder().setTaskId(this.nextTaskId()).setVer(ver).setSplitRange(SplitRange.newBuilder().setSplitKey(splitKey).setNewId(KVRangeIdUtil.next((KVRangeId)this.id)).build()).build()));
    }

    @Override
    public CompletableFuture<Void> merge(long ver, KVRangeId mergeeId, Set<String> mergeeVoters) {
        if (!this.dumpSessions.isEmpty()) {
            return CompletableFuture.failedFuture(new KVRangeException.TryLater("Range is dumping data, try later"));
        }
        return this.metricManager.recordMerge(() -> this.submitManagementCommand(KVRangeCommand.newBuilder().setTaskId(this.nextTaskId()).setVer(ver).setPrepareMergeWith(PrepareMergeWith.newBuilder().setMergeeId(mergeeId).addAllVoters((Iterable)mergeeVoters).buildPartial()).build()));
    }

    @Override
    public CompletableFuture<Boolean> exist(long ver, ByteString key, boolean linearized) {
        if (this.isNotOpening()) {
            return CompletableFuture.failedFuture(new KVRangeException.InternalException("Range not open:" + KVRangeIdUtil.toString((KVRangeId)this.id)));
        }
        return this.metricManager.recordExist(() -> this.queryRunner.exist(ver, key, linearized));
    }

    @Override
    public CompletableFuture<Optional<ByteString>> get(long ver, ByteString key, boolean linearized) {
        if (this.isNotOpening()) {
            return CompletableFuture.failedFuture(new KVRangeException.InternalException("Range not open:" + KVRangeIdUtil.toString((KVRangeId)this.id)));
        }
        return this.metricManager.recordGet(() -> this.queryRunner.get(ver, key, linearized));
    }

    @Override
    public CompletableFuture<ROCoProcOutput> queryCoProc(long ver, ROCoProcInput query, boolean linearized) {
        if (this.isNotOpening()) {
            return CompletableFuture.failedFuture(new KVRangeException.InternalException("Range not open:" + KVRangeIdUtil.toString((KVRangeId)this.id)));
        }
        return this.metricManager.recordQueryCoProc(() -> this.queryRunner.queryCoProc(ver, query, linearized));
    }

    @Override
    public CompletableFuture<ByteString> put(long ver, ByteString key, ByteString value) {
        return this.metricManager.recordPut(() -> this.submitMutationCommand(KVRangeCommand.newBuilder().setVer(ver).setTaskId(this.nextTaskId()).setPut(Put.newBuilder().setKey(key).setValue(value).build()).build()));
    }

    @Override
    public CompletableFuture<ByteString> delete(long ver, ByteString key) {
        return this.metricManager.recordDelete(() -> this.submitMutationCommand(KVRangeCommand.newBuilder().setVer(ver).setTaskId(this.nextTaskId()).setDelete(Delete.newBuilder().setKey(key).build()).build()));
    }

    @Override
    public CompletableFuture<RWCoProcOutput> mutateCoProc(long ver, RWCoProcInput mutate) {
        return this.metricManager.recordMutateCoProc(() -> this.submitMutationCommand(KVRangeCommand.newBuilder().setVer(ver).setTaskId(this.nextTaskId()).setRwCoProc(mutate).build()));
    }

    private <T> CompletableFuture<T> submitMutationCommand(KVRangeCommand mutationCommand) {
        if (this.isNotOpening()) {
            return CompletableFuture.failedFuture(new KVRangeException.InternalException("Range not open:" + KVRangeIdUtil.toString((KVRangeId)this.id)));
        }
        if (!VerUtil.boundaryCompatible(mutationCommand.getVer(), this.kvRange.currentVer())) {
            return CompletableFuture.failedFuture(new KVRangeException.BadVersion("Version Mismatch", this.latestLeaderDescriptor()));
        }
        State state = this.kvRange.currentState();
        if (state.getType() == State.StateType.NoUse || state.getType() == State.StateType.WaitingForMerge || state.getType() == State.StateType.Merged || state.getType() == State.StateType.MergedQuiting || state.getType() == State.StateType.Removed || state.getType() == State.StateType.ToBePurged) {
            return CompletableFuture.failedFuture(new KVRangeException.TryLater("Range is being merge or has been merged: state=" + state.getType().name()));
        }
        return this.submitCommand(mutationCommand);
    }

    private <T> CompletableFuture<T> submitManagementCommand(KVRangeCommand managementCommand) {
        if (this.isNotOpening()) {
            return CompletableFuture.failedFuture(new KVRangeException.InternalException("Range not open:" + KVRangeIdUtil.toString((KVRangeId)this.id)));
        }
        if (managementCommand.getVer() != this.kvRange.currentVer()) {
            return CompletableFuture.failedFuture(new KVRangeException.BadVersion("Version Mismatch", this.latestLeaderDescriptor()));
        }
        return this.submitCommand(managementCommand);
    }

    @Override
    public Observable<KVRangeDescriptor> describe() {
        return this.descriptorSubject;
    }

    private String nextTaskId() {
        return this.hostStoreId + "-" + this.id.getId() + "-" + this.taskSeqNo.getAndIncrement();
    }

    private <T> CompletableFuture<T> submitCommand(KVRangeCommand command) {
        CompletableFuture onDone = new CompletableFuture();
        CompletableFuture prev = this.cmdFutures.put(command.getTaskId(), onDone);
        assert (prev == null);
        CompletableFuture<Long> proposeFuture = this.wal.propose(command);
        onDone.whenComplete((v, e) -> {
            this.cmdFutures.remove(command.getTaskId(), onDone);
            if (onDone.isCancelled()) {
                proposeFuture.cancel(true);
            }
        });
        proposeFuture.whenCompleteAsync((r, e) -> {
            if (e != null) {
                onDone.completeExceptionally((Throwable)e);
            }
        }, (Executor)this.fsmExecutor);
        return onDone;
    }

    private void finishCommand(String taskId) {
        this.finishCommand(taskId, null);
    }

    private <T> void finishCommand(String taskId, T result) {
        CompletableFuture<?> f = this.cmdFutures.get(taskId);
        if (f != null) {
            this.log.trace("Finish write request: taskId={}", (Object)taskId);
            f.complete(result);
        }
    }

    private void finishCommandWithError(String taskId, Throwable e) {
        CompletableFuture<?> f = this.cmdFutures.get(taskId);
        if (f != null) {
            this.log.trace("Finish write request with error: taskId={}", (Object)taskId, (Object)e);
            f.completeExceptionally(e);
        }
    }

    private CompletableFuture<Void> apply(LogEntry entry, boolean isLeader) {
        CompletableFuture<Void> onDone = new CompletableFuture<Void>();
        if (this.kvRange.currentLastAppliedIndex() > entry.getIndex()) {
            this.log.debug("Skip already applied log: index={}, term={}", (Object)entry.getIndex(), (Object)entry.getTerm());
            onDone.complete(null);
            return onDone;
        }
        switch (entry.getTypeCase()) {
            case CONFIG: {
                IKVRangeWriter<?> rangeWriter = this.kvRange.toWriter();
                try (IKVRangeRefreshableReader rangeReader = this.kvRange.newReader();){
                    Supplier<CompletableFuture<Void>> afterLogApplied = this.applyConfigChange(entry.getTerm(), entry.getIndex(), entry.getConfig(), (IKVRangeReader)rangeReader, rangeWriter);
                    rangeWriter.lastAppliedIndex(entry.getIndex());
                    rangeWriter.done();
                    afterLogApplied.get().whenComplete((v, e) -> {
                        if (e != null) {
                            this.log.error("Failed to apply config change", e);
                            onDone.completeExceptionally((Throwable)e);
                        } else {
                            this.linearizer.afterLogApplied(entry.getIndex());
                            this.metricManager.reportLastAppliedIndex(entry.getIndex());
                            onDone.complete(null);
                        }
                    });
                }
                catch (Throwable t) {
                    rangeWriter.abort();
                    this.log.error("Failed to apply command", t);
                    onDone.completeExceptionally(t);
                }
                break;
            }
            case DATA: {
                KVLoadRecorder loadRecorder = new KVLoadRecorder();
                IKVRangeWriter<?> rangeWriter = this.kvRange.toWriter(loadRecorder);
                LoadRecordableKVReader rangeReader = new LoadRecordableKVReader(this.kvRange.newReader(), loadRecorder);
                try {
                    KVRangeCommand command = (KVRangeCommand)ZeroCopyParser.parse((ByteString)entry.getData(), (Parser)KVRangeCommand.parser());
                    CompletionStage applyFuture = this.applyCommand(isLeader, entry.getTerm(), entry.getIndex(), command, rangeReader, rangeWriter).whenCompleteAsync((callback, e) -> {
                        block8: {
                            try {
                                if (onDone.isCancelled()) {
                                    rangeWriter.abort();
                                    break block8;
                                }
                                try {
                                    if (e != null) {
                                        this.log.debug("Failed to apply log: {}", (Object)this.log, e);
                                        rangeWriter.abort();
                                        onDone.completeExceptionally((Throwable)e);
                                        break block8;
                                    }
                                    rangeWriter.lastAppliedIndex(entry.getIndex());
                                    rangeWriter.done();
                                    if (command.hasRwCoProc()) {
                                        IKVLoadRecord loadRecord = loadRecorder.stop();
                                        this.splitHinters.forEach(hint -> hint.recordMutate(command.getRwCoProc(), loadRecord));
                                    }
                                    callback.run();
                                    this.linearizer.afterLogApplied(entry.getIndex());
                                    this.metricManager.reportLastAppliedIndex(entry.getIndex());
                                    onDone.complete(null);
                                }
                                catch (Throwable t) {
                                    this.log.error("Failed to apply log", t);
                                    onDone.completeExceptionally(t);
                                }
                            }
                            finally {
                                rangeReader.close();
                            }
                        }
                    }, (Executor)this.fsmExecutor);
                    onDone.whenCompleteAsync((arg_0, arg_1) -> KVRangeFSM.lambda$apply$43(onDone, (CompletableFuture)applyFuture, arg_0, arg_1));
                }
                catch (Throwable t) {
                    rangeReader.close();
                    this.log.error("Failed to apply log: {}", (Object)this.log, (Object)t);
                    onDone.completeExceptionally(t);
                }
                break;
            }
        }
        return onDone;
    }

    private Supplier<CompletableFuture<Void>> applyConfigChange(long term, long index, ClusterConfig config, IKVRangeReader rangeReader, IKVRangeWritable<?> rangeWriter) {
        long ver = rangeReader.version();
        State state = rangeReader.state();
        this.log.info("Apply new config[term={}, index={}]: state={}, ver={}, leader={}\n{}", new Object[]{term, index, state, VerUtil.print(ver), this.wal.isLeader(), config});
        rangeWriter.clusterConfig(config);
        if (config.getNextVotersCount() != 0 || config.getNextLearnersCount() != 0) {
            return () -> CompletableFuture.completedFuture(null);
        }
        HashSet members = Sets.newHashSet();
        members.addAll(config.getVotersList());
        members.addAll(config.getLearnersList());
        switch (state.getType()) {
            case ConfigChanging: {
                String taskId = state.getTaskId();
                rangeWriter.ver(VerUtil.bump(ver, false));
                if (taskId.equals(config.getCorrelateId())) {
                    boolean remove;
                    boolean bl = remove = !members.contains(this.hostStoreId);
                    if (remove) {
                        this.log.debug("Replica removed[newConfig={}]", (Object)config);
                        rangeWriter.state(State.newBuilder().setType(State.StateType.Removed).setTaskId(taskId).build());
                        return () -> {
                            this.quitSignal.complete(false);
                            this.finishCommand(taskId);
                            return CompletableFuture.completedFuture(null);
                        };
                    }
                    rangeWriter.state(State.newBuilder().setType(State.StateType.Normal).setTaskId(taskId).build());
                    return () -> {
                        this.finishCommand(taskId);
                        return CompletableFuture.completedFuture(null);
                    };
                }
                rangeWriter.state(State.newBuilder().setType(State.StateType.Normal).setTaskId(taskId).build());
                return () -> {
                    this.finishCommandWithError(taskId, new KVRangeException.TryLater("ConfigChange aborted by leader changes"));
                    return CompletableFuture.completedFuture(null);
                };
            }
            case MergedQuiting: {
                boolean remove;
                String taskId = state.getTaskId();
                boolean bl = remove = !members.contains(this.hostStoreId);
                if (remove) {
                    rangeWriter.state(State.newBuilder().setType(State.StateType.Removed).setTaskId(taskId).build());
                } else {
                    rangeWriter.state(State.newBuilder().setType(State.StateType.Merged).setTaskId(taskId).build());
                }
                rangeWriter.ver(VerUtil.bump(ver, false));
                return () -> {
                    this.finishCommand(taskId);
                    if (remove) {
                        this.quitSignal.complete(false);
                    }
                    return CompletableFuture.completedFuture(null);
                };
            }
            case ToBePurged: {
                String taskId = state.getTaskId();
                if (taskId.equals(config.getCorrelateId())) {
                    rangeWriter.state(State.newBuilder().setType(State.StateType.Removed).setTaskId(taskId).build());
                    return () -> {
                        this.finishCommand(taskId);
                        this.quitSignal.complete(false);
                        return CompletableFuture.completedFuture(null);
                    };
                }
                rangeWriter.state(State.newBuilder().setType(State.StateType.Normal).setTaskId(taskId).build());
                return () -> this.compactWAL().thenRunAsync(() -> {
                    this.log.debug("Purge failed due to leader change[newConfig={}]", (Object)config);
                    this.finishCommand(taskId);
                }, this.fsmExecutor);
            }
        }
        return () -> CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<Runnable> applyCommand(boolean isLeader, long logTerm, long logIndex, KVRangeCommand command, IKVRangeRefreshableReader rangeReader, IKVRangeWritable<?> rangeWriter) {
        CompletableFuture<Runnable> onDone = new CompletableFuture<Runnable>();
        long reqVer = command.getVer();
        String taskId = command.getTaskId();
        long ver = rangeReader.version();
        State state = rangeReader.state();
        Boundary boundary = rangeReader.boundary();
        ClusterConfig clusterConfig = rangeReader.clusterConfig();
        if (this.log.isTraceEnabled()) {
            this.log.trace("Execute KVRange Command[term={}, index={}, taskId={}]: ver={}, state={}, \n{}", new Object[]{logTerm, logIndex, taskId, VerUtil.print(ver), state, command});
        }
        block1 : switch (command.getCommandTypeCase()) {
            case CHANGECONFIG: {
                ChangeConfig newConfig = command.getChangeConfig();
                if (reqVer != ver) {
                    onDone.complete(() -> this.finishCommandWithError(taskId, new KVRangeException.BadVersion("Version Mismatch", this.latestLeaderDescriptor())));
                    break;
                }
                if (state.getType() != State.StateType.Normal && state.getType() != State.StateType.Merged) {
                    onDone.complete(() -> this.finishCommandWithError(taskId, new KVRangeException.TryLater("Config change abort, range is in state:" + state.getType().name())));
                    break;
                }
                this.log.info("Changing Config[term={}, index={}, taskId={}, ver={}, state={}]: nextVoters={}, nextLearners={}", new Object[]{logTerm, logIndex, taskId, VerUtil.print(ver), state, newConfig.getVotersList(), newConfig.getLearnersList()});
                CompletableFuture<Object> compactWALFuture = CompletableFuture.completedFuture(null);
                if (this.wal.latestSnapshot().getLastAppliedIndex() < logIndex - 1L) {
                    compactWALFuture = this.compactWAL();
                }
                compactWALFuture.whenCompleteAsync((v, e) -> {
                    if (e != null) {
                        this.log.error("WAL compact failed during ConfigChange[term={}, index={}, taskId={}]: ver={}, state={}", new Object[]{logTerm, logIndex, taskId, VerUtil.print(ver), state});
                        onDone.completeExceptionally((Throwable)e);
                    } else {
                        HashSet nextLearners;
                        boolean toBePurged = this.isGracefulQuit(clusterConfig, newConfig);
                        Sets.SetView newHostingStoreIds = Sets.difference((Set)Sets.difference((Set)Sets.union((Set)Sets.newHashSet((Iterable)newConfig.getVotersList()), (Set)Sets.newHashSet((Iterable)newConfig.getLearnersList())), (Set)Sets.union((Set)Sets.newHashSet((Iterable)clusterConfig.getVotersList()), (Set)Sets.newHashSet((Iterable)clusterConfig.getLearnersList()))), Collections.singleton(this.hostStoreId));
                        HashSet nextVoters = toBePurged ? Sets.newHashSet((Iterable)clusterConfig.getVotersList()) : Sets.newHashSet((Iterable)newConfig.getVotersList());
                        HashSet hashSet = nextLearners = toBePurged ? Collections.emptySet() : Sets.newHashSet((Iterable)newConfig.getLearnersList());
                        if (this.wal.isLeader()) {
                            List onceFutures = newHostingStoreIds.stream().map(storeId -> this.messenger.once(m -> {
                                if (m.hasEnsureRangeReply()) {
                                    EnsureRangeReply reply = m.getEnsureRangeReply();
                                    return reply.getResult() == EnsureRangeReply.Result.OK;
                                }
                                return false;
                            }).orTimeout(5L, TimeUnit.SECONDS)).collect(Collectors.toList());
                            CompletableFuture.allOf((CompletableFuture[])onceFutures.toArray(CompletableFuture[]::new)).whenCompleteAsync((v1, t) -> {
                                if (t != null) {
                                    String errorMessage = String.format("ConfigChange aborted[taskId=%s] due to %s", taskId, t.getMessage());
                                    this.log.warn(errorMessage);
                                    this.finishCommandWithError(taskId, new KVRangeException.TryLater(errorMessage));
                                    this.wal.stepDown();
                                    return;
                                }
                                this.wal.changeClusterConfig(taskId, nextVoters, nextLearners).whenCompleteAsync((v2, e2) -> {
                                    if (e2 != null) {
                                        String errorMessage = String.format("ConfigChange aborted[taskId=%s] due to %s", taskId, e2.getMessage());
                                        this.log.debug(errorMessage);
                                        this.finishCommandWithError(taskId, new KVRangeException.TryLater(errorMessage));
                                        this.wal.stepDown();
                                    }
                                }, (Executor)this.fsmExecutor);
                            }, (Executor)this.fsmExecutor);
                            newHostingStoreIds.forEach(storeId -> {
                                this.log.debug("Send EnsureRequest: taskId={}, targetStoreId={}", (Object)taskId, storeId);
                                ClusterConfig ensuredClusterConfig = ClusterConfig.getDefaultInstance();
                                this.messenger.send(KVRangeMessage.newBuilder().setRangeId(this.id).setHostStoreId(storeId).setEnsureRange(EnsureRange.newBuilder().setVer(ver).setBoundary(boundary).setInitSnapshot(Snapshot.newBuilder().setTerm(0L).setIndex(0L).setClusterConfig(ensuredClusterConfig).setData(KVRangeSnapshot.newBuilder().setVer(ver).setId(this.id).setLastAppliedIndex(0L).setBoundary(boundary).setState(state).setClusterConfig(ensuredClusterConfig).build().toByteString()).build()).build()).build());
                            });
                        } else {
                            this.wal.changeClusterConfig(taskId, nextVoters, nextLearners).whenCompleteAsync((v2, e2) -> {
                                if (e2 != null) {
                                    String errorMessage = String.format("ConfigChange aborted[taskId=%s] due to %s", taskId, e2.getMessage());
                                    this.log.debug(errorMessage);
                                    this.finishCommandWithError(taskId, new KVRangeException.TryLater(errorMessage));
                                    this.wal.stepDown();
                                }
                            }, (Executor)this.fsmExecutor);
                        }
                        if (state.getType() == State.StateType.Normal) {
                            if (toBePurged) {
                                rangeWriter.state(State.newBuilder().setType(State.StateType.ToBePurged).setTaskId(taskId).build());
                            } else {
                                rangeWriter.state(State.newBuilder().setType(State.StateType.ConfigChanging).setTaskId(taskId).build());
                            }
                        } else if (state.getType() == State.StateType.Merged) {
                            if (toBePurged) {
                                rangeWriter.state(State.newBuilder().setType(State.StateType.ToBePurged).setTaskId(taskId).build());
                            } else {
                                rangeWriter.state(State.newBuilder().setType(State.StateType.MergedQuiting).setTaskId(taskId).build());
                            }
                        }
                        rangeWriter.ver(VerUtil.bump(ver, false));
                        onDone.complete(NOOP);
                    }
                }, (Executor)this.fsmExecutor);
                break;
            }
            case SPLITRANGE: {
                SplitRange request = command.getSplitRange();
                if (reqVer != ver) {
                    onDone.complete(() -> this.finishCommandWithError(taskId, new KVRangeException.BadVersion("Version Mismatch", this.latestLeaderDescriptor())));
                    break;
                }
                if (state.getType() != State.StateType.Normal) {
                    onDone.complete(() -> this.finishCommandWithError(taskId, new KVRangeException.TryLater("Split abort, range is in state:" + state.getType().name())));
                    break;
                }
                if (BoundaryUtil.isSplittable((Boundary)boundary, (ByteString)request.getSplitKey())) {
                    this.log.info("Splitting range[term={}, index={}, taskId={}, ver={}, state={}]: newRangeId={}, splitKey={}", new Object[]{logTerm, logIndex, taskId, VerUtil.print(ver), state, KVRangeIdUtil.toString((KVRangeId)request.getNewId()), request.getSplitKey().toStringUtf8()});
                    Boundary[] boundaries = BoundaryUtil.split((Boundary)boundary, (ByteString)request.getSplitKey());
                    Boundary leftBoundary = boundaries[0];
                    Boundary rightBoundary = boundaries[1];
                    KVRangeSnapshot rhsSS = KVRangeSnapshot.newBuilder().setVer(VerUtil.bump(ver, true)).setId(request.getNewId()).setLastAppliedIndex(5L).setBoundary(rightBoundary).setClusterConfig(clusterConfig).setState(State.newBuilder().setType(State.StateType.Normal).setTaskId(taskId).build()).build();
                    ((IKVRangeWritable)rangeWriter.boundary(leftBoundary)).ver(VerUtil.bump(ver, true));
                    rangeWriter.migrateTo(request.getNewId(), rhsSS);
                    onDone.complete(() -> this.compactWAL().whenCompleteAsync((v, e) -> {
                        if (e != null) {
                            this.log.error("WAL compact failed after split", e);
                            this.quitSignal.complete(true);
                            return;
                        }
                        this.log.debug("Range split completed[taskId={}]", (Object)taskId);
                        this.resetHinterAndCoProc(leftBoundary);
                        this.finishCommand(taskId);
                        this.messenger.once(KVRangeMessage::hasEnsureRangeReply).orTimeout(300L, TimeUnit.SECONDS).whenCompleteAsync((rangeMsg, t) -> {
                            if (t != null || rangeMsg.getEnsureRangeReply().getResult() != EnsureRangeReply.Result.OK) {
                                this.log.error("Failed to load rhs range[taskId={}]: newRangeId={}", new Object[]{taskId, request.getNewId(), t});
                            }
                        }, (Executor)this.fsmExecutor);
                        this.log.debug("Sending EnsureRequest to load right KVRange[{}]", (Object)KVRangeIdUtil.toString((KVRangeId)request.getNewId()));
                        this.messenger.send(KVRangeMessage.newBuilder().setRangeId(rhsSS.getId()).setHostStoreId(this.hostStoreId).setEnsureRange(EnsureRange.newBuilder().setVer(rhsSS.getVer()).setBoundary(rhsSS.getBoundary()).setInitSnapshot(Snapshot.newBuilder().setTerm(0L).setIndex(rhsSS.getLastAppliedIndex()).setClusterConfig(rhsSS.getClusterConfig()).setData(rhsSS.toByteString()).build()).build()).build());
                    }, (Executor)this.fsmExecutor));
                    break;
                }
                onDone.complete(() -> this.finishCommandWithError(taskId, new KVRangeException.BadRequest("Invalid split key")));
                break;
            }
            case PREPAREMERGEWITH: {
                if (reqVer != ver) {
                    onDone.complete(() -> this.finishCommandWithError(taskId, new KVRangeException.BadVersion("Version Mismatch", this.latestLeaderDescriptor())));
                    break;
                }
                if (state.getType() != State.StateType.Normal) {
                    onDone.complete(() -> this.finishCommandWithError(taskId, new KVRangeException.TryLater("Merge abort, range is in state:" + state.getType().name())));
                    break;
                }
                if (!clusterConfig.getNextVotersList().isEmpty() || !clusterConfig.getNextLearnersList().isEmpty()) {
                    onDone.complete(() -> this.finishCommandWithError(taskId, new KVRangeException.TryLater("Merge abort, range is in config changing")));
                    break;
                }
                PrepareMergeWith request = command.getPrepareMergeWith();
                if (request.getVotersList().isEmpty()) {
                    onDone.complete(() -> this.finishCommandWithError(taskId, new KVRangeException.BadRequest("Merge abort, empty mergee voter set")));
                    break;
                }
                boolean isVoter = clusterConfig.getVotersList().contains((Object)this.hostStoreId);
                if (!isVoter) {
                    ((IKVRangeWritable)rangeWriter.ver(VerUtil.bump(ver, false))).state(State.newBuilder().setType(State.StateType.PreparedMerging).setTaskId(taskId).build());
                    onDone.complete(NOOP);
                    break;
                }
                CompletionStage requestFuture = this.trySendPrepareMergeToRequest(taskId, request.getMergeeId(), ver, boundary, (List<String>)request.getVotersList(), clusterConfig).thenAcceptAsync(v -> {
                    ((IKVRangeWritable)rangeWriter.ver(VerUtil.bump(ver, false))).state(State.newBuilder().setType(State.StateType.PreparedMerging).setTaskId(taskId).build());
                    onDone.complete(NOOP);
                }, (Executor)this.fsmExecutor);
                onDone.whenCompleteAsync((arg_0, arg_1) -> KVRangeFSM.lambda$applyCommand$74(onDone, (CompletableFuture)requestFuture, arg_0, arg_1));
                break;
            }
            case CANCELMERGING: {
                switch (state.getType()) {
                    case PreparedMerging: {
                        if (reqVer != ver) {
                            onDone.complete(NOOP);
                            break block1;
                        }
                        this.log.info("Merger canceled[term={}, index={}, taskId={}, ver={}, state={}]", new Object[]{logTerm, logIndex, taskId, VerUtil.print(ver), state});
                        ((IKVRangeWritable)rangeWriter.ver(VerUtil.bump(ver, false))).state(State.newBuilder().setType(State.StateType.Normal).setTaskId(taskId).build());
                        onDone.complete(() -> this.compactWAL().whenCompleteAsync((v, e) -> {
                            if (e != null) {
                                this.log.error("WAL compact failed after merger cancel", e);
                            }
                            this.finishCommandWithError(taskId, new KVRangeException.TryLater("Merger canceled"));
                        }, (Executor)this.fsmExecutor));
                        break block1;
                    }
                    case WaitingForMerge: {
                        if (reqVer != ver) {
                            onDone.complete(NOOP);
                            break block1;
                        }
                        this.log.info("Mergee canceled[term={}, index={}, taskId={}, ver={}, state={}]", new Object[]{logTerm, logIndex, taskId, VerUtil.print(ver), state});
                        rangeWriter.state(State.newBuilder().setType(State.StateType.Normal).setTaskId(taskId).build());
                        rangeWriter.ver(VerUtil.bump(ver, false));
                        onDone.complete(() -> this.compactWAL().whenComplete((v, e) -> {
                            if (e != null) {
                                this.log.error("WAL compact failed after mergee cancel", e);
                            }
                        }));
                        break block1;
                    }
                }
                onDone.complete(NOOP);
                break;
            }
            case PREPAREMERGETO: {
                PrepareMergeTo request = command.getPrepareMergeTo();
                if (state.getType() == State.StateType.WaitingForMerge) {
                    onDone.complete(NOOP);
                    break;
                }
                boolean isVoter = clusterConfig.getVotersList().contains((Object)this.hostStoreId);
                ClusterConfig mergerConfig = request.getConfig();
                ProtocolStringList mergerVoters = mergerConfig.getVotersList();
                if (!(state.getType() == State.StateType.Normal && clusterConfig.getNextVotersList().isEmpty() && clusterConfig.getNextLearnersList().isEmpty() && BoundaryUtil.canCombine((Boundary)request.getBoundary(), (Boundary)boundary))) {
                    if (!isVoter) {
                        rangeWriter.ver(VerUtil.bump(ver, false));
                        onDone.complete(NOOP);
                        break;
                    }
                    CompletionStage requestFuture = this.trySendCancelMergingRequest(taskId, request.getMergerId(), request.getMergerVer(), (List<String>)mergerVoters, (List<String>)clusterConfig.getVotersList()).whenCompleteAsync((reply, e) -> {
                        rangeWriter.ver(VerUtil.bump(ver, false));
                        onDone.complete(NOOP);
                    }, (Executor)this.fsmExecutor);
                    onDone.whenCompleteAsync((arg_0, arg_1) -> KVRangeFSM.lambda$applyCommand$80(onDone, (CompletableFuture)requestFuture, arg_0, arg_1));
                    break;
                }
                if (!isVoter) {
                    ((IKVRangeWritable)rangeWriter.ver(VerUtil.bump(ver, false))).state(State.newBuilder().setType(State.StateType.WaitingForMerge).setTaskId(taskId).build());
                    onDone.complete(NOOP);
                    break;
                }
                CompletionStage requestFuture = this.trySendMergeRequest(taskId, request.getMergerId(), request.getMergerVer(), ver, boundary, (List<String>)mergerVoters, clusterConfig).thenAcceptAsync(v -> {
                    ((IKVRangeWritable)rangeWriter.ver(VerUtil.bump(ver, false))).state(State.newBuilder().setType(State.StateType.WaitingForMerge).setTaskId(taskId).build());
                    onDone.complete(NOOP);
                }, (Executor)this.fsmExecutor);
                onDone.whenCompleteAsync((arg_0, arg_1) -> KVRangeFSM.lambda$applyCommand$82(onDone, (CompletableFuture)requestFuture, arg_0, arg_1));
                break;
            }
            case MERGE: {
                Merge request = command.getMerge();
                switch (state.getType()) {
                    case PreparedMerging: {
                        if (reqVer != ver) {
                            onDone.complete(NOOP);
                            break block1;
                        }
                        KVRangeId mergeeId = request.getMergeeId();
                        ClusterConfig mergeeConfig = request.getConfig();
                        boolean isVoter = clusterConfig.getVotersList().contains((Object)this.hostStoreId);
                        ArrayList<String> mergeeReplicas = new ArrayList<String>((Collection<String>)mergeeConfig.getVotersList());
                        mergeeReplicas.addAll((Collection<String>)mergeeConfig.getLearnersList());
                        IKVRangeWritable.Migrater migrater = rangeWriter.startMerging((count, bytes) -> {
                            this.mergePendingAt = -1L;
                            this.log.info("Merging data from mergee: taskId={}, received entries={}, bytes={}", new Object[]{taskId, count, bytes});
                        });
                        CompletionStage migrateFuture = ((CompletableFuture)this.tryMigrate(mergeeId, mergeeReplicas, (List<String>)clusterConfig.getVotersList(), migrater).thenComposeAsync(result -> {
                            switch (result) {
                                case SUCCESS_AFTER_RESET: {
                                    return CompletableFuture.completedFuture(() -> {
                                        this.log.debug("Restore from leader: mergeeId={}", (Object)KVRangeIdUtil.toString((KVRangeId)mergeeId));
                                        this.quitSignal.complete(true);
                                    });
                                }
                                case SUCCESS: {
                                    return ((CompletableFuture)this.tryConfirmMerged(taskId, ver).thenComposeAsync(mergeResult -> {
                                        if (mergeResult == TryConfirmMergedResult.ALREADY_CANCELED) {
                                            migrater.abort();
                                            return CompletableFuture.completedFuture(TryConfirmMergedResult.ALREADY_CANCELED);
                                        }
                                        if (isVoter) {
                                            return this.trySendMergeDoneRequest(taskId, mergeeId, request.getMergeeVer(), (List<String>)mergeeConfig.getVotersList(), (List<String>)clusterConfig.getVotersList()).thenApply(v -> TryConfirmMergedResult.MERGED);
                                        }
                                        return CompletableFuture.completedFuture(TryConfirmMergedResult.MERGED);
                                    }, (Executor)this.fsmExecutor)).thenApplyAsync(mergeResult -> {
                                        if (mergeResult == TryConfirmMergedResult.ALREADY_CANCELED) {
                                            migrater.abort();
                                            return NOOP;
                                        }
                                        long newVer = Math.max(ver, request.getMergeeVer());
                                        Boundary mergedBoundary = BoundaryUtil.combine((Boundary[])new Boundary[]{boundary, request.getBoundary()});
                                        migrater.ver(VerUtil.bump(newVer, true)).boundary(mergedBoundary).state(State.newBuilder().setType(State.StateType.Normal).setTaskId(taskId).build());
                                        return () -> {
                                            this.log.info("Merger done[term={}, index={}, taskId={}, ver={}, state={}]: mergeeId={}, boundary={}", new Object[]{logTerm, logIndex, taskId, VerUtil.print(ver), state, KVRangeIdUtil.toString((KVRangeId)request.getMergeeId()), mergedBoundary});
                                            this.compactWAL().whenCompleteAsync((v, t) -> {
                                                if (t != null) {
                                                    this.log.error("WAL compact failed after merge", t);
                                                }
                                                this.resetHinterAndCoProc(mergedBoundary);
                                                this.finishCommand(taskId);
                                            }, (Executor)this.fsmExecutor);
                                        };
                                    }, (Executor)this.fsmExecutor);
                                }
                            }
                            return this.tryCancelMerging(taskId, ver).thenApplyAsync(cancelMergingResult -> {
                                if (cancelMergingResult == TryCancelMergingResult.CANCELLED) {
                                    return NOOP;
                                }
                                return () -> {
                                    this.log.info("Merge confirmed, restore from leader: mergeeId={}", (Object)KVRangeIdUtil.toString((KVRangeId)mergeeId));
                                    this.quitSignal.complete(true);
                                };
                            }, (Executor)this.fsmExecutor);
                        }, (Executor)this.fsmExecutor)).thenAccept(onDone::complete);
                        onDone.whenCompleteAsync((arg_0, arg_1) -> KVRangeFSM.lambda$applyCommand$93(onDone, migrater, (CompletableFuture)migrateFuture, arg_0, arg_1));
                        break block1;
                    }
                    case Normal: {
                        if (VerUtil.boundaryCompatible(reqVer, ver)) {
                            if (!clusterConfig.getVotersList().contains((Object)this.hostStoreId)) {
                                onDone.complete(NOOP);
                                break block1;
                            }
                            CompletionStage requestFuture = this.trySendCancelMergingRequest(taskId, request.getMergeeId(), request.getMergeeVer(), (List<String>)request.getConfig().getVotersList(), (List<String>)clusterConfig.getVotersList()).whenCompleteAsync((reply, e) -> onDone.complete(NOOP), (Executor)this.fsmExecutor);
                            onDone.whenCompleteAsync((arg_0, arg_1) -> KVRangeFSM.lambda$applyCommand$95(onDone, (CompletableFuture)requestFuture, arg_0, arg_1));
                            break block1;
                        }
                        this.log.debug("Late Merge command ignored: mergeeId={}", (Object)KVRangeIdUtil.toString((KVRangeId)request.getMergeeId()));
                        onDone.complete(NOOP);
                        break block1;
                    }
                }
                onDone.complete(NOOP);
                break;
            }
            case MERGEDONE: {
                if (state.getType() != State.StateType.WaitingForMerge || reqVer != ver) {
                    onDone.complete(NOOP);
                    break;
                }
                this.log.info("Mergee done[term={}, index={}, taskId={}, ver={}, state={}]: mergeeId={}", new Object[]{logTerm, logIndex, taskId, VerUtil.print(ver), state, KVRangeIdUtil.toString((KVRangeId)this.id)});
                ((IKVRangeWritable)((IKVRangeWritable)rangeWriter.boundary(BoundaryUtil.NULL_BOUNDARY)).ver(VerUtil.bump(ver, true))).state(State.newBuilder().setType(State.StateType.Merged).setTaskId(taskId).build());
                onDone.complete(() -> this.compactWAL().whenCompleteAsync((v, e) -> {
                    if (e != null) {
                        this.log.error("WAL compact failed after merge", e);
                        this.quitSignal.complete(true);
                        return;
                    }
                    this.resetHinterAndCoProc(BoundaryUtil.NULL_BOUNDARY);
                }, (Executor)this.fsmExecutor));
                break;
            }
            case DELETE: 
            case PUT: 
            case RWCOPROC: {
                if (!VerUtil.boundaryCompatible(reqVer, ver)) {
                    onDone.complete(() -> this.finishCommandWithError(taskId, new KVRangeException.BadVersion("Version Mismatch", this.latestLeaderDescriptor())));
                    break;
                }
                if (state.getType() == State.StateType.NoUse || state.getType() == State.StateType.WaitingForMerge || state.getType() == State.StateType.Merged || state.getType() == State.StateType.MergedQuiting || state.getType() == State.StateType.Removed || state.getType() == State.StateType.ToBePurged) {
                    onDone.complete(() -> this.finishCommandWithError(taskId, new KVRangeException.TryLater("Range is being merge or has been merged: state=" + state.getType().name())));
                    break;
                }
                try {
                    switch (command.getCommandTypeCase()) {
                        case DELETE: {
                            Delete delete = command.getDelete();
                            Preconditions.checkArgument((boolean)BoundaryUtil.inRange((ByteString)delete.getKey(), (Boundary)boundary));
                            Optional value = rangeReader.get(delete.getKey());
                            if (value.isPresent()) {
                                rangeWriter.kvWriter().delete(delete.getKey());
                            }
                            onDone.complete(() -> this.finishCommand(taskId, value.orElse(ByteString.EMPTY)));
                            break block1;
                        }
                        case PUT: {
                            Put put = command.getPut();
                            Preconditions.checkArgument((boolean)BoundaryUtil.inRange((ByteString)put.getKey(), (Boundary)boundary));
                            Optional value = rangeReader.get(put.getKey());
                            rangeWriter.kvWriter().put(put.getKey(), put.getValue());
                            onDone.complete(() -> this.finishCommand(taskId, value.orElse(ByteString.EMPTY)));
                            break block1;
                        }
                        case RWCOPROC: {
                            Supplier resultSupplier = this.coProc.mutate(command.getRwCoProc(), (IKVRangeReader)rangeReader, rangeWriter.kvWriter(), isLeader);
                            onDone.complete(() -> this.lambda$applyCommand$102((Supplier)resultSupplier, taskId));
                            break block1;
                        }
                    }
                }
                catch (Throwable e2) {
                    onDone.complete(() -> this.finishCommandWithError(taskId, new KVRangeException.InternalException("Failed to execute " + command.getCommandTypeCase().name(), e2)));
                }
                break;
            }
            default: {
                this.log.error("Unknown KVRange Command[type={}]", (Object)command.getCommandTypeCase());
                onDone.complete(NOOP);
            }
        }
        return onDone;
    }

    private String randomPickOne(List<String> remoteVoters, List<String> localVoters) {
        if (remoteVoters.contains(this.hostStoreId)) {
            return this.hostStoreId;
        }
        Sets.SetView shared = Sets.intersection((Set)Sets.newHashSet(remoteVoters), (Set)Sets.newHashSet(localVoters));
        if (shared.isEmpty()) {
            return remoteVoters.get(ThreadLocalRandom.current().nextInt(remoteVoters.size()));
        }
        return (String)shared.iterator().next();
    }

    private CompletableFuture<TryMigrateResult> tryMigrate(KVRangeId mergeeId, List<String> mergeeReplicas, List<String> mergerVoters, IKVRangeWritable.Migrater migrater) {
        String sessionId = UUID.randomUUID().toString();
        String mergeeVoter = this.randomPickOne(mergeeReplicas, mergerVoters);
        KVRangeSnapshotReceiver receiver = new KVRangeSnapshotReceiver(sessionId, mergeeId, mergeeVoter, this.messenger, this.metricManager, this.fsmExecutor, Math.max(1, this.opts.getMergeTimeoutSec() / 4), this.log);
        this.log.debug("Start migrating data from mergee: mergeeId={}, store={}, session={}", new Object[]{KVRangeIdUtil.toString((KVRangeId)mergeeId), mergeeVoter, sessionId});
        CompletionStage migrateTask = receiver.start(migrater::put).thenCompose(result -> {
            switch (result.code()) {
                case TIME_OUT: 
                case NOT_FOUND: 
                case ERROR: {
                    migrater.abort();
                    this.log.debug("Migration failed: mergeeId={}, store={}, result={}", new Object[]{KVRangeIdUtil.toString((KVRangeId)mergeeId), mergeeVoter, result});
                    return this.wal.retrieveCommitted(this.kvRange.currentLastAppliedIndex() + 1L, Long.MAX_VALUE).handle((logEntryItr, e) -> {
                        if (e != null) {
                            this.log.error("Failed to retrieve log from wal from index[{}]", (Object)(this.kvRange.currentLastAppliedIndex() + 1L), e);
                            return TryMigrateResult.FAILED;
                        }
                        boolean migrationDone = false;
                        while (logEntryItr.hasNext()) {
                            LogEntry logEntry = (LogEntry)logEntryItr.next();
                            if (!logEntry.hasData()) continue;
                            try {
                                KVRangeCommand command = (KVRangeCommand)ZeroCopyParser.parse((ByteString)logEntry.getData(), (Parser)KVRangeCommand.parser());
                                if (!command.hasMergeDone()) continue;
                                this.log.debug("Merge has done by {}", (Object)command.getMergeDone().getStoreId());
                                migrationDone = true;
                            }
                            catch (Throwable t) {
                                this.log.error("Failed to parse logEntry", t);
                            }
                            break;
                        }
                        logEntryItr.close();
                        return migrationDone ? TryMigrateResult.SUCCESS_AFTER_RESET : TryMigrateResult.FAILED;
                    });
                }
            }
            this.log.debug("Migration completed: mergeeId={}, store={}", (Object)KVRangeIdUtil.toString((KVRangeId)mergeeId), (Object)mergeeVoter);
            return CompletableFuture.completedFuture(TryMigrateResult.SUCCESS);
        });
        this.messenger.send(KVRangeMessage.newBuilder().setRangeId(mergeeId).setHostStoreId(mergeeVoter).setDataMergeRequest(DataMergeRequest.newBuilder().setSessionId(sessionId).setMergerId(this.id).build()).build());
        return migrateTask;
    }

    private CompletableFuture<TryCancelMergingResult> tryCancelMerging(String taskId, long ver) {
        Supplier<CompletableFuture> proposeCancelTask = () -> this.wal.propose(KVRangeCommand.newBuilder().setTaskId(taskId).setVer(ver).setCancelMerging(CancelMerging.newBuilder().build()).build());
        return ((CompletableFuture)AsyncRetry.exec(proposeCancelTask, (index, e) -> e != null, (long)Duration.ofSeconds(5L).toNanos(), (long)Long.MAX_VALUE).thenComposeAsync(index -> this.wal.once(this.kvRange.currentLastAppliedIndex(), logEntry -> {
            if (logEntry.hasData()) {
                try {
                    KVRangeCommand command = (KVRangeCommand)ZeroCopyParser.parse((ByteString)logEntry.getData(), (Parser)KVRangeCommand.parser());
                    if (command.hasMergeDone() || command.hasCancelMerging()) {
                        return true;
                    }
                }
                catch (Throwable t) {
                    this.log.error("Failed to parse logEntry", t);
                }
            }
            return false;
        }, this.fsmExecutor), (Executor)this.fsmExecutor)).thenApply(logEntry -> {
            try {
                KVRangeCommand command = (KVRangeCommand)ZeroCopyParser.parse((ByteString)logEntry.getData(), (Parser)KVRangeCommand.parser());
                return command.hasCancelMerging() ? TryCancelMergingResult.CANCELLED : TryCancelMergingResult.ALREADY_MERGED;
            }
            catch (Throwable t) {
                throw new KVRangeException("Should never happen", t);
            }
        });
    }

    private CompletableFuture<TryConfirmMergedResult> tryConfirmMerged(String taskId, long ver) {
        Supplier<CompletableFuture> proposeCancelTask = () -> this.wal.propose(KVRangeCommand.newBuilder().setTaskId(taskId).setVer(ver).setMergeDone(MergeDone.newBuilder().setStoreId(this.hostStoreId).build()).build());
        return ((CompletableFuture)AsyncRetry.exec(proposeCancelTask, (index, e) -> e != null, (long)Duration.ofSeconds(5L).toNanos(), (long)Long.MAX_VALUE).thenComposeAsync(index -> this.wal.once(this.kvRange.currentLastAppliedIndex(), logEntry -> {
            if (logEntry.hasData()) {
                try {
                    KVRangeCommand command = (KVRangeCommand)ZeroCopyParser.parse((ByteString)logEntry.getData(), (Parser)KVRangeCommand.parser());
                    if (command.hasMergeDone() || command.hasCancelMerging()) {
                        return true;
                    }
                }
                catch (Throwable t) {
                    this.log.error("Failed to parse logEntry", t);
                }
            }
            return false;
        }, this.fsmExecutor), (Executor)this.fsmExecutor)).thenApply(logEntry -> {
            try {
                KVRangeCommand command = (KVRangeCommand)ZeroCopyParser.parse((ByteString)logEntry.getData(), (Parser)KVRangeCommand.parser());
                return command.hasCancelMerging() ? TryConfirmMergedResult.ALREADY_CANCELED : TryConfirmMergedResult.MERGED;
            }
            catch (Throwable t) {
                throw new KVRangeException("Should never happen", t);
            }
        });
    }

    private CompletableFuture<Void> trySendPrepareMergeToRequest(String taskId, KVRangeId mergeeId, long mergerVer, Boundary mergerBoundary, List<String> mergeeVoters, ClusterConfig mergerConfig) {
        Supplier<CompletableFuture> sendTask = () -> {
            String mergeeVoter = this.randomPickOne(mergeeVoters, (List<String>)mergerConfig.getVotersList());
            CompletionStage replyFuture = ((CompletableFuture)this.messenger.once(m -> m.hasPrepareMergeToReply() && m.getRangeId().equals((Object)mergeeId) && m.getPrepareMergeToReply().getTaskId().equals(taskId)).orTimeout(1L, TimeUnit.SECONDS).thenApply(KVRangeMessage::getPrepareMergeToReply)).exceptionally(e -> PrepareMergeToReply.newBuilder().setTaskId(taskId).setAccept(false).build());
            this.log.debug("Send PrepareMergeTo request: mergeeId={}, mergeeStore={}", (Object)KVRangeIdUtil.toString((KVRangeId)mergeeId), (Object)mergeeVoter);
            this.messenger.send(KVRangeMessage.newBuilder().setHostStoreId(mergeeVoter).setRangeId(mergeeId).setPrepareMergeToRequest(PrepareMergeToRequest.newBuilder().setTaskId(taskId).setId(this.id).setVer(VerUtil.bump(mergerVer, false)).setBoundary(mergerBoundary).setConfig(mergerConfig).build()).build());
            return replyFuture;
        };
        return AsyncRetry.exec(sendTask, (reply, e) -> !reply.getAccept(), (long)Duration.ofSeconds(this.opts.getMergeTimeoutSec() / 2).toNanos(), (long)Duration.ofSeconds(this.opts.getMergeTimeoutSec()).toNanos()).handle((reply, e) -> {
            if (e != null) {
                this.log.warn("Failed to send PrepareMergeTo request: mergeeId={}", (Object)KVRangeIdUtil.toString((KVRangeId)mergeeId), e);
            } else if (!reply.getAccept()) {
                this.log.debug("Mergee rejected PrepareMergeTo request: mergeeId={} ", (Object)KVRangeIdUtil.toString((KVRangeId)mergeeId));
            } else {
                this.log.debug("Mergee accepted PrepareMergeTo request: mergeeId={} ", (Object)KVRangeIdUtil.toString((KVRangeId)mergeeId));
            }
            return null;
        });
    }

    private CompletableFuture<Void> trySendMergeDoneRequest(String taskId, KVRangeId mergeeId, long mergeeVer, List<String> mergeeVoters, List<String> mergerVoters) {
        Supplier<CompletableFuture> sendTask = () -> {
            String mergeeVoter = this.randomPickOne(mergeeVoters, mergerVoters);
            CompletionStage replyFuture = ((CompletableFuture)this.messenger.once(m -> m.hasMergeDoneReply() && m.getRangeId().equals((Object)mergeeId) && m.getMergeDoneReply().getTaskId().equals(taskId)).thenApply(KVRangeMessage::getMergeDoneReply)).orTimeout(1L, TimeUnit.SECONDS).exceptionally(e -> MergeDoneReply.newBuilder().setTaskId(taskId).setAccept(false).build());
            this.log.debug("Send MergeDone request: mergeeId={}, mergeeStore={}", (Object)KVRangeIdUtil.toString((KVRangeId)mergeeId), (Object)mergeeVoter);
            this.messenger.send(KVRangeMessage.newBuilder().setRangeId(mergeeId).setHostStoreId(mergeeVoter).setMergeDoneRequest(MergeDoneRequest.newBuilder().setId(this.id).setTaskId(taskId).setMergeeVer(mergeeVer).setStoreId(this.hostStoreId).build()).build());
            return replyFuture;
        };
        return AsyncRetry.exec(sendTask, (reply, e) -> !reply.getAccept(), (long)Duration.ofSeconds(this.opts.getMergeTimeoutSec() / 2).toNanos(), (long)Duration.ofSeconds(this.opts.getMergeTimeoutSec()).toNanos()).handle((reply, e) -> {
            if (e != null) {
                this.log.warn("Failed to send MergeDone request: mergeeId={}", (Object)KVRangeIdUtil.toString((KVRangeId)mergeeId), e);
            } else if (!reply.getAccept()) {
                this.log.debug("Mergee rejected MergeDone request: mergeeId={} ", (Object)KVRangeIdUtil.toString((KVRangeId)mergeeId));
            } else {
                this.log.debug("Mergee accepted MergeDone request: mergeeId={} ", (Object)KVRangeIdUtil.toString((KVRangeId)mergeeId));
            }
            return null;
        });
    }

    private CompletableFuture<Void> trySendCancelMergingRequest(String taskId, KVRangeId remoteRangeId, long remoteRangeVer, List<String> remoteRangeVoters, List<String> localVoters) {
        Supplier<CompletableFuture> sendCancelRequestTask = () -> {
            String mergerVoter = this.randomPickOne(remoteRangeVoters, localVoters);
            CompletionStage cancelReplyFuture = ((CompletableFuture)this.messenger.once(m -> m.hasCancelMergingReply() && m.getRangeId().equals((Object)remoteRangeId) && m.getCancelMergingReply().getTaskId().equals(taskId)).orTimeout(1L, TimeUnit.SECONDS).thenApply(KVRangeMessage::getCancelMergingReply)).exceptionally(v -> CancelMergingReply.newBuilder().setTaskId(taskId).setAccept(false).build());
            this.log.debug("Send CancelMerging request: remoteRangeId={}, storeId={}", (Object)KVRangeIdUtil.toString((KVRangeId)remoteRangeId), (Object)mergerVoter);
            this.messenger.send(KVRangeMessage.newBuilder().setRangeId(remoteRangeId).setHostStoreId(mergerVoter).setCancelMergingRequest(CancelMergingRequest.newBuilder().setTaskId(taskId).setVer(remoteRangeVer).setRequester(this.id).build()).build());
            return cancelReplyFuture;
        };
        return AsyncRetry.exec(sendCancelRequestTask, (reply, e) -> !reply.getAccept(), (long)Duration.ofSeconds(this.opts.getMergeTimeoutSec() / 2).toNanos(), (long)Duration.ofSeconds(this.opts.getMergeTimeoutSec()).toNanos()).handle((reply, e) -> {
            if (e != null) {
                this.log.warn("Failed to send CancelMerging request: remoteRangeId={}", (Object)KVRangeIdUtil.toString((KVRangeId)remoteRangeId), e);
            } else if (!reply.getAccept()) {
                this.log.debug("Mergee rejected CancelMerging request: remoteRangeId={} ", (Object)KVRangeIdUtil.toString((KVRangeId)remoteRangeId));
            } else {
                this.log.debug("Mergee accepted CancelMerging request: remoteRangeId={} ", (Object)KVRangeIdUtil.toString((KVRangeId)remoteRangeId));
            }
            return null;
        });
    }

    private CompletableFuture<Void> trySendMergeRequest(String taskId, KVRangeId mergerId, long mergerVer, long mergeeVer, Boundary boundary, List<String> mergerVoters, ClusterConfig mergeeConfig) {
        Supplier<CompletableFuture> sendMergeRequestTask = () -> {
            String mergerVoter = this.randomPickOne(mergerVoters, (List<String>)mergeeConfig.getVotersList());
            CompletionStage replyFuture = ((CompletableFuture)this.messenger.once(m -> m.hasMergeReply() && m.getRangeId().equals((Object)mergerId) && m.getMergeReply().getTaskId().equals(taskId)).orTimeout(1L, TimeUnit.SECONDS).thenApply(KVRangeMessage::getMergeReply)).exceptionally(e -> MergeReply.newBuilder().setTaskId(taskId).setAccept(false).build());
            this.log.debug("Send Merge request: mergerId={}, storeId={}", (Object)KVRangeIdUtil.toString((KVRangeId)mergerId), (Object)mergerVoter);
            this.messenger.send(KVRangeMessage.newBuilder().setHostStoreId(mergerVoter).setRangeId(mergerId).setMergeRequest(MergeRequest.newBuilder().setTaskId(taskId).setVer(mergerVer).setMergeeId(this.id).setMergeeVer(VerUtil.bump(mergeeVer, false)).setStoreId(this.hostStoreId).setBoundary(boundary).setConfig(mergeeConfig).build()).build());
            return replyFuture;
        };
        return AsyncRetry.exec(sendMergeRequestTask, (reply, e) -> !reply.getAccept(), (long)Duration.ofSeconds(this.opts.getMergeTimeoutSec() / 2).toNanos(), (long)Duration.ofSeconds(this.opts.getMergeTimeoutSec()).toNanos()).handle((reply, e) -> {
            if (e != null) {
                this.log.warn("Failed to send Merge request: mergerId={}", (Object)KVRangeIdUtil.toString((KVRangeId)mergerId), e);
            } else if (!reply.getAccept()) {
                this.log.debug("Mergee rejected Merge request: mergerId={} ", (Object)KVRangeIdUtil.toString((KVRangeId)mergerId));
            } else {
                this.log.debug("Merger accepted Merge request: mergerId={} ", (Object)KVRangeIdUtil.toString((KVRangeId)mergerId));
            }
            return null;
        });
    }

    private void resetHinterAndCoProc(Boundary boundary) {
        try {
            this.splitHinters.forEach(hinter -> hinter.reset(boundary));
            this.factSubject.onNext((Object)this.reset(boundary));
        }
        catch (Throwable ex) {
            this.log.error("Failed to reset hinter or coProc after boundary change", ex);
        }
    }

    private boolean isGracefulQuit(ClusterConfig currentConfig, ChangeConfig nextConfig) {
        return Set.of(this.hostStoreId).containsAll((Collection<?>)currentConfig.getVotersList()) && currentConfig.getLearnersCount() == 0 && nextConfig.getVotersCount() == 0 && nextConfig.getLearnersCount() == 0;
    }

    private KVRangeDescriptor latestLeaderDescriptor() {
        if (this.wal.isLeader()) {
            return (KVRangeDescriptor)this.descriptorSubject.getValue();
        }
        return null;
    }

    private KVRangeDescriptor latestDescriptor() {
        return (KVRangeDescriptor)this.descriptorSubject.getValue();
    }

    private CompletableFuture<Void> restore(KVRangeSnapshot snapshot, String leader, IKVRangeWALSubscriber.IAfterRestoredCallback onInstalled) {
        if (this.isNotOpening()) {
            return onInstalled.call(null, new KVRangeException.InternalException("Range not open:" + KVRangeIdUtil.toString((KVRangeId)this.id)));
        }
        return this.mgmtTaskRunner.addFirst(() -> {
            if (this.isNotOpening()) {
                return CompletableFuture.completedFuture(null);
            }
            return ((CompletableFuture)((CompletableFuture)this.restorer.restoreFrom(leader, snapshot).handle((result, ex) -> {
                if (ex != null) {
                    return onInstalled.call(null, (Throwable)ex);
                }
                return onInstalled.call(this.kvRange.checkpoint(), null);
            })).thenCompose(f -> f)).whenCompleteAsync(CompletableFutureUtil.unwrap((v, e) -> {
                if (e != null) {
                    if (e instanceof SnapshotException.ObsoleteSnapshotException) {
                        this.log.debug("Obsolete snapshot, reset kvRange to latest snapshot: \n{}", (Object)snapshot);
                    }
                } else {
                    this.linearizer.afterLogApplied(snapshot.getLastAppliedIndex());
                    this.metricManager.reportLastAppliedIndex(snapshot.getLastAppliedIndex());
                    this.factSubject.onNext((Object)this.reset(snapshot.getBoundary()));
                    this.cmdFutures.keySet().forEach(taskId -> this.finishCommandWithError((String)taskId, new KVRangeException.TryLater("Restored from snapshot, try again")));
                }
            }), (Executor)this.fsmExecutor);
        });
    }

    private void estimateSplitHint() {
        this.splitHintsSubject.onNext(this.splitHinters.stream().map(IKVRangeSplitHinter::estimate).toList());
    }

    private void shrinkWAL() {
        if (this.isNotOpening()) {
            return;
        }
        if (this.shrinkingWAL.compareAndSet(false, true)) {
            long now = System.nanoTime();
            if (now - this.lastShrinkCheckAt.get() < Duration.ofSeconds(this.opts.getShrinkWALCheckIntervalSec()).toNanos()) {
                this.shrinkingWAL.set(false);
                return;
            }
            this.lastShrinkCheckAt.set(now);
            if (this.wal.logDataSize() < (long)this.opts.getCompactWALThreshold()) {
                this.shrinkingWAL.set(false);
                return;
            }
            this.mgmtTaskRunner.add(() -> {
                if (this.isNotOpening() || this.kvRange.currentState().getType() == State.StateType.ConfigChanging) {
                    this.shrinkingWAL.set(false);
                    return CompletableFuture.completedFuture(null);
                }
                KVRangeSnapshot latestSnapshot = this.wal.latestSnapshot();
                long lastAppliedIndex = this.kvRange.currentLastAppliedIndex();
                if (this.wal.logDataSize() < (long)this.opts.getCompactWALThreshold()) {
                    this.shrinkingWAL.set(false);
                    return CompletableFuture.completedFuture(null);
                }
                if (!this.dumpSessions.isEmpty() || !this.restorer.awaitDone().isDone()) {
                    this.shrinkingWAL.set(false);
                    return CompletableFuture.completedFuture(null);
                }
                this.log.debug("Shrink wal with snapshot: lastAppliedIndex={}\n{}", (Object)lastAppliedIndex, (Object)latestSnapshot);
                return this.doCompactWAL().whenComplete((v, e) -> this.shrinkingWAL.set(false));
            });
        }
    }

    private CompletableFuture<Void> compactWAL() {
        this.dumpSessions.forEach((sessionId, session) -> {
            session.cancel();
            this.dumpSessions.remove(sessionId, session);
        });
        return this.mgmtTaskRunner.add(this::doCompactWAL);
    }

    private CompletableFuture<Void> doCompactWAL() {
        return this.metricManager.recordCompact(() -> {
            KVRangeSnapshot snapshot = this.kvRange.checkpoint();
            this.log.debug("Compact wal using snapshot:\n{}", (Object)snapshot);
            return this.wal.compact(snapshot).whenComplete((v, e) -> {
                if (e != null) {
                    Throwable cause = e instanceof CompletionException && e.getCause() != null ? e.getCause() : e;
                    this.log.error("Failed to compact WAL due to {}: \n{}", (Object)cause.getMessage(), (Object)snapshot);
                }
            });
        });
    }

    private void detectZombieState(KVRangeDescriptor descriptor) {
        if (this.zombieAt < 0L) {
            if (descriptor.getRole() == RaftNodeStatus.Candidate) {
                this.zombieAt = HLC.INST.getPhysical();
            }
        } else if (descriptor.getRole() != RaftNodeStatus.Candidate) {
            this.zombieAt = -1L;
        }
    }

    private void judgeZombieState() {
        CompletableFuture checkFuture = this.quitZombie.getAndSet(null);
        if (this.zombieAt > 0L && Duration.ofMillis(HLC.INST.getPhysical() - this.zombieAt).toSeconds() > (long)this.opts.getZombieTimeoutSec()) {
            ClusterConfig clusterConfig = this.wal.latestClusterConfig();
            if (clusterConfig.getNextVotersCount() > 0 && clusterConfig.getVotersList().equals(Collections.singletonList(this.hostStoreId))) {
                if (this.recovering.compareAndSet(false, true)) {
                    this.log.info("Recovering from lost quorum during changing config from single voter: \n{}", (Object)clusterConfig);
                    this.wal.recover().whenComplete((v, e) -> {
                        this.recovering.set(false);
                        checkFuture.complete(false);
                    });
                } else {
                    checkFuture.complete(false);
                }
            } else if (checkFuture != null) {
                this.log.info("Zombie state detected, send quit signal.");
                this.quitSignal.complete(false);
                checkFuture.complete(true);
            }
        } else if (checkFuture != null) {
            checkFuture.complete(false);
        }
    }

    private void checkMergeTimeout() {
        State state = this.kvRange.currentState();
        switch (state.getType()) {
            case PreparedMerging: {
                boolean timeout;
                if (this.mergePendingAt < 0L) {
                    this.mergePendingAt = System.nanoTime();
                    break;
                }
                boolean bl = timeout = Duration.ofSeconds(this.opts.getMergeTimeoutSec()).compareTo(Duration.ofNanos(System.nanoTime() - this.mergePendingAt)) <= 0;
                if (!timeout || !this.wal.isLeader() || !this.cancelingMerge.compareAndSet(false, true)) break;
                this.log.debug("Merge timeout, auto cancel merging: mergeeId={}", (Object)KVRangeIdUtil.toString((KVRangeId)this.id));
                ((CompletableFuture)this.wal.propose(KVRangeCommand.newBuilder().setTaskId(state.getTaskId()).setVer(this.kvRange.currentVer()).setCancelMerging(CancelMerging.newBuilder().build()).build()).thenRun(() -> {
                    this.mergePendingAt = -1L;
                })).whenComplete((logIdx, e) -> this.cancelingMerge.set(false));
                break;
            }
            case WaitingForMerge: {
                boolean timeout;
                if (this.mergePendingAt < 0L) {
                    this.mergePendingAt = System.nanoTime();
                    break;
                }
                boolean bl = timeout = Duration.ofSeconds(this.opts.getMergeTimeoutSec()).compareTo(Duration.ofNanos(System.nanoTime() - this.mergePendingAt)) <= 0;
                if (!timeout || !this.wal.isLeader()) break;
                this.log.debug("Merge timeout, broadcast merge help: mergeeId={}", (Object)KVRangeIdUtil.toString((KVRangeId)this.id));
                this.messenger.send(KVRangeMessage.newBuilder().setMergeHelpRequest(MergeHelpRequest.newBuilder().setTaskId(state.getTaskId()).setMergeeId(this.id).setVer(this.kvRange.currentVer()).setBoundary(this.boundary()).setConfig(this.wal.latestClusterConfig()).build()).build());
                this.mergePendingAt = -1L;
                break;
            }
            default: {
                this.mergePendingAt = -1L;
            }
        }
    }

    private boolean isNotOpening() {
        Lifecycle state = this.lifecycle.get();
        return state != Lifecycle.Open;
    }

    private void handleMessage(KVRangeMessage message) {
        switch (message.getPayloadTypeCase()) {
            case WALRAFTMESSAGES: {
                this.handleWALMessages(message.getHostStoreId(), message.getWalRaftMessages().getWalMessagesList());
                break;
            }
            case SNAPSHOTSYNCREQUEST: {
                this.handleSnapshotSyncRequest(message.getHostStoreId(), message.getSnapshotSyncRequest());
                break;
            }
            case PREPAREMERGETOREQUEST: {
                this.handlePrepareMergeToRequest(message.getHostStoreId(), message.getPrepareMergeToRequest());
                break;
            }
            case MERGEREQUEST: {
                this.handleMergeRequest(message.getHostStoreId(), message.getMergeRequest());
                break;
            }
            case CANCELMERGINGREQUEST: {
                this.handleCancelMergingRequest(message.getHostStoreId(), message.getCancelMergingRequest());
                break;
            }
            case MERGEDONEREQUEST: {
                this.handleMergeDoneRequest(message.getHostStoreId(), message.getMergeDoneRequest());
                break;
            }
            case DATAMERGEREQUEST: {
                this.handleDataMergeRequest(message.getHostStoreId(), message.getDataMergeRequest());
                break;
            }
            case MERGEHELPREQUEST: {
                this.handleMergeHelpRequest(message.getHostStoreId(), message.getMergeHelpRequest());
                break;
            }
        }
    }

    private void handleWALMessages(String peerId, List<RaftMessage> messages) {
        this.wal.receivePeerMessages(peerId, messages);
    }

    private void handleSnapshotSyncRequest(String follower, SnapshotSyncRequest request) {
        this.log.info("Dumping snapshot: session={}: follower={}\n{}", new Object[]{request.getSessionId(), follower, request.getSnapshot()});
        this.startDumpSession(request.getSessionId(), request.getSnapshot(), request.getSnapshot().getId(), follower);
    }

    private void handlePrepareMergeToRequest(String peer, PrepareMergeToRequest request) {
        this.log.debug("Handle PrepareMergeTo request \n{}", (Object)request);
        AtomicReference disposableRef = new AtomicReference();
        this.disposables.add(this.descriptorSubject.firstElement().observeOn(Schedulers.from((Executor)this.mgmtExecutor)).doOnSubscribe(disposableRef::set).doOnDispose(() -> {
            Disposable disposable = (Disposable)disposableRef.get();
            if (disposable != null) {
                this.disposables.delete((Disposable)disposableRef.get());
            }
        }).subscribe(latestDesc -> this.wal.propose(KVRangeCommand.newBuilder().setTaskId(request.getTaskId()).setVer(latestDesc.getVer()).setPrepareMergeTo(PrepareMergeTo.newBuilder().setMergerId(request.getId()).setMergerVer(request.getVer()).setBoundary(request.getBoundary()).setConfig(request.getConfig()).build()).build()).whenCompleteAsync((proposalIndex, e) -> {
            if (e != null) {
                this.log.debug("Failed to propose command[PrepareMergeTo]: \n{}", (Object)request, e);
            } else {
                this.log.debug("Command[PrepareMergeTo] proposed: index={}\n{}", proposalIndex, (Object)request);
            }
            this.messenger.send(KVRangeMessage.newBuilder().setRangeId(request.getId()).setHostStoreId(peer).setPrepareMergeToReply(PrepareMergeToReply.newBuilder().setTaskId(request.getTaskId()).setAccept(e == null).build()).build());
        }, (Executor)this.fsmExecutor)));
    }

    private void handleMergeRequest(String peer, MergeRequest request) {
        this.log.debug("Handle Merge request: \n{}", (Object)request);
        this.wal.propose(KVRangeCommand.newBuilder().setTaskId(request.getTaskId()).setVer(request.getVer()).setMerge(Merge.newBuilder().setMergeeId(request.getMergeeId()).setMergeeVer(request.getMergeeVer()).setBoundary(request.getBoundary()).setStoreId(request.getStoreId()).setConfig(request.getConfig()).build()).build()).whenCompleteAsync((v, e) -> {
            if (e != null) {
                this.log.debug("Failed to propose command[Merge]: \n{}", (Object)request, e);
            } else {
                this.log.debug("Command[Merge] proposed: index={}\n{}", v, (Object)request);
            }
            this.messenger.send(KVRangeMessage.newBuilder().setRangeId(request.getMergeeId()).setHostStoreId(peer).setMergeReply(MergeReply.newBuilder().setTaskId(request.getTaskId()).setAccept(e == null).build()).build());
        }, (Executor)this.fsmExecutor);
    }

    private void handleCancelMergingRequest(String peer, CancelMergingRequest request) {
        this.log.debug("Handle CancelMerging request: \n{}", (Object)request);
        this.wal.propose(KVRangeCommand.newBuilder().setTaskId(request.getTaskId()).setVer(request.getVer()).setCancelMerging(CancelMerging.newBuilder().build()).build()).whenCompleteAsync((v, e) -> {
            if (e != null) {
                this.log.debug("Failed to propose command[CancelMerging]: \n{}", (Object)request, e);
            } else {
                this.log.debug("Command[CancelMerging] proposed: index={}\n{}", v, (Object)request);
            }
            this.messenger.send(KVRangeMessage.newBuilder().setRangeId(request.getRequester()).setHostStoreId(peer).setCancelMergingReply(CancelMergingReply.newBuilder().setTaskId(request.getTaskId()).setAccept(e == null).build()).build());
        }, (Executor)this.fsmExecutor);
    }

    private void handleMergeDoneRequest(String peer, MergeDoneRequest request) {
        this.log.debug("Handle MergeDone request: \n{}", (Object)request);
        this.wal.propose(KVRangeCommand.newBuilder().setTaskId(request.getTaskId()).setVer(request.getMergeeVer()).setMergeDone(MergeDone.newBuilder().setStoreId(request.getStoreId()).build()).build()).whenCompleteAsync((v, e) -> {
            if (e != null) {
                this.log.debug("Failed to propose command[MergeDone]: \n{}", (Object)request, e);
            } else {
                this.log.debug("Command[MergeDone] proposed: index={}\n{}", v, (Object)request);
            }
            this.messenger.send(KVRangeMessage.newBuilder().setRangeId(request.getId()).setHostStoreId(peer).setMergeDoneReply(MergeDoneReply.newBuilder().setTaskId(request.getTaskId()).setAccept(e == null).build()).build());
        }, (Executor)this.fsmExecutor);
    }

    private void handleDataMergeRequest(String peer, DataMergeRequest request) {
        this.log.debug("Handle DataMerge request: \n{}", (Object)request);
        AtomicReference disposableRef = new AtomicReference();
        this.disposables.add(this.descriptorSubject.filter(desc -> desc.getState() == State.StateType.WaitingForMerge).firstElement().observeOn(Schedulers.from((Executor)this.mgmtExecutor)).doOnSubscribe(disposableRef::set).doOnDispose(() -> {
            Disposable disposable = (Disposable)disposableRef.get();
            if (disposable != null) {
                this.disposables.delete((Disposable)disposableRef.get());
            }
        }).subscribe(desc -> {
            KVRangeSnapshot checkpoint = this.kvRange.checkpoint();
            this.startDumpSession(request.getSessionId(), checkpoint, request.getMergerId(), peer);
        }));
    }

    private void handleMergeHelpRequest(String peer, MergeHelpRequest request) {
        this.log.debug("Handle MergeHelp request: \n{}", (Object)request);
        KVRangeId mergeeId = request.getMergeeId();
        Boundary mergeeBoundary = request.getBoundary();
        Boundary myBoundary = this.boundary();
        ByteString myEndKey = BoundaryUtil.endKey((Boundary)myBoundary);
        ByteString mergeeStartKey = BoundaryUtil.startKey((Boundary)mergeeBoundary);
        if (this.kvRange.currentState().getType() == State.StateType.Normal && mergeeId.getEpoch() == this.id.getEpoch()) {
            if (Objects.equals(myEndKey, mergeeStartKey)) {
                this.log.debug("help mergee cancel: mergeeId={}", (Object)KVRangeIdUtil.toString((KVRangeId)request.getMergeeId()));
                this.messenger.send(KVRangeMessage.newBuilder().setRangeId(mergeeId).setHostStoreId(peer).setCancelMergingRequest(CancelMergingRequest.newBuilder().setTaskId(request.getTaskId()).setVer(request.getVer()).setRequester(this.id).build()).build());
            } else if (BoundaryUtil.inRange((Boundary)mergeeBoundary, (Boundary)myBoundary)) {
                this.log.debug("help mergee finish: mergeeId={}", (Object)KVRangeIdUtil.toString((KVRangeId)request.getMergeeId()));
                this.messenger.send(KVRangeMessage.newBuilder().setRangeId(mergeeId).setHostStoreId(peer).setMergeDoneRequest(MergeDoneRequest.newBuilder().setId(this.id).setTaskId(request.getTaskId()).setMergeeVer(request.getVer()).setStoreId(this.hostStoreId).build()).build());
            }
        }
    }

    private void startDumpSession(String sessionId, KVRangeSnapshot snapshot, KVRangeId targetRangeId, String targetStoreId) {
        KVRangeDumpSession session = new KVRangeDumpSession(sessionId, snapshot, targetRangeId, targetStoreId, this.kvRange, this.messenger, Duration.ofSeconds(this.opts.getSnapshotSyncIdleTimeoutSec()), this.opts.getSnapshotSyncBytesPerSec(), this.snapshotBandwidthGovernor, bytes -> {
            if (this.kvRange.currentState().getType() == State.StateType.WaitingForMerge) {
                this.mergePendingAt = -1L;
            }
            this.metricManager.reportDump(bytes);
        }, this.tags);
        this.dumpSessions.put(session.id(), session);
        session.awaitDone().whenComplete((result, e) -> {
            this.dumpSessions.remove(session.id(), session);
            switch (result) {
                case OK: {
                    this.log.info("Snapshot dumped: session={}, follower={}", (Object)session.id(), (Object)targetStoreId);
                    break;
                }
                case Canceled: {
                    this.log.info("Snapshot dump canceled: session={}, follower={}", (Object)session.id(), (Object)targetStoreId);
                    break;
                }
                case NoCheckpoint: {
                    this.log.info("No checkpoint found, compact WAL now");
                    this.compactWAL();
                    break;
                }
                case Abort: {
                    this.log.info("Snapshot dump aborted: session={}, follower={}", (Object)session.id(), (Object)targetStoreId);
                    break;
                }
                case Error: {
                    this.log.warn("Snapshot dump failed: session={}, follower={}", (Object)session.id(), (Object)targetStoreId);
                    break;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Any reset(Boundary boundary) {
        long startAt = System.nanoTime();
        long stamp = this.resetLock.writeLock();
        try {
            this.queryReadySubject.onNext((Object)false);
            Any any = this.coProc.reset(boundary);
            return any;
        }
        finally {
            this.resetLock.unlockWrite(stamp);
            this.queryReadySubject.onNext((Object)true);
            this.log.debug("Reset coProc done, took {} ms", (Object)Duration.ofNanos(System.nanoTime() - startAt).toMillis());
        }
    }

    private /* synthetic */ void lambda$applyCommand$102(Supplier resultSupplier, String taskId) {
        IKVRangeCoProc.MutationResult result = (IKVRangeCoProc.MutationResult)resultSupplier.get();
        result.fact().ifPresent(arg_0 -> this.factSubject.onNext(arg_0));
        this.finishCommand(taskId, result.output());
    }

    private static /* synthetic */ void lambda$applyCommand$95(CompletableFuture onDone, CompletableFuture requestFuture, Runnable v, Throwable e) {
        if (onDone.isCancelled()) {
            requestFuture.cancel(true);
        }
    }

    private static /* synthetic */ void lambda$applyCommand$93(CompletableFuture onDone, IKVRangeWritable.Migrater migrater, CompletableFuture migrateFuture, Runnable v, Throwable e) {
        if (onDone.isCancelled()) {
            migrater.abort();
            migrateFuture.cancel(true);
        }
    }

    private static /* synthetic */ void lambda$applyCommand$82(CompletableFuture onDone, CompletableFuture requestFuture, Runnable v, Throwable e) {
        if (onDone.isCancelled()) {
            requestFuture.cancel(true);
        }
    }

    private static /* synthetic */ void lambda$applyCommand$80(CompletableFuture onDone, CompletableFuture requestFuture, Runnable v, Throwable e) {
        if (onDone.isCancelled()) {
            requestFuture.cancel(true);
        }
    }

    private static /* synthetic */ void lambda$applyCommand$74(CompletableFuture onDone, CompletableFuture requestFuture, Runnable v, Throwable e) {
        if (onDone.isCancelled()) {
            requestFuture.cancel(true);
        }
    }

    private static /* synthetic */ void lambda$apply$43(CompletableFuture onDone, CompletableFuture applyFuture, Void v, Throwable e) {
        if (onDone.isCancelled()) {
            applyFuture.cancel(true);
        }
    }

    static enum Lifecycle {
        Init,
        Opening,
        Open,
        Closing,
        Closed,
        Destroying,
        Destroyed;

    }

    public static interface QuitListener {
        public void onQuit(IKVRangeFSM var1, boolean var2);
    }

    private static enum TryConfirmMergedResult {
        ALREADY_CANCELED,
        MERGED;

    }

    private static enum TryCancelMergingResult {
        CANCELLED,
        ALREADY_MERGED;

    }

    private static enum TryMigrateResult {
        SUCCESS_AFTER_RESET,
        SUCCESS,
        FAILED;

    }
}

