/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.worker.cache;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.store.api.IKVRangeRefreshableReader;
import org.apache.bifromq.dist.worker.cache.ITenantRouteCache;
import org.apache.bifromq.dist.worker.cache.ITenantRouteCacheFactory;
import org.apache.bifromq.dist.worker.cache.TenantRouteCache;
import org.apache.bifromq.dist.worker.cache.TenantRouteMatcher;
import org.apache.bifromq.plugin.eventcollector.IEventCollector;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;

class TenantRouteCacheFactory
implements ITenantRouteCacheFactory {
    private final ISettingProvider settingProvider;
    private final IEventCollector eventCollector;
    private final Executor matchExecutor;
    private final Supplier<IKVRangeRefreshableReader> readerSupplier;
    private final Timer internalMatchTimer;
    private final Duration expiry;
    private final Duration fanoutCheckInterval;

    public TenantRouteCacheFactory(Supplier<IKVRangeRefreshableReader> readerSupplier, ISettingProvider settingProvider, IEventCollector eventCollector, Duration expiry, Duration fanoutCheckInterval, Executor matchExecutor, String ... tags) {
        this.settingProvider = settingProvider;
        this.eventCollector = eventCollector;
        this.matchExecutor = matchExecutor;
        this.readerSupplier = readerSupplier;
        this.expiry = expiry;
        this.fanoutCheckInterval = fanoutCheckInterval;
        this.internalMatchTimer = Timer.builder((String)"dist.match.internal").tags((Iterable)Tags.of((String[])tags)).register((MeterRegistry)Metrics.globalRegistry);
    }

    @Override
    public Duration expiry() {
        return this.expiry;
    }

    @Override
    public ITenantRouteCache create(KVRangeId rangeId, String tenantId) {
        return new TenantRouteCache(rangeId, tenantId, new TenantRouteMatcher(tenantId, this.readerSupplier, this.eventCollector, this.internalMatchTimer), this.settingProvider, this.expiry, this.fanoutCheckInterval, this.matchExecutor);
    }

    @Override
    public void close() {
        Metrics.globalRegistry.remove((Meter)this.internalMatchTimer);
    }
}

