/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.metaservice;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.subjects.BehaviorSubject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.bifromq.basekv.metaservice.IBaseKVLandscapeCRDT;
import org.apache.bifromq.basekv.metaservice.IBaseKVLandscapeObserver;
import org.apache.bifromq.basekv.proto.KVRangeStoreDescriptor;
import org.apache.bifromq.logger.MDCLogger;
import org.slf4j.Logger;

class BaseKVLandscapeObserver
implements IBaseKVLandscapeObserver {
    private final Logger log;
    private final BehaviorSubject<Map<String, KVRangeStoreDescriptor>> landscapeSubject = BehaviorSubject.create();
    private final CompositeDisposable disposable = new CompositeDisposable();

    BaseKVLandscapeObserver(IBaseKVLandscapeCRDT landscapeCRDT) {
        this.log = MDCLogger.getLogger(BaseKVLandscapeObserver.class, (String[])new String[]{"clusterId", landscapeCRDT.clusterId()});
        this.disposable.add(landscapeCRDT.landscape().map(descriptorMap -> {
            HashMap descriptorMapByStoreId = new HashMap();
            descriptorMap.forEach((key, value) -> descriptorMapByStoreId.compute(key.getStoreId(), (k, v) -> {
                if (v == null) {
                    return value;
                }
                return v.getHlc() > value.getHlc() ? v : value;
            }));
            this.log.debug("Landscape changed: {}", descriptorMapByStoreId);
            return descriptorMapByStoreId;
        }).subscribe(arg_0 -> this.landscapeSubject.onNext(arg_0)));
    }

    @Override
    public final Observable<Map<String, KVRangeStoreDescriptor>> landscape() {
        return this.landscapeSubject.distinctUntilChanged();
    }

    @Override
    public Optional<KVRangeStoreDescriptor> getStoreDescriptor(String storeId) {
        for (String key : ((Map)this.landscapeSubject.getValue()).keySet()) {
            if (!key.equals(storeId)) continue;
            return Optional.of((KVRangeStoreDescriptor)((Map)this.landscapeSubject.getValue()).get(key));
        }
        return Optional.empty();
    }

    @Override
    public void stop() {
        this.disposable.dispose();
        this.landscapeSubject.onComplete();
    }
}

