/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine;

import com.google.protobuf.ByteString;
import java.util.Optional;
import org.apache.bifromq.basekv.localengine.IKVSpaceIterator;
import org.apache.bifromq.basekv.localengine.IKVSpaceReader;
import org.apache.bifromq.basekv.localengine.metrics.KVSpaceOpMeters;
import org.apache.bifromq.basekv.proto.Boundary;
import org.slf4j.Logger;

public abstract class AbstractKVSpaceReader
implements IKVSpaceReader {
    protected final String id;
    protected final KVSpaceOpMeters opMeters;
    protected final Logger logger;

    protected AbstractKVSpaceReader(String id, KVSpaceOpMeters opMeters, Logger logger) {
        this.id = id;
        this.opMeters = opMeters;
        this.logger = logger;
    }

    @Override
    public final String id() {
        return this.id;
    }

    @Override
    public final Optional<ByteString> metadata(ByteString metaKey) {
        return (Optional)this.opMeters.metadataCallTimer.record(() -> this.doMetadata(metaKey));
    }

    @Override
    public final boolean exist(ByteString key) {
        return this.opMeters.existCallTimer.record(() -> this.doExist(key));
    }

    @Override
    public final Optional<ByteString> get(ByteString key) {
        return (Optional)this.opMeters.getCallTimer.record(() -> this.doGet(key).map(k -> {
            this.opMeters.readBytesSummary.record((double)k.size());
            return k;
        }));
    }

    @Override
    public final IKVSpaceIterator newIterator() {
        return this.newIterator(Boundary.getDefaultInstance());
    }

    @Override
    public final IKVSpaceIterator newIterator(Boundary subBoundary) {
        return (IKVSpaceIterator)this.opMeters.iterNewCallTimer.record(() -> new MonitoredKeyRangeIterator(this.doNewIterator(subBoundary)));
    }

    @Override
    public final long size(Boundary boundary) {
        return this.opMeters.sizeCallTimer.record(() -> this.doSize(boundary));
    }

    protected abstract Optional<ByteString> doMetadata(ByteString var1);

    protected abstract boolean doExist(ByteString var1);

    protected abstract Optional<ByteString> doGet(ByteString var1);

    protected abstract IKVSpaceIterator doNewIterator(Boundary var1);

    protected abstract long doSize(Boundary var1);

    private class MonitoredKeyRangeIterator
    implements IKVSpaceIterator {
        final IKVSpaceIterator delegate;

        private MonitoredKeyRangeIterator(IKVSpaceIterator delegate) {
            this.delegate = delegate;
        }

        @Override
        public ByteString key() {
            ByteString key = this.delegate.key();
            AbstractKVSpaceReader.this.opMeters.readBytesSummary.record((double)key.size());
            return key;
        }

        @Override
        public ByteString value() {
            ByteString value = this.delegate.value();
            AbstractKVSpaceReader.this.opMeters.readBytesSummary.record((double)value.size());
            return value;
        }

        @Override
        public boolean isValid() {
            return this.delegate.isValid();
        }

        @Override
        public void next() {
            AbstractKVSpaceReader.this.opMeters.iterNextCallTimer.record(this.delegate::next);
        }

        @Override
        public void prev() {
            AbstractKVSpaceReader.this.opMeters.iterPrevCallTimer.record(this.delegate::prev);
        }

        @Override
        public void seekToFirst() {
            AbstractKVSpaceReader.this.opMeters.iterSeekToFirstCallTimer.record(this.delegate::seekToFirst);
        }

        @Override
        public void seekToLast() {
            AbstractKVSpaceReader.this.opMeters.iterSeekToLastCallTimer.record(this.delegate::seekToLast);
        }

        @Override
        public void seek(ByteString target) {
            AbstractKVSpaceReader.this.opMeters.iterSeekCallTimer.record(() -> this.delegate.seek(target));
        }

        @Override
        public void seekForPrev(ByteString target) {
            AbstractKVSpaceReader.this.opMeters.iterSeekForPrevCallTimer.record(() -> this.delegate.seekForPrev(target));
        }

        @Override
        public void close() {
            this.delegate.close();
        }
    }
}

