/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.util;

import com.google.common.io.BaseEncoding;
import com.google.protobuf.ByteString;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.util.function.Supplier;
import org.apache.bifromq.basecrdt.proto.Replica;
import org.apache.bifromq.basecrdt.store.proto.AckMessage;
import org.apache.bifromq.basecrdt.store.proto.CRDTStoreMessage;
import org.apache.bifromq.basecrdt.store.proto.DeltaMessage;

public class Formatter {
    public static Supplier<String> toPrintable(ByteString address) {
        return () -> BaseEncoding.base64().encode(address.toByteArray());
    }

    public static String print(Replica replica) {
        return Formatter.toPrintable(replica).get();
    }

    public static Supplier<String> toPrintable(Replica replica) {
        return () -> replica.getUri() + "-" + replica.hashCode();
    }

    public static Supplier<String> toPrintable(DeltaMessage delta) {
        return () -> {
            try {
                return JsonFormat.printer().print((MessageOrBuilder)delta);
            }
            catch (Exception e) {
                return delta.toString();
            }
        };
    }

    public static Supplier<String> toPrintable(AckMessage ack) {
        return () -> {
            try {
                return JsonFormat.printer().print((MessageOrBuilder)ack);
            }
            catch (Exception e) {
                return ack.toString();
            }
        };
    }

    public static Supplier<String> toPrintable(CRDTStoreMessage ack) {
        return () -> {
            try {
                return JsonFormat.printer().print((MessageOrBuilder)ack);
            }
            catch (Exception e) {
                return ack.toString();
            }
        };
    }
}

