/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.starter.metrics.netty;

import io.netty.buffer.ByteBufAllocatorMetric;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.bifromq.baseenv.EnvProvider;

public class PooledByteBufAllocatorMetric
implements ByteBufAllocatorMetric {
    private static final Executor EXECUTOR = Executors.newSingleThreadExecutor(EnvProvider.INSTANCE.newThreadFactory("netty-metrics-reader", true));
    private final AtomicBoolean isReading = new AtomicBoolean(false);
    private final io.netty.buffer.PooledByteBufAllocatorMetric delegate;
    private volatile long usedHeapMemory;
    private volatile long usedDirectMemory;

    public PooledByteBufAllocatorMetric(io.netty.buffer.PooledByteBufAllocatorMetric delegate) {
        this.delegate = delegate;
    }

    public long usedHeapMemory() {
        this.scheduleUpdate();
        return this.usedHeapMemory;
    }

    public long usedDirectMemory() {
        this.scheduleUpdate();
        return this.usedDirectMemory;
    }

    private void scheduleUpdate() {
        if (this.isReading.compareAndSet(false, true)) {
            EXECUTOR.execute(() -> {
                this.usedHeapMemory = this.delegate.usedHeapMemory();
                this.usedDirectMemory = this.delegate.usedDirectMemory();
                this.isReading.set(false);
            });
        }
    }
}

