/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.server.scheduler;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.protobuf.ByteString;
import com.google.protobuf.ProtocolStringList;
import java.time.Duration;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import org.apache.bifromq.basekv.client.KVRangeRouterUtil;
import org.apache.bifromq.basekv.client.KVRangeSetting;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.utils.BoundaryUtil;
import org.apache.bifromq.dist.rpc.proto.Fact;
import org.apache.bifromq.dist.trie.ITopicFilterIterator;
import org.apache.bifromq.dist.trie.ThreadLocalTopicFilterIterator;
import org.apache.bifromq.dist.trie.TopicTrieNode;
import org.apache.bifromq.dist.worker.schema.KVSchemaUtil;
import org.apache.bifromq.util.TopicUtil;

class TenantRangeLookupCache {
    private final String tenantId;
    private final LoadingCache<CacheKey, Collection<KVRangeSetting>> cache;

    TenantRangeLookupCache(String tenantId, Duration expireAfterAccess, long maximumSize) {
        this.tenantId = tenantId;
        this.cache = Caffeine.newBuilder().expireAfterAccess(expireAfterAccess).maximumSize(maximumSize).build(this::lookup);
    }

    Collection<KVRangeSetting> lookup(String topic, NavigableMap<Boundary, KVRangeSetting> effectiveRouter) {
        ByteString tenantStartKey = KVSchemaUtil.tenantBeginKey((String)this.tenantId);
        Boundary tenantBoundary = BoundaryUtil.toBoundary((ByteString)tenantStartKey, (ByteString)BoundaryUtil.upperBound((ByteString)tenantStartKey));
        Collection allCandidates = KVRangeRouterUtil.findByBoundary((Boundary)tenantBoundary, effectiveRouter);
        return (Collection)this.cache.get((Object)new CacheKey(this.tenantId, topic, new CandidatesView(allCandidates)));
    }

    private Collection<KVRangeSetting> lookup(CacheKey key) {
        TopicTrieNode.Builder topicTrieBuilder = TopicTrieNode.builder((boolean)true);
        topicTrieBuilder.addTopic(TopicUtil.parse((String)this.tenantId, (String)key.topic, (boolean)false), (Object)key.topic);
        try (ITopicFilterIterator topicFilterIterator = ThreadLocalTopicFilterIterator.get((TopicTrieNode)topicTrieBuilder.build());){
            topicFilterIterator.init(topicTrieBuilder.build());
            LinkedList<KVRangeSetting> finalCandidates = new LinkedList<KVRangeSetting>();
            for (KVRangeSetting candidate : key.candidates) {
                Optional factOpt = candidate.getFact(Fact.class);
                if (factOpt.isEmpty()) {
                    finalCandidates.add(candidate);
                    continue;
                }
                Fact fact = (Fact)factOpt.get();
                if (!fact.hasFirstGlobalFilterLevels() || !fact.hasLastGlobalFilterLevels()) continue;
                ProtocolStringList firstFilterLevels = fact.getFirstGlobalFilterLevels().getFilterLevelList();
                ProtocolStringList lastFilterLevels = fact.getLastGlobalFilterLevels().getFilterLevelList();
                topicFilterIterator.seek((List)firstFilterLevels);
                if (!topicFilterIterator.isValid()) break;
                if (!topicFilterIterator.key().equals(firstFilterLevels) && TopicUtil.fastJoin((CharSequence)"\u0000", (Iterable)topicFilterIterator.key()).compareTo(TopicUtil.fastJoin((CharSequence)"\u0000", (Iterable)lastFilterLevels)) > 0) continue;
                finalCandidates.add(candidate);
            }
            LinkedList<KVRangeSetting> linkedList = finalCandidates;
            return linkedList;
        }
    }

    private record CacheKey(String tenantId, String topic, CandidatesView candidates) {
    }

    private static final class CandidatesView
    extends AbstractCollection<KVRangeSetting> {
        private final Collection<KVRangeSetting> delegate;
        private final int size;
        private final int hash;

        CandidatesView(Collection<KVRangeSetting> delegate) {
            this.delegate = delegate;
            this.size = delegate.size();
            int h = 1;
            for (KVRangeSetting e : delegate) {
                h = 31 * h + (e == null ? 0 : e.hashCode());
            }
            this.hash = h;
        }

        @Override
        public Iterator<KVRangeSetting> iterator() {
            final Iterator<KVRangeSetting> it = this.delegate.iterator();
            return new Iterator<KVRangeSetting>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public KVRangeSetting next() {
                    return (KVRangeSetting)it.next();
                }
            };
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Collection)) {
                return false;
            }
            Collection other = (Collection)obj;
            if (other.size() != this.size) {
                return false;
            }
            Iterator<KVRangeSetting> it1 = this.iterator();
            Iterator it2 = other.iterator();
            while (it1.hasNext() && it2.hasNext()) {
                Object o2;
                KVRangeSetting o1 = it1.next();
                if (Objects.equals(o1, o2 = it2.next())) continue;
                return false;
            }
            return !it1.hasNext() && !it2.hasNext();
        }

        @Override
        public int hashCode() {
            return this.hash;
        }
    }
}

