/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.retain.store;

import com.google.common.util.concurrent.MoreExecutors;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import java.time.Duration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.bifromq.base.util.AsyncRunner;
import org.apache.bifromq.baseenv.EnvProvider;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.basehookloader.BaseHookLoader;
import org.apache.bifromq.basekv.balance.KVStoreBalanceController;
import org.apache.bifromq.basekv.client.IBaseKVStoreClient;
import org.apache.bifromq.basekv.server.IBaseKVStoreServer;
import org.apache.bifromq.basekv.store.api.IKVRangeCoProcFactory;
import org.apache.bifromq.baserpc.client.IConnectable;
import org.apache.bifromq.retain.store.IRetainStore;
import org.apache.bifromq.retain.store.RetainStoreBuilder;
import org.apache.bifromq.retain.store.RetainStoreCoProcFactory;
import org.apache.bifromq.retain.store.gc.IRetainStoreGCProcessor;
import org.apache.bifromq.retain.store.gc.RetainStoreGCProcessor;
import org.apache.bifromq.retain.store.spi.IRetainStoreBalancerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RetainStore
implements IRetainStore {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RetainStore.class);
    protected final RetainStoreCoProcFactory coProcFactory;
    private final String clusterId;
    private final ExecutorService rpcExecutor;
    private final IBaseKVStoreServer storeServer;
    private final AtomicReference<Status> status = new AtomicReference<Status>(Status.INIT);
    private final IBaseKVStoreClient storeClient;
    private final KVStoreBalanceController balanceController;
    private final AsyncRunner jobRunner;
    private final ScheduledExecutorService jobScheduler;
    private final boolean jobExecutorOwner;
    private final Duration gcInterval;
    private final List<IRetainStoreBalancerFactory> effectiveBalancerFactories = new LinkedList<IRetainStoreBalancerFactory>();
    private volatile CompletableFuture<Void> gcJob;
    private IRetainStoreGCProcessor gcProcessor;

    public RetainStore(RetainStoreBuilder builder) {
        this.clusterId = builder.clusterId;
        this.storeClient = builder.retainStoreClient;
        this.gcInterval = builder.gcInterval;
        this.coProcFactory = new RetainStoreCoProcFactory();
        Map loadedFactories = BaseHookLoader.load(IRetainStoreBalancerFactory.class);
        for (String factoryName : builder.balancerFactoryConfig.keySet()) {
            if (!loadedFactories.containsKey(factoryName)) {
                log.warn("RetainStoreBalancerFactory[{}] not found", (Object)factoryName);
                continue;
            }
            IRetainStoreBalancerFactory balancer = (IRetainStoreBalancerFactory)loadedFactories.get(factoryName);
            balancer.init(builder.balancerFactoryConfig.get(factoryName));
            log.info("RetainStoreBalancerFactory[{}] enabled", (Object)factoryName);
            this.effectiveBalancerFactories.add(balancer);
        }
        this.balanceController = new KVStoreBalanceController(builder.metaService, this.storeClient, this.effectiveBalancerFactories, builder.bootstrapDelay, builder.zombieProbeDelay, builder.balancerRetryDelay, builder.bgTaskExecutor);
        boolean bl = this.jobExecutorOwner = builder.bgTaskExecutor == null;
        if (this.jobExecutorOwner) {
            String threadName = String.format("retain-store[%s]-job-executor", builder.clusterId);
            this.jobScheduler = ExecutorServiceMetrics.monitor((MeterRegistry)Metrics.globalRegistry, (ScheduledExecutorService)new ScheduledThreadPoolExecutor(1, EnvProvider.INSTANCE.newThreadFactory(threadName)), (String)threadName, (Tag[])new Tag[0]);
        } else {
            this.jobScheduler = builder.bgTaskExecutor;
        }
        this.jobRunner = new AsyncRunner("job.runner", (Executor)this.jobScheduler, new String[]{"type", "retainstore"});
        this.rpcExecutor = builder.workerThreads == 0 ? MoreExecutors.newDirectExecutorService() : ExecutorServiceMetrics.monitor((MeterRegistry)Metrics.globalRegistry, (ExecutorService)new ThreadPoolExecutor(builder.workerThreads, builder.workerThreads, 0L, TimeUnit.MILLISECONDS, new LinkedTransferQueue<Runnable>(), EnvProvider.INSTANCE.newThreadFactory("retain-store-executor")), (String)"retain-store-executor", (Tag[])new Tag[0]);
        this.storeServer = IBaseKVStoreServer.builder().rpcServerBuilder(builder.rpcServerBuilder).metaService(builder.metaService).addService(builder.clusterId).coProcFactory((IKVRangeCoProcFactory)this.coProcFactory).storeOptions(builder.storeOptions).agentHost(builder.agentHost).queryExecutor(MoreExecutors.directExecutor()).rpcExecutor((Executor)this.rpcExecutor).tickerThreads(builder.tickerThreads).bgTaskExecutor(builder.bgTaskExecutor).attributes(builder.attributes).finish().build();
        this.start();
    }

    @Override
    public String id() {
        return this.storeServer.storeId(this.clusterId);
    }

    private void start() {
        if (this.status.compareAndSet(Status.INIT, Status.STARTING)) {
            log.info("Starting retain store");
            this.storeServer.start();
            this.balanceController.start(this.id());
            this.gcProcessor = new RetainStoreGCProcessor(this.storeClient, this.id());
            this.status.compareAndSet(Status.STARTING, Status.STARTED);
            this.storeClient.connState().filter(connState -> connState == IConnectable.ConnState.READY).takeUntil(connState -> connState == IConnectable.ConnState.READY).doOnComplete(this::scheduleGC).subscribe();
            log.debug("Retain store started");
        }
    }

    @Override
    public void close() {
        if (this.status.compareAndSet(Status.STARTED, Status.STOPPING)) {
            log.info("Stopping RetainStore");
            if (this.gcJob != null && !this.gcJob.isDone()) {
                this.gcJob.cancel(true);
            }
            this.balanceController.stop();
            this.storeServer.stop();
            this.coProcFactory.close();
            this.effectiveBalancerFactories.forEach(IRetainStoreBalancerFactory::close);
            if (this.jobExecutorOwner) {
                log.debug("Shutting down job executor");
                MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.jobScheduler, (long)5L, (TimeUnit)TimeUnit.SECONDS);
            }
            MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.rpcExecutor, (long)5L, (TimeUnit)TimeUnit.SECONDS);
            log.debug("RetainStore shutdown");
            this.status.compareAndSet(Status.STOPPING, Status.STOPPED);
        }
    }

    private void scheduleGC() {
        this.jobScheduler.schedule(this::gc, this.gcInterval.toMillis(), TimeUnit.MILLISECONDS);
    }

    private void gc() {
        this.jobRunner.add(() -> {
            if (this.status.get() != Status.STARTED) {
                return;
            }
            long reqId = HLC.INST.getPhysical();
            log.debug("Retain Store GC: id={}", (Object)this.id());
            this.gcJob = ((CompletableFuture)this.gcProcessor.gc(reqId, null, null, HLC.INST.getPhysical()).thenAccept(v -> log.debug("Retain Store GC succeed: id={}", (Object)this.id()))).whenComplete((v, e) -> this.scheduleGC());
        });
    }

    private static enum Status {
        INIT,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }
}

