/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.server;

import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.bifromq.baseenv.EnvProvider;
import org.apache.bifromq.baserpc.server.AbstractResponsePipeline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResponsePipeline<RequestT, ResponseT>
extends AbstractResponsePipeline<RequestT, ResponseT> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResponsePipeline.class);
    private static final ScheduledExecutorService SCHEDULER = Executors.newSingleThreadScheduledExecutor(EnvProvider.INSTANCE.newThreadFactory("base-rpc-flow-controller", true));
    private final Supplier<Boolean> flowControlSignal;
    private final AtomicBoolean flowControlEnabled = new AtomicBoolean(false);
    private final long timeoutNanos;
    private final AtomicLong throttledAt = new AtomicLong(Long.MAX_VALUE);

    public ResponsePipeline(StreamObserver<ResponseT> responseObserver) {
        this(responseObserver, null, null);
    }

    public ResponsePipeline(StreamObserver<ResponseT> respObserver, Supplier<Boolean> slowDownSignal, Duration slowDownTimeout) {
        super(respObserver);
        if (slowDownSignal != null) {
            this.flowControlSignal = slowDownSignal;
            this.responseObserver.disableAutoRequest();
            this.responseObserver.setOnReadyHandler(new Runnable(){
                private boolean wasReady = false;

                @Override
                public void run() {
                    if (ResponsePipeline.this.responseObserver.isReady() && !this.wasReady) {
                        this.wasReady = true;
                        ResponsePipeline.this.responseObserver.request(1);
                    }
                }
            });
            this.timeoutNanos = slowDownTimeout.toNanos();
        } else {
            this.flowControlSignal = () -> false;
            this.timeoutNanos = 0L;
        }
    }

    public final void onNext(RequestT request) {
        this.startHandlingRequest(request).thenAccept(response -> this.emitResponse(request, response));
        if (!this.flowControlEnabled.get()) {
            if (this.flowControlSignal.get().booleanValue() && this.flowControlEnabled.compareAndSet(false, true)) {
                this.throttledAt.set(System.nanoTime());
                log.debug("ResponsePipeline@{} flow control start", (Object)this.hashCode());
                this.checkSignal();
            } else {
                this.responseObserver.request(1);
            }
        }
    }

    private void checkSignal() {
        SCHEDULER.schedule(() -> {
            if (!this.flowControlSignal.get().booleanValue()) {
                this.throttledAt.set(Long.MAX_VALUE);
                this.flowControlEnabled.set(false);
                log.debug("ResponsePipeline@{} flow control stop", (Object)this.hashCode());
                this.responseObserver.request(1);
            } else if (System.nanoTime() - this.throttledAt.get() > this.timeoutNanos) {
                log.debug("ResponsePipeline@{} flow control timeout", (Object)this.hashCode());
                this.responseObserver.onError((Throwable)Status.RESOURCE_EXHAUSTED.asRuntimeException());
            } else {
                this.checkSignal();
            }
        }, 100L, TimeUnit.MILLISECONDS);
    }
}

