/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed.storage;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.storage.MvPartitionStorage;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.engine.MvPartitionMeta;
import org.apache.ignite3.internal.storage.engine.MvTableStorage;
import org.apache.ignite3.internal.storage.engine.StorageTableDescriptor;
import org.apache.ignite3.internal.storage.index.IndexStorage;
import org.apache.ignite3.internal.storage.index.StorageHashIndexDescriptor;
import org.apache.ignite3.internal.storage.index.StorageSortedIndexDescriptor;
import org.jetbrains.annotations.Nullable;

public class NullMvTableStorage
implements MvTableStorage {
    private final StorageTableDescriptor tableDescriptor;

    public NullMvTableStorage(StorageTableDescriptor tableDescriptor) {
        this.tableDescriptor = tableDescriptor;
    }

    @Override
    public CompletableFuture<MvPartitionStorage> createMvPartition(int partitionId) {
        return (CompletableFuture)this.throwNoPartitionsException();
    }

    @Override
    @Nullable
    public MvPartitionStorage getMvPartition(int partitionId) {
        return (MvPartitionStorage)this.throwNoPartitionsException();
    }

    @Override
    public CompletableFuture<Void> destroyPartition(int partitionId) throws StorageException {
        return (CompletableFuture)this.throwNoPartitionsException();
    }

    @Override
    public void createSortedIndex(int partitionId, StorageSortedIndexDescriptor indexDescriptor) {
        this.throwNoPartitionsException();
    }

    @Override
    public void createHashIndex(int partitionId, StorageHashIndexDescriptor indexDescriptor) {
        this.throwNoPartitionsException();
    }

    @Override
    public CompletableFuture<Void> destroyIndex(int indexId) {
        return (CompletableFuture)this.throwNoStorageEngineException("Table uses an unknown storage profile or engine, so current node either should not receive any index destruction events, or storage profile addition is not handled properly");
    }

    @Override
    public boolean isVolatile() {
        return (Boolean)this.throwNoPartitionsException();
    }

    @Override
    public CompletableFuture<Void> destroy() {
        return (CompletableFuture)this.throwNoStorageEngineException("Table uses an unknown storage profile or engine, so current node either should not receive any table destruction events, or storage profile addition is not handled properly");
    }

    @Override
    public CompletableFuture<Void> startRebalancePartition(int partitionId) {
        return (CompletableFuture)this.throwNoPartitionsException();
    }

    @Override
    public CompletableFuture<Void> abortRebalancePartition(int partitionId) {
        return (CompletableFuture)this.throwNoPartitionsException();
    }

    @Override
    public CompletableFuture<Void> finishRebalancePartition(int partitionId, MvPartitionMeta partitionMeta) {
        return (CompletableFuture)this.throwNoPartitionsException();
    }

    @Override
    public CompletableFuture<Void> clearPartition(int partitionId) {
        return (CompletableFuture)this.throwNoPartitionsException();
    }

    @Override
    @Nullable
    public IndexStorage getIndex(int partitionId, int indexId) {
        return (IndexStorage)this.throwNoPartitionsException();
    }

    @Override
    public StorageTableDescriptor getTableDescriptor() {
        return this.tableDescriptor;
    }

    @Override
    public void close() throws Exception {
    }

    private <T> T throwNoPartitionsException() {
        return this.throwNoStorageEngineException("Table uses an unknown storage profile or engine, so current node either should not receive any assignments, or storage profile addition is not handled properly");
    }

    private <T> T throwNoStorageEngineException(String errorMessage) {
        throw new StorageException(errorMessage + " [tableId=" + this.tableDescriptor.getId() + "]");
    }
}

