/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedBaseMessage;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxState;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxStateAware;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringBuilder;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridDistributedTxPrepareResponse
extends GridDistributedBaseMessage
implements IgniteTxStateAware {
    private static final long serialVersionUID = 0L;
    @GridToStringExclude
    @GridDirectTransient
    private Throwable err;
    private byte[] errBytes;
    @GridDirectTransient
    private IgniteTxState txState;
    private int part;
    protected byte flags;

    public GridDistributedTxPrepareResponse() {
    }

    public GridDistributedTxPrepareResponse(int part, GridCacheVersion xid, boolean addDepInfo) {
        super(xid, 0, addDepInfo);
        this.part = part;
    }

    public GridDistributedTxPrepareResponse(int part, GridCacheVersion xid, Throwable err, boolean addDepInfo) {
        super(xid, 0, addDepInfo);
        this.part = part;
        this.err = err;
    }

    protected final void setFlag(boolean flag, int mask) {
        this.flags = flag ? (byte)(this.flags | mask) : (byte)(this.flags & ~mask);
    }

    protected final boolean isFlag(int mask) {
        return (this.flags & mask) != 0;
    }

    @Override
    public int partition() {
        return this.part;
    }

    @Override
    public Throwable error() {
        return this.err;
    }

    public void error(Throwable err) {
        this.err = err;
    }

    public boolean isRollback() {
        return this.err != null;
    }

    @Override
    public IgniteTxState txState() {
        return this.txState;
    }

    @Override
    public void txState(IgniteTxState txState) {
        this.txState = txState;
    }

    @Override
    public IgniteLogger messageLogger(GridCacheSharedContext<?, ?> ctx) {
        return ctx.txPrepareMessageLogger();
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext<?, ?> ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        if (this.err != null && this.errBytes == null) {
            this.errBytes = U.marshal(ctx, (Object)this.err);
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext<?, ?> ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        if (this.errBytes != null && this.err == null) {
            this.err = (Throwable)U.unmarshal(ctx, this.errBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 8: {
                if (!writer.writeByteArray("errBytes", this.errBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeByte("flags", this.flags)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeInt("part", this.part)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 8: {
                this.errBytes = reader.readByteArray("errBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.flags = reader.readByte("flags");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 10: {
                this.part = reader.readInt("part");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDistributedTxPrepareResponse.class);
    }

    @Override
    public short directType() {
        return 26;
    }

    @Override
    public byte fieldsCount() {
        return 11;
    }

    @Override
    public String toString() {
        return GridToStringBuilder.toString(GridDistributedTxPrepareResponse.class, this, "err", (Object)(this.err == null ? "null" : this.err.toString()), "super", (Object)super.toString());
    }
}

