/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.endpoints;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Post;
import io.micronaut.security.annotation.Secured;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.endpoints.LogoutControllerConfiguration;
import io.micronaut.security.event.LogoutEvent;
import io.micronaut.security.handlers.LogoutHandler;
import jakarta.inject.Inject;

@Requirements(value={@Requires(property="micronaut.security.endpoints.logout.enabled", notEquals="false", defaultValue="true"), @Requires(beans={LogoutHandler.class})})
@Controller(value="${micronaut.security.endpoints.logout.path:/logout}")
@Secured(value={"isAnonymous()"})
public class LogoutController {
    private final LogoutHandler logoutHandler;
    private final ApplicationEventPublisher eventPublisher;
    private final boolean getAllowed;

    @Inject
    public LogoutController(LogoutHandler logoutHandler, ApplicationEventPublisher eventPublisher, LogoutControllerConfiguration logoutControllerConfiguration) {
        this.logoutHandler = logoutHandler;
        this.eventPublisher = eventPublisher;
        this.getAllowed = logoutControllerConfiguration.isGetAllowed();
    }

    @Consumes(value={"application/x-www-form-urlencoded", "application/json"})
    @Post
    public MutableHttpResponse<?> index(HttpRequest<?> request, @Nullable Authentication authentication) {
        return this.handleLogout(request, authentication);
    }

    @Get
    public MutableHttpResponse<?> indexGet(HttpRequest<?> request, @Nullable Authentication authentication) {
        if (!this.getAllowed) {
            return HttpResponse.status((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED);
        }
        return this.handleLogout(request, authentication);
    }

    protected MutableHttpResponse<?> handleLogout(HttpRequest<?> request, @Nullable Authentication authentication) {
        if (authentication != null) {
            this.eventPublisher.publishEvent((Object)new LogoutEvent(authentication));
        }
        return this.logoutHandler.logout(request);
    }
}

