/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;

public class ReadableByteChannelMock
implements ReadableByteChannel {
    private final byte[][] chunks;
    private int chunkCount = 0;
    private ByteBuffer currentChunk;
    private boolean eof = false;
    private boolean closed = false;

    public ReadableByteChannelMock(String[] strings, Charset charset) {
        this.chunks = new byte[strings.length][];
        for (int i = 0; i < strings.length; ++i) {
            this.chunks[i] = strings[i].getBytes(charset);
        }
    }

    public ReadableByteChannelMock(byte[] ... chunks) {
        this.chunks = chunks;
    }

    private void prepareChunk() {
        if (this.currentChunk == null || !this.currentChunk.hasRemaining()) {
            if (this.chunkCount < this.chunks.length) {
                byte[] bytes = this.chunks[this.chunkCount];
                ++this.chunkCount;
                this.currentChunk = ByteBuffer.wrap(bytes);
            } else {
                this.eof = true;
            }
        }
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        this.prepareChunk();
        if (this.eof) {
            return -1;
        }
        int i = 0;
        while (dst.hasRemaining() && this.currentChunk.hasRemaining()) {
            dst.put(this.currentChunk.get());
            ++i;
        }
        return i;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public boolean isOpen() {
        return !this.closed && !this.eof;
    }
}

