/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.esri;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCGeometry;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.udf.esri.GeometryUtils;
import org.apache.hadoop.hive.ql.udf.esri.LogUtils;
import org.apache.hadoop.hive.ql.udf.esri.ST_GeometryAccessor;
import org.apache.hadoop.io.BytesWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="ST_StartPoint", value="_FUNC_(geometry) - returns the first point of an ST_Linestring", extended="Example:\n  > SELECT _FUNC_(ST_LineString(1.5,2.5, 3.0,2.2)) FROM src LIMIT 1;  -- POINT(1.5 2.5)\n")
public class ST_StartPoint
extends ST_GeometryAccessor {
    static final Logger LOG = LoggerFactory.getLogger((String)ST_StartPoint.class.getName());

    public BytesWritable evaluate(BytesWritable geomref) {
        if (geomref == null || geomref.getLength() == 0) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        OGCGeometry ogcGeometry = GeometryUtils.geometryFromEsriShape(geomref);
        if (ogcGeometry == null) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        if (GeometryUtils.getType(geomref) == GeometryUtils.OGCType.ST_LINESTRING) {
            MultiPath lines = (MultiPath)ogcGeometry.getEsriGeometry();
            int wkid = GeometryUtils.getWKID(geomref);
            SpatialReference spatialReference = null;
            if (wkid != 0) {
                spatialReference = SpatialReference.create((int)wkid);
            }
            return GeometryUtils.geometryToEsriShapeBytesWritable(OGCGeometry.createFromEsriGeometry((Geometry)lines.getPoint(0), (SpatialReference)spatialReference));
        }
        LogUtils.Log_InvalidType(LOG, GeometryUtils.OGCType.ST_LINESTRING, GeometryUtils.getType(geomref));
        return null;
    }
}

