/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionException;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorUtil;
import org.apache.hadoop.hive.ql.txn.compactor.MetaStoreCompactorThread;
import org.apache.hadoop.hive.ql.txn.compactor.MetadataCache;
import org.apache.hadoop.hive.ql.txn.compactor.TableOptimizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Initiator
extends MetaStoreCompactorThread {
    private static final String CLASS_NAME = Initiator.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private boolean metricsEnabled;
    private boolean shouldUseMutex = true;
    private List<TableOptimizer> optimizers;

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 32[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected boolean isCacheEnabled() {
        return MetastoreConf.getBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_INITIATOR_TABLECACHE_ON);
    }

    @VisibleForTesting
    protected String resolveUserToRunAs(Map<String, String> cache, Table t, Partition p) throws IOException, InterruptedException {
        String fullTableName = TxnUtils.getFullTableName((String)t.getDbName(), (String)t.getTableName());
        StorageDescriptor sd = CompactorUtil.resolveStorageDescriptor(t, p);
        String user = cache.get(fullTableName);
        if (user == null) {
            user = TxnUtils.findUserToRunAs((String)sd.getLocation(), (Table)t, (Configuration)this.conf);
            cache.put(fullTableName, user);
        }
        return user;
    }

    @Override
    public void init(AtomicBoolean stop) throws Exception {
        super.init(stop);
        this.checkInterval = this.conf.getTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_CHECK_INTERVAL, TimeUnit.MILLISECONDS);
        this.metricsEnabled = MetastoreConf.getBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_ENABLED) && MetastoreConf.getBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_ACIDMETRICS_EXT_ON);
        this.optimizers = Arrays.stream(MetastoreConf.getTrimmedStringsVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_INITIATOR_TABLE_OPTIMIZERS)).map(this::instantiateTableOptimizer).toList();
    }

    private TableOptimizer instantiateTableOptimizer(String className) {
        try {
            Class<?> icebergInitiatorClazz = Class.forName(className, true, Utilities.getSessionSpecifiedClassLoader());
            Class[] constructorParameterTypes = new Class[]{HiveConf.class, TxnStore.class, MetadataCache.class};
            Constructor<?> constructor = icebergInitiatorClazz.getConstructor(constructorParameterTypes);
            Object[] constructorArgs = new Object[]{this.conf, this.txnHandler, this.metadataCache};
            return (TableOptimizer)constructor.newInstance(constructorArgs);
        }
        catch (Exception e) {
            throw new CompactionException((Throwable)e, "Failed instantiating and calling table optimizer %s", className);
        }
    }

    private void recoverFailedCompactions() throws MetaException {
        this.txnHandler.revokeTimedoutWorkers(HiveConf.getTimeVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_WORKER_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS));
    }

    public void enforceMutex(boolean enableMutex) {
        this.shouldUseMutex = enableMutex;
    }

    @VisibleForTesting
    protected Partition resolvePartition(CompactionInfo ci) throws Exception {
        Table table = this.metadataCache.computeIfAbsent(ci.getFullTableName(), () -> CompactorUtil.resolveTable(this.conf, ci.dbname, ci.tableName));
        if (!MetaStoreUtils.isIcebergTable((Map)table.getParameters())) {
            return CompactorUtil.resolvePartition(this.conf, null, ci.dbname, ci.tableName, ci.partName, CompactorUtil.METADATA_FETCH_MODE.LOCAL);
        }
        if (ci.partName == null) {
            return null;
        }
        Partition partition = new Partition();
        partition.setSd(table.getSd().deepCopy());
        partition.setParameters((Map)Maps.newHashMap());
        return partition;
    }

    private static /* synthetic */ Void lambda$run$3(String tableName, String partition, Throwable exc) {
        LOG.error("Error while running scheduling the compaction on the table {} / partition {}.", new Object[]{tableName, partition, exc});
        return null;
    }

    private /* synthetic */ void lambda$run$2(CompactionInfo ci, Table t, Partition p, String runAs) throws Exception {
        CompactorUtil.scheduleCompactionIfRequired(ci, t, p, runAs, this.metricsEnabled, this.hostName, this.txnHandler, this.conf);
    }

    private /* synthetic */ Table lambda$run$1(CompactionInfo ci) throws Exception {
        return this.resolveTable(ci);
    }

    private static /* synthetic */ Set lambda$run$0(TableOptimizer optimizer, long prevStart, ShowCompactResponse currentCompactions, Set skipDBs, Set skipTables) throws Exception {
        return optimizer.findPotentialCompactions(prevStart, currentCompactions, skipDBs, skipTables);
    }

    private static class InitiatorCycleUpdater
    implements Runnable {
        private final String metric;
        private final long startedAt;
        private final long warningThreshold;
        private final long errorThreshold;
        private boolean errorReported;
        private boolean warningReported;

        InitiatorCycleUpdater(String metric, long startedAt, long warningThreshold, long errorThreshold) {
            this.metric = metric;
            this.startedAt = startedAt;
            this.warningThreshold = warningThreshold;
            this.errorThreshold = errorThreshold;
        }

        @Override
        public void run() {
            long elapsed = MetaStoreCompactorThread.updateCycleDurationMetric(this.metric, this.startedAt);
            if (elapsed >= this.errorThreshold) {
                if (!this.errorReported) {
                    LOG.error("Long running Initiator has been detected, duration {}", (Object)elapsed);
                    this.errorReported = true;
                }
            } else if (elapsed >= this.warningThreshold && !this.warningReported && !this.errorReported) {
                this.warningReported = true;
                LOG.warn("Long running Initiator has been detected, duration {}", (Object)elapsed);
            }
        }
    }
}

