/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.cloudjdbc;

import com.xugu.cloudjdbc.Connection;
import com.xugu.cloudjdbc.TypesUtil;
import com.xugu.util.ArrayAssistant;
import com.xugu.util.ArrayAssistantRegistry;
import com.xugu.util.Parser;
import com.xugu.util.TimestampUtils;
import com.xugu.util.internal.Nullness;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;

final class ArrayDecoding {
    private static final ArrayDecoder<Long[]> LONG_OBJ_ARRAY = new AbstractObjectArrayDecoder<Long[]>(Long.class){

        @Override
        Object parseValue(int length, ByteBuffer bytes, Connection connection) {
            return bytes.getLong();
        }

        @Override
        Object parseValue(String stringVal, Connection connection) throws SQLException {
            return ArrayDecoding.toLong(stringVal);
        }
    };
    private static final BigInteger LONGMAX = new BigInteger(Long.toString(Long.MAX_VALUE));
    private static final BigInteger LONGMIN = new BigInteger(Long.toString(Long.MIN_VALUE));
    private static final ArrayDecoder<Long[]> INT4_UNSIGNED_OBJ_ARRAY = new AbstractObjectArrayDecoder<Long[]>(Long.class){

        @Override
        Object parseValue(int length, ByteBuffer bytes, Connection connection) {
            long value = (long)bytes.getInt() & 0xFFFFFFFFL;
            return value;
        }

        @Override
        Object parseValue(String stringVal, Connection connection) throws SQLException {
            return ArrayDecoding.toLong(stringVal);
        }
    };
    private static final ArrayDecoder<Integer[]> INTEGER_OBJ_ARRAY = new AbstractObjectArrayDecoder<Integer[]>(Integer.class){

        @Override
        Object parseValue(int length, ByteBuffer bytes, Connection connection) {
            return bytes.getInt();
        }

        @Override
        Object parseValue(String stringVal, Connection connection) throws SQLException {
            return ArrayDecoding.toInt(stringVal);
        }
    };
    private static final BigInteger INTMAX = new BigInteger(Integer.toString(Integer.MAX_VALUE));
    private static final BigInteger INTMIN = new BigInteger(Integer.toString(Integer.MIN_VALUE));
    private static final ArrayDecoder<Short[]> SHORT_OBJ_ARRAY = new AbstractObjectArrayDecoder<Short[]>(Short.class){

        @Override
        Object parseValue(int length, ByteBuffer bytes, Connection connection) {
            return bytes.getShort();
        }

        @Override
        Object parseValue(String stringVal, Connection connection) throws SQLException {
            return ArrayDecoding.toShort(stringVal);
        }
    };
    private static final BigInteger SHORTMAX = new BigInteger(Short.toString((short)Short.MAX_VALUE));
    private static final BigInteger SHORTMIN = new BigInteger(Short.toString((short)Short.MIN_VALUE));
    private static final ArrayDecoder<Double[]> DOUBLE_OBJ_ARRAY = new AbstractObjectArrayDecoder<Double[]>(Double.class){

        @Override
        Object parseValue(int length, ByteBuffer bytes, Connection connection) {
            return bytes.getDouble();
        }

        @Override
        Object parseValue(String stringVal, Connection connection) throws SQLException {
            return ArrayDecoding.toDouble(stringVal);
        }
    };
    private static final ArrayDecoder<Float[]> FLOAT_OBJ_ARRAY = new AbstractObjectArrayDecoder<Float[]>(Float.class){

        @Override
        Object parseValue(int length, ByteBuffer bytes, Connection connection) {
            return Float.valueOf(bytes.getFloat());
        }

        @Override
        Object parseValue(String stringVal, Connection connection) throws SQLException {
            return Float.valueOf(ArrayDecoding.toFloat(stringVal));
        }
    };
    private static final ArrayDecoder<Boolean[]> BOOLEAN_OBJ_ARRAY = new AbstractObjectArrayDecoder<Boolean[]>(Boolean.class){

        @Override
        Object parseValue(int length, ByteBuffer bytes, Connection connection) {
            return bytes.get() == 1;
        }

        @Override
        Object parseValue(String stringVal, Connection connection) throws SQLException {
            return ArrayDecoding.fromString(stringVal);
        }
    };
    private static final ArrayDecoder<String[]> STRING_ARRAY = new AbstractObjectArrayDecoder<String[]>(String.class){

        @Override
        Object parseValue(int length, ByteBuffer bytes, Connection connection) throws SQLException {
            String val;
            assert (bytes.hasArray());
            byte[] byteArray = bytes.array();
            int offset = bytes.arrayOffset() + bytes.position();
            try {
                val = new String(byteArray, offset, length, connection.getCharSet());
            }
            catch (IOException var8) {
                throw new SQLException("Invalid character data was found.  This is most likely caused by stored data containing characters that are invalid for the character set the database was created in.  The most common example of this is storing 8bit data in a SQL_ASCII database.");
            }
            bytes.position(bytes.position() + length);
            return val;
        }

        @Override
        Object parseValue(String stringVal, Connection connection) throws SQLException {
            return stringVal;
        }
    };
    private static final ArrayDecoder<byte[][]> BYTE_ARRAY_ARRAY = new AbstractObjectArrayDecoder<byte[][]>(byte[].class){

        @Override
        Object parseValue(int length, ByteBuffer bytes, Connection connection) throws SQLException {
            byte[] array = new byte[length];
            bytes.get(array);
            return array;
        }

        @Override
        Object parseValue(String stringVal, Connection connection) throws SQLException {
            return ArrayDecoding.toBytes(stringVal.getBytes(StandardCharsets.US_ASCII));
        }
    };
    private static final int[] HEX_VALS = new int[55];
    private static final int MAX_3_BUFF_SIZE = 0x200000;
    private static final ArrayDecoder<BigDecimal[]> BIG_DECIMAL_STRING_DECODER = new AbstractObjectStringArrayDecoder<BigDecimal[]>(BigDecimal.class){

        @Override
        Object parseValue(String stringVal, Connection connection) throws SQLException {
            return ArrayDecoding.toBigDecimal(stringVal);
        }
    };
    private static final ArrayDecoder<String[]> STRING_ONLY_DECODER = new AbstractObjectStringArrayDecoder<String[]>(String.class){

        @Override
        Object parseValue(String stringVal, Connection connection) throws SQLException {
            return stringVal;
        }
    };
    private static final ArrayDecoder<Date[]> DATE_DECODER = new AbstractObjectStringArrayDecoder<Date[]>(Date.class){

        @Override
        Object parseValue(String stringVal, Connection connection) throws SQLException {
            return TimestampUtils.toDate(null, stringVal);
        }
    };
    private static final ArrayDecoder<Time[]> TIME_DECODER = new AbstractObjectStringArrayDecoder<Time[]>(Time.class){

        @Override
        Object parseValue(String stringVal, Connection connection) throws SQLException {
            return TimestampUtils.toTime(null, stringVal);
        }
    };
    private static final ArrayDecoder<Timestamp[]> TIMESTAMP_DECODER = new AbstractObjectStringArrayDecoder<Timestamp[]>(Timestamp.class){

        @Override
        Object parseValue(String stringVal, Connection connection) throws SQLException {
            return TimestampUtils.toTimestamp(null, stringVal);
        }
    };
    private static final Map<Integer, ArrayDecoder> OID_TO_DECODER = new HashMap<Integer, ArrayDecoder>(29);

    ArrayDecoding() {
    }

    public static long toLong(@Nullable String s) throws SQLException {
        if (s != null) {
            try {
                s = s.trim();
                return Long.parseLong(s);
            }
            catch (NumberFormatException var7) {
                try {
                    BigDecimal n = new BigDecimal(s);
                    BigInteger i = n.toBigInteger();
                    int gt = i.compareTo(LONGMAX);
                    int lt = i.compareTo(LONGMIN);
                    if (gt <= 0 && lt >= 0) {
                        return i.longValue();
                    }
                    throw new SQLException("Bad value for type {0} : {1}", "long");
                }
                catch (NumberFormatException var6) {
                    throw new SQLException("Bad value for type {0} : {1}", "long");
                }
            }
        }
        return 0L;
    }

    public static int toInt(@Nullable String s) throws SQLException {
        if (s != null) {
            try {
                s = s.trim();
                return Integer.parseInt(s);
            }
            catch (NumberFormatException var7) {
                try {
                    BigDecimal n = new BigDecimal(s);
                    BigInteger i = n.toBigInteger();
                    int gt = i.compareTo(INTMAX);
                    int lt = i.compareTo(INTMIN);
                    if (gt <= 0 && lt >= 0) {
                        return i.intValue();
                    }
                    throw new SQLException("Bad value for type {0} : {1}", "int");
                }
                catch (NumberFormatException var6) {
                    throw new SQLException("Bad value for type {0} : {1}", "int");
                }
            }
        }
        return 0;
    }

    public static short toShort(@Nullable String s) throws SQLException {
        if (s != null) {
            try {
                s = s.trim();
                return Short.parseShort(s);
            }
            catch (NumberFormatException var7) {
                try {
                    BigDecimal n = new BigDecimal(s);
                    BigInteger i = n.toBigInteger();
                    int gt = i.compareTo(SHORTMAX);
                    int lt = i.compareTo(SHORTMIN);
                    if (gt <= 0 && lt >= 0) {
                        return i.shortValue();
                    }
                    throw new SQLException("Bad value for type {0} : {1}", "short");
                }
                catch (NumberFormatException var6) {
                    throw new SQLException("Bad value for type {0} : {1}", "short");
                }
            }
        }
        return 0;
    }

    public static double toDouble(@Nullable String s) throws SQLException {
        if (s != null) {
            try {
                s = s.trim();
                return Double.parseDouble(s);
            }
            catch (NumberFormatException var2) {
                throw new SQLException("Bad value for type {0} : {1}", "double");
            }
        }
        return 0.0;
    }

    public static float toFloat(@Nullable String s) throws SQLException {
        if (s != null) {
            try {
                s = s.trim();
                return Float.parseFloat(s);
            }
            catch (NumberFormatException var2) {
                throw new SQLException("Bad value for type {0} : {1}", "float");
            }
        }
        return 0.0f;
    }

    static boolean fromString(String strval) throws SQLException {
        String val = strval.trim();
        if (!("1".equals(val) || "true".equalsIgnoreCase(val) || "t".equalsIgnoreCase(val) || "yes".equalsIgnoreCase(val) || "y".equalsIgnoreCase(val) || "on".equalsIgnoreCase(val))) {
            if (!("0".equals(val) || "false".equalsIgnoreCase(val) || "f".equalsIgnoreCase(val) || "no".equalsIgnoreCase(val) || "n".equalsIgnoreCase(val) || "off".equalsIgnoreCase(val))) {
                throw ArrayDecoding.cannotCoerceException(strval);
            }
            return false;
        }
        return true;
    }

    private static SQLException cannotCoerceException(Object value) {
        return new SQLException("Cannot cast to boolean: \"{0}\"", String.valueOf(value));
    }

    public static @PolyNull byte[] toBytes(@PolyNull byte[] s) throws SQLException {
        if (s == null) {
            return null;
        }
        return s.length >= 2 && s[0] == 92 && s[1] == 120 ? ArrayDecoding.toBytesHexEscaped(s) : ArrayDecoding.toBytesOctalEscaped(s);
    }

    private static int getHex(byte b) {
        return HEX_VALS[b - 48];
    }

    private static byte[] toBytesHexEscaped(byte[] s) {
        int realLength = s.length - 2;
        byte[] output = new byte[realLength >>> 1];
        for (int i = 0; i < realLength; i += 2) {
            int val = ArrayDecoding.getHex(s[2 + i]) << 4;
            output[i >>> 1] = (byte)(val |= ArrayDecoding.getHex(s[3 + i]));
        }
        return output;
    }

    private static byte[] toBytesOctalEscaped(byte[] s) {
        int slength = s.length;
        byte[] buf = null;
        int correctSize = slength;
        if (slength > 0x200000) {
            for (int i = 0; i < slength; ++i) {
                byte next;
                byte current = s[i];
                if (current != 92) continue;
                if ((next = s[++i]) == 92) {
                    --correctSize;
                    continue;
                }
                correctSize -= 3;
            }
            buf = new byte[correctSize];
        } else {
            buf = new byte[slength];
        }
        int bufpos = 0;
        for (int i = 0; i < slength; ++i) {
            byte nextbyte = s[i];
            if (nextbyte == 92) {
                int thebyte;
                byte secondbyte;
                if ((secondbyte = s[++i]) == 92) {
                    buf[bufpos++] = 92;
                    continue;
                }
                if ((thebyte = (secondbyte - 48) * 64 + (s[++i] - 48) * 8 + (s[++i] - 48)) > 127) {
                    thebyte -= 256;
                }
                buf[bufpos++] = (byte)thebyte;
                continue;
            }
            buf[bufpos++] = nextbyte;
        }
        if (bufpos == correctSize) {
            return buf;
        }
        byte[] result = new byte[bufpos];
        System.arraycopy(buf, 0, result, 0, bufpos);
        return result;
    }

    public static @PolyNull BigDecimal toBigDecimal(@PolyNull String s) throws SQLException {
        if (s == null) {
            return null;
        }
        try {
            s = s.trim();
            return new BigDecimal(s);
        }
        catch (NumberFormatException var2) {
            throw new SQLException("Bad value for type {0} : {1}", "BigDecimal");
        }
    }

    private static <A> ArrayDecoder<A> getDecoder(int typeId, Connection connection) throws SQLException {
        Integer key = typeId;
        ArrayDecoder decoder = OID_TO_DECODER.get(key);
        if (decoder != null) {
            return decoder;
        }
        ArrayAssistant assistant = ArrayAssistantRegistry.getAssistant(typeId);
        if (assistant != null) {
            return new ArrayAssistantObjectArrayDecoder(assistant);
        }
        String typeName = TypesUtil.getRedhorseTypeName(typeId);
        if (typeName == null) {
            throw new SQLException("readArray(data,oid)");
        }
        int type = TypesUtil.toJavaType(TypesUtil.getRedhorseType(typeName));
        return type != 1 && type != 12 ? new MappedTypeObjectArrayDecoder(typeName) : STRING_ONLY_DECODER;
    }

    public static Object readBinaryArray(int index, int count, byte[] bytes, Connection connection) throws SQLException {
        int adjustedSkipIndex;
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.order(ByteOrder.BIG_ENDIAN);
        int dimensions = buffer.getInt();
        boolean hasNulls = buffer.getInt() != 0;
        int elementOid = buffer.getInt();
        ArrayDecoder decoder = ArrayDecoding.getDecoder(elementOid, connection);
        if (!decoder.supportBinary()) {
            throw new SQLException("readBinaryArray(data,oid)");
        }
        if (dimensions == 0) {
            return decoder.createArray(0);
        }
        int n = adjustedSkipIndex = index > 0 ? index - 1 : 0;
        if (dimensions == 1) {
            int length = buffer.getInt();
            buffer.position(buffer.position() + 4);
            if (count > 0) {
                length = Math.min(length, count);
            }
            Object array = decoder.createArray(length);
            decoder.populateFromBinary(array, adjustedSkipIndex, length, buffer, connection);
            return array;
        }
        int[] dimensionLengths = new int[dimensions];
        for (int i = 0; i < dimensions; ++i) {
            dimensionLengths[i] = buffer.getInt();
            buffer.position(buffer.position() + 4);
        }
        if (count > 0) {
            dimensionLengths[0] = Math.min(count, dimensionLengths[0]);
        }
        Object[] array = decoder.createMultiDimensionalArray(dimensionLengths);
        ArrayDecoding.storeValues(array, decoder, buffer, adjustedSkipIndex, dimensionLengths, 0, connection);
        return array;
    }

    private static <A> void storeValues(A[] array, ArrayDecoder<A> decoder, ByteBuffer bytes, int skip, int[] dimensionLengths, int dim, Connection connection) throws SQLException {
        int i;
        assert (dim <= dimensionLengths.length - 2);
        for (i = 0; i < skip; ++i) {
            if (dim == dimensionLengths.length - 2) {
                decoder.populateFromBinary(array[0], 0, dimensionLengths[dim + 1], bytes, connection);
                continue;
            }
            ArrayDecoding.storeValues((Object[])array[0], decoder, bytes, 0, dimensionLengths, dim + 1, connection);
        }
        for (i = 0; i < dimensionLengths[dim]; ++i) {
            if (dim == dimensionLengths.length - 2) {
                decoder.populateFromBinary(array[i], 0, dimensionLengths[dim + 1], bytes, connection);
                continue;
            }
            ArrayDecoding.storeValues((Object[])array[i], decoder, bytes, 0, dimensionLengths, dim + 1, connection);
        }
    }

    static DBArrayList buildArrayList(String fieldString, char delim) {
        DBArrayList arrayList = new DBArrayList();
        if (fieldString == null) {
            return arrayList;
        }
        char[] chars = fieldString.toCharArray();
        StringBuilder buffer = null;
        boolean insideString = false;
        boolean wasInsideString = false;
        ArrayList<DBArrayList> dims = new ArrayList<DBArrayList>();
        DBArrayList curArray = arrayList;
        int startOffset = 0;
        if (chars[0] == '[') {
            while (chars[startOffset] != '=') {
                ++startOffset;
            }
            ++startOffset;
        }
        for (int i = startOffset; i < chars.length; ++i) {
            if (chars[i] == '\\') {
                ++i;
            } else {
                if (!insideString && chars[i] == '{') {
                    if (dims.isEmpty()) {
                        dims.add(arrayList);
                    } else {
                        DBArrayList a = new DBArrayList();
                        DBArrayList p = (DBArrayList)dims.get(dims.size() - 1);
                        p.add(a);
                        dims.add(a);
                    }
                    curArray = (DBArrayList)dims.get(dims.size() - 1);
                    for (int t = i + 1; t < chars.length; ++t) {
                        if (Character.isWhitespace(chars[t])) continue;
                        if (chars[t] != '{') break;
                        ++curArray.dimensionsCount;
                    }
                    buffer = new StringBuilder();
                    continue;
                }
                if (chars[i] == '\"') {
                    insideString = !insideString;
                    wasInsideString = true;
                    continue;
                }
                if (!insideString && Parser.isArrayWhiteSpace(chars[i])) continue;
                if (!insideString && (chars[i] == delim || chars[i] == '}') || i == chars.length - 1) {
                    String b;
                    if (chars[i] != '\"' && chars[i] != '}' && chars[i] != delim && buffer != null) {
                        buffer.append(chars[i]);
                    }
                    String string = b = buffer == null ? null : buffer.toString();
                    if (b != null && (!b.isEmpty() || wasInsideString)) {
                        curArray.add(!wasInsideString && b.equals("NULL") ? null : b);
                    }
                    wasInsideString = false;
                    buffer = new StringBuilder();
                    if (chars[i] != '}') continue;
                    dims.remove(dims.size() - 1);
                    if (!dims.isEmpty()) {
                        curArray = (DBArrayList)dims.get(dims.size() - 1);
                    }
                    buffer = null;
                    continue;
                }
            }
            if (buffer == null) continue;
            buffer.append(chars[i]);
        }
        return arrayList;
    }

    public static Object readStringArray(int index, int count, int typeId, DBArrayList list, Connection connection) throws SQLException {
        DBArrayList adjustedList;
        ArrayDecoder decoder = ArrayDecoding.getDecoder(typeId, connection);
        int dims = list.dimensionsCount;
        if (dims == 0) {
            return decoder.createArray(0);
        }
        boolean sublist = false;
        int adjustedSkipIndex = 0;
        if (index > 1) {
            sublist = true;
            adjustedSkipIndex = index - 1;
        }
        int adjustedCount = list.size();
        if (count > 0 && count != adjustedCount) {
            sublist = true;
            adjustedCount = Math.min(adjustedCount, count);
        }
        List<Object> list2 = adjustedList = sublist ? list.subList(adjustedSkipIndex, adjustedSkipIndex + adjustedCount) : list;
        if (dims == 1) {
            int length = adjustedList.size();
            if (count > 0) {
                length = Math.min(length, count);
            }
            Object array = decoder.createArray(length);
            decoder.populateFromString(array, adjustedList, connection);
            return array;
        }
        int[] dimensionLengths = new int[dims];
        dimensionLengths[0] = adjustedCount;
        List tmpList = (List)adjustedList.get(0);
        for (int i = 1; i < dims; ++i) {
            dimensionLengths[i] = Nullness.castNonNull(tmpList, "first element of adjustedList is null").size();
            if (i == dims - 1) continue;
            tmpList = (List)tmpList.get(0);
        }
        Object[] array = decoder.createMultiDimensionalArray(dimensionLengths);
        ArrayDecoding.storeStringValues(array, decoder, adjustedList, dimensionLengths, 0, connection);
        return array;
    }

    private static <A> void storeStringValues(A[] array, ArrayDecoder<A> decoder, List list, int[] dimensionLengths, int dim, Connection connection) throws SQLException {
        assert (dim <= dimensionLengths.length - 2);
        for (int i = 0; i < dimensionLengths[dim]; ++i) {
            Object element = Nullness.castNonNull(list.get(i), "list.get(i)");
            if (dim == dimensionLengths.length - 2) {
                decoder.populateFromString(array[i], (List)element, connection);
                continue;
            }
            ArrayDecoding.storeStringValues((Object[])array[i], decoder, (List)element, dimensionLengths, dim + 1, connection);
        }
    }

    static {
        OID_TO_DECODER.put(26, INT4_UNSIGNED_OBJ_ARRAY);
        OID_TO_DECODER.put(20, LONG_OBJ_ARRAY);
        OID_TO_DECODER.put(23, INTEGER_OBJ_ARRAY);
        OID_TO_DECODER.put(21, SHORT_OBJ_ARRAY);
        OID_TO_DECODER.put(790, DOUBLE_OBJ_ARRAY);
        OID_TO_DECODER.put(701, DOUBLE_OBJ_ARRAY);
        OID_TO_DECODER.put(700, FLOAT_OBJ_ARRAY);
        OID_TO_DECODER.put(25, STRING_ARRAY);
        OID_TO_DECODER.put(1043, STRING_ARRAY);
        OID_TO_DECODER.put(3802, STRING_ONLY_DECODER);
        OID_TO_DECODER.put(1560, BOOLEAN_OBJ_ARRAY);
        OID_TO_DECODER.put(16, BOOLEAN_OBJ_ARRAY);
        OID_TO_DECODER.put(17, BYTE_ARRAY_ARRAY);
        OID_TO_DECODER.put(1700, BIG_DECIMAL_STRING_DECODER);
        OID_TO_DECODER.put(1042, STRING_ONLY_DECODER);
        OID_TO_DECODER.put(18, STRING_ONLY_DECODER);
        OID_TO_DECODER.put(114, STRING_ONLY_DECODER);
        OID_TO_DECODER.put(1082, DATE_DECODER);
        OID_TO_DECODER.put(1083, TIME_DECODER);
        OID_TO_DECODER.put(1266, TIME_DECODER);
        OID_TO_DECODER.put(1114, TIMESTAMP_DECODER);
        OID_TO_DECODER.put(1184, TIMESTAMP_DECODER);
    }

    static final class DBArrayList
    extends ArrayList<Object> {
        private static final long serialVersionUID = 1L;
        int dimensionsCount = 1;

        DBArrayList() {
        }
    }

    private static interface ArrayDecoder<A> {
        public A createArray(@NonNegative int var1);

        public Object[] createMultiDimensionalArray(int[] var1);

        public boolean supportBinary();

        public void populateFromBinary(A var1, @NonNegative int var2, @NonNegative int var3, ByteBuffer var4, Connection var5) throws SQLException;

        public void populateFromString(A var1, List<String> var2, Connection var3) throws SQLException;
    }

    private static abstract class AbstractObjectStringArrayDecoder<A>
    implements ArrayDecoder<A> {
        final Class<?> baseClazz;

        AbstractObjectStringArrayDecoder(Class<?> baseClazz) {
            this.baseClazz = baseClazz;
        }

        @Override
        public boolean supportBinary() {
            return false;
        }

        @Override
        public A createArray(int size) {
            return (A)Array.newInstance(this.baseClazz, size);
        }

        @Override
        public Object[] createMultiDimensionalArray(int[] sizes) {
            return (Object[])Array.newInstance(this.baseClazz, sizes);
        }

        @Override
        public void populateFromBinary(A arr, int index, int count, ByteBuffer bytes, Connection connection) throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }

        @Override
        public void populateFromString(A arr, List<String> strings, Connection connection) throws SQLException {
            Object[] array = (Object[])arr;
            int j = strings.size();
            for (int i = 0; i < j; ++i) {
                String stringVal = strings.get(i);
                array[i] = stringVal != null ? this.parseValue(stringVal, connection) : null;
            }
        }

        abstract Object parseValue(String var1, Connection var2) throws SQLException;
    }

    private static abstract class AbstractObjectArrayDecoder<A>
    extends AbstractObjectStringArrayDecoder<A> {
        AbstractObjectArrayDecoder(Class<?> baseClazz) {
            super(baseClazz);
        }

        @Override
        public boolean supportBinary() {
            return true;
        }

        @Override
        public void populateFromBinary(A arr, int index, int count, ByteBuffer bytes, Connection connection) throws SQLException {
            int length;
            int i;
            Object[] array = (Object[])arr;
            for (i = 0; i < index; ++i) {
                length = bytes.getInt();
                if (length <= 0) continue;
                bytes.position(bytes.position() + length);
            }
            for (i = 0; i < count; ++i) {
                length = bytes.getInt();
                array[i] = length != -1 ? this.parseValue(length, bytes, connection) : null;
            }
        }

        abstract Object parseValue(int var1, ByteBuffer var2, Connection var3) throws SQLException;
    }

    private static final class ArrayAssistantObjectArrayDecoder
    extends AbstractObjectArrayDecoder {
        private final ArrayAssistant arrayAssistant;

        ArrayAssistantObjectArrayDecoder(ArrayAssistant arrayAssistant) {
            super(arrayAssistant.baseType());
            this.arrayAssistant = arrayAssistant;
        }

        @Override
        Object parseValue(int length, ByteBuffer bytes, Connection connection) throws SQLException {
            assert (bytes.hasArray());
            byte[] byteArray = bytes.array();
            int offset = bytes.arrayOffset() + bytes.position();
            Object val = this.arrayAssistant.buildElement(byteArray, offset, length);
            bytes.position(bytes.position() + length);
            return val;
        }

        @Override
        Object parseValue(String stringVal, Connection connection) throws SQLException {
            return this.arrayAssistant.buildElement(stringVal);
        }
    }

    private static final class MappedTypeObjectArrayDecoder
    extends AbstractObjectArrayDecoder<Object[]> {
        private final String typeName;

        MappedTypeObjectArrayDecoder(String baseTypeName) {
            super(Object.class);
            this.typeName = baseTypeName;
        }

        @Override
        Object parseValue(int length, ByteBuffer bytes, Connection connection) throws SQLException {
            byte[] copy = new byte[length];
            bytes.get(copy);
            return connection.getObject(this.typeName, null, copy);
        }

        @Override
        Object parseValue(String stringVal, Connection connection) throws SQLException {
            return connection.getObject(this.typeName, stringVal, null);
        }
    }
}

