/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.util;

import java.util.concurrent.TimeUnit;
import org.apache.hertzbeat.common.util.ExponentialBackoff;

public final class BackoffUtils {
    private BackoffUtils() {
    }

    public static boolean shouldContinueAfterBackoff(ExponentialBackoff backoff) {
        if (Thread.currentThread().isInterrupted()) {
            return false;
        }
        try {
            TimeUnit.MILLISECONDS.sleep(backoff.nextDelay());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        return true;
    }
}

