/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.serialize;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.hertzbeat.common.entity.log.LogEntry;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaLogEntryDeserializer
implements Deserializer<LogEntry> {
    private static final Logger log = LoggerFactory.getLogger(KafkaLogEntryDeserializer.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    public void configure(Map<String, ?> configs, boolean isKey) {
        super.configure(configs, isKey);
    }

    public LogEntry deserialize(String topic, byte[] data) {
        if (data == null || data.length == 0) {
            log.warn("Empty data received for topic: {}", (Object)topic);
            return null;
        }
        try {
            String jsonString = new String(data, StandardCharsets.UTF_8);
            return (LogEntry)this.objectMapper.readValue(jsonString, LogEntry.class);
        }
        catch (JsonProcessingException e) {
            log.error("Failed to deserialize LogEntry from JSON for topic: {}", (Object)topic, (Object)e);
            return null;
        }
    }

    public LogEntry deserialize(String topic, Headers headers, byte[] data) {
        return this.deserialize(topic, data);
    }

    public void close() {
        super.close();
    }
}

