/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.persist;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttPersistable;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;

public class MemoryPersistence
implements MqttClientPersistence {
    private Hashtable<String, MqttPersistable> data;

    @Override
    public void close() throws MqttPersistenceException {
        if (this.data != null) {
            this.data.clear();
        }
    }

    @Override
    public Enumeration<String> keys() throws MqttPersistenceException {
        this.checkIsOpen();
        return this.data.keys();
    }

    @Override
    public MqttPersistable get(String key) throws MqttPersistenceException {
        this.checkIsOpen();
        return this.data.get(key);
    }

    @Override
    public void open(String clientId, String serverURI) throws MqttPersistenceException {
        this.data = new Hashtable();
    }

    @Override
    public void put(String key, MqttPersistable persistable) throws MqttPersistenceException {
        this.checkIsOpen();
        this.data.put(key, persistable);
    }

    @Override
    public void remove(String key) throws MqttPersistenceException {
        this.checkIsOpen();
        this.data.remove(key);
    }

    @Override
    public void clear() throws MqttPersistenceException {
        this.checkIsOpen();
        this.data.clear();
    }

    @Override
    public boolean containsKey(String key) throws MqttPersistenceException {
        this.checkIsOpen();
        return this.data.containsKey(key);
    }

    private void checkIsOpen() throws MqttPersistenceException {
        if (this.data == null) {
            throw new MqttPersistenceException();
        }
    }
}

