/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.support;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.stereotype.Component;

@Component
public class CommonThreadPool
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(CommonThreadPool.class);
    private ThreadPoolExecutor workerExecutor;

    public CommonThreadPool() {
        this.initWorkExecutor();
    }

    private void initWorkExecutor() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setUncaughtExceptionHandler((thread, throwable) -> {
            log.error("common executor has uncaughtException.");
            log.error(throwable.getMessage(), throwable);
        }).setDaemon(true).setNameFormat("common-worker-%d").build();
        this.workerExecutor = new ThreadPoolExecutor(1, Integer.MAX_VALUE, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory, new ThreadPoolExecutor.AbortPolicy());
    }

    public void execute(Runnable runnable) throws RejectedExecutionException {
        this.workerExecutor.execute(runnable);
    }

    public void destroy() throws Exception {
        if (this.workerExecutor != null) {
            this.workerExecutor.shutdownNow();
        }
    }
}

