/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.BiIntFunction;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.IntFunction;
import org.jetbrains.annotations.NotNull;

public class ConcurrentIntHashMap<V>
implements Serializable {
    static final int EMPTY_KEY = Integer.MIN_VALUE;
    static final int HASH_BITS = Integer.MAX_VALUE;
    static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    static final int MIN_TREEIFY_CAPACITY = 64;
    static final int MOVED = -1;
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    static final int RESERVED = -3;
    static final int TREEBIN = -2;
    static final int TREEIFY_THRESHOLD = 8;
    static final int UNTREEIFY_THRESHOLD = 6;
    private static final long ABASE;
    private static final int ASHIFT;
    private static final long BASECOUNT;
    private static final long CELLSBUSY;
    private static final long CELLVALUE;
    private static final int DEFAULT_CAPACITY = 16;
    private static final float LOAD_FACTOR = 0.75f;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final int MIN_TRANSFER_STRIDE = 16;
    private static final long PROBE;
    private static final int PROBE_INCREMENT = -1640531527;
    private static final int RESIZE_STAMP_BITS = 16;
    private static final int MAX_RESIZERS = 65535;
    private static final int RESIZE_STAMP_SHIFT = 16;
    private static final long SEED;
    private static final long SEEDER_INCREMENT = -4942790177534073029L;
    private static final long SIZECTL;
    private static final long TRANSFERINDEX;
    private static final AtomicInteger probeGenerator;
    private static final AtomicLong seeder;
    private static final ObjectStreamField[] serialPersistentFields;
    private static final long serialVersionUID = 7249069246763182397L;
    private final ThreadLocal<Traverser<V>> tlTraverser = ThreadLocal.withInitial(Traverser::new);
    volatile transient Node<V>[] table;
    private volatile transient long baseCount;
    private volatile transient int cellsBusy;
    private volatile transient CounterCell[] counterCells;
    private transient EntrySetView<V> entrySet;
    private transient KeySetView<V> keySet;
    private volatile transient Node<V>[] nextTable;
    private volatile transient int sizeCtl;
    private volatile transient int transferIndex;
    private transient ValuesView<V> values;

    public ConcurrentIntHashMap(int initialCapacity, float loadFactor) {
        long size;
        if (!(loadFactor > 0.0f) || initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        if (initialCapacity < 1) {
            initialCapacity = 1;
        }
        this.sizeCtl = (size = (long)(1.0 + (double)((float)initialCapacity / loadFactor))) >= 0x40000000L ? 0x40000000 : ConcurrentIntHashMap.tableSizeFor((int)size);
    }

    public ConcurrentIntHashMap(ConcurrentIntHashMap<? extends V> m) {
        this.sizeCtl = 16;
        this.putAll(m);
    }

    public ConcurrentIntHashMap() {
    }

    public ConcurrentIntHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.sizeCtl = initialCapacity >= 0x20000000 ? 0x40000000 : ConcurrentIntHashMap.tableSizeFor(initialCapacity + (initialCapacity >>> 1) + 1);
    }

    public static KeySetView<Boolean> newKeySet() {
        return new KeySetView<Boolean>(new ConcurrentIntHashMap(), Boolean.TRUE);
    }

    public static KeySetView<Boolean> newKeySet(int initialCapacity) {
        return new KeySetView<Boolean>(new ConcurrentIntHashMap(initialCapacity), Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        long delta = 0L;
        int i = 0;
        Node<V>[] tab = this.table;
        while (tab != null && i < tab.length) {
            Node<V> f = ConcurrentIntHashMap.tabAt(tab, i);
            if (f == null) {
                ++i;
                continue;
            }
            int fh = f.hash;
            if (fh == -1) {
                tab = this.helpTransfer(tab, f);
                i = 0;
                continue;
            }
            Node<V> node = f;
            synchronized (node) {
                if (ConcurrentIntHashMap.tabAt(tab, i) == f) {
                    Node<V> p;
                    Node<V> node2 = fh >= 0 ? f : (p = f instanceof TreeBin ? ((TreeBin)f).first : null);
                    while (p != null) {
                        --delta;
                        p = p.next;
                    }
                    ConcurrentIntHashMap.setTabAt(tab, i++, null);
                }
            }
        }
        if (delta != 0L) {
            this.addCount(delta, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V compute(int key, BiIntFunction<? super V, ? extends V> remappingFunction) {
        int binCount;
        int delta;
        Object val;
        block37: {
            int i;
            if (key < 0) {
                throw new IllegalArgumentException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            int h = ConcurrentIntHashMap.spread(ConcurrentIntHashMap.keyHashCode(key));
            val = null;
            delta = 0;
            binCount = 0;
            Node<V>[] tab = this.table;
            while (true) {
                int n;
                if (tab == null || (n = tab.length) == 0) {
                    tab = this.initTable();
                    continue;
                }
                i = n - 1 & h;
                Node<V> f = ConcurrentIntHashMap.tabAt(tab, i);
                if (f == null) {
                    ReservationNode r;
                    ReservationNode reservationNode = r = new ReservationNode();
                    synchronized (reservationNode) {
                        if (ConcurrentIntHashMap.casTabAt(tab, i, r)) {
                            binCount = 1;
                            Node<Object> node = null;
                            try {
                                V v = remappingFunction.apply(key, null);
                                val = v;
                                if (v != null) {
                                    delta = 1;
                                    node = new Node<Object>(h, key, val, null);
                                }
                            }
                            finally {
                                ConcurrentIntHashMap.setTabAt(tab, i, node);
                            }
                        }
                    }
                    if (binCount == 0) continue;
                    break block37;
                }
                int fh = f.hash;
                if (fh == -1) {
                    tab = this.helpTransfer(tab, f);
                    continue;
                }
                Node<V> node = f;
                synchronized (node) {
                    block38: {
                        if (ConcurrentIntHashMap.tabAt(tab, i) == f) {
                            if (fh >= 0) {
                                binCount = 1;
                                Node<V> e = f;
                                Node<V> pred = null;
                                while (true) {
                                    if (e.hash == h && e.key == key) {
                                        val = remappingFunction.apply(key, e.val);
                                        if (val != null) {
                                            e.val = val;
                                        } else {
                                            delta = -1;
                                            Node en = e.next;
                                            if (pred != null) {
                                                pred.next = en;
                                            } else {
                                                ConcurrentIntHashMap.setTabAt(tab, i, en);
                                            }
                                        }
                                        break block38;
                                    }
                                    pred = e;
                                    e = e.next;
                                    if (e == null) {
                                        val = remappingFunction.apply(key, null);
                                        if (val != null) {
                                            delta = 1;
                                            pred.next = new Node<Object>(h, key, val, null);
                                        }
                                        break block38;
                                    }
                                    ++binCount;
                                }
                            }
                            if (f instanceof TreeBin) {
                                binCount = 1;
                                TreeBin t = (TreeBin)f;
                                TreeNode r = t.root;
                                TreeNode p = r != null ? r.findTreeNode(h, key) : null;
                                Object pv = p == null ? null : p.val;
                                val = remappingFunction.apply(key, pv);
                                if (val != null) {
                                    if (p != null) {
                                        p.val = val;
                                    } else {
                                        delta = 1;
                                        t.putTreeVal(h, key, val);
                                    }
                                } else if (p != null) {
                                    delta = -1;
                                    if (t.removeTreeNode(p)) {
                                        ConcurrentIntHashMap.setTabAt(tab, i, ConcurrentIntHashMap.untreeify(t.first));
                                    }
                                }
                            }
                        }
                    }
                }
                if (binCount != 0) break;
            }
            if (binCount >= 8) {
                this.treeifyBin(tab, i);
            }
        }
        if (delta != 0) {
            this.addCount(delta, binCount);
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V computeIfAbsent(int key, Object token, BiIntFunction<Object, ? extends V> mappingFunction) {
        int binCount;
        Object val;
        block31: {
            boolean added;
            int i;
            if (key < 0) {
                throw new IllegalArgumentException();
            }
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            int h = ConcurrentIntHashMap.spread(ConcurrentIntHashMap.keyHashCode(key));
            val = null;
            binCount = 0;
            Node<V>[] tab = this.table;
            while (true) {
                Node node;
                int n;
                if (tab == null || (n = tab.length) == 0) {
                    tab = this.initTable();
                    continue;
                }
                i = n - 1 & h;
                Node<V> f = ConcurrentIntHashMap.tabAt(tab, i);
                if (f == null) {
                    ReservationNode r;
                    node = r = new ReservationNode();
                    synchronized (node) {
                        if (ConcurrentIntHashMap.casTabAt(tab, i, r)) {
                            binCount = 1;
                            Node<Object> node2 = null;
                            try {
                                V v = mappingFunction.apply(key, token);
                                val = v;
                                if (v != null) {
                                    node2 = new Node<Object>(h, key, val, null);
                                }
                            }
                            finally {
                                ConcurrentIntHashMap.setTabAt(tab, i, node2);
                            }
                        }
                    }
                    if (binCount == 0) continue;
                    break block31;
                }
                int fh = f.hash;
                if (fh == -1) {
                    tab = this.helpTransfer(tab, f);
                    continue;
                }
                added = false;
                node = f;
                synchronized (node) {
                    block32: {
                        if (ConcurrentIntHashMap.tabAt(tab, i) == f) {
                            if (fh >= 0) {
                                binCount = 1;
                                Node<V> e = f;
                                while (true) {
                                    if (e.hash == h && e.key == key) {
                                        val = e.val;
                                        break block32;
                                    }
                                    Node<V> pred = e;
                                    e = e.next;
                                    if (e == null) {
                                        V v = mappingFunction.apply(key, token);
                                        val = v;
                                        if (v != null) {
                                            added = true;
                                            pred.next = new Node<Object>(h, key, val, null);
                                        }
                                        break block32;
                                    }
                                    ++binCount;
                                }
                            }
                            if (f instanceof TreeBin) {
                                TreeNode p;
                                binCount = 2;
                                TreeBin t = (TreeBin)f;
                                TreeNode r = t.root;
                                if (r != null && (p = r.findTreeNode(h, key)) != null) {
                                    val = p.val;
                                } else {
                                    V v = mappingFunction.apply(key, token);
                                    val = v;
                                    if (v != null) {
                                        added = true;
                                        t.putTreeVal(h, key, val);
                                    }
                                }
                            }
                        }
                    }
                }
                if (binCount != 0) break;
            }
            if (binCount >= 8) {
                this.treeifyBin(tab, i);
            }
            if (!added) {
                return (V)val;
            }
        }
        if (val != null) {
            this.addCount(1L, binCount);
        }
        return (V)val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V computeIfAbsent(int key, IntFunction<? extends V> mappingFunction) {
        int binCount;
        Object val;
        block31: {
            boolean added;
            int i;
            if (key < 0) {
                throw new IllegalArgumentException();
            }
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            int h = ConcurrentIntHashMap.spread(ConcurrentIntHashMap.keyHashCode(key));
            val = null;
            binCount = 0;
            Node<V>[] tab = this.table;
            while (true) {
                Node node;
                int n;
                if (tab == null || (n = tab.length) == 0) {
                    tab = this.initTable();
                    continue;
                }
                i = n - 1 & h;
                Node<V> f = ConcurrentIntHashMap.tabAt(tab, i);
                if (f == null) {
                    ReservationNode r;
                    node = r = new ReservationNode();
                    synchronized (node) {
                        if (ConcurrentIntHashMap.casTabAt(tab, i, r)) {
                            binCount = 1;
                            Node<Object> node2 = null;
                            try {
                                V v = mappingFunction.apply(key);
                                val = v;
                                if (v != null) {
                                    node2 = new Node<Object>(h, key, val, null);
                                }
                            }
                            finally {
                                ConcurrentIntHashMap.setTabAt(tab, i, node2);
                            }
                        }
                    }
                    if (binCount == 0) continue;
                    break block31;
                }
                int fh = f.hash;
                if (fh == -1) {
                    tab = this.helpTransfer(tab, f);
                    continue;
                }
                added = false;
                node = f;
                synchronized (node) {
                    block32: {
                        if (ConcurrentIntHashMap.tabAt(tab, i) == f) {
                            if (fh >= 0) {
                                binCount = 1;
                                Node<V> e = f;
                                while (true) {
                                    if (e.hash == h && e.key == key) {
                                        val = e.val;
                                        break block32;
                                    }
                                    Node<V> pred = e;
                                    e = e.next;
                                    if (e == null) {
                                        V v = mappingFunction.apply(key);
                                        val = v;
                                        if (v != null) {
                                            added = true;
                                            pred.next = new Node<Object>(h, key, val, null);
                                        }
                                        break block32;
                                    }
                                    ++binCount;
                                }
                            }
                            if (f instanceof TreeBin) {
                                TreeNode p;
                                binCount = 2;
                                TreeBin t = (TreeBin)f;
                                TreeNode r = t.root;
                                if (r != null && (p = r.findTreeNode(h, key)) != null) {
                                    val = p.val;
                                } else {
                                    V v = mappingFunction.apply(key);
                                    val = v;
                                    if (v != null) {
                                        added = true;
                                        t.putTreeVal(h, key, val);
                                    }
                                }
                            }
                        }
                    }
                }
                if (binCount != 0) break;
            }
            if (binCount >= 8) {
                this.treeifyBin(tab, i);
            }
            if (!added) {
                return (V)val;
            }
        }
        if (val != null) {
            this.addCount(1L, binCount);
        }
        return (V)val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V computeIfPresent(int key, BiIntFunction<? super V, ? extends V> remappingFunction) {
        if (key < 0) {
            throw new IllegalArgumentException();
        }
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int h = ConcurrentIntHashMap.spread(ConcurrentIntHashMap.keyHashCode(key));
        V val = null;
        int delta = 0;
        int binCount = 0;
        Node<V>[] tab = this.table;
        while (true) {
            int n;
            if (tab == null || (n = tab.length) == 0) {
                tab = this.initTable();
                continue;
            }
            int i = n - 1 & h;
            Node<V> f = ConcurrentIntHashMap.tabAt(tab, i);
            if (f == null) break;
            int fh = f.hash;
            if (fh == -1) {
                tab = this.helpTransfer(tab, f);
                continue;
            }
            Node<V> node = f;
            synchronized (node) {
                if (ConcurrentIntHashMap.tabAt(tab, i) == f) {
                    if (fh >= 0) {
                        binCount = 1;
                        Node<V> e = f;
                        Node<V> pred = null;
                        while (true) {
                            if (e.hash == h && e.key == key) {
                                val = remappingFunction.apply(key, e.val);
                                if (val != null) {
                                    e.val = val;
                                } else {
                                    delta = -1;
                                    Node en = e.next;
                                    if (pred != null) {
                                        pred.next = en;
                                    } else {
                                        ConcurrentIntHashMap.setTabAt(tab, i, en);
                                    }
                                }
                            } else {
                                pred = e;
                                e = e.next;
                                if (e != null) {
                                    ++binCount;
                                    continue;
                                }
                            }
                            break;
                        }
                    } else if (f instanceof TreeBin) {
                        TreeNode p;
                        binCount = 2;
                        TreeBin t = (TreeBin)f;
                        TreeNode r = t.root;
                        if (r != null && (p = r.findTreeNode(h, key)) != null) {
                            val = remappingFunction.apply(key, p.val);
                            if (val != null) {
                                p.val = val;
                            } else {
                                delta = -1;
                                if (t.removeTreeNode(p)) {
                                    ConcurrentIntHashMap.setTabAt(tab, i, ConcurrentIntHashMap.untreeify(t.first));
                                }
                            }
                        }
                    }
                }
            }
            if (binCount != 0) break;
        }
        if (delta != 0) {
            this.addCount(delta, binCount);
        }
        return val;
    }

    public boolean containsKey(int key) {
        return this.get(key) != null;
    }

    public boolean containsValue(V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Node<V>[] t = this.table;
        if (t != null) {
            Node<V> p;
            Traverser<V> it = this.getTraverser(t);
            while ((p = it.advance()) != null) {
                Object v = p.val;
                if (v != value && !value.equals(v)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public Set<IntEntry<V>> entrySet() {
        EntrySetView<V> es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySetView(this));
    }

    public boolean equals(Object o) {
        if (o != this) {
            Node<V> p;
            if (!(o instanceof ConcurrentIntHashMap)) {
                return false;
            }
            ConcurrentIntHashMap m = (ConcurrentIntHashMap)o;
            Traverser<V> it = this.getTraverser(this.table);
            while ((p = it.advance()) != null) {
                Object val = p.val;
                V v = m.get(p.key);
                if (v != null && (v == val || v.equals(val))) continue;
                return false;
            }
            for (IntEntry<V> e : m.entrySet()) {
                V v;
                V mv;
                int mk = e.getKey();
                if (mk != Integer.MIN_VALUE && (mv = e.getValue()) != null && (v = this.get(mk)) != null && (mv == v || mv.equals(v))) continue;
                return false;
            }
        }
        return true;
    }

    public V get(int key) {
        Node<V> e;
        int n;
        int h = ConcurrentIntHashMap.spread(ConcurrentIntHashMap.keyHashCode(key));
        Node<V>[] tab = this.table;
        if (this.table != null && (n = tab.length) > 0 && (e = ConcurrentIntHashMap.tabAt(tab, n - 1 & h)) != null) {
            int eh = e.hash;
            if (eh == h) {
                if (e.key == key) {
                    return e.val;
                }
            } else if (eh < 0) {
                Node<V> p = e.find(h, key);
                return p != null ? (V)p.val : null;
            }
            while ((e = e.next) != null) {
                if (e.hash != h || e.key != key) continue;
                return e.val;
            }
        }
        return null;
    }

    public V getOrDefault(int key, V defaultValue) {
        V v = this.get(key);
        return v == null ? defaultValue : v;
    }

    public int hashCode() {
        int h = 0;
        Node<V>[] t = this.table;
        if (t != null) {
            Node<V> p;
            Traverser<V> it = this.getTraverser(t);
            while ((p = it.advance()) != null) {
                h += ConcurrentIntHashMap.keyHashCode(p.key) ^ p.val.hashCode();
            }
        }
        return h;
    }

    public boolean isEmpty() {
        return this.sumCount() <= 0L;
    }

    public KeySetView<V> keySet(V mappedValue) {
        if (mappedValue == null) {
            throw new NullPointerException();
        }
        return new KeySetView<V>(this, mappedValue);
    }

    @NotNull
    public KeySetView<V> keySet() {
        KeySetView<V> ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySetView<Object>(this, null));
    }

    public long mappingCount() {
        return Math.max(this.sumCount(), 0L);
    }

    public V put(int key, V value) {
        return this.putVal(key, value, false);
    }

    public void putAll(@NotNull ConcurrentIntHashMap<? extends V> m) {
        this.tryPresize(m.size());
        for (IntEntry<V> e : m.entrySet()) {
            this.putVal(e.getKey(), e.getValue(), false);
        }
    }

    public V putIfAbsent(int key, V value) {
        return this.putVal(key, value, true);
    }

    public boolean remove(int key, V value) {
        return value != null && this.replaceNode(key, null, value) != null;
    }

    public V remove(int key) {
        return this.replaceNode(key, null, null);
    }

    public boolean replace(int key, @NotNull V oldValue, @NotNull V newValue) {
        return this.replaceNode(key, newValue, oldValue) != null;
    }

    public V replace(int key, @NotNull V value) {
        return this.replaceNode(key, value, null);
    }

    public int size() {
        long n = this.sumCount();
        return n < 0L ? 0 : (n > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)n);
    }

    public String toString() {
        Traverser<V> it = this.getTraverser(this.table);
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        Node<V> p = it.advance();
        if (p != null) {
            while (true) {
                int k = p.key;
                Object v = p.val;
                sb.append(k);
                sb.append('=');
                sb.append((Object)(v == this ? "(this Map)" : v));
                p = it.advance();
                if (p == null) break;
                sb.append(',').append(' ');
            }
        }
        return sb.append('}').toString();
    }

    @NotNull
    public Collection<V> values() {
        ValuesView<V> vs = this.values;
        return vs != null ? vs : (this.values = new ValuesView(this));
    }

    private static long initialSeed() {
        String pp = System.getProperty("java.util.secureRandomSeed");
        if (pp != null && pp.equalsIgnoreCase("true")) {
            byte[] seedBytes = SecureRandom.getSeed(8);
            long s = (long)seedBytes[0] & 0xFFL;
            for (int i = 1; i < 8; ++i) {
                s = s << 8 | (long)seedBytes[i] & 0xFFL;
            }
            return s;
        }
        return ConcurrentIntHashMap.mix64(System.currentTimeMillis()) ^ ConcurrentIntHashMap.mix64(System.nanoTime());
    }

    private static int keyHashCode(int key) {
        return key;
    }

    private static long mix64(long z) {
        z = (z ^ z >>> 33) * -49064778989728563L;
        z = (z ^ z >>> 33) * -4265267296055464877L;
        return z ^ z >>> 33;
    }

    private static int tableSizeFor(int c) {
        int n = c - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    private void addCount(long x, int check) {
        long s;
        long b;
        CounterCell[] as = this.counterCells;
        if (this.counterCells != null || !Unsafe.cas((Object)this, BASECOUNT, b = this.baseCount, s = b + x)) {
            long v;
            CounterCell a;
            int m;
            boolean uncontended = true;
            if (as == null || (m = as.length - 1) < 0 || (a = as[ConcurrentIntHashMap.getProbe() & m]) == null || !(uncontended = Unsafe.cas((Object)a, CELLVALUE, v = a.value, v + x))) {
                this.fullAddCount(x, uncontended);
                return;
            }
            if (check <= 1) {
                return;
            }
            s = this.sumCount();
        }
        if (check >= 0) {
            int sc;
            while (s >= (long)(sc = this.sizeCtl)) {
                int n;
                Node<V>[] tab = this.table;
                if (this.table == null || (n = tab.length) >= 0x40000000) break;
                int rs = ConcurrentIntHashMap.resizeStamp(n);
                if (sc < 0) {
                    if (sc >>> 16 != rs || sc == rs + 65535) break;
                    Node<V>[] nt = this.nextTable;
                    if (this.nextTable == null || this.transferIndex <= 0) break;
                    if (Unsafe.getUnsafe().compareAndSwapInt(this, SIZECTL, sc, sc + 1)) {
                        this.transfer(tab, nt);
                    }
                } else if (Unsafe.getUnsafe().compareAndSwapInt(this, SIZECTL, sc, (rs << 16) + 2)) {
                    this.transfer(tab, null);
                }
                s = this.sumCount();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void fullAddCount(long x, boolean wasUncontended) {
        int h = ConcurrentIntHashMap.getProbe();
        if (h == 0) {
            ConcurrentIntHashMap.localInit();
            h = ConcurrentIntHashMap.getProbe();
            wasUncontended = true;
        }
        boolean collide = false;
        while (true) {
            long v;
            int n;
            CounterCell[] as = this.counterCells;
            if (this.counterCells != null && (n = as.length) > 0) {
                CounterCell a = as[n - 1 & h];
                if (a == null) {
                    if (this.cellsBusy == 0) {
                        CounterCell r = new CounterCell(x);
                        if (this.cellsBusy == 0 && Unsafe.getUnsafe().compareAndSwapInt(this, CELLSBUSY, 0, 1)) {
                            boolean created = false;
                            try {
                                int j;
                                int m;
                                CounterCell[] rs = this.counterCells;
                                if (this.counterCells != null && (m = rs.length) > 0 && rs[j = m - 1 & h] == null) {
                                    rs[j] = r;
                                    created = true;
                                }
                            }
                            finally {
                                this.cellsBusy = 0;
                            }
                            if (!created) continue;
                            return;
                        }
                    }
                    collide = false;
                } else if (!wasUncontended) {
                    wasUncontended = true;
                } else {
                    v = a.value;
                    if (Unsafe.cas((Object)a, CELLVALUE, v, v + x)) return;
                    if (this.counterCells != as || n >= NCPU) {
                        collide = false;
                    } else if (!collide) {
                        collide = true;
                    } else if (this.cellsBusy == 0 && Unsafe.getUnsafe().compareAndSwapInt(this, CELLSBUSY, 0, 1)) {
                        try {
                            if (this.counterCells == as) {
                                CounterCell[] rs = new CounterCell[n << 1];
                                System.arraycopy(as, 0, rs, 0, n);
                                this.counterCells = rs;
                            }
                        }
                        finally {
                            this.cellsBusy = 0;
                        }
                        collide = false;
                        continue;
                    }
                }
                h = ConcurrentIntHashMap.advanceProbe(h);
                continue;
            }
            if (this.cellsBusy == 0 && this.counterCells == as && Unsafe.getUnsafe().compareAndSwapInt(this, CELLSBUSY, 0, 1)) {
                boolean init = false;
                try {
                    if (this.counterCells == as) {
                        CounterCell[] rs = new CounterCell[2];
                        rs[h & 1] = new CounterCell(x);
                        this.counterCells = rs;
                        init = true;
                    }
                }
                finally {
                    this.cellsBusy = 0;
                }
                if (!init) continue;
                return;
            }
            v = this.baseCount;
            if (Unsafe.cas((Object)this, BASECOUNT, v, v + x)) return;
        }
    }

    private Traverser<V> getTraverser(Node<V>[] tab) {
        Traverser<V> traverser = this.tlTraverser.get();
        int len = tab == null ? 0 : tab.length;
        traverser.of(tab, len, len);
        return traverser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node<V>[] initTable() {
        Node<V>[] tab;
        block6: {
            int sc;
            while (true) {
                tab = this.table;
                if (this.table != null && tab.length != 0) break block6;
                sc = this.sizeCtl;
                if (sc < 0) {
                    Os.pause();
                    continue;
                }
                if (Unsafe.getUnsafe().compareAndSwapInt(this, SIZECTL, sc, -1)) break;
            }
            try {
                tab = this.table;
                if (this.table == null || tab.length == 0) {
                    int n = sc > 0 ? sc : 16;
                    Node[] nt = new Node[n];
                    tab = nt;
                    this.table = nt;
                    sc = n - (n >>> 2);
                }
            }
            finally {
                this.sizeCtl = sc;
            }
        }
        return tab;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transfer(Node<V>[] tab, Node<V>[] nextTab) {
        int n = tab.length;
        int stride = NCPU > 1 ? (n >>> 3) / NCPU : n;
        if (stride < 16) {
            stride = 16;
        }
        if (nextTab == null) {
            try {
                Node[] nt = new Node[n << 1];
                nextTab = nt;
            }
            catch (Throwable ex) {
                this.sizeCtl = Integer.MAX_VALUE;
                return;
            }
            this.nextTable = nextTab;
            this.transferIndex = n;
        }
        int nextn = nextTab.length;
        ForwardingNode<V> fwd = new ForwardingNode<V>(nextTab);
        boolean advance = true;
        boolean finishing = false;
        int i = 0;
        int bound = 0;
        while (true) {
            if (advance) {
                int nextBound;
                if (--i >= bound || finishing) {
                    advance = false;
                    continue;
                }
                int nextIndex = this.transferIndex;
                if (nextIndex <= 0) {
                    i = -1;
                    advance = false;
                    continue;
                }
                if (!Unsafe.getUnsafe().compareAndSwapInt(this, TRANSFERINDEX, nextIndex, nextBound = nextIndex > stride ? nextIndex - stride : 0)) continue;
                bound = nextBound;
                i = nextIndex - 1;
                advance = false;
                continue;
            }
            if (i < 0 || i >= n || i + n >= nextn) {
                if (finishing) {
                    this.nextTable = null;
                    this.table = nextTab;
                    this.sizeCtl = (n << 1) - (n >>> 1);
                    return;
                }
                int sc = this.sizeCtl;
                if (!Unsafe.getUnsafe().compareAndSwapInt(this, SIZECTL, sc, sc - 1)) continue;
                if (sc - 2 != ConcurrentIntHashMap.resizeStamp(n) << 16) {
                    return;
                }
                advance = true;
                finishing = true;
                i = n;
                continue;
            }
            TreeBin f = ConcurrentIntHashMap.tabAt(tab, i);
            if (f == null) {
                advance = ConcurrentIntHashMap.casTabAt(tab, i, fwd);
                continue;
            }
            int fh = f.hash;
            if (fh == -1) {
                advance = true;
                continue;
            }
            TreeBin treeBin = f;
            synchronized (treeBin) {
                if (ConcurrentIntHashMap.tabAt(tab, i) == f) {
                    Node hn;
                    if (fh >= 0) {
                        Node ln;
                        int runBit = fh & n;
                        TreeBin lastRun = f;
                        Node p = f.next;
                        while (p != null) {
                            int b = p.hash & n;
                            if (b != runBit) {
                                runBit = b;
                                lastRun = p;
                            }
                            p = p.next;
                        }
                        if (runBit == 0) {
                            ln = lastRun;
                            hn = null;
                        } else {
                            hn = lastRun;
                            ln = null;
                        }
                        p = f;
                        while (p != lastRun) {
                            int ph = p.hash;
                            int pk = p.key;
                            Object pv = p.val;
                            if ((ph & n) == 0) {
                                ln = new Node(ph, pk, pv, ln);
                            } else {
                                hn = new Node(ph, pk, pv, hn);
                            }
                            p = p.next;
                        }
                        ConcurrentIntHashMap.setTabAt(nextTab, i, ln);
                        ConcurrentIntHashMap.setTabAt(nextTab, i + n, hn);
                        ConcurrentIntHashMap.setTabAt(tab, i, fwd);
                        advance = true;
                    } else if (f instanceof TreeBin) {
                        TreeBin ln;
                        TreeBin t = f;
                        TreeNode lo = null;
                        TreeNode loTail = null;
                        TreeNode hi = null;
                        TreeNode hiTail = null;
                        int lc = 0;
                        int hc = 0;
                        Node e = t.first;
                        while (e != null) {
                            int h = e.hash;
                            TreeNode p = new TreeNode(h, e.key, e.val, null, null);
                            if ((h & n) == 0) {
                                p.prev = loTail;
                                if (p.prev == null) {
                                    lo = p;
                                } else {
                                    loTail.next = p;
                                }
                                loTail = p;
                                ++lc;
                            } else {
                                p.prev = hiTail;
                                if (p.prev == null) {
                                    hi = p;
                                } else {
                                    hiTail.next = p;
                                }
                                hiTail = p;
                                ++hc;
                            }
                            e = e.next;
                        }
                        TreeBin treeBin2 = lc <= 6 ? ConcurrentIntHashMap.untreeify(lo) : (ln = hc != 0 ? new TreeBin(lo) : t);
                        hn = hc <= 6 ? ConcurrentIntHashMap.untreeify(hi) : (lc != 0 ? new TreeBin(hi) : t);
                        ConcurrentIntHashMap.setTabAt(nextTab, i, ln);
                        ConcurrentIntHashMap.setTabAt(nextTab, i + n, hn);
                        ConcurrentIntHashMap.setTabAt(tab, i, fwd);
                        advance = true;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void treeifyBin(Node<V>[] tab, int index) {
        if (tab != null) {
            int n = tab.length;
            if (n < 64) {
                this.tryPresize(n << 1);
            } else {
                Node<V> b = ConcurrentIntHashMap.tabAt(tab, index);
                if (b != null && b.hash >= 0) {
                    Node<V> node = b;
                    synchronized (node) {
                        if (ConcurrentIntHashMap.tabAt(tab, index) == b) {
                            TreeNode hd = null;
                            TreeNode tl = null;
                            Node<V> e = b;
                            while (e != null) {
                                TreeNode p = new TreeNode(e.hash, e.key, e.val, null, null);
                                p.prev = tl;
                                if (p.prev == null) {
                                    hd = p;
                                } else {
                                    tl.next = p;
                                }
                                tl = p;
                                e = e.next;
                            }
                            ConcurrentIntHashMap.setTabAt(tab, index, new TreeBin(hd));
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryPresize(int size) {
        int sc;
        int c;
        int n = c = size >= 0x20000000 ? 0x40000000 : ConcurrentIntHashMap.tableSizeFor(size + (size >>> 1) + 1);
        while ((sc = this.sizeCtl) >= 0) {
            int n2;
            Node<V>[] tab = this.table;
            if (tab == null || (n2 = tab.length) == 0) {
                n2 = Math.max(sc, c);
                if (!Unsafe.getUnsafe().compareAndSwapInt(this, SIZECTL, sc, -1)) continue;
                try {
                    if (this.table != tab) continue;
                    Node[] nt = new Node[n2];
                    this.table = nt;
                    sc = n2 - (n2 >>> 2);
                    continue;
                }
                finally {
                    this.sizeCtl = sc;
                    continue;
                }
            }
            if (c <= sc || n2 >= 0x40000000) break;
            if (tab != this.table) continue;
            int rs = ConcurrentIntHashMap.resizeStamp(n2);
            if (sc < 0) {
                if (sc >>> 16 != rs || sc == rs + 1 || sc == rs + 65535) break;
                Node<V>[] nt = this.nextTable;
                if (this.nextTable == null || this.transferIndex <= 0) break;
                if (!Unsafe.getUnsafe().compareAndSwapInt(this, SIZECTL, sc, sc + 1)) continue;
                this.transfer(tab, nt);
                continue;
            }
            if (!Unsafe.getUnsafe().compareAndSwapInt(this, SIZECTL, sc, (rs << 16) + 2)) continue;
            this.transfer(tab, null);
        }
    }

    static int advanceProbe(int probe) {
        probe ^= probe << 13;
        probe ^= probe >>> 17;
        probe ^= probe << 5;
        Unsafe.getUnsafe().putInt(Thread.currentThread(), PROBE, probe);
        return probe;
    }

    static <V> boolean casTabAt(Node<V>[] tab, int i, Node<V> v) {
        return Unsafe.getUnsafe().compareAndSwapObject(tab, ((long)i << ASHIFT) + ABASE, null, v);
    }

    static Class<?> comparableClassFor(Object x) {
        if (x instanceof Comparable) {
            Class<?> c = x.getClass();
            if (c == String.class) {
                return c;
            }
            Type[] ts = c.getGenericInterfaces();
            if (ts != null) {
                for (int i = 0; i < ts.length; ++i) {
                    Type[] as;
                    ParameterizedType p;
                    Type t = ts[i];
                    if (!(t instanceof ParameterizedType) || (p = (ParameterizedType)t).getRawType() != Comparable.class || (as = p.getActualTypeArguments()) == null || as.length != 1 || as[0] != c) continue;
                    return c;
                }
            }
        }
        return null;
    }

    static int compareComparables(int k, long x) {
        return Long.compare(k, x);
    }

    static int getProbe() {
        return Unsafe.getUnsafe().getInt(Thread.currentThread(), PROBE);
    }

    static void localInit() {
        int p = probeGenerator.addAndGet(-1640531527);
        int probe = p == 0 ? 1 : p;
        long seed = ConcurrentIntHashMap.mix64(seeder.getAndAdd(-4942790177534073029L));
        Thread t = Thread.currentThread();
        Unsafe.getUnsafe().putLong(t, SEED, seed);
        Unsafe.getUnsafe().putInt(t, PROBE, probe);
    }

    static int resizeStamp(int n) {
        return Integer.numberOfLeadingZeros(n) | 0x8000;
    }

    static <K, V> void setTabAt(Node<V>[] tab, int i, Node<V> v) {
        Unsafe.getUnsafe().putObjectVolatile(tab, ((long)i << ASHIFT) + ABASE, v);
    }

    static int spread(int h) {
        return (h ^ h >>> 16) & Integer.MAX_VALUE;
    }

    static <V> Node<V> tabAt(Node<V>[] tab, int i) {
        return (Node)Unsafe.getUnsafe().getObjectVolatile(tab, ((long)i << ASHIFT) + ABASE);
    }

    static <V> Node<V> untreeify(Node<V> b) {
        Node hd = null;
        Node tl = null;
        Node<V> q = b;
        while (q != null) {
            Node p = new Node(q.hash, q.key, q.val, null);
            if (tl == null) {
                hd = p;
            } else {
                tl.next = p;
            }
            tl = p;
            q = q.next;
        }
        return hd;
    }

    final Node<V>[] helpTransfer(Node<V>[] tab, Node<V> f) {
        if (tab != null && f instanceof ForwardingNode) {
            Node<V>[] nextTab = ((ForwardingNode)f).nextTable;
            if (((ForwardingNode)f).nextTable != null) {
                int sc;
                int rs = ConcurrentIntHashMap.resizeStamp(tab.length);
                while (nextTab == this.nextTable && this.table == tab && (sc = this.sizeCtl) < 0 && sc >>> 16 == rs && sc != rs + 1 && sc != rs + 65535 && this.transferIndex > 0) {
                    if (!Unsafe.getUnsafe().compareAndSwapInt(this, SIZECTL, sc, sc + 1)) continue;
                    this.transfer(tab, nextTab);
                    break;
                }
                return nextTab;
            }
        }
        return this.table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final V putVal(int key, V value, boolean onlyIfAbsent) {
        int binCount;
        block21: {
            V oldVal;
            int i;
            if (key < 0) {
                throw new IllegalArgumentException();
            }
            if (value == null) {
                throw new NullPointerException();
            }
            int hash = ConcurrentIntHashMap.spread(ConcurrentIntHashMap.keyHashCode(key));
            binCount = 0;
            Node<V> _new = null;
            Node<V>[] tab = this.table;
            while (true) {
                int n;
                if (tab == null || (n = tab.length) == 0) {
                    tab = this.initTable();
                    continue;
                }
                i = n - 1 & hash;
                Node<V> f = ConcurrentIntHashMap.tabAt(tab, i);
                if (f == null) {
                    if (_new == null) {
                        _new = new Node<V>(hash, key, value, null);
                    }
                    if (!ConcurrentIntHashMap.casTabAt(tab, i, _new)) continue;
                    break block21;
                }
                int fh = f.hash;
                if (fh == -1) {
                    tab = this.helpTransfer(tab, f);
                    continue;
                }
                oldVal = null;
                Node<V> node = f;
                synchronized (node) {
                    block22: {
                        if (ConcurrentIntHashMap.tabAt(tab, i) == f) {
                            if (fh >= 0) {
                                binCount = 1;
                                Node<V> e = f;
                                while (true) {
                                    if (e.hash == hash && e.key == key) {
                                        oldVal = e.val;
                                        if (!onlyIfAbsent) {
                                            e.val = value;
                                        }
                                        break block22;
                                    }
                                    Node<V> pred = e;
                                    e = e.next;
                                    if (e == null) {
                                        pred.next = _new == null ? new Node<V>(hash, key, value, null) : _new;
                                        break block22;
                                    }
                                    ++binCount;
                                }
                            }
                            if (f instanceof TreeBin) {
                                binCount = 2;
                                TreeNode<V> p = ((TreeBin)f).putTreeVal(hash, key, value);
                                if (p != null) {
                                    oldVal = p.val;
                                    if (!onlyIfAbsent) {
                                        p.val = value;
                                    }
                                }
                            }
                        }
                    }
                }
                if (binCount != 0) break;
            }
            if (binCount >= 8) {
                this.treeifyBin(tab, i);
            }
            if (oldVal != null) {
                return oldVal;
            }
        }
        this.addCount(1L, binCount);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final V replaceNode(int key, V value, V cv) {
        int i;
        Node<V> f;
        int n;
        int hash = ConcurrentIntHashMap.spread(ConcurrentIntHashMap.keyHashCode(key));
        Node<V>[] tab = this.table;
        while (tab != null && (n = tab.length) != 0 && (f = ConcurrentIntHashMap.tabAt(tab, i = n - 1 & hash)) != null) {
            int fh = f.hash;
            if (fh == -1) {
                tab = this.helpTransfer(tab, f);
                continue;
            }
            Object oldVal = null;
            boolean validated = false;
            Node<V> node = f;
            synchronized (node) {
                if (ConcurrentIntHashMap.tabAt(tab, i) == f) {
                    if (fh >= 0) {
                        validated = true;
                        Node<V> e = f;
                        Node<V> pred = null;
                        do {
                            if (e.hash == hash && e.key == key) {
                                Object ev = e.val;
                                if (cv == null || cv == ev || cv.equals(ev)) {
                                    oldVal = ev;
                                    if (value != null) {
                                        e.val = value;
                                    } else if (pred != null) {
                                        pred.next = e.next;
                                    } else {
                                        ConcurrentIntHashMap.setTabAt(tab, i, e.next);
                                    }
                                }
                                break;
                            }
                            pred = e;
                        } while ((e = e.next) != null);
                    } else if (f instanceof TreeBin) {
                        TreeNode p;
                        validated = true;
                        TreeBin t = (TreeBin)f;
                        TreeNode r = t.root;
                        if (r != null && (p = r.findTreeNode(hash, key)) != null) {
                            Object pv = p.val;
                            if (cv == null || cv == pv || cv.equals(pv)) {
                                oldVal = pv;
                                if (value != null) {
                                    p.val = value;
                                } else if (t.removeTreeNode(p)) {
                                    ConcurrentIntHashMap.setTabAt(tab, i, ConcurrentIntHashMap.untreeify(t.first));
                                }
                            }
                        }
                    }
                }
            }
            if (!validated) continue;
            if (oldVal == null) break;
            if (value == null) {
                this.addCount(-1L, -1);
            }
            return (V)oldVal;
        }
        return null;
    }

    final long sumCount() {
        CounterCell[] as = this.counterCells;
        long sum = this.baseCount;
        if (as != null) {
            for (int i = 0; i < as.length; ++i) {
                CounterCell a = as[i];
                if (a == null) continue;
                sum += a.value;
            }
        }
        return sum;
    }

    static {
        probeGenerator = new AtomicInteger();
        seeder = new AtomicLong(ConcurrentIntHashMap.initialSeed());
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("segments", Segment[].class), new ObjectStreamField("segmentMask", Integer.TYPE), new ObjectStreamField("segmentShift", Integer.TYPE)};
        try {
            Class<Thread> tk = Thread.class;
            SEED = Unsafe.getUnsafe().objectFieldOffset(tk.getDeclaredField("threadLocalRandomSeed"));
            PROBE = Unsafe.getUnsafe().objectFieldOffset(tk.getDeclaredField("threadLocalRandomProbe"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
        try {
            Class<ConcurrentIntHashMap> k = ConcurrentIntHashMap.class;
            SIZECTL = Unsafe.getUnsafe().objectFieldOffset(k.getDeclaredField("sizeCtl"));
            TRANSFERINDEX = Unsafe.getUnsafe().objectFieldOffset(k.getDeclaredField("transferIndex"));
            BASECOUNT = Unsafe.getUnsafe().objectFieldOffset(k.getDeclaredField("baseCount"));
            CELLSBUSY = Unsafe.getUnsafe().objectFieldOffset(k.getDeclaredField("cellsBusy"));
            Class<CounterCell> ck = CounterCell.class;
            CELLVALUE = Unsafe.getUnsafe().objectFieldOffset(ck.getDeclaredField("value"));
            Class<Node[]> ak = Node[].class;
            ABASE = Unsafe.getUnsafe().arrayBaseOffset(ak);
            int scale = Unsafe.getUnsafe().arrayIndexScale(ak);
            if ((scale & scale - 1) != 0) {
                throw new Error("data type scale not a power of two");
            }
            ASHIFT = 31 - Integer.numberOfLeadingZeros(scale);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public static class KeySetView<V>
    implements Serializable {
        private static final long serialVersionUID = 7249069246763182397L;
        private final ConcurrentIntHashMap<V> map;
        private final ThreadLocal<KeyIterator<V>> tlKeyIterator = ThreadLocal.withInitial(KeyIterator::new);
        private final V value;

        KeySetView(ConcurrentIntHashMap<V> map, V value) {
            this.map = map;
            this.value = value;
        }

        public boolean add(int k) {
            V v = this.value;
            if (v == null) {
                throw new UnsupportedOperationException();
            }
            return this.map.putVal(k, v, true) == null;
        }

        public final void clear() {
            this.map.clear();
        }

        public boolean contains(int k) {
            return this.map.containsKey(k);
        }

        public boolean equals(Object o) {
            KeySetView c;
            return o instanceof KeySetView && ((c = (KeySetView)o) == this || this.containsAll(c) && c.containsAll(this));
        }

        public V getMappedValue() {
            return this.value;
        }

        public int hashCode() {
            int h = 0;
            KeyIterator<V> it = this.iterator();
            if (it.hasNext()) {
                do {
                    int k = it.next();
                    h += ConcurrentIntHashMap.keyHashCode(k);
                } while (it.hasNext());
            }
            return h;
        }

        public final boolean isEmpty() {
            return this.map.isEmpty();
        }

        @NotNull
        public KeyIterator<V> iterator() {
            KeyIterator<V> it = this.tlKeyIterator.get();
            it.of(this.map);
            return it;
        }

        public boolean remove(int k) {
            return this.map.remove(k) != null;
        }

        public final int size() {
            return this.map.size();
        }

        public final String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            KeyIterator<V> it = this.iterator();
            if (it.hasNext()) {
                while (true) {
                    int k = it.next();
                    sb.append(k);
                    if (!it.hasNext()) break;
                    sb.append(',').append(' ');
                }
            }
            return sb.append(']').toString();
        }

        private boolean containsAll(@NotNull KeySetView<?> c) {
            KeyIterator<V> it = this.iterator();
            if (it.hasNext()) {
                do {
                    int k;
                    if (this.contains(k = it.next())) continue;
                    return false;
                } while (it.hasNext());
            }
            return true;
        }
    }

    static class Node<V>
    implements IntEntry<V> {
        final int hash;
        final int key;
        volatile Node<V> next;
        volatile V val;

        Node(int hash, int key, V val, Node<V> next) {
            this.hash = hash;
            this.key = key;
            this.val = val;
            this.next = next;
        }

        @Override
        public final boolean equals(Object o) {
            V u;
            Object v;
            IntEntry e;
            int k;
            return o instanceof IntEntry && (k = (e = (IntEntry)o).getKey()) != Integer.MIN_VALUE && (v = e.getValue()) != null && k == this.key && (v == (u = this.val) || v.equals(u));
        }

        @Override
        public final int getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.val;
        }

        @Override
        public final int hashCode() {
            return ConcurrentIntHashMap.keyHashCode(this.key) ^ this.val.hashCode();
        }

        @Override
        public final V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        public final String toString() {
            return this.key + "=" + String.valueOf(this.val);
        }

        Node<V> find(int h, int k) {
            Node<V> e = this;
            if (k != Integer.MIN_VALUE) {
                do {
                    if (e.hash != h || e.key != k) continue;
                    return e;
                } while ((e = e.next) != null);
            }
            return null;
        }
    }

    static final class TreeBin<V>
    extends Node<V> {
        static final int READER = 4;
        static final int WAITER = 2;
        static final int WRITER = 1;
        private static final long LOCKSTATE;
        private static final sun.misc.Unsafe U;
        volatile TreeNode<V> first;
        volatile int lockState;
        TreeNode<V> root;
        volatile Thread waiter;

        TreeBin(TreeNode<V> b) {
            super(-2, Integer.MIN_VALUE, null, null);
            this.first = b;
            TreeNode r = null;
            TreeNode x = b;
            while (x != null) {
                TreeNode next = (TreeNode)x.next;
                x.right = null;
                x.left = null;
                if (r == null) {
                    x.parent = null;
                    x.red = false;
                    r = x;
                } else {
                    TreeNode xp;
                    int dir;
                    int k = x.key;
                    int h = x.hash;
                    TreeNode p = r;
                    do {
                        int pk = p.key;
                        int ph = p.hash;
                        if (ph > h) {
                            dir = -1;
                        } else if (ph < h) {
                            dir = 1;
                        } else {
                            dir = ConcurrentIntHashMap.compareComparables(k, pk);
                            if (dir == 0) {
                                dir = TreeBin.tieBreakOrder(k, pk);
                            }
                        }
                        xp = p;
                    } while ((p = dir <= 0 ? p.left : p.right) != null);
                    x.parent = xp;
                    if (dir <= 0) {
                        xp.left = x;
                    } else {
                        xp.right = x;
                    }
                    r = TreeBin.balanceInsertion(r, x);
                }
                x = next;
            }
            this.root = r;
            assert (TreeBin.checkInvariants(this.root));
        }

        private void contendedLock() {
            boolean waiting = false;
            while (true) {
                int s;
                if (((s = this.lockState) & 0xFFFFFFFD) == 0) {
                    if (!U.compareAndSwapInt(this, LOCKSTATE, s, 1)) continue;
                    if (waiting) {
                        this.waiter = null;
                    }
                    return;
                }
                if ((s & 2) == 0) {
                    if (!U.compareAndSwapInt(this, LOCKSTATE, s, s | 2)) continue;
                    waiting = true;
                    this.waiter = Thread.currentThread();
                    continue;
                }
                if (!waiting) continue;
                LockSupport.park(this);
            }
        }

        private void lockRoot() {
            if (!U.compareAndSwapInt(this, LOCKSTATE, 0, 1)) {
                this.contendedLock();
            }
        }

        private void unlockRoot() {
            this.lockState = 0;
        }

        static <V> TreeNode<V> balanceDeletion(TreeNode<V> root, TreeNode<V> x) {
            while (x != null && x != root) {
                TreeNode sr;
                TreeNode sl;
                TreeNode xp = x.parent;
                if (xp == null) {
                    x.red = false;
                    return x;
                }
                if (x.red) {
                    x.red = false;
                    return root;
                }
                TreeNode xpl = xp.left;
                if (xpl == x) {
                    TreeNode xpr = xp.right;
                    if (xpr != null && xpr.red) {
                        xpr.red = false;
                        xp.red = true;
                        root = TreeBin.rotateLeft(root, xp);
                        xp = x.parent;
                        TreeNode treeNode = xpr = xp == null ? null : xp.right;
                    }
                    if (xpr == null) {
                        x = xp;
                        continue;
                    }
                    sl = xpr.left;
                    sr = xpr.right;
                    if (!(sr != null && sr.red || sl != null && sl.red)) {
                        xpr.red = true;
                        x = xp;
                        continue;
                    }
                    if (sr == null || !sr.red) {
                        sl.red = false;
                        xpr.red = true;
                        root = TreeBin.rotateRight(root, xpr);
                        xp = x.parent;
                        TreeNode treeNode = xpr = xp == null ? null : xp.right;
                    }
                    if (xpr != null) {
                        xpr.red = xp.red;
                        sr = xpr.right;
                        if (sr != null) {
                            sr.red = false;
                        }
                    }
                    if (xp != null) {
                        xp.red = false;
                        root = TreeBin.rotateLeft(root, xp);
                    }
                    x = root;
                    continue;
                }
                if (xpl != null && xpl.red) {
                    xpl.red = false;
                    xp.red = true;
                    root = TreeBin.rotateRight(root, xp);
                    xp = x.parent;
                    TreeNode treeNode = xpl = xp == null ? null : xp.left;
                }
                if (xpl == null) {
                    x = xp;
                    continue;
                }
                sl = xpl.left;
                sr = xpl.right;
                if (!(sl != null && sl.red || sr != null && sr.red)) {
                    xpl.red = true;
                    x = xp;
                    continue;
                }
                if (sl == null || !sl.red) {
                    sr.red = false;
                    xpl.red = true;
                    root = TreeBin.rotateLeft(root, xpl);
                    xp = x.parent;
                    TreeNode treeNode = xpl = xp == null ? null : xp.left;
                }
                if (xpl != null) {
                    xpl.red = xp.red;
                    sl = xpl.left;
                    if (sl != null) {
                        sl.red = false;
                    }
                }
                if (xp != null) {
                    xp.red = false;
                    root = TreeBin.rotateRight(root, xp);
                }
                x = root;
            }
            return root;
        }

        static <V> TreeNode<V> balanceInsertion(TreeNode<V> root, TreeNode<V> x) {
            x.red = true;
            while (true) {
                TreeNode xpp;
                TreeNode xp;
                if ((xp = x.parent) == null) {
                    x.red = false;
                    return x;
                }
                if (!xp.red || (xpp = xp.parent) == null) {
                    return root;
                }
                TreeNode xppl = xpp.left;
                if (xp == xppl) {
                    TreeNode xppr = xpp.right;
                    if (xppr != null && xppr.red) {
                        xppr.red = false;
                        xp.red = false;
                        xpp.red = true;
                        x = xpp;
                        continue;
                    }
                    if (x == xp.right) {
                        x = xp;
                        root = TreeBin.rotateLeft(root, x);
                        xp = x.parent;
                        TreeNode treeNode = xpp = xp == null ? null : xp.parent;
                    }
                    if (xp == null) continue;
                    xp.red = false;
                    if (xpp == null) continue;
                    xpp.red = true;
                    root = TreeBin.rotateRight(root, xpp);
                    continue;
                }
                if (xppl != null && xppl.red) {
                    xppl.red = false;
                    xp.red = false;
                    xpp.red = true;
                    x = xpp;
                    continue;
                }
                if (x == xp.left) {
                    x = xp;
                    root = TreeBin.rotateRight(root, x);
                    xp = x.parent;
                    TreeNode treeNode = xpp = xp == null ? null : xp.parent;
                }
                if (xp == null) continue;
                xp.red = false;
                if (xpp == null) continue;
                xpp.red = true;
                root = TreeBin.rotateLeft(root, xpp);
            }
        }

        static <V> boolean checkInvariants(TreeNode<V> t) {
            TreeNode tp = t.parent;
            TreeNode tl = t.left;
            TreeNode tr = t.right;
            TreeNode tb = t.prev;
            TreeNode tn = (TreeNode)t.next;
            if (tb != null && tb.next != t) {
                return false;
            }
            if (tn != null && tn.prev != t) {
                return false;
            }
            if (tp != null && t != tp.left && t != tp.right) {
                return false;
            }
            if (tl != null && (tl.parent != t || tl.hash > t.hash)) {
                return false;
            }
            if (tr != null && (tr.parent != t || tr.hash < t.hash)) {
                return false;
            }
            if (t.red && tl != null && tl.red && tr != null && tr.red) {
                return false;
            }
            if (tl != null && !TreeBin.checkInvariants(tl)) {
                return false;
            }
            return tr == null || TreeBin.checkInvariants(tr);
        }

        static <V> TreeNode<V> rotateLeft(TreeNode<V> root, TreeNode<V> p) {
            TreeNode r;
            if (p != null && (r = p.right) != null) {
                p.right = r.left;
                TreeNode rl = p.right;
                if (p.right != null) {
                    rl.parent = p;
                }
                TreeNode pp = r.parent = p.parent;
                if (r.parent == null) {
                    root = r;
                    r.red = false;
                } else if (pp.left == p) {
                    pp.left = r;
                } else {
                    pp.right = r;
                }
                r.left = p;
                p.parent = r;
            }
            return root;
        }

        static <V> TreeNode<V> rotateRight(TreeNode<V> root, TreeNode<V> p) {
            TreeNode l;
            if (p != null && (l = p.left) != null) {
                p.left = l.right;
                TreeNode lr = p.left;
                if (p.left != null) {
                    lr.parent = p;
                }
                TreeNode pp = l.parent = p.parent;
                if (l.parent == null) {
                    root = l;
                    l.red = false;
                } else if (pp.right == p) {
                    pp.right = l;
                } else {
                    pp.left = l;
                }
                l.right = p;
                p.parent = l;
            }
            return root;
        }

        static int tieBreakOrder(Object a, Object b) {
            int d;
            if (a == null || b == null || (d = a.getClass().getName().compareTo(b.getClass().getName())) == 0) {
                d = System.identityHashCode(a) <= System.identityHashCode(b) ? -1 : 1;
            }
            return d;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Node<V> find(int h, int k) {
            if (k != Integer.MIN_VALUE) {
                Node e = this.first;
                while (e != null) {
                    TreeNode<V> p;
                    int s = this.lockState;
                    if ((s & 3) != 0) {
                        if (e.hash == h && e.key == k) {
                            return e;
                        }
                        e = e.next;
                        continue;
                    }
                    if (!U.compareAndSwapInt(this, LOCKSTATE, s, s + 4)) continue;
                    try {
                        TreeNode<V> r = this.root;
                        p = r == null ? null : r.findTreeNode(h, k);
                    }
                    finally {
                        Thread w;
                        if (U.getAndAddInt(this, LOCKSTATE, -4) == 6 && (w = this.waiter) != null) {
                            LockSupport.unpark(w);
                        }
                    }
                    return p;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TreeNode<V> putTreeVal(int h, int k, V v) {
            block19: {
                TreeNode<V> xp;
                int dir;
                boolean searched = false;
                TreeNode<V> p = this.root;
                do {
                    if (p == null) {
                        this.root = new TreeNode<V>(h, k, v, null, null);
                        this.first = this.root;
                        break block19;
                    }
                    int ph = p.hash;
                    if (ph > h) {
                        dir = -1;
                    } else if (ph < h) {
                        dir = 1;
                    } else {
                        int pk = p.key;
                        if (pk == k) {
                            return p;
                        }
                        dir = ConcurrentIntHashMap.compareComparables(k, pk);
                        if (dir == 0) {
                            if (!searched) {
                                TreeNode q;
                                searched = true;
                                TreeNode ch = p.left;
                                if (ch != null && (q = ch.findTreeNode(h, k)) != null || (ch = p.right) != null && (q = ch.findTreeNode(h, k)) != null) {
                                    return q;
                                }
                            }
                            dir = TreeBin.tieBreakOrder(k, pk);
                        }
                    }
                    xp = p;
                } while ((p = dir <= 0 ? p.left : p.right) != null);
                TreeNode<V> f = this.first;
                TreeNode<V> x = new TreeNode<V>(h, k, v, f, xp);
                this.first = x;
                if (f != null) {
                    f.prev = x;
                }
                if (dir <= 0) {
                    xp.left = x;
                } else {
                    xp.right = x;
                }
                if (!xp.red) {
                    x.red = true;
                } else {
                    this.lockRoot();
                    try {
                        this.root = TreeBin.balanceInsertion(this.root, x);
                    }
                    finally {
                        this.unlockRoot();
                    }
                }
            }
            assert (TreeBin.checkInvariants(this.root));
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean removeTreeNode(TreeNode<V> p) {
            TreeNode rl;
            TreeNode next = (TreeNode)p.next;
            TreeNode pred = p.prev;
            if (pred == null) {
                this.first = next;
            } else {
                pred.next = next;
            }
            if (next != null) {
                next.prev = pred;
            }
            if (this.first == null) {
                this.root = null;
                return true;
            }
            TreeNode<V> r = this.root;
            if (r == null || r.right == null || (rl = r.left) == null || rl.left == null) {
                return true;
            }
            this.lockRoot();
            try {
                TreeNode pp;
                TreeNode replacement;
                TreeNode pl = p.left;
                TreeNode pr = p.right;
                if (pl != null && pr != null) {
                    TreeNode sl;
                    TreeNode s = pr;
                    while ((sl = s.left) != null) {
                        s = sl;
                    }
                    boolean c = s.red;
                    s.red = p.red;
                    p.red = c;
                    TreeNode sr = s.right;
                    TreeNode pp2 = p.parent;
                    if (s == pr) {
                        p.parent = s;
                        s.right = p;
                    } else {
                        TreeNode sp = s.parent;
                        p.parent = sp;
                        if (p.parent != null) {
                            if (s == sp.left) {
                                sp.left = p;
                            } else {
                                sp.right = p;
                            }
                        }
                        s.right = pr;
                        pr.parent = s;
                    }
                    p.left = null;
                    p.right = sr;
                    if (p.right != null) {
                        sr.parent = p;
                    }
                    s.left = pl;
                    pl.parent = s;
                    s.parent = pp2;
                    if (s.parent == null) {
                        r = s;
                    } else if (p == pp2.left) {
                        pp2.left = s;
                    } else {
                        pp2.right = s;
                    }
                    replacement = sr != null ? sr : p;
                } else {
                    replacement = pl != null ? pl : (pr != null ? pr : p);
                }
                if (replacement != p) {
                    replacement.parent = p.parent;
                    pp = replacement.parent;
                    if (pp == null) {
                        r = replacement;
                    } else if (p == pp.left) {
                        pp.left = replacement;
                    } else {
                        pp.right = replacement;
                    }
                    p.parent = null;
                    p.right = null;
                    p.left = null;
                }
                TreeNode<V> treeNode = this.root = p.red ? r : TreeBin.balanceDeletion(r, replacement);
                if (p == replacement && (pp = p.parent) != null) {
                    if (p == pp.left) {
                        pp.left = null;
                    } else if (p == pp.right) {
                        pp.right = null;
                    }
                    p.parent = null;
                }
            }
            finally {
                this.unlockRoot();
            }
            assert (TreeBin.checkInvariants(this.root));
            return false;
        }

        static {
            try {
                U = Unsafe.getUnsafe();
                Class<TreeBin> k = TreeBin.class;
                LOCKSTATE = U.objectFieldOffset(k.getDeclaredField("lockState"));
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
    }

    static final class TreeNode<V>
    extends Node<V> {
        TreeNode<V> left;
        TreeNode<V> parent;
        TreeNode<V> prev;
        boolean red;
        TreeNode<V> right;

        TreeNode(int hash, int key, V val, Node<V> next, TreeNode<V> parent) {
            super(hash, key, val, next);
            this.parent = parent;
        }

        @Override
        Node<V> find(int h, int k) {
            return this.findTreeNode(h, k);
        }

        TreeNode<V> findTreeNode(int h, int k) {
            if (k != Integer.MIN_VALUE) {
                TreeNode<V> p = this;
                do {
                    TreeNode<V> pl = p.left;
                    TreeNode<V> pr = p.right;
                    int ph = p.hash;
                    if (ph > h) {
                        p = pl;
                        continue;
                    }
                    if (ph < h) {
                        p = pr;
                        continue;
                    }
                    int pk = p.key;
                    if (pk == k) {
                        return p;
                    }
                    if (pl == null) {
                        p = pr;
                        continue;
                    }
                    if (pr == null) {
                        p = pl;
                        continue;
                    }
                    int dir = ConcurrentIntHashMap.compareComparables(k, pk);
                    if (dir != 0) {
                        p = dir < 0 ? pl : pr;
                        continue;
                    }
                    TreeNode<V> q = pr.findTreeNode(h, k);
                    if (q != null) {
                        return q;
                    }
                    p = pl;
                } while (p != null);
            }
            return null;
        }
    }

    static final class ReservationNode<V>
    extends Node<V> {
        ReservationNode() {
            super(-3, Integer.MIN_VALUE, null, null);
        }

        @Override
        Node<V> find(int h, int k) {
            return null;
        }
    }

    static class Traverser<V> {
        int baseIndex;
        int baseLimit;
        int baseSize;
        int index;
        Node<V> next;
        TableStack<V> stack;
        TableStack<V> spare;
        Node<V>[] tab;

        Traverser() {
        }

        private void pushState(Node<V>[] t, int i, int n) {
            TableStack<V> s = this.spare;
            if (s != null) {
                this.spare = s.next;
            } else {
                s = new TableStack();
            }
            s.tab = t;
            s.length = n;
            s.index = i;
            s.next = this.stack;
            this.stack = s;
        }

        private void recoverState(int n) {
            int len;
            TableStack<V> s;
            while ((s = this.stack) != null && (this.index += (len = s.length)) >= n) {
                n = len;
                this.index = s.index;
                this.tab = s.tab;
                s.tab = null;
                TableStack next = s.next;
                s.next = this.spare;
                this.stack = next;
                this.spare = s;
            }
            if (s == null && (this.index += this.baseSize) >= n) {
                this.index = ++this.baseIndex;
            }
        }

        final Node<V> advance() {
            Node<V> e = this.next;
            if (e != null) {
                e = e.next;
            }
            while (true) {
                int i;
                int n;
                Node<V>[] t;
                block10: {
                    block9: {
                        if (e != null) {
                            this.next = e;
                            return this.next;
                        }
                        if (this.baseIndex >= this.baseLimit) break block9;
                        t = this.tab;
                        if (this.tab != null && (n = t.length) > (i = this.index) && i >= 0) break block10;
                    }
                    this.next = null;
                    return null;
                }
                e = ConcurrentIntHashMap.tabAt(t, i);
                if (e != null && e.hash < 0) {
                    if (e instanceof ForwardingNode) {
                        this.tab = ((ForwardingNode)e).nextTable;
                        e = null;
                        this.pushState(t, i, n);
                        continue;
                    }
                    e = e instanceof TreeBin ? ((TreeBin)e).first : null;
                }
                if (this.stack != null) {
                    this.recoverState(n);
                    continue;
                }
                this.index = i + this.baseSize;
                if (this.index < n) continue;
                this.index = ++this.baseIndex;
            }
        }

        void of(Node<V>[] tab, int size, int limit) {
            this.tab = tab;
            this.baseSize = size;
            this.index = 0;
            this.baseIndex = 0;
            this.baseLimit = limit;
            this.next = null;
        }
    }

    static final class EntrySetView<V>
    extends CollectionView<V, IntEntry<V>>
    implements Set<IntEntry<V>>,
    Serializable {
        private static final long serialVersionUID = 2249069246763182397L;
        private final ThreadLocal<EntryIterator<V>> tlEntryIterator = ThreadLocal.withInitial(EntryIterator::new);

        EntrySetView(ConcurrentIntHashMap<V> map) {
            super(map);
        }

        @Override
        public boolean add(IntEntry<V> e) {
            return this.map.putVal(e.getKey(), e.getValue(), false) == null;
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends IntEntry<V>> c) {
            boolean added = false;
            for (IntEntry<V> e : c) {
                if (!this.add(e)) continue;
                added = true;
            }
            return added;
        }

        @Override
        public boolean contains(Object o) {
            Object v;
            Object r;
            IntEntry e;
            int k;
            return o instanceof IntEntry && (k = (e = (IntEntry)o).getKey()) != Integer.MIN_VALUE && (r = this.map.get(k)) != null && (v = e.getValue()) != null && (v == r || v.equals(r));
        }

        @Override
        public boolean equals(Object o) {
            Set c;
            return o instanceof Set && ((c = (Set)o) == this || this.containsAll(c) && c.containsAll(this));
        }

        @Override
        public int hashCode() {
            int h = 0;
            Node<V>[] t = this.map.table;
            if (t != null) {
                Node p;
                Traverser it = this.map.getTraverser(t);
                while ((p = it.advance()) != null) {
                    h += p.hashCode();
                }
            }
            return h;
        }

        @Override
        @NotNull
        public Iterator<IntEntry<V>> iterator() {
            EntryIterator<V> it = this.tlEntryIterator.get();
            it.of(this.map);
            return it;
        }

        @Override
        public boolean remove(Object o) {
            Object v;
            IntEntry e;
            int k;
            return o instanceof IntEntry && (k = (e = (IntEntry)o).getKey()) != Integer.MIN_VALUE && (v = e.getValue()) != null && this.map.remove(k, v);
        }
    }

    public static interface IntEntry<V> {
        public boolean equals(Object var1);

        public int getKey();

        public V getValue();

        public int hashCode();

        public V setValue(V var1);
    }

    static final class ValuesView<V>
    extends CollectionView<V, V>
    implements Collection<V>,
    Serializable {
        private static final long serialVersionUID = 2249069246763182397L;
        private final ThreadLocal<ValueIterator<V>> tlValueIterator = ThreadLocal.withInitial(ValueIterator::new);

        ValuesView(ConcurrentIntHashMap<V> map) {
            super(map);
        }

        @Override
        public boolean add(V e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends V> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return this.map.containsValue(o);
        }

        @Override
        @NotNull
        public Iterator<V> iterator() {
            ValueIterator<V> it = this.tlValueIterator.get();
            it.of(this.map);
            return it;
        }

        @Override
        public boolean remove(Object o) {
            if (o != null) {
                Iterator<V> it = this.iterator();
                while (it.hasNext()) {
                    if (!o.equals(it.next())) continue;
                    it.remove();
                    return true;
                }
            }
            return false;
        }
    }

    static final class CounterCell {
        final long value;

        CounterCell(long x) {
            this.value = x;
        }
    }

    static final class ForwardingNode<V>
    extends Node<V> {
        final Node<V>[] nextTable;

        ForwardingNode(Node<V>[] tab) {
            super(-1, Integer.MIN_VALUE, null, null);
            this.nextTable = tab;
        }

        @Override
        Node<V> find(int h, int k) {
            Node<V>[] tab = this.nextTable;
            block0: while (true) {
                Node<V> e;
                int n;
                if (k == Integer.MIN_VALUE || tab == null || (n = tab.length) == 0 || (e = ConcurrentIntHashMap.tabAt(tab, n - 1 & h)) == null) {
                    return null;
                }
                do {
                    int eh;
                    if ((eh = e.hash) == h && e.key == k) {
                        return e;
                    }
                    if (eh >= 0) continue;
                    if (e instanceof ForwardingNode) {
                        tab = ((ForwardingNode)e).nextTable;
                        continue block0;
                    }
                    return e.find(h, k);
                } while ((e = e.next) != null);
                break;
            }
            return null;
        }
    }

    static class Segment
    extends ReentrantLock
    implements Serializable {
        private static final long serialVersionUID = 2249069246763182397L;
        final float loadFactor;

        Segment() {
            this.loadFactor = 0.75f;
        }
    }

    static final class ValueIterator<V>
    extends BaseIterator<V>
    implements Iterator<V> {
        ValueIterator() {
        }

        @Override
        public V next() {
            Node p = this.next;
            if (p == null) {
                throw new NoSuchElementException();
            }
            Object v = p.val;
            this.lastReturned = p;
            this.advance();
            return v;
        }
    }

    static final class TableStack<V> {
        int index;
        int length;
        TableStack<V> next;
        Node<V>[] tab;

        TableStack() {
        }
    }

    static final class MapEntry<V>
    implements IntEntry<V> {
        final int key;
        final ConcurrentIntHashMap<V> map;
        V val;

        MapEntry(int key, V val, ConcurrentIntHashMap<V> map) {
            this.key = key;
            this.val = val;
            this.map = map;
        }

        @Override
        public boolean equals(Object o) {
            Object v;
            IntEntry e;
            int k;
            return o instanceof IntEntry && (k = (e = (IntEntry)o).getKey()) != Integer.MIN_VALUE && (v = e.getValue()) != null && k == this.key && (v == this.val || v.equals(this.val));
        }

        @Override
        public int getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.val;
        }

        @Override
        public int hashCode() {
            return ConcurrentIntHashMap.keyHashCode(this.key) ^ this.val.hashCode();
        }

        @Override
        @NotNull
        public V setValue(V value) {
            if (value == null) {
                throw new NullPointerException();
            }
            V v = this.val;
            this.val = value;
            this.map.put(this.key, value);
            return v;
        }

        public String toString() {
            return this.key + "=" + String.valueOf(this.val);
        }
    }

    public static final class KeyIterator<V>
    extends BaseIterator<V> {
        public int next() {
            Node p = this.next;
            if (p == null) {
                throw new NoSuchElementException();
            }
            int k = p.key;
            this.lastReturned = p;
            this.advance();
            return k;
        }
    }

    static final class EntryIterator<V>
    extends BaseIterator<V>
    implements Iterator<IntEntry<V>> {
        EntryIterator() {
        }

        @Override
        public IntEntry<V> next() {
            Node p = this.next;
            if (p == null) {
                throw new NoSuchElementException();
            }
            int k = p.key;
            Object v = p.val;
            this.lastReturned = p;
            this.advance();
            return new MapEntry(k, v, this.map);
        }
    }

    static abstract class CollectionView<V, E>
    implements Collection<E>,
    Serializable {
        private static final String oomeMsg = "Required array size too large";
        private static final long serialVersionUID = 7249069246763182397L;
        final ConcurrentIntHashMap<V> map;

        CollectionView(ConcurrentIntHashMap<V> map) {
            this.map = map;
        }

        @Override
        public final void clear() {
            this.map.clear();
        }

        @Override
        public abstract boolean contains(Object var1);

        @Override
        public final boolean containsAll(@NotNull Collection<?> c) {
            if (c != this) {
                for (Object e : c) {
                    if (e != null && this.contains(e)) continue;
                    return false;
                }
            }
            return true;
        }

        public ConcurrentIntHashMap<V> getMap() {
            return this.map;
        }

        @Override
        public final boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        @NotNull
        public abstract Iterator<E> iterator();

        @Override
        public abstract boolean remove(Object var1);

        @Override
        public final boolean removeAll(@NotNull Collection<?> c) {
            boolean modified = false;
            Iterator<E> it = this.iterator();
            while (it.hasNext()) {
                if (!c.contains(it.next())) continue;
                it.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public final boolean retainAll(@NotNull Collection<?> c) {
            boolean modified = false;
            Iterator<E> it = this.iterator();
            while (it.hasNext()) {
                if (c.contains(it.next())) continue;
                it.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public final int size() {
            return this.map.size();
        }

        @Override
        public final Object @NotNull [] toArray() {
            long sz = this.map.mappingCount();
            if (sz > 0x7FFFFFF7L) {
                throw new OutOfMemoryError(oomeMsg);
            }
            int n = (int)sz;
            Object[] r = new Object[n];
            int i = 0;
            for (E e : this) {
                if (i == n) {
                    if (n >= 0x7FFFFFF7) {
                        throw new OutOfMemoryError(oomeMsg);
                    }
                    n = n >= 0x3FFFFFFB ? 0x7FFFFFF7 : (n += (n >>> 1) + 1);
                    r = Arrays.copyOf(r, n);
                }
                r[i++] = e;
            }
            return i == n ? r : Arrays.copyOf(r, i);
        }

        @Override
        public final <T> T @NotNull [] toArray(@NotNull @NotNull T @NotNull [] a) {
            long sz = this.map.mappingCount();
            if (sz > 0x7FFFFFF7L) {
                throw new OutOfMemoryError(oomeMsg);
            }
            int m = (int)sz;
            T[] r = a.length >= m ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), m);
            int n = r.length;
            int i = 0;
            for (E e : this) {
                if (i == n) {
                    if (n >= 0x7FFFFFF7) {
                        throw new OutOfMemoryError(oomeMsg);
                    }
                    n = n >= 0x3FFFFFFB ? 0x7FFFFFF7 : (n += (n >>> 1) + 1);
                    r = Arrays.copyOf(r, n);
                }
                r[i++] = e;
            }
            if (a == r && i < n) {
                r[i] = null;
                return r;
            }
            return i == n ? r : Arrays.copyOf(r, i);
        }

        public final String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            Iterator<E> it = this.iterator();
            if (it.hasNext()) {
                while (true) {
                    E e;
                    sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
                    if (!it.hasNext()) break;
                    sb.append(',').append(' ');
                }
            }
            return sb.append(']').toString();
        }
    }

    static class BaseIterator<V>
    extends Traverser<V> {
        Node<V> lastReturned;
        ConcurrentIntHashMap<V> map;

        BaseIterator() {
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        public final void remove() {
            Node<V> p = this.lastReturned;
            if (p == null) {
                throw new IllegalStateException();
            }
            this.lastReturned = null;
            this.map.replaceNode(p.key, null, null);
        }

        void of(ConcurrentIntHashMap<V> map) {
            Node<V>[] tab = map.table;
            int l = tab == null ? 0 : tab.length;
            super.of(tab, l, l);
            this.map = map;
            this.advance();
        }
    }
}

