/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDescendingRecordListCursor;
import io.questdb.std.DirectLongList;
import io.questdb.std.Rows;
import org.jetbrains.annotations.NotNull;

class LatestByAllRecordCursor
extends AbstractDescendingRecordListCursor {
    private final Map map;
    private final RecordSink recordSink;

    public LatestByAllRecordCursor(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata, @NotNull Map map, @NotNull DirectLongList rows, @NotNull RecordSink recordSink) {
        super(configuration, metadata, rows);
        this.map = map;
        this.recordSink = recordSink;
    }

    @Override
    public void close() {
        if (this.isOpen()) {
            this.map.close();
            super.close();
        }
    }

    @Override
    public void of(PageFrameCursor pageFrameCursor, SqlExecutionContext executionContext) throws SqlException {
        if (!this.isOpen) {
            this.isOpen = true;
            this.map.reopen();
        }
        super.of(pageFrameCursor, executionContext);
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Row backward scan");
    }

    @Override
    protected void buildTreeMap() {
        PageFrame frame;
        while ((frame = this.frameCursor.next()) != null) {
            this.circuitBreaker.statefulThrowExceptionIfTripped();
            int frameIndex = this.frameCount;
            long partitionLo = frame.getPartitionLo();
            long partitionHi = frame.getPartitionHi() - 1L;
            this.frameAddressCache.add(this.frameCount, frame);
            this.frameMemoryPool.navigateTo(this.frameCount++, this.recordA);
            this.recordA.setRowIndex(partitionHi);
            for (long row = partitionHi - partitionLo; row >= 0L; --row) {
                this.recordA.setRowIndex(row);
                MapKey key = this.map.withKey();
                key.put(this.recordA, this.recordSink);
                if (!key.create()) continue;
                this.rows.add(Rows.toRowID(frameIndex, row));
            }
        }
        this.map.clear();
    }
}

