/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.orderby;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.sql.DelegatingRecordCursor;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.RecordComparator;
import io.questdb.griffin.engine.orderby.DynamicLimitCursor;
import io.questdb.griffin.engine.orderby.LimitedSizeLongTreeChain;
import io.questdb.griffin.engine.orderby.LimitedSizePartiallySortedLightRecordCursor;
import io.questdb.griffin.engine.orderby.LimitedSizeSortedLightRecordCursor;
import io.questdb.griffin.engine.orderby.LongTreeChain;
import io.questdb.griffin.engine.orderby.SortedLightRecordCursor;
import io.questdb.griffin.engine.orderby.SortedLightRecordCursorFactory;
import io.questdb.griffin.engine.orderby.SortedRecordCursorFactory;
import io.questdb.std.Misc;
import org.jetbrains.annotations.Nullable;

public class LimitedSizeSortedLightRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final RecordCursorFactory base;
    private final RecordComparator comparator;
    private final CairoConfiguration configuration;
    private final Function hiFunction;
    private final Function loFunction;
    private final ListColumnFilter sortColumnFilter;
    private final int timestampIndex;
    private LimitedSizeLongTreeChain chain;
    private DelegatingRecordCursor cursor;
    private boolean isFirstN;
    private long limit;
    private long skipFirst;
    private long skipLast;

    public LimitedSizeSortedLightRecordCursorFactory(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory base, RecordComparator comparator, Function loFunc, @Nullable Function hiFunc, ListColumnFilter sortColumnFilter, int timestampIndex) {
        super(metadata);
        this.base = base;
        this.loFunction = loFunc;
        this.hiFunction = hiFunc;
        this.configuration = configuration;
        this.comparator = comparator;
        this.sortColumnFilter = sortColumnFilter;
        this.timestampIndex = timestampIndex;
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        executionContext.setColumnPreTouchEnabled(false);
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        try {
            this.initialize(executionContext, baseCursor);
        }
        catch (Throwable th) {
            Misc.free(baseCursor);
            throw th;
        }
        try {
            this.cursor.of(baseCursor, executionContext);
            return this.cursor;
        }
        catch (Throwable th) {
            Misc.free(this.cursor);
            throw th;
        }
    }

    @Override
    public int getScanDirection() {
        return SortedRecordCursorFactory.getScanDirection(this.sortColumnFilter);
    }

    @Override
    public boolean implementsLimit() {
        return true;
    }

    public void initializeLimitedSizeCursor(SqlExecutionContext executionContext, RecordCursor baseCursor) throws SqlException {
        this.computeLimits(baseCursor, executionContext);
        this.chain = new LimitedSizeLongTreeChain(this.configuration.getSqlSortKeyPageSize(), this.configuration.getSqlSortKeyMaxPages(), this.configuration.getSqlSortLightValuePageSize(), this.configuration.getSqlSortLightValueMaxPages());
        this.cursor = this.timestampIndex == -1 || !this.isFirstN ? new LimitedSizeSortedLightRecordCursor(this.chain, this.comparator) : new LimitedSizePartiallySortedLightRecordCursor(this.chain, this.comparator, this.timestampIndex);
        this.chain.updateLimits(this.isFirstN, this.limit);
        ((DynamicLimitCursor)((Object)this.cursor)).updateLimits(this.limit, this.skipFirst, this.skipLast);
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Sort light");
        sink.meta("lo").val(this.loFunction);
        if (this.hiFunction != null) {
            sink.meta("hi").val(this.hiFunction);
        }
        if (this.timestampIndex != -1) {
            sink.meta("partiallySorted").val(true);
        }
        SortedLightRecordCursorFactory.addSortKeys(sink, this.sortColumnFilter);
        sink.child(this.base);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    @Override
    public boolean usesIndex() {
        return this.base.usesIndex();
    }

    private boolean canBeOptimized(RecordCursor baseCursor, SqlExecutionContext executionContext) throws SqlException {
        this.loFunction.init(baseCursor, executionContext);
        if (this.hiFunction != null) {
            this.hiFunction.init(baseCursor, executionContext);
        }
        return this.loFunction.getLong(null) < 0L || this.hiFunction == null || this.hiFunction.getLong(null) >= 0L;
    }

    private void computeLimits(RecordCursor baseCursor, SqlExecutionContext executionContext) throws SqlException {
        this.loFunction.init(baseCursor, executionContext);
        if (this.hiFunction != null) {
            this.hiFunction.init(baseCursor, executionContext);
        }
        this.skipFirst = 0L;
        this.skipLast = 0L;
        this.limit = 0L;
        this.isFirstN = false;
        long lo = this.loFunction.getLong(null);
        if (lo < 0L && this.hiFunction == null) {
            this.limit = -lo;
        } else if (lo > -1L && this.hiFunction == null) {
            this.isFirstN = true;
            this.limit = lo;
        } else {
            long hi = this.hiFunction.getLong(null);
            if (lo < 0L) {
                if (lo == hi) {
                    this.limit = 0L;
                } else {
                    this.limit = -Math.min(hi, lo);
                    this.skipLast = Math.max(-Math.max(hi, lo), 0L);
                }
            } else if (hi < 0L) {
                this.limit = -1L;
                this.skipFirst = lo;
                this.skipLast = -hi;
            } else {
                this.isFirstN = true;
                this.limit = Math.max(hi, lo);
                this.skipFirst = Math.min(hi, lo);
            }
        }
    }

    private void initialize(SqlExecutionContext executionContext, RecordCursor baseCursor) throws SqlException {
        if (this.isInitialized()) {
            if (this.chain != null && this.cursor instanceof DynamicLimitCursor) {
                this.computeLimits(baseCursor, executionContext);
                this.chain.updateLimits(this.isFirstN, this.limit);
                ((DynamicLimitCursor)((Object)this.cursor)).updateLimits(this.limit, this.skipFirst, this.skipLast);
            }
            return;
        }
        if (this.canBeOptimized(baseCursor, executionContext)) {
            this.initializeLimitedSizeCursor(executionContext, baseCursor);
        } else {
            this.initializeUnlimitedSizeCursor();
        }
    }

    private void initializeUnlimitedSizeCursor() {
        LongTreeChain chain = new LongTreeChain(this.configuration.getSqlSortKeyPageSize(), this.configuration.getSqlSortKeyMaxPages(), this.configuration.getSqlSortLightValuePageSize(), this.configuration.getSqlSortLightValueMaxPages());
        this.cursor = new SortedLightRecordCursor(chain, this.comparator);
    }

    private boolean isInitialized() {
        return this.cursor != null;
    }

    @Override
    protected void _close() {
        Misc.free(this.base);
        Misc.free(this.cursor);
    }
}

