/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.window;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.cairo.sql.WindowSPI;
import io.questdb.cairo.vm.api.MemoryARW;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.window.AbstractWindowFunctionFactory;
import io.questdb.griffin.engine.functions.window.LeadLagWindowFunctionFactoryHelper;
import io.questdb.griffin.engine.functions.window.WindowDoubleFunction;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;

public class LagDoubleFunctionFactory
extends AbstractWindowFunctionFactory {
    private static final String SIGNATURE = "lag(DV)";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        return LeadLagWindowFunctionFactoryHelper.newInstance(position, args, argPositions, configuration, sqlExecutionContext, defaultValue -> {
            if (!ColumnType.isAssignableFrom(defaultValue.getType(), 10)) {
                throw SqlException.$(argPositions.getQuick(2), "default value must be can cast to double");
            }
        }, LagFunction::new, LeadLagValueCurrentRow::new, LagOverPartitionFunction::new);
    }

    static class LeadLagValueCurrentRow
    extends LeadLagWindowFunctionFactoryHelper.BaseLeadLagCurrentRow
    implements WindowDoubleFunction {
        private double value;

        public LeadLagValueCurrentRow(VirtualRecord partitionByRecord, Function arg, String name, boolean ignoreNulls) {
            super(partitionByRecord, arg, name, ignoreNulls);
        }

        @Override
        public void computeNext(Record record) {
            this.value = this.arg.getDouble(record);
        }

        @Override
        public double getDouble(Record rec) {
            return this.value;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.value);
        }
    }

    static class LagOverPartitionFunction
    extends LeadLagWindowFunctionFactoryHelper.BaseLagOverPartitionFunction
    implements WindowDoubleFunction {
        private double lagValue;

        public LagOverPartitionFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, MemoryARW memory, Function arg, boolean ignoreNulls, Function defaultValue, long offset) {
            super(map, partitionByRecord, partitionBySink, memory, arg, ignoreNulls, defaultValue, offset);
        }

        @Override
        public double getDouble(Record rec) {
            return this.lagValue;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.lagValue);
        }

        @Override
        protected boolean computeNext0(long count, long offset, long startOffset, long firstIdx, Record record) {
            boolean respectNulls;
            double d = this.arg.getDouble(record);
            this.lagValue = count < offset ? (this.defaultValue == null ? Double.NaN : this.defaultValue.getDouble(record)) : this.memory.getDouble(startOffset + firstIdx * 8L);
            boolean bl = respectNulls = !this.ignoreNulls || Numbers.isFinite(d);
            if (respectNulls) {
                this.memory.putDouble(startOffset + firstIdx * 8L, d);
            }
            return respectNulls;
        }
    }

    public static class LagFunction
    extends LeadLagWindowFunctionFactoryHelper.BaseLagFunction
    implements WindowDoubleFunction {
        private double lagValue;

        public LagFunction(Function arg, Function defaultValueFunc, long offset, MemoryARW memory, boolean ignoreNulls) {
            super(arg, defaultValueFunc, offset, memory, ignoreNulls);
        }

        @Override
        public boolean computeNext0(Record record) {
            boolean respectNulls;
            this.lagValue = this.count < this.offset ? (this.defaultValue == null ? Double.NaN : this.defaultValue.getDouble(record)) : this.buffer.getDouble((long)this.loIdx * 8L);
            double d = this.arg.getDouble(record);
            boolean bl = respectNulls = !this.ignoreNulls || Numbers.isFinite(d);
            if (respectNulls) {
                this.buffer.putDouble((long)this.loIdx * 8L, d);
            }
            return respectNulls;
        }

        @Override
        public double getDouble(Record rec) {
            return this.lagValue;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.lagValue);
        }
    }
}

