/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.test;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.Unsafe;
import org.jetbrains.annotations.NotNull;

public class TestSumStringGroupByFunction
extends StrFunction
implements GroupByFunction,
UnaryFunction {
    private final Function arg;
    private long mem = Unsafe.malloc(1024L, 31);
    private int valueIndex;

    public TestSumStringGroupByFunction(@NotNull Function arg) {
        this.arg = arg;
    }

    @Override
    public void close() {
        this.mem = Unsafe.free(this.mem, 1024L, 31);
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record, long rowId) {
        mapValue.putDouble(this.valueIndex, this.arg.getDouble(record));
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
        mapValue.putDouble(this.valueIndex, mapValue.getDouble(this.valueIndex) + this.arg.getDouble(record));
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public String getName() {
        return "sum_t";
    }

    @Override
    public CharSequence getStrA(Record rec) {
        return null;
    }

    @Override
    public CharSequence getStrB(Record rec) {
        return null;
    }

    @Override
    public int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public void initValueIndex(int valueIndex) {
        this.valueIndex = valueIndex;
    }

    @Override
    public void initValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(10);
    }

    @Override
    public void setDouble(MapValue mapValue, double value) {
        mapValue.putDouble(this.valueIndex, value);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putDouble(this.valueIndex, Double.NaN);
    }

    @Override
    public boolean supportsParallelism() {
        return false;
    }
}

