/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.cairo.wal.seq.SeqTxnTracker;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.Os;

public class WaitWalTableFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "wait_wal_table(s)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        CharSequence tableName = args.getQuick(0).getStrA(null);
        return new WaitWalFunction(tableName);
    }

    private static class WaitWalFunction
    extends BooleanFunction
    implements Function {
        private final CharSequence tableName;
        private SqlExecutionContext executionContext;
        private long seqTxn;
        private SeqTxnTracker seqTxnTracker;

        public WaitWalFunction(CharSequence tableName) {
            this.tableName = tableName;
        }

        @Override
        public boolean getBool(Record rec) {
            if (this.seqTxnTracker != null) {
                int i = 0;
                while (this.seqTxnTracker.getWriterTxn() < this.seqTxn) {
                    Os.sleep(1L);
                    this.executionContext.getCircuitBreaker().statefulThrowExceptionIfTripped();
                    if (i % 1000 == 0 && this.seqTxnTracker.isSuspended()) {
                        throw CairoException.nonCritical().put("table is suspended [tableName=").put(this.tableName).put("]");
                    }
                    ++i;
                }
            }
            return true;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            TableToken tt = executionContext.getCairoEngine().verifyTableName(this.tableName);
            if (tt.isWal()) {
                this.seqTxnTracker = executionContext.getCairoEngine().getTableSequencerAPI().getTxnTracker(tt);
                this.seqTxn = this.seqTxnTracker.getSeqTxn();
                this.executionContext = executionContext;
            } else {
                this.seqTxnTracker = null;
                this.executionContext = null;
            }
            super.init(symbolTableSource, executionContext);
        }

        @Override
        public boolean isRuntimeConstant() {
            return true;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("wait_wal_table(").val(this.tableName).val(')');
        }
    }
}

