/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.IntFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class AddIntFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "+(II)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new AddIntFunc(args.getQuick(0), args.getQuick(1));
    }

    private static class AddIntFunc
    extends IntFunction
    implements BinaryFunction {
        final Function left;
        final Function right;

        public AddIntFunc(Function left, Function right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public int getInt(Record rec) {
            int left = this.left.getInt(rec);
            int right = this.right.getInt(rec);
            if (left == Integer.MIN_VALUE || right == Integer.MIN_VALUE) {
                return Integer.MIN_VALUE;
            }
            return left + right;
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public long getLong(Record rec) {
            int left = this.left.getInt(rec);
            int right = this.right.getInt(rec);
            if (left == Integer.MIN_VALUE || right == Integer.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            return (long)left + (long)right;
        }

        @Override
        public Function getRight() {
            return this.right;
        }

        @Override
        public boolean isConstant() {
            boolean leftIsConstant = this.left.isConstant();
            boolean rightIsConstant = this.right.isConstant();
            return leftIsConstant && rightIsConstant || leftIsConstant && this.left.getInt(null) == Integer.MIN_VALUE || rightIsConstant && this.right.getInt(null) == Integer.MIN_VALUE;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.left).val('+').val(this.right);
        }
    }
}

