/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.long128;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.Long128Function;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;

public class LongsToLong128FunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "to_long128(LL)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function loLong = args.getQuick(0);
        Function hiLong = args.getQuick(1);
        return new LongsToLong128Function(loLong, hiLong);
    }

    private static class LongsToLong128Function
    extends Long128Function
    implements BinaryFunction {
        private final Function hi;
        private final Function lo;

        public LongsToLong128Function(Function lo, Function hi) {
            this.lo = lo;
            this.hi = hi;
        }

        @Override
        public void close() {
            Misc.free(this.lo);
            Misc.free(this.hi);
        }

        @Override
        public Function getLeft() {
            return this.lo;
        }

        @Override
        public long getLong128Hi(Record rec) {
            return this.hi.getLong(rec);
        }

        @Override
        public long getLong128Lo(Record rec) {
            return this.lo.getLong(rec);
        }

        @Override
        public String getName() {
            return "to_long128";
        }

        @Override
        public Function getRight() {
            return this.hi;
        }
    }
}

