/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.histogram.org.HdrHistogram.PackedHistogram;

public class ApproxPercentileLongPackedGroupByFunction
extends DoubleFunction
implements GroupByFunction,
BinaryFunction {
    private final Function exprFunc;
    private final int funcPosition;
    private final ObjList<PackedHistogram> histograms = new ObjList();
    private final Function percentileFunc;
    private final int precision;
    private int histogramIndex;
    private int valueIndex;

    public ApproxPercentileLongPackedGroupByFunction(Function exprFunc, Function percentileFunc, int precision, int funcPosition) {
        assert (precision >= 0 && precision <= 5);
        this.exprFunc = exprFunc;
        this.percentileFunc = percentileFunc;
        this.precision = precision;
        this.funcPosition = funcPosition;
    }

    @Override
    public void clear() {
        this.histograms.clear();
        this.histogramIndex = 0;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record, long rowId) {
        PackedHistogram histogram;
        if (this.histograms.size() <= this.histogramIndex) {
            histogram = new PackedHistogram(1L, 1000L, this.precision);
            this.histograms.extendAndSet(this.histogramIndex, histogram);
            histogram.setAutoResize(true);
        } else {
            histogram = this.histograms.getQuick(this.histogramIndex);
            histogram.reset();
        }
        long val = this.exprFunc.getLong(record);
        if (val != Long.MIN_VALUE) {
            histogram.recordValue(val);
        }
        mapValue.putLong(this.valueIndex, this.histogramIndex++);
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
        PackedHistogram histogram = this.histograms.getQuick(mapValue.getInt(this.valueIndex));
        long val = this.exprFunc.getLong(record);
        if (val != Long.MIN_VALUE) {
            histogram.recordValue(val);
        }
    }

    @Override
    public double getDouble(Record rec) {
        if (this.histograms.size() == 0) {
            return Double.NaN;
        }
        PackedHistogram histogram = this.histograms.getQuick(rec.getInt(this.valueIndex));
        if (histogram.getTotalCount() == 0L) {
            return Double.NaN;
        }
        return histogram.getValueAtPercentile(this.percentileFunc.getDouble(null) * 100.0);
    }

    @Override
    public Function getLeft() {
        return this.exprFunc;
    }

    @Override
    public String getName() {
        return "approx_percentile";
    }

    @Override
    public Function getRight() {
        return this.percentileFunc;
    }

    @Override
    public int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
        BinaryFunction.super.init(symbolTableSource, executionContext);
        double percentile = this.percentileFunc.getDouble(null);
        if (Numbers.isNull(percentile) || percentile < 0.0 || percentile > 1.0) {
            throw SqlException.$(this.funcPosition, "percentile must be between 0.0 and 1.0");
        }
    }

    @Override
    public void initValueIndex(int valueIndex) {
        this.valueIndex = valueIndex;
    }

    @Override
    public void initValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(6);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isThreadSafe() {
        return false;
    }

    @Override
    public void setEmpty(MapValue mapValue) {
        mapValue.putLong(this.valueIndex, 0L);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putLong(this.valueIndex, Long.MIN_VALUE);
    }

    @Override
    public boolean supportsParallelism() {
        return false;
    }
}

