/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.eq;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.griffin.engine.functions.eq.AbstractEqBinaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public final class EqUuidFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "=(ZZ)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function a = args.getQuick(0);
        Function b = args.getQuick(1);
        if (a.isConstant() && b.isConstant()) {
            return EqUuidFunctionFactory.createConstant(a, b);
        }
        if (a.isConstant() && !b.isConstant()) {
            return this.createHalfConstantFunc(a, b);
        }
        if (!a.isConstant() && b.isConstant()) {
            return this.createHalfConstantFunc(b, a);
        }
        return new Func(a, b);
    }

    private static BooleanConstant createConstant(Function a, Function b) {
        long aHi = a.getLong128Hi(null);
        long aLo = a.getLong128Lo(null);
        long bHi = b.getLong128Hi(null);
        long bLo = b.getLong128Lo(null);
        return BooleanConstant.of(aHi == bHi && aLo == bLo);
    }

    private Function createHalfConstantFunc(Function constFunc, Function varFunc) {
        return new ConstCheckFunc(varFunc, constFunc.getLong128Hi(null), constFunc.getLong128Lo(null));
    }

    public static class Func
    extends AbstractEqBinaryFunction
    implements BinaryFunction {
        public Func(Function left, Function right) {
            super(left, right);
        }

        @Override
        public boolean getBool(Record rec) {
            long leftHi = this.left.getLong128Hi(rec);
            long leftLo = this.left.getLong128Lo(rec);
            long rightHi = this.right.getLong128Hi(rec);
            long rightLo = this.right.getLong128Lo(rec);
            return this.negated != (leftHi == rightHi && leftLo == rightLo);
        }
    }

    private static class ConstCheckFunc
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final Function arg;
        private final long hiConstant;
        private final long loConstant;

        public ConstCheckFunc(Function arg, long hiConstant, long loConstant) {
            this.arg = arg;
            this.hiConstant = hiConstant;
            this.loConstant = loConstant;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            long hi = this.arg.getLong128Hi(rec);
            long lo = this.arg.getLong128Lo(rec);
            return this.negated != (hi == this.hiConstant && lo == this.loConstant);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.arg);
            if (this.negated) {
                sink.val('!');
            }
            sink.val("='").valUuid(this.loConstant, this.hiConstant).val('\'');
        }
    }
}

