/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.date.OffsetTimestampFunction;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.TimeZoneRules;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.datetime.microtime.Timestamps;
import org.jetbrains.annotations.NotNull;

public class ToUTCTimestampFunctionFactory
implements FunctionFactory {
    public static final String NAME = "to_utc";

    @Override
    public String getSignature() {
        return "to_utc(NS)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function timestampFunc = args.getQuick(0);
        Function timezoneFunc = args.getQuick(1);
        int timezonePos = argPositions.getQuick(1);
        if (timezoneFunc.isConstant()) {
            return ToUTCTimestampFunctionFactory.toUTCConstFunction(timestampFunc, timezoneFunc, timezonePos);
        }
        if (timezoneFunc.isRuntimeConstant()) {
            return new RuntimeConstFunc(timestampFunc, timezoneFunc, timezonePos);
        }
        return new Func(timestampFunc, timezoneFunc);
    }

    @NotNull
    private static TimestampFunction toUTCConstFunction(Function timestampFunc, Function timezoneFunc, int timezonePos) throws SqlException {
        CharSequence tz = timezoneFunc.getStrA(null);
        if (tz != null) {
            int hi = tz.length();
            long l = Timestamps.parseOffset(tz, 0, hi);
            if (l == Long.MIN_VALUE) {
                try {
                    return new ConstRulesFunc(timestampFunc, TimestampFormatUtils.EN_LOCALE.getZoneRules(Numbers.decodeLowInt(TimestampFormatUtils.EN_LOCALE.matchZone(tz, 0, hi)), 1));
                }
                catch (NumericException e) {
                    Misc.free(timestampFunc);
                    throw SqlException.$(timezonePos, "invalid timezone: ").put(tz);
                }
            }
            return new OffsetTimestampFunction(timestampFunc, (long)(-Numbers.decodeLowInt(l)) * 60000000L);
        }
        throw SqlException.$(timezonePos, "timezone must not be null");
    }

    private static class RuntimeConstFunc
    extends TimestampFunction
    implements BinaryFunction {
        private final Function timestampFunc;
        private final Function timezoneFunc;
        private final int timezonePos;
        private long tzOffset;
        private TimeZoneRules tzRules;

        public RuntimeConstFunc(Function timestampFunc, Function timezoneFunc, int timezonePos) {
            this.timestampFunc = timestampFunc;
            this.timezoneFunc = timezoneFunc;
            this.timezonePos = timezonePos;
        }

        @Override
        public Function getLeft() {
            return this.timestampFunc;
        }

        @Override
        public String getName() {
            return ToUTCTimestampFunctionFactory.NAME;
        }

        @Override
        public Function getRight() {
            return this.timezoneFunc;
        }

        @Override
        public long getTimestamp(Record rec) {
            long timestamp = this.timestampFunc.getTimestamp(rec);
            if (this.tzRules != null) {
                long offset = this.tzRules.getLocalOffset(timestamp);
                return timestamp - offset;
            }
            return timestamp - this.tzOffset;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            BinaryFunction.super.init(symbolTableSource, executionContext);
            CharSequence tz = this.timezoneFunc.getStrA(null);
            if (tz == null) {
                throw SqlException.$(this.timezonePos, "timezone must not be null");
            }
            int hi = tz.length();
            long l = Timestamps.parseOffset(tz, 0, hi);
            if (l == Long.MIN_VALUE) {
                try {
                    this.tzRules = TimestampFormatUtils.EN_LOCALE.getZoneRules(Numbers.decodeLowInt(TimestampFormatUtils.EN_LOCALE.matchZone(tz, 0, hi)), 1);
                    this.tzOffset = 0L;
                }
                catch (NumericException e) {
                    throw SqlException.$(this.timezonePos, "invalid timezone: ").put(tz);
                }
            } else {
                this.tzOffset = (long)Numbers.decodeLowInt(l) * 60000000L;
                this.tzRules = null;
            }
        }
    }

    private static class Func
    extends TimestampFunction
    implements BinaryFunction {
        private final Function timestampFunc;
        private final Function timezoneFunc;

        public Func(Function timestampFunc, Function timezoneFunc) {
            this.timestampFunc = timestampFunc;
            this.timezoneFunc = timezoneFunc;
        }

        @Override
        public Function getLeft() {
            return this.timestampFunc;
        }

        @Override
        public String getName() {
            return ToUTCTimestampFunctionFactory.NAME;
        }

        @Override
        public Function getRight() {
            return this.timezoneFunc;
        }

        @Override
        public long getTimestamp(Record rec) {
            long timestampValue = this.timestampFunc.getTimestamp(rec);
            try {
                CharSequence tz = this.timezoneFunc.getStrA(rec);
                return tz != null ? Timestamps.toUTC(timestampValue, TimestampFormatUtils.EN_LOCALE, tz) : timestampValue;
            }
            catch (NumericException e) {
                return timestampValue;
            }
        }
    }

    private static class ConstRulesFunc
    extends TimestampFunction
    implements UnaryFunction {
        private final Function timestampFunc;
        private final TimeZoneRules tzRules;

        public ConstRulesFunc(Function timestampFunc, TimeZoneRules tzRules) {
            this.timestampFunc = timestampFunc;
            this.tzRules = tzRules;
        }

        @Override
        public Function getArg() {
            return this.timestampFunc;
        }

        @Override
        public String getName() {
            return ToUTCTimestampFunctionFactory.NAME;
        }

        @Override
        public long getTimestamp(Record rec) {
            long timestamp = this.timestampFunc.getTimestamp(rec);
            long offset = this.tzRules.getLocalOffset(timestamp);
            return timestamp - offset;
        }
    }
}

