/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.TernaryFunction;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.date.TimestampFloorOffsetFunctions;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.TimeZoneRules;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.datetime.microtime.Timestamps;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TimestampFloorFromOffsetFunctionFactory
implements FunctionFactory {
    private static final long MIN_GAP_MINUTES = 15L;
    private static final long MIN_GAP_SECONDS = 900L;
    private static final long MIN_GAP_MILLIS = 900000L;
    private static final long MIN_GAP_MICROS = 900000000L;
    private static final TimestampFloorFunction floorDDFunc = Timestamps::floorDD;
    private static final TimestampFloorFunction floorHHFunc = Timestamps::floorHH;
    private static final TimestampFloorFunction floorMCFunc = Timestamps::floorMC;
    private static final TimestampFloorFunction floorMIFunc = Timestamps::floorMI;
    private static final TimestampFloorFunction floorMMFunc = Timestamps::floorMM;
    private static final TimestampFloorFunction floorMSFunc = Timestamps::floorMS;
    private static final TimestampFloorFunction floorSSFunc = Timestamps::floorSS;
    private static final TimestampFloorFunction floorWWFunc = Timestamps::floorWW;
    private static final TimestampFloorFunction floorYYYYFunc = Timestamps::floorYYYY;

    @Override
    public String getSignature() {
        return "timestamp_floor(sNnSS)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        CharSequence unitStr = args.getQuick(0).getStrA(null);
        int stride = Timestamps.getStrideMultiple(unitStr, argPositions.getQuick(0));
        char unit = Timestamps.getStrideUnit(unitStr, argPositions.getQuick(0));
        int unitPos = argPositions.getQuick(0);
        Function timestampFunc = args.getQuick(1);
        long from = args.getQuick(2).getTimestamp(null);
        if (from == Long.MIN_VALUE) {
            from = 0L;
        }
        Function offsetFunc = args.getQuick(3);
        int offsetPos = argPositions.getQuick(3);
        Function timezoneFunc = args.getQuick(4);
        int timezonePos = argPositions.getQuick(4);
        TimestampFloorFunction floorFunc = TimestampFloorFromOffsetFunctionFactory.getFloorFunction(unit, unitPos);
        String offsetStr = null;
        long offset = 0L;
        if (offsetFunc.isConstant()) {
            CharSequence o = offsetFunc.getStrA(null);
            if (o != null) {
                long val = Timestamps.parseOffset(o);
                if (val == Long.MIN_VALUE) {
                    throw SqlException.$(offsetPos, "invalid offset: ").put(o);
                }
                offset = (long)Numbers.decodeLowInt(val) * 60000000L;
            }
            offsetStr = Chars.toString(o);
        }
        if (timezoneFunc.isConstant()) {
            CharSequence tz = timezoneFunc.getStrA(null);
            long tzOffset = 0L;
            TimeZoneRules tzRules = null;
            if (tz != null) {
                int hi = tz.length();
                long l = Timestamps.parseOffset(tz, 0, hi);
                if (l == Long.MIN_VALUE) {
                    try {
                        tzRules = TimestampFormatUtils.EN_LOCALE.getZoneRules(Numbers.decodeLowInt(TimestampFormatUtils.EN_LOCALE.matchZone(tz, 0, hi)), 1);
                    }
                    catch (NumericException e) {
                        Misc.free(timestampFunc);
                        throw SqlException.$(timezonePos, "invalid timezone: ").put(tz);
                    }
                    if (tzRules.hasFixedOffset()) {
                        tzOffset = tzRules.getOffset(0L);
                        tzRules = null;
                    }
                } else {
                    tzOffset = (long)Numbers.decodeLowInt(l) * 60000000L;
                }
            }
            String tzStr = Chars.toString(tz);
            if (tzRules == null) {
                if (offsetFunc.isConstant()) {
                    return TimestampFloorFromOffsetFunctionFactory.createAllConstFunc(timestampFunc, floorFunc, stride, unit, unitPos, from, offset, offsetStr, tzOffset, tzStr);
                }
                if (offsetFunc.isRuntimeConstant()) {
                    return new RuntimeConstOffsetFunction(timestampFunc, floorFunc, stride, unit, from, offsetFunc, offsetPos, tzOffset, tzStr);
                }
                throw SqlException.$(offsetPos, "const or runtime const expected");
            }
            if (offsetFunc.isConstant()) {
                return TimestampFloorFromOffsetFunctionFactory.createAllConstTzFunc(timestampFunc, floorFunc, stride, unit, from, offset, offsetStr, tzRules, tzStr);
            }
            if (offsetFunc.isRuntimeConstant()) {
                return new RuntimeConstOffsetDstGapAwareFunc(timestampFunc, floorFunc, stride, unit, from, offsetFunc, offsetPos, tzRules, tzStr);
            }
            throw SqlException.$(offsetPos, "const or runtime const expected");
        }
        if (timezoneFunc.isRuntimeConstant()) {
            if (offsetFunc.isConstant()) {
                return TimestampFloorFromOffsetFunctionFactory.createRuntimeConstTzFunc(timestampFunc, floorFunc, stride, unit, from, offset, offsetStr, timezoneFunc, timezonePos);
            }
            if (offsetFunc.isRuntimeConstant()) {
                return new AllRuntimeConstDstGapAwareFunc(timestampFunc, floorFunc, stride, unit, from, offsetFunc, offsetPos, timezoneFunc, timezonePos);
            }
            throw SqlException.$(offsetPos, "const or runtime const expected");
        }
        throw SqlException.$(timezonePos, "const or runtime const expected");
    }

    private static boolean canSkipDstGapCorrection(int stride, char unit, long from, long offset) {
        if ((from + offset) % 86400000000L != 0L) {
            return false;
        }
        switch (unit) {
            case 'M': 
            case 'd': 
            case 'h': 
            case 'w': 
            case 'y': {
                return true;
            }
            case 'm': {
                return 15L % (long)stride == 0L || (long)stride % 15L == 0L;
            }
            case 's': {
                return 900L % (long)stride == 0L || (long)stride % 900L == 0L;
            }
            case 'T': {
                return 900000L % (long)stride == 0L || (long)stride % 900000L == 0L;
            }
            case 'U': {
                return 900000000L % (long)stride == 0L || (long)stride % 900000000L == 0L;
            }
        }
        return false;
    }

    @NotNull
    private static Function createAllConstFunc(@NotNull Function timestampFunc, @NotNull TimestampFloorFunction floorFunc, int stride, char unit, int unitPos, long from, long offset, @Nullable String offsetStr, long tzOffset, @Nullable String tzStr) throws SqlException {
        if (tzOffset == 0L) {
            long effectiveOffset = from + offset;
            switch (unit) {
                case 'M': {
                    return new TimestampFloorOffsetFunctions.TimestampFloorOffsetMMFunction(timestampFunc, stride, effectiveOffset);
                }
                case 'y': {
                    return new TimestampFloorOffsetFunctions.TimestampFloorOffsetYYYYFunction(timestampFunc, stride, effectiveOffset);
                }
                case 'w': {
                    return new TimestampFloorOffsetFunctions.TimestampFloorOffsetWWFunction(timestampFunc, stride, effectiveOffset);
                }
                case 'd': {
                    return new TimestampFloorOffsetFunctions.TimestampFloorOffsetDDFunction(timestampFunc, stride, effectiveOffset);
                }
                case 'h': {
                    return new TimestampFloorOffsetFunctions.TimestampFloorOffsetHHFunction(timestampFunc, stride, effectiveOffset);
                }
                case 'm': {
                    return new TimestampFloorOffsetFunctions.TimestampFloorOffsetMIFunction(timestampFunc, stride, effectiveOffset);
                }
                case 's': {
                    return new TimestampFloorOffsetFunctions.TimestampFloorOffsetSSFunction(timestampFunc, stride, effectiveOffset);
                }
                case 'T': {
                    return new TimestampFloorOffsetFunctions.TimestampFloorOffsetMSFunction(timestampFunc, stride, effectiveOffset);
                }
                case 'U': {
                    return new TimestampFloorOffsetFunctions.TimestampFloorOffsetMCFunction(timestampFunc, stride, effectiveOffset);
                }
            }
            throw SqlException.position(unitPos).put("unexpected unit");
        }
        return new AllConstFunc(timestampFunc, floorFunc, stride, unit, from, offset, offsetStr, tzOffset, tzStr);
    }

    @NotNull
    private static Function createAllConstTzFunc(@NotNull Function timestampFunc, @NotNull TimestampFloorFunction floorFunc, int stride, char unit, long from, long offset, @Nullable String offsetStr, @NotNull TimeZoneRules tzRules, @NotNull String tzStr) {
        if (TimestampFloorFromOffsetFunctionFactory.canSkipDstGapCorrection(stride, unit, from, offset)) {
            return new AllConstTzFunc(timestampFunc, floorFunc, stride, unit, from, offset, offsetStr, tzRules, tzStr);
        }
        return new AllConstDstGapAwareFunc(timestampFunc, floorFunc, stride, unit, from, offset, offsetStr, tzRules, tzStr);
    }

    @NotNull
    private static Function createRuntimeConstTzFunc(Function timestampFunc, TimestampFloorFunction floorFunc, int stride, char unit, long from, long offset, String offsetStr, Function timezoneFunc, int timezonePos) {
        if (TimestampFloorFromOffsetFunctionFactory.canSkipDstGapCorrection(stride, unit, from, offset)) {
            return new RuntimeConstTzFunc(timestampFunc, floorFunc, stride, unit, from, offset, offsetStr, timezoneFunc, timezonePos);
        }
        return new RuntimeConstDstGapAwareFunc(timestampFunc, floorFunc, stride, unit, from, offset, offsetStr, timezoneFunc, timezonePos);
    }

    private static long floorWithDstGapCorrection(long timestamp, TimestampFloorFunction floorFunc, int stride, long offset, TimeZoneRules tzRules) {
        long localTimestamp = timestamp + tzRules.getOffset(timestamp);
        long flooredTimestamp = floorFunc.floor(localTimestamp, stride, offset);
        long gapDuration = tzRules.getDstGapOffset(flooredTimestamp);
        if (gapDuration == 0L) {
            return flooredTimestamp;
        }
        return floorFunc.floor(flooredTimestamp - gapDuration, stride, offset);
    }

    private static TimestampFloorFunction getFloorFunction(char unit, int unitPos) throws SqlException {
        switch (unit) {
            case 'M': {
                return floorMMFunc;
            }
            case 'y': {
                return floorYYYYFunc;
            }
            case 'w': {
                return floorWWFunc;
            }
            case 'd': {
                return floorDDFunc;
            }
            case 'h': {
                return floorHHFunc;
            }
            case 'm': {
                return floorMIFunc;
            }
            case 's': {
                return floorSSFunc;
            }
            case 'T': {
                return floorMSFunc;
            }
            case 'U': {
                return floorMCFunc;
            }
        }
        throw SqlException.position(unitPos).put("unexpected unit");
    }

    @FunctionalInterface
    private static interface TimestampFloorFunction {
        public long floor(long var1, int var3, long var4);
    }

    private static class RuntimeConstOffsetFunction
    extends TimestampFunction
    implements BinaryFunction {
        private final TimestampFloorFunction floorFunc;
        private final long from;
        private final Function offsetFunc;
        private final int offsetPos;
        private final int stride;
        private final Function tsFunc;
        private final long tzOffset;
        private final String tzStr;
        private final char unit;
        private long effectiveOffset;

        public RuntimeConstOffsetFunction(Function tsFunc, TimestampFloorFunction floorFunc, int stride, char unit, long from, Function offsetFunc, int offsetPos, long tzOffset, String tzStr) {
            this.tsFunc = tsFunc;
            this.floorFunc = floorFunc;
            this.stride = stride;
            this.unit = unit;
            this.from = from;
            this.offsetFunc = offsetFunc;
            this.offsetPos = offsetPos;
            this.tzOffset = tzOffset;
            this.tzStr = tzStr;
        }

        @Override
        public Function getLeft() {
            return this.tsFunc;
        }

        @Override
        public Function getRight() {
            return this.offsetFunc;
        }

        @Override
        public final long getTimestamp(Record rec) {
            long timestamp = this.tsFunc.getTimestamp(rec);
            if (timestamp != Long.MIN_VALUE) {
                long localTimestamp = timestamp + this.tzOffset;
                return this.floorFunc.floor(localTimestamp, this.stride, this.effectiveOffset);
            }
            return Long.MIN_VALUE;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            long offset;
            BinaryFunction.super.init(symbolTableSource, executionContext);
            CharSequence offsetStr = this.offsetFunc.getStrA(null);
            if (offsetStr != null) {
                long val = Timestamps.parseOffset(offsetStr);
                if (val == Long.MIN_VALUE) {
                    throw SqlException.$(this.offsetPos, "invalid offset: ").put(offsetStr);
                }
                offset = (long)Numbers.decodeLowInt(val) * 60000000L;
            } else {
                offset = 0L;
            }
            this.effectiveOffset = this.from + offset;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("timestamp_floor").val("('");
            sink.val(this.stride);
            sink.val(this.unit).val("',");
            sink.val(this.tsFunc).val(',');
            if (this.from != 0L) {
                sink.val('\'').val(Timestamps.toString(this.from)).val("',");
            } else {
                sink.val("null,");
            }
            sink.val(this.offsetFunc).val(',');
            if (this.tzStr != null) {
                sink.val('\'').val(this.tzStr).val('\'');
            } else {
                sink.val("null");
            }
            sink.val(')');
        }
    }

    private static class RuntimeConstOffsetDstGapAwareFunc
    extends TimestampFunction
    implements BinaryFunction {
        private final TimestampFloorFunction floorFunc;
        private final long from;
        private final Function offsetFunc;
        private final int offsetPos;
        private final int stride;
        private final Function tsFunc;
        private final TimeZoneRules tzRules;
        private final String tzStr;
        private final char unit;
        private long effectiveOffset;

        public RuntimeConstOffsetDstGapAwareFunc(Function tsFunc, TimestampFloorFunction floorFunc, int stride, char unit, long from, Function offsetFunc, int offsetPos, TimeZoneRules tzRules, String tzStr) {
            this.tsFunc = tsFunc;
            this.floorFunc = floorFunc;
            this.stride = stride;
            this.unit = unit;
            this.from = from;
            this.offsetFunc = offsetFunc;
            this.offsetPos = offsetPos;
            this.tzRules = tzRules;
            this.tzStr = tzStr;
        }

        @Override
        public Function getLeft() {
            return this.tsFunc;
        }

        @Override
        public Function getRight() {
            return this.offsetFunc;
        }

        @Override
        public final long getTimestamp(Record rec) {
            long timestamp = this.tsFunc.getTimestamp(rec);
            if (timestamp != Long.MIN_VALUE) {
                return TimestampFloorFromOffsetFunctionFactory.floorWithDstGapCorrection(timestamp, this.floorFunc, this.stride, this.effectiveOffset, this.tzRules);
            }
            return Long.MIN_VALUE;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            long offset;
            BinaryFunction.super.init(symbolTableSource, executionContext);
            CharSequence offsetStr = this.offsetFunc.getStrA(null);
            if (offsetStr != null) {
                long val = Timestamps.parseOffset(offsetStr);
                if (val == Long.MIN_VALUE) {
                    throw SqlException.$(this.offsetPos, "invalid offset: ").put(offsetStr);
                }
                offset = (long)Numbers.decodeLowInt(val) * 60000000L;
            } else {
                offset = 0L;
            }
            this.effectiveOffset = this.from + offset;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("timestamp_floor").val("('");
            sink.val(this.stride);
            sink.val(this.unit).val("',");
            sink.val(this.tsFunc).val(',');
            if (this.from != 0L) {
                sink.val('\'').val(Timestamps.toString(this.from)).val("',");
            } else {
                sink.val("null,");
            }
            sink.val(this.offsetFunc).val(',');
            sink.val('\'').val(this.tzStr).val('\'');
            sink.val(')');
        }
    }

    private static class AllRuntimeConstDstGapAwareFunc
    extends TimestampFunction
    implements TernaryFunction {
        private final TimestampFloorFunction floorFunc;
        private final long from;
        private final Function offsetFunc;
        private final int offsetPos;
        private final int stride;
        private final Function timezoneFunc;
        private final int timezonePos;
        private final Function tsFunc;
        private final char unit;
        private long effectiveOffset;
        private long tzOffset;
        private TimeZoneRules tzRules;

        public AllRuntimeConstDstGapAwareFunc(Function tsFunc, TimestampFloorFunction floorFunc, int stride, char unit, long from, Function offsetFunc, int offsetPos, Function timezoneFunc, int timezonePos) {
            this.tsFunc = tsFunc;
            this.floorFunc = floorFunc;
            this.stride = stride;
            this.unit = unit;
            this.from = from;
            this.offsetFunc = offsetFunc;
            this.offsetPos = offsetPos;
            this.timezoneFunc = timezoneFunc;
            this.timezonePos = timezonePos;
        }

        @Override
        public Function getCenter() {
            return this.offsetFunc;
        }

        @Override
        public Function getLeft() {
            return this.tsFunc;
        }

        @Override
        public Function getRight() {
            return this.timezoneFunc;
        }

        @Override
        public final long getTimestamp(Record rec) {
            long timestamp = this.tsFunc.getTimestamp(rec);
            if (timestamp != Long.MIN_VALUE) {
                if (this.tzRules != null) {
                    return TimestampFloorFromOffsetFunctionFactory.floorWithDstGapCorrection(timestamp, this.floorFunc, this.stride, this.effectiveOffset, this.tzRules);
                }
                long localTimestamp = timestamp + this.tzOffset;
                return this.floorFunc.floor(localTimestamp, this.stride, this.effectiveOffset);
            }
            return Long.MIN_VALUE;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            long offset;
            TernaryFunction.super.init(symbolTableSource, executionContext);
            CharSequence offsetStr = this.offsetFunc.getStrA(null);
            if (offsetStr != null) {
                long val = Timestamps.parseOffset(offsetStr);
                if (val == Long.MIN_VALUE) {
                    throw SqlException.$(this.offsetPos, "invalid offset: ").put(offsetStr);
                }
                offset = (long)Numbers.decodeLowInt(val) * 60000000L;
            } else {
                offset = 0L;
            }
            this.effectiveOffset = this.from + offset;
            CharSequence tz = this.timezoneFunc.getStrA(null);
            if (tz != null) {
                int hi = tz.length();
                long l = Timestamps.parseOffset(tz, 0, hi);
                if (l == Long.MIN_VALUE) {
                    try {
                        this.tzRules = TimestampFormatUtils.EN_LOCALE.getZoneRules(Numbers.decodeLowInt(TimestampFormatUtils.EN_LOCALE.matchZone(tz, 0, hi)), 1);
                        this.tzOffset = 0L;
                    }
                    catch (NumericException e) {
                        throw SqlException.$(this.timezonePos, "invalid timezone: ").put(tz);
                    }
                } else {
                    this.tzOffset = (long)Numbers.decodeLowInt(l) * 60000000L;
                    this.tzRules = null;
                }
            } else {
                this.tzOffset = 0L;
                this.tzRules = null;
            }
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("timestamp_floor").val("('");
            sink.val(this.stride);
            sink.val(this.unit).val("',");
            sink.val(this.tsFunc).val(',');
            if (this.from != 0L) {
                sink.val('\'').val(Timestamps.toString(this.from)).val("',");
            } else {
                sink.val("null,");
            }
            sink.val(this.offsetFunc).val(',');
            sink.val(this.timezoneFunc);
            sink.val(')');
        }
    }

    private static class AllConstFunc
    extends TimestampFunction
    implements UnaryFunction {
        private final long effectiveOffset;
        private final TimestampFloorFunction floorFunc;
        private final long from;
        private final String offsetStr;
        private final int stride;
        private final Function tsFunc;
        private final long tzOffset;
        private final String tzStr;
        private final char unit;

        public AllConstFunc(Function tsFunc, TimestampFloorFunction floorFunc, int stride, char unit, long from, long offset, String offsetStr, long tzOffset, String tzStr) {
            this.tsFunc = tsFunc;
            this.floorFunc = floorFunc;
            this.stride = stride;
            this.unit = unit;
            this.from = from;
            this.effectiveOffset = from + offset;
            this.offsetStr = offsetStr;
            this.tzOffset = tzOffset;
            this.tzStr = tzStr;
        }

        @Override
        public Function getArg() {
            return this.tsFunc;
        }

        @Override
        public final long getTimestamp(Record rec) {
            long timestamp = this.tsFunc.getTimestamp(rec);
            if (timestamp != Long.MIN_VALUE) {
                long localTimestamp = timestamp + this.tzOffset;
                return this.floorFunc.floor(localTimestamp, this.stride, this.effectiveOffset);
            }
            return Long.MIN_VALUE;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("timestamp_floor").val("('");
            sink.val(this.stride);
            sink.val(this.unit).val("',");
            sink.val(this.tsFunc).val(',');
            if (this.from != 0L) {
                sink.val('\'').val(Timestamps.toString(this.from)).val("',");
            } else {
                sink.val("null,");
            }
            if (this.offsetStr != null) {
                sink.val('\'').val(this.offsetStr).val("',");
            } else {
                sink.val("'00:00',");
            }
            sink.val('\'').val(this.tzStr).val('\'');
            sink.val(')');
        }
    }

    private static class AllConstTzFunc
    extends TimestampFunction
    implements UnaryFunction {
        private final long effectiveOffset;
        private final TimestampFloorFunction floorFunc;
        private final long from;
        private final String offsetStr;
        private final int stride;
        private final Function tsFunc;
        private final TimeZoneRules tzRules;
        private final String tzStr;
        private final char unit;

        public AllConstTzFunc(Function tsFunc, TimestampFloorFunction floorFunc, int stride, char unit, long from, long offset, String offsetStr, TimeZoneRules tzRules, String tzStr) {
            this.tsFunc = tsFunc;
            this.floorFunc = floorFunc;
            this.stride = stride;
            this.unit = unit;
            this.from = from;
            this.effectiveOffset = from + offset;
            this.offsetStr = offsetStr;
            this.tzRules = tzRules;
            this.tzStr = tzStr;
        }

        @Override
        public Function getArg() {
            return this.tsFunc;
        }

        @Override
        public final long getTimestamp(Record rec) {
            long timestamp = this.tsFunc.getTimestamp(rec);
            if (timestamp != Long.MIN_VALUE) {
                long localTimestamp = timestamp + this.tzRules.getOffset(timestamp);
                return this.floorFunc.floor(localTimestamp, this.stride, this.effectiveOffset);
            }
            return Long.MIN_VALUE;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("timestamp_floor").val("('");
            sink.val(this.stride);
            sink.val(this.unit).val("',");
            sink.val(this.tsFunc).val(',');
            if (this.from != 0L) {
                sink.val('\'').val(Timestamps.toString(this.from)).val("',");
            } else {
                sink.val("null,");
            }
            if (this.offsetStr != null) {
                sink.val('\'').val(this.offsetStr).val("',");
            } else {
                sink.val("'00:00',");
            }
            sink.val('\'').val(this.tzStr).val('\'');
            sink.val(')');
        }
    }

    private static class AllConstDstGapAwareFunc
    extends TimestampFunction
    implements UnaryFunction {
        private final long effectiveOffset;
        private final TimestampFloorFunction floorFunc;
        private final long from;
        private final String offsetStr;
        private final int stride;
        private final Function tsFunc;
        private final TimeZoneRules tzRules;
        private final String tzStr;
        private final char unit;

        public AllConstDstGapAwareFunc(Function tsFunc, TimestampFloorFunction floorFunc, int stride, char unit, long from, long offset, String offsetStr, TimeZoneRules tzRules, String tzStr) {
            this.tsFunc = tsFunc;
            this.floorFunc = floorFunc;
            this.stride = stride;
            this.unit = unit;
            this.from = from;
            this.effectiveOffset = from + offset;
            this.offsetStr = offsetStr;
            this.tzRules = tzRules;
            this.tzStr = tzStr;
        }

        @Override
        public Function getArg() {
            return this.tsFunc;
        }

        @Override
        public final long getTimestamp(Record rec) {
            long timestamp = this.tsFunc.getTimestamp(rec);
            if (timestamp != Long.MIN_VALUE) {
                return TimestampFloorFromOffsetFunctionFactory.floorWithDstGapCorrection(timestamp, this.floorFunc, this.stride, this.effectiveOffset, this.tzRules);
            }
            return Long.MIN_VALUE;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("timestamp_floor").val("('");
            sink.val(this.stride);
            sink.val(this.unit).val("',");
            sink.val(this.tsFunc).val(',');
            if (this.from != 0L) {
                sink.val('\'').val(Timestamps.toString(this.from)).val("',");
            } else {
                sink.val("null,");
            }
            if (this.offsetStr != null) {
                sink.val('\'').val(this.offsetStr).val("',");
            } else {
                sink.val("'00:00',");
            }
            sink.val('\'').val(this.tzStr).val('\'');
            sink.val(')');
        }
    }

    private static class RuntimeConstTzFunc
    extends TimestampFunction
    implements BinaryFunction {
        private final long effectiveOffset;
        private final TimestampFloorFunction floorFunc;
        private final long from;
        private final String offsetStr;
        private final int stride;
        private final Function timezoneFunc;
        private final int timezonePos;
        private final Function tsFunc;
        private final char unit;
        private long tzOffset;
        private TimeZoneRules tzRules;

        public RuntimeConstTzFunc(Function tsFunc, TimestampFloorFunction floorFunc, int stride, char unit, long from, long offset, String offsetStr, Function timezoneFunc, int timezonePos) {
            this.tsFunc = tsFunc;
            this.floorFunc = floorFunc;
            this.stride = stride;
            this.unit = unit;
            this.from = from;
            this.effectiveOffset = from + offset;
            this.offsetStr = offsetStr;
            this.timezoneFunc = timezoneFunc;
            this.timezonePos = timezonePos;
        }

        @Override
        public Function getLeft() {
            return this.tsFunc;
        }

        @Override
        public Function getRight() {
            return this.timezoneFunc;
        }

        @Override
        public final long getTimestamp(Record rec) {
            long timestamp = this.tsFunc.getTimestamp(rec);
            if (timestamp != Long.MIN_VALUE) {
                long localTimestamp = this.tzRules != null ? timestamp + this.tzRules.getOffset(timestamp) : timestamp + this.tzOffset;
                return this.floorFunc.floor(localTimestamp, this.stride, this.effectiveOffset);
            }
            return Long.MIN_VALUE;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            BinaryFunction.super.init(symbolTableSource, executionContext);
            CharSequence tz = this.timezoneFunc.getStrA(null);
            if (tz != null) {
                int hi = tz.length();
                long l = Timestamps.parseOffset(tz, 0, hi);
                if (l == Long.MIN_VALUE) {
                    try {
                        this.tzRules = TimestampFormatUtils.EN_LOCALE.getZoneRules(Numbers.decodeLowInt(TimestampFormatUtils.EN_LOCALE.matchZone(tz, 0, hi)), 1);
                        this.tzOffset = 0L;
                    }
                    catch (NumericException e) {
                        throw SqlException.$(this.timezonePos, "invalid timezone: ").put(tz);
                    }
                } else {
                    this.tzOffset = (long)Numbers.decodeLowInt(l) * 60000000L;
                    this.tzRules = null;
                }
            } else {
                this.tzOffset = 0L;
                this.tzRules = null;
            }
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("timestamp_floor").val("('");
            sink.val(this.stride);
            sink.val(this.unit).val("',");
            sink.val(this.tsFunc).val(',');
            if (this.from != 0L) {
                sink.val('\'').val(Timestamps.toString(this.from)).val("',");
            } else {
                sink.val("null,");
            }
            if (this.offsetStr != null) {
                sink.val('\'').val(this.offsetStr).val("',");
            } else {
                sink.val("'00:00',");
            }
            sink.val(this.timezoneFunc);
            sink.val(')');
        }
    }

    private static class RuntimeConstDstGapAwareFunc
    extends TimestampFunction
    implements BinaryFunction {
        private final long effectiveOffset;
        private final TimestampFloorFunction floorFunc;
        private final long from;
        private final String offsetStr;
        private final int stride;
        private final Function timezoneFunc;
        private final int timezonePos;
        private final Function tsFunc;
        private final char unit;
        private long tzOffset;
        private TimeZoneRules tzRules;

        public RuntimeConstDstGapAwareFunc(Function tsFunc, TimestampFloorFunction floorFunc, int stride, char unit, long from, long offset, String offsetStr, Function timezoneFunc, int timezonePos) {
            this.tsFunc = tsFunc;
            this.floorFunc = floorFunc;
            this.stride = stride;
            this.unit = unit;
            this.from = from;
            this.effectiveOffset = from + offset;
            this.offsetStr = offsetStr;
            this.timezoneFunc = timezoneFunc;
            this.timezonePos = timezonePos;
        }

        @Override
        public Function getLeft() {
            return this.tsFunc;
        }

        @Override
        public Function getRight() {
            return this.timezoneFunc;
        }

        @Override
        public final long getTimestamp(Record rec) {
            long timestamp = this.tsFunc.getTimestamp(rec);
            if (timestamp != Long.MIN_VALUE) {
                if (this.tzRules != null) {
                    return TimestampFloorFromOffsetFunctionFactory.floorWithDstGapCorrection(timestamp, this.floorFunc, this.stride, this.effectiveOffset, this.tzRules);
                }
                long localTimestamp = timestamp + this.tzOffset;
                return this.floorFunc.floor(localTimestamp, this.stride, this.effectiveOffset);
            }
            return Long.MIN_VALUE;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            BinaryFunction.super.init(symbolTableSource, executionContext);
            CharSequence tz = this.timezoneFunc.getStrA(null);
            if (tz != null) {
                int hi = tz.length();
                long l = Timestamps.parseOffset(tz, 0, hi);
                if (l == Long.MIN_VALUE) {
                    try {
                        this.tzRules = TimestampFormatUtils.EN_LOCALE.getZoneRules(Numbers.decodeLowInt(TimestampFormatUtils.EN_LOCALE.matchZone(tz, 0, hi)), 1);
                        this.tzOffset = 0L;
                    }
                    catch (NumericException e) {
                        throw SqlException.$(this.timezonePos, "invalid timezone: ").put(tz);
                    }
                } else {
                    this.tzOffset = (long)Numbers.decodeLowInt(l) * 60000000L;
                    this.tzRules = null;
                }
            } else {
                this.tzOffset = 0L;
                this.tzRules = null;
            }
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("timestamp_floor").val("('");
            sink.val(this.stride);
            sink.val(this.unit).val("',");
            sink.val(this.tsFunc).val(',');
            if (this.from != 0L) {
                sink.val('\'').val(Timestamps.toString(this.from)).val("',");
            } else {
                sink.val("null,");
            }
            if (this.offsetStr != null) {
                sink.val('\'').val(this.offsetStr).val("',");
            } else {
                sink.val("'00:00',");
            }
            sink.val(this.timezoneFunc);
            sink.val(')');
        }
    }
}

