/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.ObjHashSet;
import io.questdb.std.ObjList;

public class InformationSchemaTablesFunctionFactory
implements FunctionFactory {
    private static final int COLUMN_CATALOG = 0;
    private static final int COLUMN_IS_INSERTABLE_INTO = 9;
    private static final int COLUMN_IS_TYPED = 10;
    private static final int COLUMN_NAME = 2;
    private static final int COLUMN_SCHEMA = 1;
    private static final int COLUMN_TYPE = 3;
    private static final RecordMetadata METADATA;

    @Override
    public String getSignature() {
        return "information_schema.tables()";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CursorFunction(new InformationSchemaTablesCursorFactory(configuration, METADATA)){

            @Override
            public boolean isRuntimeConstant() {
                return true;
            }
        };
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("table_catalog", 11));
        metadata.add(new TableColumnMetadata("table_schema", 11));
        metadata.add(new TableColumnMetadata("table_name", 11));
        metadata.add(new TableColumnMetadata("table_type", 11));
        metadata.add(new TableColumnMetadata("self_referencing_column_name", 11));
        metadata.add(new TableColumnMetadata("reference_generation", 11));
        metadata.add(new TableColumnMetadata("user_defined_type_catalog", 11));
        metadata.add(new TableColumnMetadata("user_defined_type_schema", 11));
        metadata.add(new TableColumnMetadata("user_defined_type_name", 11));
        metadata.add(new TableColumnMetadata("is_insertable_into", 1));
        metadata.add(new TableColumnMetadata("is_typed", 1));
        metadata.add(new TableColumnMetadata("commit_action", 11));
        METADATA = metadata;
    }

    public static class InformationSchemaTablesCursorFactory
    extends AbstractRecordCursorFactory {
        private final TableListRecordCursor cursor = new TableListRecordCursor();
        private final boolean hideTelemetryTables;
        private final CharSequence sysTablePrefix;
        private final CharSequence tempPendingRenameTablePrefix;
        private CairoEngine engine;
        private TableToken tableToken;

        public InformationSchemaTablesCursorFactory(CairoConfiguration configuration, RecordMetadata metadata) {
            super(metadata);
            this.tempPendingRenameTablePrefix = configuration.getTempRenamePendingTablePrefix();
            this.sysTablePrefix = configuration.getSystemTableNamePrefix();
            this.hideTelemetryTables = configuration.getTelemetryConfiguration().hideTables();
        }

        @Override
        public RecordCursor getCursor(SqlExecutionContext executionContext) {
            this.engine = executionContext.getCairoEngine();
            this.cursor.toTop();
            return this.cursor;
        }

        @Override
        public boolean recordCursorSupportsRandomAccess() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.type("information_schema.tables");
        }

        @Override
        protected void _close() {
            this.cursor.close();
            this.engine = null;
        }

        private class TableListRecordCursor
        implements NoRandomAccessRecordCursor {
            private final TableListRecord record = new TableListRecord();
            private final ObjHashSet<TableToken> tableBucket = new ObjHashSet();
            private int tableIndex = -1;

            private TableListRecordCursor() {
            }

            @Override
            public void close() {
                this.tableIndex = -1;
            }

            @Override
            public Record getRecord() {
                return this.record;
            }

            @Override
            public boolean hasNext() {
                if (this.tableIndex < 0) {
                    InformationSchemaTablesCursorFactory.this.engine.getTableTokens(this.tableBucket, false);
                    this.tableIndex = -1;
                }
                ++this.tableIndex;
                int n = this.tableBucket.size();
                while (this.tableIndex < n) {
                    InformationSchemaTablesCursorFactory.this.tableToken = this.tableBucket.get(this.tableIndex);
                    if (TableUtils.isFinalTableName(InformationSchemaTablesCursorFactory.this.tableToken.getTableName(), InformationSchemaTablesCursorFactory.this.tempPendingRenameTablePrefix) && !this.isSystemTable(InformationSchemaTablesCursorFactory.this.tableToken)) break;
                    ++this.tableIndex;
                }
                return this.tableIndex < n;
            }

            @Override
            public long preComputedStateSize() {
                return 0L;
            }

            @Override
            public long size() {
                return -1L;
            }

            @Override
            public void toTop() {
                this.tableIndex = -1;
            }

            private boolean isSystemTable(TableToken tableToken) {
                String tableName = tableToken.getTableName();
                return InformationSchemaTablesCursorFactory.this.hideTelemetryTables && (Chars.equals(tableName, "telemetry") || Chars.equals(tableName, "telemetry_config")) || Chars.startsWith((CharSequence)tableName, InformationSchemaTablesCursorFactory.this.sysTablePrefix) || Chars.equals(tableName, "_query_trace");
            }

            private class TableListRecord
            implements Record {
                private TableListRecord() {
                }

                @Override
                public boolean getBool(int col) {
                    if (col == 10) {
                        return false;
                    }
                    return col == 9;
                }

                @Override
                public CharSequence getStrA(int col) {
                    if (col == 2) {
                        return InformationSchemaTablesCursorFactory.this.tableToken.getTableName();
                    }
                    if (col == 0) {
                        return "qdb";
                    }
                    if (col == 1) {
                        return "public";
                    }
                    if (col == 3) {
                        return "BASE TABLE";
                    }
                    return null;
                }

                @Override
                public CharSequence getStrB(int col) {
                    return this.getStrA(col);
                }

                @Override
                public int getStrLen(int col) {
                    return TableUtils.lengthOf(this.getStrA(col));
                }
            }
        }
    }
}

