/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoTable;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.MetadataCacheReader;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class AllTablesFunctionFactory
implements FunctionFactory {
    private static final RecordMetadata METADATA;

    @Override
    public String getSignature() {
        return "all_tables()";
    }

    @Override
    public boolean isRuntimeConstant() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CursorFunction(new AllTablesCursorFactory()){

            @Override
            public boolean isRuntimeConstant() {
                return true;
            }
        };
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("table_name", 11));
        METADATA = metadata;
    }

    public static class AllTablesCursorFactory
    extends AbstractRecordCursorFactory {
        public static final Log LOG = LogFactory.getLog(AllTablesCursorFactory.class);
        private final AllTablesRecordCursor cursor;
        private final CharSequenceObjHashMap<CairoTable> tableCache = new CharSequenceObjHashMap();
        private long tableCacheVersion = -1L;

        public AllTablesCursorFactory() {
            super(METADATA);
            this.cursor = new AllTablesRecordCursor(this.tableCache);
        }

        @Override
        public RecordCursor getCursor(SqlExecutionContext executionContext) {
            CairoEngine engine = executionContext.getCairoEngine();
            try (MetadataCacheReader metadataRO = engine.getMetadataCache().readLock();){
                this.tableCacheVersion = metadataRO.snapshot(this.tableCache, this.tableCacheVersion);
            }
            this.cursor.toTop();
            return this.cursor;
        }

        @Override
        public boolean recordCursorSupportsRandomAccess() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.type("all_tables()");
        }

        @Override
        protected void _close() {
            this.cursor.close();
        }

        private static class AllTablesRecordCursor
        implements NoRandomAccessRecordCursor {
            private final AllTablesRecord record = new AllTablesRecord();
            private final CharSequenceObjHashMap<CairoTable> tableCache;
            private int iteratorIdx = -1;

            public AllTablesRecordCursor(CharSequenceObjHashMap<CairoTable> tableCache) {
                this.tableCache = tableCache;
            }

            @Override
            public void close() {
            }

            @Override
            public Record getRecord() {
                return this.record;
            }

            @Override
            public boolean hasNext() {
                if (this.iteratorIdx < this.tableCache.size() - 1) {
                    this.record.of(this.tableCache.getAt(++this.iteratorIdx));
                    return true;
                }
                return false;
            }

            @Override
            public long size() {
                return -1L;
            }

            @Override
            public long preComputedStateSize() {
                return 0L;
            }

            @Override
            public void toTop() {
                this.iteratorIdx = -1;
            }

            private static class AllTablesRecord
            implements Record {
                private CairoTable table;

                private AllTablesRecord() {
                }

                @Override
                public CharSequence getStrA(int col) {
                    return this.table.getTableName();
                }

                @Override
                public CharSequence getStrB(int col) {
                    return this.getStrA(col);
                }

                @Override
                public int getStrLen(int col) {
                    return this.getStrA(col).length();
                }

                public void of(CairoTable table) {
                    this.table = table;
                }
            }
        }
    }
}

