/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ImplicitCastException;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToShortFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class CastCharToShortFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Ae)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(args.getQuick(0));
    }

    public static class Func
    extends AbstractCastToShortFunction {
        public Func(Function arg) {
            super(arg);
        }

        @Override
        public short getShort(Record rec) {
            char c = this.arg.getChar(rec);
            byte v = (byte)(c - 48);
            if (v > -1 && v < 10) {
                return v;
            }
            throw ImplicitCastException.inconvertibleValue(c, 4, 3);
        }
    }
}

