/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.MultiArgFunction;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.bool.InTimestampIntervalFunctionFactory;
import io.questdb.griffin.model.IntervalUtils;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;

public class InTimestampTimestampFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "in(NV)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        boolean allConst = true;
        boolean allRuntimeConst = true;
        int n = args.size();
        for (int i = 1; i < n && (allConst || allRuntimeConst); ++i) {
            Function func = args.getQuick(i);
            switch (ColumnType.tagOf(func.getType())) {
                case 0: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 12: 
                case 26: 
                case 33: {
                    break;
                }
                case 32: {
                    return new InTimestampIntervalFunctionFactory.Func(args.getQuick(0), args.getQuick(1));
                }
                default: {
                    throw SqlException.position(argPositions.getQuick(i)).put("cannot compare TIMESTAMP with type ").put(ColumnType.nameOf(func.getType()));
                }
            }
            if (func.isConstant()) continue;
            allConst = false;
            if (func.isRuntimeConstant()) continue;
            allRuntimeConst = false;
        }
        boolean intervalSearch = InTimestampTimestampFunctionFactory.isIntervalSearch(args);
        if (allConst) {
            if (intervalSearch) {
                Function rightFn = args.getQuick(1);
                CharSequence right = rightFn.getStrA(null);
                return new EqTimestampStrConstantFunction(args.getQuick(0), right, argPositions.getQuick(1));
            }
            return new InTimestampConstFunction(args.getQuick(0), InTimestampTimestampFunctionFactory.parseDiscreteTimestampValues(args, argPositions));
        }
        if (allRuntimeConst) {
            if (intervalSearch) {
                return new InTimestampRuntimeConstIntervalFunction(args.getQuick(0), args.getQuick(1), argPositions.getQuick(1));
            }
            return new InTimestampManyRuntimeConstantsFunction(new ObjList<Function>(args));
        }
        if (intervalSearch) {
            return new EqTimestampStrFunction(args.get(0), args.get(1));
        }
        return new InTimestampVarFunction(new ObjList<Function>(args));
    }

    private static boolean isIntervalSearch(ObjList<Function> args) {
        if (args.size() != 2) {
            return false;
        }
        Function rightFn = args.getQuick(1);
        return ColumnType.isVarcharOrString(rightFn.getType());
    }

    private static LongList parseDiscreteTimestampValues(ObjList<Function> args, IntList argPositions) throws SqlException {
        LongList res = new LongList(args.size() - 1);
        res.extendAndSet(args.size() - 2, 0L);
        int n = args.size();
        for (int i = 1; i < n; ++i) {
            long val;
            Function func = args.getQuick(i);
            switch (ColumnType.tagOf(func.getType())) {
                case 7: {
                    val = func.getDate(null);
                    val = val == Long.MIN_VALUE ? val : val * 1000L;
                    break;
                }
                case 5: 
                case 6: 
                case 8: {
                    val = func.getTimestamp(null);
                    break;
                }
                case 11: 
                case 12: 
                case 26: 
                case 33: {
                    CharSequence tsValue = func.getStrA(null);
                    val = tsValue != null ? InTimestampTimestampFunctionFactory.tryParseTimestamp(tsValue, argPositions.getQuick(i)) : Long.MIN_VALUE;
                    break;
                }
                default: {
                    throw SqlException.inconvertibleTypes(argPositions.getQuick(i), func.getType(), ColumnType.nameOf(func.getType()), 8, ColumnType.nameOf(8));
                }
            }
            res.setQuick(i - 1, val);
        }
        res.sort();
        return res;
    }

    private static long tryParseTimestamp(CharSequence seq, int position) throws SqlException {
        try {
            return IntervalUtils.parseFloorPartialTimestamp(seq);
        }
        catch (NumericException e) {
            throw SqlException.invalidDate(seq, position);
        }
    }

    private static class EqTimestampStrConstantFunction
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final LongList intervals = new LongList();
        private final Function left;

        public EqTimestampStrConstantFunction(Function left, CharSequence right, int rightPosition) throws SqlException {
            this.left = left;
            IntervalUtils.parseAndApplyIntervalEx(right, this.intervals, rightPosition);
        }

        @Override
        public Function getArg() {
            return this.left;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != IntervalUtils.isInIntervals(this.intervals, this.left.getTimestamp(rec));
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.left);
            if (this.negated) {
                sink.val(" not");
            }
            sink.val(" in ").val(this.intervals);
        }
    }

    private static class InTimestampConstFunction
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final LongList inList;
        private final Function tsFunc;

        public InTimestampConstFunction(Function tsFunc, LongList longList) {
            this.tsFunc = tsFunc;
            this.inList = longList;
        }

        @Override
        public Function getArg() {
            return this.tsFunc;
        }

        @Override
        public boolean getBool(Record rec) {
            long ts = this.tsFunc.getTimestamp(rec);
            return this.negated != this.inList.binarySearch(ts, -1) >= 0;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.tsFunc);
            if (this.negated) {
                sink.val(" not");
            }
            sink.val(" in ").val(this.inList);
        }
    }

    private static class InTimestampRuntimeConstIntervalFunction
    extends NegatableBooleanFunction
    implements BinaryFunction {
        private final Function intervalFunc;
        private final int intervalFuncPos;
        private final LongList intervals = new LongList();
        private final Function left;

        public InTimestampRuntimeConstIntervalFunction(Function left, Function intervalFunc, int intervalFuncPos) {
            this.left = left;
            this.intervalFunc = intervalFunc;
            this.intervalFuncPos = intervalFuncPos;
        }

        @Override
        public boolean getBool(Record rec) {
            long ts = this.left.getTimestamp(rec);
            return ts == Long.MIN_VALUE ? this.negated : this.negated != IntervalUtils.isInIntervals(this.intervals, ts);
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public Function getRight() {
            return this.intervalFunc;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            BinaryFunction.super.init(symbolTableSource, executionContext);
            this.intervals.clear();
            switch (this.intervalFunc.getType()) {
                case 11: 
                case 26: {
                    IntervalUtils.parseAndApplyIntervalEx(this.intervalFunc.getStrA(null), this.intervals, 0);
                    break;
                }
                default: {
                    throw SqlException.$(this.intervalFuncPos, "unsupported bind variable type [").put(ColumnType.nameOf(this.intervalFunc.getType())).put("] expected one of [STRING or VARCHAR]");
                }
            }
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.left);
            if (this.negated) {
                sink.val(" not");
            }
            sink.val(" in ").val(this.intervalFunc);
        }
    }

    private static class InTimestampManyRuntimeConstantsFunction
    extends NegatableBooleanFunction
    implements MultiArgFunction {
        private final ObjList<Function> args;
        private final LongList timestampValues;

        public InTimestampManyRuntimeConstantsFunction(ObjList<Function> args) {
            this.args = args;
            this.timestampValues = new LongList(args.size());
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.args;
        }

        @Override
        public boolean getBool(Record rec) {
            long ts = this.args.getQuick(0).getTimestamp(rec);
            int n = this.timestampValues.size();
            for (int i = 0; i < n; ++i) {
                long val = this.timestampValues.getQuick(i);
                if (val != ts) continue;
                return !this.negated;
            }
            return this.negated;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            MultiArgFunction.super.init(symbolTableSource, executionContext);
            this.timestampValues.clear();
            int n = this.args.size();
            for (int i = 1; i < n; ++i) {
                Function func = this.args.getQuick(i);
                long val = Long.MIN_VALUE;
                switch (ColumnType.tagOf(func.getType())) {
                    case 5: 
                    case 6: 
                    case 8: {
                        val = func.getTimestamp(null);
                        break;
                    }
                    case 11: 
                    case 12: 
                    case 26: {
                        CharSequence str = func.getStrA(null);
                        val = str != null ? IntervalUtils.tryParseTimestamp(str) : Long.MIN_VALUE;
                    }
                }
                this.timestampValues.add(val);
            }
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.args.getQuick(0));
            if (this.negated) {
                sink.val(" not");
            }
            sink.val(" in ");
            sink.val(this.args, 1);
        }
    }

    private static class EqTimestampStrFunction
    extends NegatableBooleanFunction
    implements BinaryFunction {
        private final LongList intervals = new LongList();
        private final Function left;
        private final Function right;

        public EqTimestampStrFunction(Function left, Function right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean getBool(Record rec) {
            long ts = this.left.getTimestamp(rec);
            if (ts == Long.MIN_VALUE) {
                return this.negated;
            }
            CharSequence timestampAsString = this.right.getStrA(rec);
            if (timestampAsString == null) {
                return this.negated;
            }
            this.intervals.clear();
            try {
                IntervalUtils.parseAndApplyIntervalEx(timestampAsString, this.intervals, 0);
            }
            catch (SqlException e) {
                return this.negated;
            }
            return this.negated != IntervalUtils.isInIntervals(this.intervals, ts);
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public Function getRight() {
            return this.right;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.left);
            if (this.negated) {
                sink.val(" not");
            }
            sink.val(" in ").val(this.right);
        }
    }

    private static class InTimestampVarFunction
    extends NegatableBooleanFunction
    implements MultiArgFunction {
        private final ObjList<Function> args;

        public InTimestampVarFunction(ObjList<Function> args) {
            this.args = args;
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.args;
        }

        @Override
        public boolean getBool(Record rec) {
            long ts = this.args.getQuick(0).getTimestamp(rec);
            int n = this.args.size();
            for (int i = 1; i < n; ++i) {
                Function func = this.args.getQuick(i);
                long val = Long.MIN_VALUE;
                switch (ColumnType.tagOf(func.getType())) {
                    case 5: 
                    case 6: 
                    case 8: {
                        val = func.getTimestamp(rec);
                        break;
                    }
                    case 11: 
                    case 12: 
                    case 26: {
                        CharSequence str = func.getStrA(rec);
                        long l = val = str != null ? IntervalUtils.tryParseTimestamp(str) : Long.MIN_VALUE;
                    }
                }
                if (val != ts) continue;
                return !this.negated;
            }
            return this.negated;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.args.getQuick(0));
            if (this.negated) {
                sink.val(" not");
            }
            sink.val(" in ");
            sink.val(this.args, 1);
        }
    }
}

