/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.FunctionFactoryDescriptor;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class NegatingFunctionFactory
implements FunctionFactory {
    private final FunctionFactory delegate;
    private final String signature;

    public NegatingFunctionFactory(String name, FunctionFactory delegate) throws SqlException {
        this.signature = FunctionFactoryDescriptor.replaceSignatureName(name, delegate.getSignature());
        this.delegate = delegate;
    }

    public FunctionFactory getDelegate() {
        return this.delegate;
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function function = this.delegate.newInstance(position, args, argPositions, configuration, sqlExecutionContext);
        if (function instanceof NegatableBooleanFunction) {
            NegatableBooleanFunction negatableFunction = (NegatableBooleanFunction)function;
            negatableFunction.setNegated();
            return negatableFunction;
        }
        if (function instanceof BooleanConstant) {
            return BooleanConstant.of(!function.getBool(null));
        }
        throw SqlException.$(position, "negating operation is not supported for result of function ").put(this.delegate.getSignature());
    }
}

