/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text.types;

import io.questdb.cairo.TableWriter;
import io.questdb.cutlass.text.types.AbstractTypeAdapter;
import io.questdb.griffin.SqlKeywords;
import io.questdb.std.Long256Acceptor;
import io.questdb.std.Numbers;
import io.questdb.std.str.DirectUtf8Sequence;

public final class Long256Adapter
extends AbstractTypeAdapter {
    public static final Long256Adapter INSTANCE = new Long256Adapter();
    private static final Long256Acceptor NOOP_LONG256_BUILDER = (l0, l1, l2, l3) -> {};

    private Long256Adapter() {
    }

    @Override
    public int getType() {
        return 13;
    }

    @Override
    public boolean probe(DirectUtf8Sequence text) {
        return Numbers.extractLong256(text, NOOP_LONG256_BUILDER);
    }

    @Override
    public void write(TableWriter.Row row, int column, DirectUtf8Sequence value) {
        row.putLong256(column, SqlKeywords.isNullKeyword(value) ? null : value.asAsciiCharSequence());
    }
}

