/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text;

import io.questdb.cutlass.text.AbstractTextLexer;
import io.questdb.cutlass.text.TextConfiguration;
import io.questdb.std.SwarUtils;

public class GenericTextLexer
extends AbstractTextLexer {
    private byte delimiter;
    private long delimiterMask;

    public GenericTextLexer(TextConfiguration textConfiguration) {
        super(textConfiguration);
    }

    public void of(byte delimiter) {
        this.delimiter = delimiter;
        this.delimiterMask = SwarUtils.broadcast(delimiter);
    }

    @Override
    protected void doSwitch(long lo, long hi, byte b) throws AbstractTextLexer.LineLimitException {
        if (b == this.delimiter) {
            this.onColumnDelimiter(lo);
        } else if (b == 34) {
            this.onQuote();
        } else if (b == 10 || b == 13) {
            this.onLineEnd(hi);
        } else {
            this.checkEol(lo);
        }
    }

    @Override
    protected long getDelimiterMask() {
        return this.delimiterMask;
    }
}

