/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.pgwire;

import io.questdb.FactoryProvider;
import io.questdb.Metrics;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.SecurityContext;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableWriterAPI;
import io.questdb.cairo.pool.WriterSource;
import io.questdb.cairo.security.DenyAllSecurityContext;
import io.questdb.cairo.security.SecurityContextFactory;
import io.questdb.cairo.sql.BindVariableService;
import io.questdb.cairo.sql.NetworkSqlExecutionCircuitBreaker;
import io.questdb.cutlass.auth.AuthenticatorException;
import io.questdb.cutlass.auth.SocketAuthenticator;
import io.questdb.cutlass.pgwire.OptionsListener;
import io.questdb.cutlass.pgwire.PGConfiguration;
import io.questdb.cutlass.pgwire.PGMessageProcessingException;
import io.questdb.cutlass.pgwire.PGPipelineEntry;
import io.questdb.cutlass.pgwire.PGResponseSink;
import io.questdb.cutlass.pgwire.PGResumeCallback;
import io.questdb.cutlass.pgwire.TypesAndInsert;
import io.questdb.cutlass.pgwire.TypesAndSelect;
import io.questdb.griffin.BatchCallback;
import io.questdb.griffin.CharacterStore;
import io.questdb.griffin.CharacterStoreEntry;
import io.questdb.griffin.CompiledQuery;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlExecutionContextImpl;
import io.questdb.griffin.engine.functions.bind.BindVariableServiceImpl;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.SCSequence;
import io.questdb.network.IOContext;
import io.questdb.network.Net;
import io.questdb.network.NoSpaceLeftInResponseBufferException;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.network.PeerIsSlowToWriteException;
import io.questdb.network.QueryPausedException;
import io.questdb.network.SuspendEvent;
import io.questdb.network.TlsSessionInitFailedException;
import io.questdb.std.AssociativeCache;
import io.questdb.std.BinarySequence;
import io.questdb.std.DirectBinarySequence;
import io.questdb.std.FlyweightMessageContainer;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.ObjObjHashMap;
import io.questdb.std.ObjectPool;
import io.questdb.std.ObjectStackPool;
import io.questdb.std.Rnd;
import io.questdb.std.SimpleAssociativeCache;
import io.questdb.std.Unsafe;
import io.questdb.std.Utf8SequenceObjHashMap;
import io.questdb.std.Vect;
import io.questdb.std.WeakSelfReturningObjectPool;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.DirectUtf8String;
import io.questdb.std.str.StdoutSink;
import io.questdb.std.str.Utf16Sink;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8Sink;
import io.questdb.std.str.Utf8String;
import io.questdb.std.str.Utf8s;
import java.util.ArrayDeque;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PGConnectionContext
extends IOContext<PGConnectionContext>
implements WriterSource,
OptionsListener {
    public static final byte STATUS_IDLE = 73;
    public static final byte STATUS_IN_ERROR = 69;
    public static final byte STATUS_IN_TRANSACTION = 84;
    public static final String TAG_ALTER_ROLE = "ALTER ROLE";
    public static final String TAG_BEGIN = "BEGIN";
    public static final String TAG_COMMIT = "COMMIT";
    public static final String TAG_CREATE_ROLE = "CREATE ROLE";
    public static final String TAG_DEALLOCATE = "DEALLOCATE";
    public static final String TAG_EXPLAIN = "EXPLAIN";
    public static final String TAG_INSERT = "INSERT";
    public static final String TAG_INSERT_AS_SELECT = "TAG_INSERT_AS_SELECT";
    public static final String TAG_OK = "OK";
    public static final String TAG_PSEUDO_SELECT = "PSEUDO_SELECT";
    public static final String TAG_ROLLBACK = "ROLLBACK";
    public static final String TAG_SELECT = "SELECT";
    public static final String TAG_SET = "SET";
    public static final String TAG_UPDATE = "UPDATE";
    static final int ERROR_TRANSACTION = 3;
    static final int IMPLICIT_TRANSACTION = 0;
    static final int INT_BYTES_X = Numbers.bswap(4);
    static final int INT_NULL_X = Numbers.bswap(-1);
    static final int IN_TRANSACTION = 1;
    static final byte MESSAGE_TYPE_BIND_COMPLETE = 50;
    static final byte MESSAGE_TYPE_CLOSE_COMPLETE = 51;
    static final byte MESSAGE_TYPE_COMMAND_COMPLETE = 67;
    static final byte MESSAGE_TYPE_DATA_ROW = 68;
    static final byte MESSAGE_TYPE_EMPTY_QUERY = 73;
    static final byte MESSAGE_TYPE_ERROR_RESPONSE = 69;
    static final byte MESSAGE_TYPE_NO_DATA = 110;
    static final byte MESSAGE_TYPE_PARAMETER_DESCRIPTION = 116;
    static final byte MESSAGE_TYPE_PARSE_COMPLETE = 49;
    static final byte MESSAGE_TYPE_PORTAL_SUSPENDED = 115;
    static final byte MESSAGE_TYPE_ROW_DESCRIPTION = 84;
    private static final int CACHE_HIT_INSERT_INVALID = 1;
    private static final int CACHE_HIT_INSERT_VALID = 2;
    private static final int CACHE_HIT_SELECT_INVALID = 3;
    private static final int CACHE_HIT_SELECT_VALID = 4;
    private static final int CACHE_MISS = 0;
    private static final Log LOG = LogFactory.getLog(PGConnectionContext.class);
    private static final long MALFORMED_CLIENT_READ_TIMEOUT_MILLIS = 5000L;
    private static final byte MESSAGE_TYPE_READY_FOR_QUERY = 90;
    private static final byte MESSAGE_TYPE_SSL_SUPPORTED_RESPONSE = 83;
    private static final int PREFIXED_MESSAGE_HEADER_LEN = 5;
    private static final int PROTOCOL_TAIL_COMMAND_LENGTH = 64;
    private static final int SSL_REQUEST = 80877103;
    private final BatchCallback batchCallback;
    private final ObjectPool<DirectBinarySequence> binarySequenceParamsPool;
    private final BindVariableService bindVariableService;
    private final IntList bindVariableTypes = new IntList();
    private final CharacterStore bindVariableValuesCharacterStore;
    private final NetworkSqlExecutionCircuitBreaker circuitBreaker;
    private final PGConfiguration configuration;
    private final DirectUtf8String directUtf8NamedPortal = new DirectUtf8String();
    private final DirectUtf8String directUtf8NamedStatement = new DirectUtf8String();
    private final boolean dumpNetworkTraffic;
    private final CairoEngine engine;
    private final ObjectStackPool<PGPipelineEntry> entryPool;
    private final int forceRecvFragmentationChunkSize;
    private final int forceSendFragmentationChunkSize;
    private final int maxBlobSize;
    private final Metrics metrics;
    private final Utf8SequenceObjHashMap<PGPipelineEntry> namedPortals;
    private final Utf8SequenceObjHashMap<PGPipelineEntry> namedStatements;
    private final ObjObjHashMap<TableToken, TableWriterAPI> pendingWriters;
    private final ArrayDeque<PGPipelineEntry> pipeline = new ArrayDeque();
    private final Consumer<? super Utf8Sequence> preparedStatementDeallocator = this::deallocateNamedStatement;
    private final ResponseUtf8Sink responseUtf8Sink = new ResponseUtf8Sink();
    private final Rnd rnd;
    private final SecurityContextFactory securityContextFactory;
    private final SqlExecutionContextImpl sqlExecutionContext;
    private final CharacterStore sqlTextCharacterStore;
    private final WeakSelfReturningObjectPool<TypesAndInsert> taiPool;
    private final SCSequence tempSequence = new SCSequence();
    private final DirectUtf8String utf8String = new DirectUtf8String();
    private SocketAuthenticator authenticator;
    private int bufferRemainingOffset = 0;
    private int bufferRemainingSize = 0;
    private boolean freezeRecvBuffer;
    private int namedStatementLimit;
    private PGPipelineEntry pipelineCurrentEntry;
    private long recvBuffer;
    private long recvBufferReadOffset = 0L;
    private int recvBufferSize;
    private long recvBufferWriteOffset = 0L;
    private PGResumeCallback resumeCallback;
    private long sendBuffer;
    private long sendBufferLimit;
    private long sendBufferPtr;
    private int sendBufferSize;
    private SuspendEvent suspendEvent;
    private final AssociativeCache<TypesAndSelect> tasCache;
    private SimpleAssociativeCache<TypesAndInsert> taiCache;
    private final PGResumeCallback msgFlushRef = this::msgFlush0;
    private boolean tlsSessionStarting = false;
    private long totalReceived = 0L;
    private int transactionState = 0;
    private final PGResumeCallback msgSyncRef = this::msgSync0;

    public PGConnectionContext(CairoEngine engine, PGConfiguration configuration, SqlExecutionContextImpl sqlExecutionContext, NetworkSqlExecutionCircuitBreaker circuitBreaker, AssociativeCache<TypesAndSelect> tasCache) {
        super(configuration.getFactoryProvider().getPGWireSocketFactory(), configuration.getNetworkFacade(), LOG);
        try {
            this.engine = engine;
            this.configuration = configuration;
            this.bindVariableService = new BindVariableServiceImpl(engine.getConfiguration());
            this.recvBufferSize = configuration.getRecvBufferSize();
            this.sendBufferSize = configuration.getSendBufferSize();
            this.forceSendFragmentationChunkSize = configuration.getForceSendFragmentationChunkSize();
            this.forceRecvFragmentationChunkSize = configuration.getForceRecvFragmentationChunkSize();
            this.sqlTextCharacterStore = new CharacterStore(configuration.getCharacterStoreCapacity(), configuration.getCharacterStorePoolCapacity());
            this.bindVariableValuesCharacterStore = new CharacterStore(configuration.getCharacterStoreCapacity(), configuration.getCharacterStorePoolCapacity());
            this.maxBlobSize = configuration.getMaxBlobSizeOnQuery();
            this.dumpNetworkTraffic = configuration.getDumpNetworkTraffic();
            this.circuitBreaker = circuitBreaker;
            this.sqlExecutionContext = sqlExecutionContext;
            this.rnd = configuration.getRandom();
            this.sqlExecutionContext.with(DenyAllSecurityContext.INSTANCE, this.bindVariableService, this.rnd);
            this.namedStatements = new Utf8SequenceObjHashMap(configuration.getNamedStatementCacheCapacity());
            this.pendingWriters = new ObjObjHashMap(configuration.getPendingWritersCacheSize());
            this.namedPortals = new Utf8SequenceObjHashMap(configuration.getNamedStatementCacheCapacity());
            this.binarySequenceParamsPool = new ObjectPool<DirectBinarySequence>(DirectBinarySequence::new, configuration.getBinParamCountCapacity());
            this.metrics = engine.getMetrics();
            this.tasCache = tasCache;
            this.entryPool = new ObjectStackPool<PGPipelineEntry>(() -> new PGPipelineEntry(engine), configuration.getPipelineCapacity());
            boolean enableInsertCache = configuration.isInsertCacheEnabled();
            int insertBlockCount = enableInsertCache ? configuration.getInsertCacheBlockCount() : 1;
            int insertRowCount = enableInsertCache ? configuration.getInsertCacheRowCount() : 1;
            this.taiCache = new SimpleAssociativeCache(insertBlockCount, insertRowCount);
            this.taiPool = new WeakSelfReturningObjectPool<TypesAndInsert>(TypesAndInsert::new, insertBlockCount * insertRowCount);
            this.namedStatementLimit = configuration.getNamedStatementLimit();
            this.batchCallback = new PGConnectionBatchCallback();
            FactoryProvider factoryProvider = configuration.getFactoryProvider();
            this.securityContextFactory = factoryProvider.getSecurityContextFactory();
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    public static long getLongUnsafe(long address) {
        return Numbers.bswap(Unsafe.getUnsafe().getLong(address));
    }

    public static long getStringLengthTedious(long x, long limit) {
        for (long i = x; i < limit; ++i) {
            if (Unsafe.getUnsafe().getByte(i) != 0) continue;
            return i;
        }
        return -1L;
    }

    public static long getUtf8StrSize(long x, long limit, CharSequence errorMessage, @Nullable PGPipelineEntry pe) throws PGMessageProcessingException {
        long len;
        long l = len = Unsafe.getUnsafe().getByte(x) == 0 ? x : PGConnectionContext.getStringLengthTedious(x, limit);
        if (len > -1L) {
            return len;
        }
        if (pe != null) {
            pe.getErrorMessageSink().put(errorMessage);
        } else {
            LOG.error().$(errorMessage).$();
        }
        throw PGMessageProcessingException.INSTANCE;
    }

    public static void putInt(long address, int value) {
        Unsafe.getUnsafe().putInt(address, Numbers.bswap(value));
    }

    public static void putLong(long address, long value) {
        Unsafe.getUnsafe().putLong(address, Numbers.bswap(value));
    }

    public static void putShort(long address, short value) {
        Unsafe.getUnsafe().putShort(address, Numbers.bswap(value));
    }

    @Override
    public void clear() {
        super.clear();
        do {
            if (this.pipelineCurrentEntry == null || this.pipelineCurrentEntry.isPreparedStatement() || this.pipelineCurrentEntry.isPortal()) continue;
            this.releaseToPool(this.pipelineCurrentEntry);
        } while ((this.pipelineCurrentEntry = this.pipeline.poll()) != null);
        this.freePipelineEntriesFrom(this.namedStatements, true);
        this.freePipelineEntriesFrom(this.namedPortals, false);
        this.recvBuffer = Unsafe.free(this.recvBuffer, this.recvBufferSize, 48);
        this.sendBufferPtr = this.sendBufferLimit = Unsafe.free(this.sendBuffer, this.sendBufferSize, 48);
        this.sendBuffer = this.sendBufferLimit;
        this.responseUtf8Sink.bookmarkPtr = this.sendBufferPtr;
        this.prepareForNewQuery();
        this.clearRecvBuffer();
        this.clearWriters();
        Misc.clear(this.bindVariableTypes);
        Misc.clear(this.sqlTextCharacterStore);
        Misc.clear(this.bindVariableValuesCharacterStore);
        Misc.clear(this.circuitBreaker);
        Misc.clear(this.responseUtf8Sink);
        Misc.clear(this.pendingWriters);
        Misc.clear(this.authenticator);
        Misc.clear(this.bindVariableService);
        this.bufferRemainingOffset = 0;
        this.bufferRemainingSize = 0;
        this.freezeRecvBuffer = false;
        this.resumeCallback = null;
        this.suspendEvent = null;
        this.tlsSessionStarting = false;
        this.totalReceived = 0L;
        this.transactionState = 0;
        this.entryPool.resetCapacity();
    }

    @Override
    public void clearSuspendEvent() {
        this.suspendEvent = Misc.free(this.suspendEvent);
    }

    public void clearWriters() {
        if (this.pendingWriters != null) {
            this.rollbackAndClosePendingWriters();
            this.pendingWriters.clear();
        }
    }

    @Override
    public void close() {
        this.clear();
        if (this.sqlExecutionContext != null) {
            this.sqlExecutionContext.with(DenyAllSecurityContext.INSTANCE, null, null, -1L, null);
        }
        this.authenticator = Misc.free(this.authenticator);
        this.taiCache = Misc.free(this.taiCache);
    }

    @Override
    public SuspendEvent getSuspendEvent() {
        return this.suspendEvent;
    }

    @Override
    public TableWriterAPI getTableWriterAPI(TableToken tableToken, @NotNull String lockReason) {
        int index = this.pendingWriters.keyIndex(tableToken);
        if (index < 0) {
            return this.pendingWriters.valueAt(index);
        }
        return this.engine.getTableWriterAPI(tableToken, lockReason);
    }

    @Override
    public TableWriterAPI getTableWriterAPI(CharSequence tableName, @NotNull String lockReason) {
        return this.getTableWriterAPI(this.engine.verifyTableName(tableName), lockReason);
    }

    public void handleClientOperation(int operation) throws Exception {
        assert (this.authenticator != null);
        try {
            this.handleTlsRequest();
            if (this.tlsSessionStarting) {
                this.flushRemainingBuffer();
                this.tlsSessionStarting = false;
                try {
                    this.socket.startTlsSession(null);
                }
                catch (TlsSessionInitFailedException e) {
                    LOG.error().$("failed to create new TLS session").$(e).$();
                    throw PGMessageProcessingException.INSTANCE;
                }
                throw PeerIsSlowToWriteException.INSTANCE;
            }
            this.handleAuthentication();
        }
        catch (PeerDisconnectedException | PeerIsSlowToReadException | PeerIsSlowToWriteException e) {
            throw e;
        }
        catch (PGMessageProcessingException bpe) {
            this.shutdownSocketGracefully();
            throw bpe;
        }
        catch (Throwable th) {
            this.metrics.pgWireMetrics().getErrorCounter().inc();
            throw th;
        }
        this.flushRemainingBuffer();
        if (this.resumeCallback != null) {
            this.resumeCallback.resume();
        }
        long readOffsetBeforeParse = -1L;
        while (true) {
            if (readOffsetBeforeParse == this.recvBufferReadOffset || this.recvBufferReadOffset == this.recvBufferWriteOffset || operation == 1 && readOffsetBeforeParse == -1L) {
                if (!this.freezeRecvBuffer) {
                    if (this.recvBufferReadOffset == this.recvBufferWriteOffset) {
                        this.clearRecvBuffer();
                    } else if (this.recvBufferReadOffset > 0L) {
                        this.shiftReceiveBuffer(this.recvBufferReadOffset);
                    }
                }
                this.recv();
            }
            readOffsetBeforeParse = this.recvBufferReadOffset;
            this.totalReceived += this.recvBufferWriteOffset - this.recvBufferReadOffset;
            try {
                this.parseMessage(this.recvBuffer + this.recvBufferReadOffset, (int)(this.recvBufferWriteOffset - this.recvBufferReadOffset));
                continue;
            }
            catch (PGMessageProcessingException e) {
                LOG.error().$("failed to parse message [err: `").$safe(e.getFlyweightMessage()).$("`]").$();
                continue;
            }
            break;
        }
    }

    public void setAuthenticator(SocketAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    @Override
    public void setSqlTimeout(long sqlTimeout) {
        if (sqlTimeout > 0L) {
            this.circuitBreaker.setTimeout(sqlTimeout);
        }
    }

    public void setSuspendEvent(SuspendEvent suspendEvent) {
        this.suspendEvent = suspendEvent;
    }

    private static void sendErrorResponseAndReset(PGResponseSink sink, CharSequence message) throws PeerIsSlowToReadException, PeerDisconnectedException {
        sink.put((byte)69);
        long addr = sink.skipInt();
        sink.put('C');
        sink.putZ("08P01");
        sink.put('M');
        sink.putZ(message);
        sink.put('S');
        sink.putZ("ERROR");
        sink.put('\u0000');
        sink.putLen(addr);
        sink.sendBufferAndReset();
    }

    private void addPipelineEntry() {
        if (this.pipelineCurrentEntry != null) {
            this.pipeline.add(this.pipelineCurrentEntry);
            this.pipelineCurrentEntry = null;
        }
    }

    private void assertBufferSize(boolean check) throws PGMessageProcessingException {
        if (check) {
            return;
        }
        LOG.error().$("undersized receive buffer or someone is abusing protocol [recvBufferSize=").$(this.recvBufferSize).$(']').$();
        throw PGMessageProcessingException.INSTANCE;
    }

    private void clearRecvBuffer() {
        this.recvBufferWriteOffset = 0L;
        this.recvBufferReadOffset = 0L;
    }

    private void deallocateNamedStatement(Utf8Sequence statementName) {
        PGPipelineEntry pe = this.removeNamedStatementFromCache(statementName);
        this.releaseToPool(pe);
    }

    private void doSendWithRetries(int bufferOffset, int bufferSize) throws PeerDisconnectedException, PeerIsSlowToReadException {
        int offset = bufferOffset;
        int remaining = bufferSize;
        while (remaining > 0) {
            int m = this.socket.send(this.sendBuffer + (long)offset, Math.min(remaining, this.forceSendFragmentationChunkSize));
            if (m < 0) {
                LOG.info().$("disconnected on write [code=").$(m).I$();
                throw PeerDisconnectedException.INSTANCE;
            }
            PGConnectionContext.dumpBuffer('<', this.sendBuffer + (long)offset, m, this.dumpNetworkTraffic);
            remaining -= m;
            offset += m;
            if (m != 0 && this.forceSendFragmentationChunkSize >= this.sendBufferSize) continue;
            break;
        }
        if (remaining > 0) {
            this.bufferRemainingOffset = offset;
            this.bufferRemainingSize = remaining;
            throw PeerIsSlowToReadException.INSTANCE;
        }
    }

    private void flushRemainingBuffer() throws PeerDisconnectedException, PeerIsSlowToReadException {
        if (this.bufferRemainingSize > 0) {
            this.sendBuffer(this.bufferRemainingOffset, this.bufferRemainingSize);
        }
    }

    private void freePipelineEntriesFrom(Utf8SequenceObjHashMap<PGPipelineEntry> cache, boolean isStatementClose) {
        ObjList<Utf8String> names = cache.keys();
        int n = names.size();
        for (int i = 0; i < n; ++i) {
            PGPipelineEntry pe = cache.get(names.getQuick(i));
            pe.setStateClosed(true, isStatementClose);
            pe.cacheIfPossible(this.tasCache, this.taiCache);
            this.releaseToPool(pe);
        }
        cache.clear();
    }

    @Nullable
    private Utf8Sequence getUtf8NamedPortal(long lo, long hi) {
        if (hi - lo > 0L) {
            return this.directUtf8NamedPortal.of(lo, hi);
        }
        return null;
    }

    @Nullable
    private Utf8Sequence getUtf8NamedStatement(long lo, long hi) {
        if (hi - lo > 0L) {
            return this.directUtf8NamedStatement.of(lo, hi);
        }
        return null;
    }

    private void handleAuthentication() throws PeerIsSlowToWriteException, PeerIsSlowToReadException, PGMessageProcessingException, PeerDisconnectedException {
        int r;
        if (this.authenticator.isAuthenticated()) {
            return;
        }
        try {
            r = this.authenticator.handleIO();
            if (r == -1) {
                try {
                    SecurityContext securityContext = this.securityContextFactory.getInstance(this.authenticator.getPrincipal(), this.authenticator.getGroups(), this.authenticator.getAuthType(), (byte)1);
                    this.sqlExecutionContext.with(securityContext, this.bindVariableService, this.rnd, this.getFd(), this.circuitBreaker);
                    securityContext.checkEntityEnabled();
                    r = this.authenticator.loginOK();
                }
                catch (CairoException e) {
                    LOG.error().$("failed to authenticate [error=").$safe(e.getFlyweightMessage()).I$();
                    r = this.authenticator.denyAccess(e.getFlyweightMessage());
                }
            }
        }
        catch (AuthenticatorException e) {
            throw PeerDisconnectedException.INSTANCE;
        }
        switch (r) {
            case -1: {
                assert (this.authenticator.isAuthenticated());
                break;
            }
            case 0: {
                throw PeerIsSlowToWriteException.INSTANCE;
            }
            case 1: {
                throw PeerIsSlowToReadException.INSTANCE;
            }
            case 3: {
                throw PeerDisconnectedException.INSTANCE;
            }
            default: {
                throw PGMessageProcessingException.INSTANCE;
            }
        }
        this.recvBufferWriteOffset = this.authenticator.getRecvBufPos() - this.recvBuffer;
        this.recvBufferReadOffset = this.authenticator.getRecvBufPseudoStart() - this.recvBuffer;
    }

    private void handleTlsRequest() throws PeerIsSlowToWriteException, PeerIsSlowToReadException, PGMessageProcessingException, PeerDisconnectedException {
        if (!this.socket.supportsTls() || this.tlsSessionStarting || this.socket.isTlsSessionStarted()) {
            return;
        }
        if (this.bufferRemainingSize > 0) {
            this.sendBuffer(this.bufferRemainingOffset, this.bufferRemainingSize);
            throw PGMessageProcessingException.INSTANCE;
        }
        this.recv();
        int expectedLen = 8;
        int len = (int)(this.recvBufferWriteOffset - this.recvBufferReadOffset);
        if (len < expectedLen) {
            throw PeerIsSlowToWriteException.INSTANCE;
        }
        if (len != expectedLen) {
            LOG.error().$("request SSL message expected [actualLen=").$(len).I$();
            PGConnectionContext.sendErrorResponseAndReset(this.responseUtf8Sink, "request SSL message expected");
            throw PGMessageProcessingException.INSTANCE;
        }
        long address = this.recvBuffer + this.recvBufferReadOffset;
        int msgLen = PGConnectionContext.getIntUnsafe(address);
        this.recvBufferReadOffset += 4L;
        address += 4L;
        if (msgLen != expectedLen) {
            LOG.error().$("unexpected request SSL message [msgLen=").$(msgLen).I$();
            PGConnectionContext.sendErrorResponseAndReset(this.responseUtf8Sink, "unexpected request SSL message");
            throw PGMessageProcessingException.INSTANCE;
        }
        int request = PGConnectionContext.getIntUnsafe(address);
        this.recvBufferReadOffset += 4L;
        if (request != 80877103) {
            LOG.error().$("unexpected request SSL message [request=").$(msgLen).I$();
            PGConnectionContext.sendErrorResponseAndReset(this.responseUtf8Sink, "unexpected request SSL message");
            throw PGMessageProcessingException.INSTANCE;
        }
        this.responseUtf8Sink.put((byte)83);
        this.tlsSessionStarting = true;
        this.responseUtf8Sink.sendBufferAndReset();
    }

    private void lookupPipelineEntryForNamedPortal(@Nullable Utf8Sequence namedPortal) throws PGMessageProcessingException {
        if (namedPortal != null) {
            PGPipelineEntry pe = this.namedPortals.get(namedPortal);
            if (pe == null) {
                throw this.msgKaput().put(" portal does not exist [name=").put(namedPortal).put(']');
            }
            this.replaceCurrentPipelineEntry(pe);
        }
    }

    private void lookupPipelineEntryForNamedStatement(long lo, long hi) throws PGMessageProcessingException {
        @Nullable Utf8Sequence namedStatement = this.getUtf8NamedStatement(lo, hi);
        if (namedStatement != null) {
            PGPipelineEntry pe = this.namedStatements.get(namedStatement);
            if (pe == null) {
                throw this.msgKaput().put("statement or portal does not exist [name=").put(namedStatement).put(']');
            }
            this.replaceCurrentPipelineEntry(pe);
        }
    }

    private void msgBind(long lo, long msgLimit) throws PGMessageProcessingException {
        if (this.pipelineCurrentEntry != null && this.pipelineCurrentEntry.isError()) {
            return;
        }
        if (this.pipelineCurrentEntry != null && (this.pipelineCurrentEntry.isStateExec() || this.pipelineCurrentEntry.isStateClosed())) {
            this.pipeline.add(this.pipelineCurrentEntry);
            this.pipelineCurrentEntry = null;
        }
        long hi = PGConnectionContext.getUtf8StrSize(lo, msgLimit, "bad portal name length (bind)", this.pipelineCurrentEntry);
        Utf8Sequence namedPortal = this.getUtf8NamedPortal(lo, hi);
        lo = hi + 1L;
        hi = PGConnectionContext.getUtf8StrSize(lo, msgLimit, "bad prepared statement name length [msgType='B']", this.pipelineCurrentEntry);
        this.lookupPipelineEntryForNamedStatement(lo, hi);
        if (this.pipelineCurrentEntry == null) {
            throw this.msgKaput().put("received a Bind message without a matching Parse");
        }
        this.pipelineCurrentEntry.setStateBind(true);
        if (namedPortal != null) {
            LOG.info().$("create portal [name=").$(namedPortal).I$();
            int index = this.namedPortals.keyIndex(namedPortal);
            if (index > -1) {
                Utf8String immutableNamedPortal = Utf8String.newInstance(namedPortal);
                if (this.pipelineCurrentEntry.isPreparedStatement()) {
                    PGPipelineEntry pe = this.entryPool.next();
                    pe.msgParseCopyParameterTypesFrom(this.pipelineCurrentEntry);
                    int cachedStatus = 0;
                    TypesAndSelect tas = this.tasCache.poll(this.pipelineCurrentEntry.getSqlText());
                    if (tas != null) {
                        if (pe.msgParseReconcileParameterTypes(tas)) {
                            pe.ofCachedSelect(this.pipelineCurrentEntry.getSqlText(), tas);
                            cachedStatus = 4;
                        } else {
                            tas.close();
                            cachedStatus = 3;
                        }
                    }
                    if (cachedStatus != 4) {
                        pe.compileNewSQL(this.pipelineCurrentEntry.getSqlText(), this.engine, this.sqlExecutionContext, this.taiPool, false);
                    }
                    pe.setParentPreparedStatement(this.pipelineCurrentEntry);
                    pe.copyStateFrom(this.pipelineCurrentEntry);
                    this.pipelineCurrentEntry.bindPortalName(immutableNamedPortal);
                    this.pipelineCurrentEntry.clearState();
                    this.pipelineCurrentEntry = pe;
                    this.pipelineCurrentEntry.setStateBind(true);
                }
                this.pipelineCurrentEntry.setNamedPortal(true, immutableNamedPortal);
                this.namedPortals.putAt(index, namedPortal, this.pipelineCurrentEntry);
            } else {
                throw this.msgKaput().put("portal already exists [namedPortal=").put(namedPortal).put(']');
            }
        }
        lo = hi + 1L;
        short parameterFormatCodeCount = this.pipelineCurrentEntry.getShort(lo, msgLimit, "could not read parameter format code count");
        short parameterValueCount = this.pipelineCurrentEntry.getShort((lo += 2L) + (long)(parameterFormatCodeCount * 2), msgLimit, "could not read parameter value count");
        this.pipelineCurrentEntry.msgBindCopyParameterFormatCodes(lo, msgLimit, parameterFormatCodeCount, parameterValueCount);
        lo += (long)(parameterFormatCodeCount * 2);
        lo += 2L;
        lo = this.pipelineCurrentEntry.msgBindCopyParameterValuesArea(lo, msgLimit);
        short columnFormatCodeCount = this.pipelineCurrentEntry.getShort(lo, msgLimit, "could not read result set column format codes");
        this.pipelineCurrentEntry.msgBindCopySelectFormatCodes(lo += 2L, columnFormatCodeCount);
    }

    private void msgClose(long lo, long msgLimit) throws PGMessageProcessingException {
        PGPipelineEntry lookedUpPipelineEntry;
        byte type = Unsafe.getUnsafe().getByte(lo);
        boolean isStatementClose = false;
        switch (type) {
            case 83: {
                long hi = PGConnectionContext.getUtf8StrSize(++lo, msgLimit, "bad prepared statement name length", this.pipelineCurrentEntry);
                lookedUpPipelineEntry = this.removeNamedStatementFromCache(this.getUtf8NamedStatement(lo, hi));
                isStatementClose = true;
                break;
            }
            case 80: {
                long high = PGConnectionContext.getUtf8StrSize(++lo, msgLimit, "bad prepared portal name length (close)", this.pipelineCurrentEntry);
                lookedUpPipelineEntry = this.removeNamedPortalFromCache(this.getUtf8NamedPortal(lo, high));
                break;
            }
            default: {
                throw this.msgKaput().put("invalid type for close message [type=").put(type).put(']');
            }
        }
        if (lookedUpPipelineEntry == null) {
            if (this.pipelineCurrentEntry == null) {
                this.pipelineCurrentEntry = this.entryPool.next();
            }
        } else if (lookedUpPipelineEntry != this.pipelineCurrentEntry) {
            if (this.pipelineCurrentEntry != null) {
                if (this.pipelineCurrentEntry.isDirty()) {
                    this.addPipelineEntry();
                } else {
                    this.releaseToPoolIfAbandoned(this.pipelineCurrentEntry);
                }
            }
            this.pipelineCurrentEntry = lookedUpPipelineEntry;
        }
        this.pipelineCurrentEntry.setStateClosed(true, isStatementClose);
    }

    private void msgDescribe(long lo, long msgLimit) throws PGMessageProcessingException {
        if (this.pipelineCurrentEntry != null && this.pipelineCurrentEntry.isError()) {
            return;
        }
        boolean isPortal = Unsafe.getUnsafe().getByte(lo) == 80;
        long hi = PGConnectionContext.getUtf8StrSize(lo + 1L, msgLimit, "bad prepared statement name length (describe)", this.pipelineCurrentEntry);
        if (isPortal) {
            this.lookupPipelineEntryForNamedPortal(this.getUtf8NamedPortal(lo + 1L, hi));
        } else {
            this.lookupPipelineEntryForNamedStatement(lo + 1L, hi);
        }
        if (this.pipelineCurrentEntry == null) {
            throw this.msgKaput().put("spurious describe message received");
        }
        this.pipelineCurrentEntry.setStateDesc(isPortal ? 1 : 2);
    }

    private void msgExecute(long lo, long msgLimit) throws PGMessageProcessingException {
        if (this.pipelineCurrentEntry != null && this.pipelineCurrentEntry.isError()) {
            return;
        }
        long hi = PGConnectionContext.getUtf8StrSize(lo, msgLimit, "bad portal name length (execute)", this.pipelineCurrentEntry);
        this.lookupPipelineEntryForNamedPortal(this.getUtf8NamedPortal(lo, hi));
        if (this.pipelineCurrentEntry == null) {
            throw this.msgKaput().put("spurious execute message");
        }
        lo = hi + 1L;
        this.pipelineCurrentEntry.setReturnRowCountLimit(this.pipelineCurrentEntry.getInt(lo, msgLimit, "could not read max rows value"));
        this.pipelineCurrentEntry.setStateExec(true);
        this.sqlExecutionContext.initNow();
        this.transactionState = this.pipelineCurrentEntry.msgExecute(this.sqlExecutionContext, this.transactionState, this.taiPool, this.pendingWriters, this, this.bindVariableValuesCharacterStore, this.utf8String, this.binarySequenceParamsPool, this.tempSequence, this.preparedStatementDeallocator);
    }

    private void msgFlush() throws PeerIsSlowToReadException, PeerDisconnectedException, QueryPausedException {
        this.addPipelineEntry();
        this.resumeCallback = this.msgFlushRef;
        this.msgFlush0();
    }

    private void msgFlush0() throws PeerIsSlowToReadException, PeerDisconnectedException, QueryPausedException {
        this.syncPipeline();
        this.resumeCallback = null;
        this.responseUtf8Sink.sendBufferAndReset();
    }

    private PGMessageProcessingException msgKaput() {
        if (this.pipelineCurrentEntry == null) {
            this.pipelineCurrentEntry = this.entryPool.next();
        }
        return PGMessageProcessingException.instance(this.pipelineCurrentEntry);
    }

    private void msgParse(long address, long lo, long msgLimit) throws PGMessageProcessingException {
        TypesAndSelect tas;
        if (this.pipelineCurrentEntry != null && this.pipelineCurrentEntry.isError()) {
            return;
        }
        this.addPipelineEntry();
        this.pipelineCurrentEntry = this.entryPool.next();
        this.bindVariableService.clear();
        this.pipelineCurrentEntry.setStateParse(true);
        long hi = PGConnectionContext.getUtf8StrSize(lo, msgLimit, "bad prepared statement name length (parse)", this.pipelineCurrentEntry);
        Utf8Sequence namedStatement = this.getUtf8NamedStatement(lo, hi);
        lo = hi + 1L;
        hi = PGConnectionContext.getUtf8StrSize(lo, msgLimit, "bad query text length", this.pipelineCurrentEntry);
        CharacterStoreEntry e = this.sqlTextCharacterStore.newEntry();
        if (!Utf8s.utf8ToUtf16(lo, hi, e)) {
            throw this.msgKaput().put("invalid UTF8 bytes in parse query");
        }
        CharSequence utf16SqlText = e.toImmutable();
        lo = hi + 1L;
        short parameterTypeCount = this.pipelineCurrentEntry.getShort(lo, msgLimit, "could not read parameter type count");
        if (parameterTypeCount > 0) {
            if (lo + 2L + (long)parameterTypeCount * 4L > msgLimit) {
                throw this.msgKaput().put("could not read parameters [parameterCount=").put(parameterTypeCount).put(", offset=").put(lo - address).put(", remaining=").put(msgLimit - lo);
            }
            LOG.debug().$("params [count=").$(parameterTypeCount).I$();
            this.pipelineCurrentEntry.msgParseCopyParameterTypesFromMsg(lo + 2L, parameterTypeCount);
        } else if (parameterTypeCount < 0) {
            throw this.msgKaput().put("invalid parameter count [parameterCount=").put(parameterTypeCount).put(", offset=").put(lo - address);
        }
        int cachedStatus = 0;
        TypesAndInsert tai = this.taiCache.poll(utf16SqlText);
        if (tai != null) {
            if (this.pipelineCurrentEntry.msgParseReconcileParameterTypes(parameterTypeCount, tai)) {
                this.pipelineCurrentEntry.ofCachedInsert(utf16SqlText, tai);
                cachedStatus = 2;
            } else {
                tai.close();
                cachedStatus = 1;
            }
        }
        if (cachedStatus == 0 && (tas = this.tasCache.poll(utf16SqlText)) != null) {
            if (this.pipelineCurrentEntry.msgParseReconcileParameterTypes(parameterTypeCount, tas)) {
                this.pipelineCurrentEntry.ofCachedSelect(utf16SqlText, tas);
                cachedStatus = 4;
                this.sqlExecutionContext.resetFlags();
            } else {
                tas.close();
                cachedStatus = 3;
            }
        }
        if (cachedStatus != 2 && cachedStatus != 4) {
            this.pipelineCurrentEntry.compileNewSQL(utf16SqlText, this.engine, this.sqlExecutionContext, this.taiPool, false);
        }
        this.msgParseCreateNamedStatement(namedStatement);
    }

    private void msgParseCreateNamedStatement(Utf8Sequence namedStatement) throws PGMessageProcessingException {
        if (namedStatement != null) {
            LOG.info().$("create prepared statement [name=").$(namedStatement).I$();
            int index = this.namedStatements.keyIndex(namedStatement);
            if (index > -1) {
                if (this.namedStatements.size() == this.namedStatementLimit) {
                    throw this.msgKaput().put("client created too many named statements without closing them. it looks like a buggy client. [limit=").put(this.namedStatementLimit).put(']');
                }
                Utf8String immutableNamedStatement = Utf8String.newInstance(namedStatement);
                this.pipelineCurrentEntry.setNamedStatement(immutableNamedStatement);
                this.namedStatements.putAt(index, immutableNamedStatement, this.pipelineCurrentEntry);
            } else {
                throw this.msgKaput().put("duplicate statement [name=").put(namedStatement).put(']');
            }
        }
    }

    private void msgQuery(long lo, long limit) throws PGMessageProcessingException, PeerIsSlowToReadException, QueryPausedException, PeerDisconnectedException {
        if (this.pipelineCurrentEntry != null && this.pipelineCurrentEntry.isError()) {
            return;
        }
        CharacterStoreEntry e = this.sqlTextCharacterStore.newEntry();
        if (!Utf8s.utf8ToUtf16(lo, limit - 1L, e)) {
            throw this.msgKaput().put("invalid UTF8 bytes in parse query");
        }
        this.sqlExecutionContext.initNow();
        CharSequence activeSqlText = this.sqlTextCharacterStore.toImmutable();
        try (SqlCompiler compiler = this.engine.getSqlCompiler();){
            compiler.compileBatch(activeSqlText, this.sqlExecutionContext, this.batchCallback);
            if (this.pipelineCurrentEntry == null) {
                this.pipelineCurrentEntry = this.entryPool.next();
                this.pipelineCurrentEntry.ofEmpty(activeSqlText);
                this.pipelineCurrentEntry.setStateExec(true);
            }
        }
        catch (Throwable ex) {
            if (this.transactionState == 1) {
                this.transactionState = 3;
            }
            throw this.msgKaput().put(ex);
        }
        finally {
            this.msgSync();
        }
    }

    private void msgSync() throws PeerIsSlowToReadException, PeerDisconnectedException, QueryPausedException {
        if (this.transactionState == 0) {
            try {
                if (this.pipelineCurrentEntry == null) {
                    this.pipelineCurrentEntry = this.entryPool.next();
                }
                this.pipelineCurrentEntry.commit(this.pendingWriters);
            }
            catch (PGMessageProcessingException pGMessageProcessingException) {
                // empty catch block
            }
        }
        this.addPipelineEntry();
        this.resumeCallback = this.msgSyncRef;
        this.msgSync0();
    }

    private void msgSync0() throws PeerIsSlowToReadException, PeerDisconnectedException, QueryPausedException {
        this.syncPipeline();
        if (this.sendBufferLimit - this.sendBufferPtr < 64L) {
            this.responseUtf8Sink.sendBufferAndReset();
        }
        this.outReadForNewQuery();
        this.resumeCallback = null;
        this.responseUtf8Sink.sendBufferAndReset();
        this.prepareForNewQuery();
    }

    private void outReadForNewQuery() {
        this.responseUtf8Sink.put((byte)90);
        this.responseUtf8Sink.putNetworkInt(5);
        switch (this.transactionState) {
            case 1: {
                this.responseUtf8Sink.put((byte)84);
                break;
            }
            case 3: {
                this.responseUtf8Sink.put((byte)69);
                break;
            }
            default: {
                this.responseUtf8Sink.put((byte)73);
            }
        }
    }

    private void parseMessage(long address, int len) throws PGMessageProcessingException, PeerIsSlowToReadException, PeerDisconnectedException, QueryPausedException {
        if (len < 5) {
            return;
        }
        byte type = Unsafe.getUnsafe().getByte(address);
        int msgLen = PGConnectionContext.getIntUnsafe(address + 1L);
        LOG.debug().$("received msg [type=").$((char)type).$(", len=").$(msgLen).I$();
        if (msgLen < 1) {
            LOG.error().$("invalid message length [type=").$(type).$(", msgLen=").$(msgLen).$(", recvBufferReadOffset=").$(this.recvBufferReadOffset).$(", recvBufferWriteOffset=").$(this.recvBufferWriteOffset).$(", totalReceived=").$(this.totalReceived).I$();
            throw PGMessageProcessingException.INSTANCE;
        }
        if (msgLen > len - 1) {
            LOG.debug().$("not enough data in buffer [expected=").$(msgLen).$(", have=").$(len).$(", recvBufferWriteOffset=").$(this.recvBufferWriteOffset).$(", recvBufferReadOffset=").$(this.recvBufferReadOffset).I$();
            return;
        }
        this.recvBufferReadOffset += (long)(msgLen + 1);
        long msgLimit = address + (long)msgLen + 1L;
        long msgLo = address + 5L;
        if (this.pipelineCurrentEntry == null || !this.pipelineCurrentEntry.isError()) {
            try {
                this.sqlExecutionContext.getSecurityContext().checkEntityEnabled();
            }
            catch (Throwable e) {
                throw this.msgKaput().put(e);
            }
        }
        switch (type) {
            case 80: {
                this.msgParse(address, msgLo, msgLimit);
                break;
            }
            case 66: {
                this.msgBind(msgLo, msgLimit);
                break;
            }
            case 68: {
                this.msgDescribe(msgLo, msgLimit);
                break;
            }
            case 69: {
                this.msgExecute(msgLo, msgLimit);
                break;
            }
            case 81: {
                this.msgQuery(msgLo, msgLimit);
                break;
            }
            case 83: {
                this.msgSync();
                break;
            }
            case 72: {
                this.msgFlush();
                break;
            }
            case 88: {
                throw PeerDisconnectedException.INSTANCE;
            }
            case 67: {
                this.msgClose(msgLo, msgLimit);
                break;
            }
            default: {
                throw this.msgKaput().put("unknown message [type=").put(type).put(']');
            }
        }
    }

    private void prepareForNewQuery() {
        LOG.debug().$("prepare for new query").$();
        Misc.clear(this.bindVariableService);
        this.freezeRecvBuffer = false;
        this.sqlExecutionContext.setCacheHit(false);
        this.sqlExecutionContext.containsSecret(false);
        Misc.clear(this.sqlTextCharacterStore);
    }

    private void releaseToPool(@NotNull PGPipelineEntry pe) {
        pe.close();
        this.entryPool.release(pe);
    }

    private PGPipelineEntry removeNamedPortalFromCache(Utf8Sequence portalName) {
        int index;
        if (portalName != null && (index = this.namedPortals.keyIndex(portalName)) < 0) {
            int parentIndex;
            PGPipelineEntry pe = this.namedPortals.valueAt(index);
            PGPipelineEntry peParent = pe.getParentPreparedStatementPipelineEntry();
            if (peParent != null && (parentIndex = peParent.getNamedPortals().indexOf(portalName)) != -1) {
                peParent.getNamedPortals().remove(parentIndex);
            }
            this.namedPortals.removeAt(index);
            return pe;
        }
        return null;
    }

    private PGPipelineEntry removeNamedStatementFromCache(Utf8Sequence namedStatement) {
        int index;
        if (namedStatement != null && (index = this.namedStatements.keyIndex(namedStatement)) < 0) {
            PGPipelineEntry pe = this.namedStatements.valueAt(index);
            this.namedStatements.removeAt(index);
            ObjList<Utf8String> portalNames = pe.getNamedPortals();
            int n = portalNames.size();
            for (int i = 0; i < n; ++i) {
                int portalKeyIndex = this.namedPortals.keyIndex(portalNames.getQuick(i));
                if (portalKeyIndex < 0) {
                    Misc.free(this.namedPortals.valueAt(portalKeyIndex));
                    this.namedPortals.removeAt(portalKeyIndex);
                    continue;
                }
                LOG.debug().$("ignoring non-existent portal [portalName=").$(portalNames.getQuick(i)).$(", namedStatement=").$(namedStatement).I$();
            }
            return pe;
        }
        return null;
    }

    private void replaceCurrentPipelineEntry(PGPipelineEntry nextEntry) {
        if (nextEntry == this.pipelineCurrentEntry) {
            return;
        }
        this.releaseToPoolIfAbandoned(this.pipelineCurrentEntry);
        this.pipelineCurrentEntry = nextEntry.copyIfExecuted(this.entryPool);
    }

    private void rollbackAndClosePendingWriters() {
        for (ObjObjHashMap.Entry<TableToken, TableWriterAPI> entry : this.pendingWriters) {
            TableWriterAPI m = (TableWriterAPI)entry.value;
            m.rollback();
            Misc.free(m);
        }
    }

    private void shiftReceiveBuffer(long readOffsetBeforeParse) {
        long len = this.recvBufferWriteOffset - readOffsetBeforeParse;
        LOG.debug().$("shift [offset=").$(readOffsetBeforeParse).$(", len=").$(len).I$();
        Vect.memmove(this.recvBuffer, this.recvBuffer + readOffsetBeforeParse, len);
        this.recvBufferWriteOffset = len;
        this.recvBufferReadOffset = 0L;
    }

    private void shutdownSocketGracefully() {
        int n;
        this.socket.shutdown(1);
        MillisecondClock clock = this.engine.getConfiguration().getMillisecondClock();
        long startTime = clock.getTicks();
        while ((n = this.socket.recv(this.recvBuffer, this.recvBufferSize)) > 0 && clock.getTicks() - startTime <= 5000L) {
        }
    }

    private void syncPipeline() throws PeerIsSlowToReadException, QueryPausedException, PeerDisconnectedException {
        while (this.pipelineCurrentEntry != null || (this.pipelineCurrentEntry = this.pipeline.poll()) != null) {
            boolean isExec = this.pipelineCurrentEntry.isStateExec();
            boolean isError = this.pipelineCurrentEntry.isError();
            boolean isClosed = this.pipelineCurrentEntry.isStateClosed();
            while (true) {
                try {
                    this.pipelineCurrentEntry.msgSync(this.sqlExecutionContext, this.pendingWriters, this.responseUtf8Sink);
                }
                catch (NoSpaceLeftInResponseBufferException e) {
                    this.responseUtf8Sink.resetToBookmark();
                    if (this.responseUtf8Sink.sendBufferAndReset() != 0) continue;
                    this.responseUtf8Sink.reset();
                    ((Utf16Sink)((Utf16Sink)((Utf16Sink)this.pipelineCurrentEntry.getErrorMessageSink().put("not enough space in send buffer [sendBufferSize=").put(this.responseUtf8Sink.getSendBufferSize())).put(", requiredSize=")).put(Math.max(e.getBytesRequired(), 2L * this.responseUtf8Sink.getSendBufferSize()))).put(']');
                    this.pipelineCurrentEntry.msgSync(this.sqlExecutionContext, this.pendingWriters, this.responseUtf8Sink);
                }
                break;
            }
            PGPipelineEntry nextEntry = this.pipeline.poll();
            if (nextEntry != null || isExec || isError || isClosed) {
                if (!isError) {
                    this.pipelineCurrentEntry.cacheIfPossible(this.tasCache, this.taiCache);
                }
                this.releaseToPoolIfAbandoned(this.pipelineCurrentEntry);
                this.pipelineCurrentEntry = nextEntry;
                continue;
            }
            LOG.debug().$("pipeline entry not consumed [instance=)").$(this.pipelineCurrentEntry).$(", sql=").$safe(this.pipelineCurrentEntry.getSqlText()).$(", stmt=").$safe(this.pipelineCurrentEntry.getNamedStatement()).$(", portal=").$safe(this.pipelineCurrentEntry.getNamedPortal()).I$();
            break;
        }
        this.sqlTextCharacterStore.clear();
    }

    static void dumpBuffer(char direction, long buffer, int len, boolean dumpNetworkTraffic) {
        if (dumpNetworkTraffic && len > 0) {
            StdoutSink.INSTANCE.put(direction);
            Net.dump(buffer, len);
        }
    }

    static int getIntUnsafe(long address) {
        return Numbers.bswap(Unsafe.getUnsafe().getInt(address));
    }

    static short getShortUnsafe(long address) {
        return Numbers.bswap(Unsafe.getUnsafe().getShort(address));
    }

    @Override
    protected void doInit() {
        this.sqlExecutionContext.with(this.getFd());
        assert (this.recvBuffer == 0L);
        this.recvBufferSize = this.configuration.getRecvBufferSize();
        this.recvBuffer = Unsafe.malloc(this.recvBufferSize, 48);
        assert (this.sendBuffer == 0L);
        this.sendBufferSize = this.configuration.getSendBufferSize();
        this.responseUtf8Sink.bookmarkPtr = this.sendBufferPtr = (this.sendBuffer = Unsafe.malloc(this.sendBufferSize, 48));
        this.sendBufferLimit = this.sendBuffer + (long)this.sendBufferSize;
        this.namedStatementLimit = this.configuration.getNamedStatementLimit();
        this.authenticator.init(this.socket, this.recvBuffer, this.recvBuffer + (long)this.recvBufferSize, this.sendBuffer, this.sendBufferLimit);
    }

    int doReceive(int remaining) {
        long data = this.recvBuffer + this.recvBufferWriteOffset;
        int n = this.socket.recv(data, remaining);
        PGConnectionContext.dumpBuffer('>', data, n, this.dumpNetworkTraffic);
        return n;
    }

    void recv() throws PeerDisconnectedException, PeerIsSlowToWriteException, PGMessageProcessingException {
        int remaining = (int)((long)this.recvBufferSize - this.recvBufferWriteOffset);
        this.assertBufferSize(remaining > 0);
        int n = this.doReceive(Math.min(this.forceRecvFragmentationChunkSize, remaining));
        LOG.debug().$("recv [n=").$(n).I$();
        if (n < 0) {
            LOG.info().$("disconnected on read [code=").$(n).I$();
            throw PeerDisconnectedException.INSTANCE;
        }
        if (n == 0) {
            throw PeerIsSlowToWriteException.INSTANCE;
        }
        this.recvBufferWriteOffset += (long)n;
    }

    void releaseToPoolIfAbandoned(PGPipelineEntry pe) {
        if (pe != null) {
            if (pe.isCopy || !pe.isPreparedStatement() && !pe.isPortal()) {
                this.releaseToPool(pe);
            } else {
                pe.clearState();
            }
        }
    }

    void sendBuffer(int offset, int size) throws PeerDisconnectedException, PeerIsSlowToReadException {
        int n = this.socket.send(this.sendBuffer + (long)offset, Math.min(size, this.forceSendFragmentationChunkSize));
        PGConnectionContext.dumpBuffer('<', this.sendBuffer + (long)offset, n, this.dumpNetworkTraffic);
        if (n < 0) {
            throw PeerDisconnectedException.INSTANCE;
        }
        if (n < size) {
            this.doSendWithRetries(offset + n, size - n);
        }
        this.responseUtf8Sink.bookmarkPtr = this.sendBufferPtr = this.sendBuffer;
        this.bufferRemainingSize = 0;
        this.bufferRemainingOffset = 0;
    }

    private class ResponseUtf8Sink
    implements PGResponseSink,
    Mutable {
        private long bookmarkPtr = -1L;

        @Override
        public void bookmark() {
            this.bookmarkPtr = PGConnectionContext.this.sendBufferPtr;
        }

        @Override
        public void bump(int size) {
            PGConnectionContext.this.sendBufferPtr += (long)size;
        }

        @Override
        public void checkCapacity(long size) {
            if (PGConnectionContext.this.sendBufferPtr + size < PGConnectionContext.this.sendBufferLimit) {
                return;
            }
            throw NoSpaceLeftInResponseBufferException.instance(size);
        }

        @Override
        public void clear() {
            this.reset();
        }

        @Override
        public long getMaxBlobSize() {
            return PGConnectionContext.this.maxBlobSize;
        }

        @Override
        public long getSendBufferPtr() {
            return PGConnectionContext.this.sendBufferPtr;
        }

        @Override
        public long getSendBufferSize() {
            return PGConnectionContext.this.sendBufferSize;
        }

        @Override
        public long getWrittenBytes() {
            return PGConnectionContext.this.sendBufferPtr - PGConnectionContext.this.sendBuffer;
        }

        @Override
        public Utf8Sink put(@Nullable Utf8Sequence us) {
            int size;
            if (us != null && (size = us.size()) > 0) {
                this.checkCapacity(size);
                Utf8s.strCpy(us, size, PGConnectionContext.this.sendBufferPtr);
                PGConnectionContext.this.sendBufferPtr += (long)size;
            }
            return this;
        }

        @Override
        public Utf8Sink put(byte b) {
            this.checkCapacity(1L);
            Unsafe.getUnsafe().putByte(PGConnectionContext.this.sendBufferPtr++, b);
            return this;
        }

        @Override
        public void put(BinarySequence sequence) {
            long len = sequence.length();
            if (len > (long)PGConnectionContext.this.maxBlobSize) {
                this.setNullValue();
            } else {
                this.checkCapacity((int)(len + 4L));
                PGConnectionContext.putInt(PGConnectionContext.this.sendBufferPtr, (int)len);
                PGConnectionContext.this.sendBufferPtr += 4L;
                for (long x = 0L; x < len; ++x) {
                    Unsafe.getUnsafe().putByte(PGConnectionContext.this.sendBufferPtr + x, sequence.byteAt(x));
                }
                PGConnectionContext.this.sendBufferPtr += len;
            }
        }

        @Override
        public void putDirectInt(int xValue) {
            this.checkCapacity(4L);
            Unsafe.getUnsafe().putInt(PGConnectionContext.this.sendBufferPtr, xValue);
            PGConnectionContext.this.sendBufferPtr += 4L;
        }

        @Override
        public void putDirectShort(short xValue) {
            this.checkCapacity(2L);
            Unsafe.getUnsafe().putShort(PGConnectionContext.this.sendBufferPtr, xValue);
            PGConnectionContext.this.sendBufferPtr += 2L;
        }

        @Override
        public void putIntDirect(int value) {
            this.checkCapacity(4L);
            this.putIntUnsafe(0L, value);
            PGConnectionContext.this.sendBufferPtr += 4L;
        }

        @Override
        public void putIntUnsafe(long offset, int value) {
            Unsafe.getUnsafe().putInt(PGConnectionContext.this.sendBufferPtr + offset, value);
        }

        @Override
        public void putLen(long start) {
            PGConnectionContext.putInt(start, (int)(PGConnectionContext.this.sendBufferPtr - start));
        }

        @Override
        public void putLenEx(long start) {
            PGConnectionContext.putInt(start, (int)(PGConnectionContext.this.sendBufferPtr - start - 4L));
        }

        @Override
        public void putNetworkDouble(double value) {
            this.checkCapacity(8L);
            Unsafe.getUnsafe().putDouble(PGConnectionContext.this.sendBufferPtr, Double.longBitsToDouble(Numbers.bswap(Double.doubleToLongBits(value))));
            PGConnectionContext.this.sendBufferPtr += 8L;
        }

        @Override
        public void putNetworkFloat(float value) {
            this.checkCapacity(4L);
            Unsafe.getUnsafe().putFloat(PGConnectionContext.this.sendBufferPtr, Float.intBitsToFloat(Numbers.bswap(Float.floatToIntBits(value))));
            PGConnectionContext.this.sendBufferPtr += 4L;
        }

        @Override
        public void putNetworkInt(int value) {
            this.checkCapacity(4L);
            PGConnectionContext.putInt(PGConnectionContext.this.sendBufferPtr, value);
            PGConnectionContext.this.sendBufferPtr += 4L;
        }

        @Override
        public void putNetworkLong(long value) {
            this.checkCapacity(8L);
            PGConnectionContext.putLong(PGConnectionContext.this.sendBufferPtr, value);
            PGConnectionContext.this.sendBufferPtr += 8L;
        }

        @Override
        public void putNetworkShort(short value) {
            this.checkCapacity(2L);
            PGConnectionContext.putShort(PGConnectionContext.this.sendBufferPtr, value);
            PGConnectionContext.this.sendBufferPtr += 2L;
        }

        @Override
        public Utf8Sink putNonAscii(long lo, long hi) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putZ(CharSequence value) {
            this.put(value);
            this.checkCapacity(1L);
            Unsafe.getUnsafe().putByte(PGConnectionContext.this.sendBufferPtr++, (byte)0);
        }

        @Override
        public void reset() {
            PGConnectionContext.this.sendBufferPtr = PGConnectionContext.this.sendBuffer;
        }

        @Override
        public void resetToBookmark() {
            if (this.bookmarkPtr != -1L) {
                PGConnectionContext.this.sendBufferPtr = this.bookmarkPtr;
                this.bookmarkPtr = -1L;
            }
        }

        @Override
        public void resetToBookmark(long address) {
            PGConnectionContext.this.sendBufferPtr = address;
            this.bookmarkPtr = -1L;
        }

        @Override
        public int sendBufferAndReset() throws PeerDisconnectedException, PeerIsSlowToReadException {
            int sendSize = (int)(PGConnectionContext.this.sendBufferPtr - PGConnectionContext.this.sendBuffer - (long)PGConnectionContext.this.bufferRemainingOffset);
            PGConnectionContext.this.sendBuffer(PGConnectionContext.this.bufferRemainingOffset, sendSize);
            PGConnectionContext.this.responseUtf8Sink.reset();
            return sendSize;
        }

        @Override
        public void setNullValue() {
            this.putIntDirect(INT_NULL_X);
        }

        @Override
        public long skipInt() {
            this.checkCapacity(4L);
            long checkpoint = PGConnectionContext.this.sendBufferPtr;
            PGConnectionContext.this.sendBufferPtr += 4L;
            return checkpoint;
        }
    }

    private class PGConnectionBatchCallback
    implements BatchCallback {
        private PGConnectionBatchCallback() {
        }

        @Override
        public void postCompile(SqlCompiler compiler, CompiledQuery cq, CharSequence queryText) throws Exception {
            CharacterStoreEntry entry = PGConnectionContext.this.sqlTextCharacterStore.newEntry();
            entry.put(queryText);
            PGConnectionContext.this.pipelineCurrentEntry.ofSimpleQuery(entry.toImmutable(), PGConnectionContext.this.sqlExecutionContext, cq, PGConnectionContext.this.taiPool);
            PGConnectionContext.this.transactionState = PGConnectionContext.this.pipelineCurrentEntry.msgExecute(PGConnectionContext.this.sqlExecutionContext, PGConnectionContext.this.transactionState, PGConnectionContext.this.taiPool, PGConnectionContext.this.pendingWriters, PGConnectionContext.this, PGConnectionContext.this.bindVariableValuesCharacterStore, PGConnectionContext.this.utf8String, PGConnectionContext.this.binarySequenceParamsPool, PGConnectionContext.this.tempSequence, PGConnectionContext.this.preparedStatementDeallocator);
            PGConnectionContext.this.pipelineCurrentEntry.setStateExec(true);
        }

        @Override
        public boolean preCompile(SqlCompiler compiler, CharSequence sqlText) {
            PGConnectionContext.this.addPipelineEntry();
            PGConnectionContext.this.pipelineCurrentEntry = PGConnectionContext.this.entryPool.next();
            TypesAndSelect tas = PGConnectionContext.this.tasCache.poll(sqlText);
            if (tas == null) {
                return true;
            }
            if (!PGConnectionContext.this.pipelineCurrentEntry.msgParseReconcileParameterTypes((short)0, tas)) {
                tas.close();
                return false;
            }
            CharacterStoreEntry entry = PGConnectionContext.this.sqlTextCharacterStore.newEntry();
            entry.put(sqlText);
            try {
                PGConnectionContext.this.pipelineCurrentEntry.ofSimpleCachedSelect(entry.toImmutable(), PGConnectionContext.this.sqlExecutionContext, tas);
                return false;
            }
            catch (Throwable e) {
                CharSequence msg = e instanceof FlyweightMessageContainer ? ((FlyweightMessageContainer)((Object)e)).getFlyweightMessage() : e.getMessage();
                LOG.info().$("could not use cached select [error=").$(msg).$(']').$();
                PGConnectionContext.this.pipelineCurrentEntry.clearState();
                tas.close();
                return true;
            }
        }
    }

    public static class Portal
    implements Mutable {
        public CharSequence statementName = null;

        @Override
        public void clear() {
            this.statementName = null;
        }
    }
}

