/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.processors;

import io.questdb.Metrics;
import io.questdb.cairo.CairoEngine;
import io.questdb.cutlass.http.HttpChunkedResponse;
import io.questdb.cutlass.http.HttpConnectionContext;
import io.questdb.cutlass.http.HttpContextConfiguration;
import io.questdb.cutlass.http.HttpException;
import io.questdb.cutlass.http.HttpMultipartContentProcessor;
import io.questdb.cutlass.http.HttpRequestHandler;
import io.questdb.cutlass.http.HttpRequestHeader;
import io.questdb.cutlass.http.HttpRequestProcessor;
import io.questdb.cutlass.http.LocalValue;
import io.questdb.cutlass.http.processors.LineHttpProcessorConfiguration;
import io.questdb.cutlass.http.processors.LineHttpProcessorState;
import io.questdb.cutlass.http.processors.SendStatus;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.metrics.AtomicLongGauge;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8String;
import io.questdb.std.str.Utf8s;

public class LineHttpProcessorImpl
implements HttpMultipartContentProcessor,
HttpRequestHandler {
    private static final Utf8String CONTENT_ENCODING = new Utf8String("Content-Encoding");
    private static final Log LOG = LogFactory.getLog(LineHttpProcessorImpl.class);
    private static final LocalValue<LineHttpProcessorState> LV = new LocalValue();
    private static final Utf8String URL_PARAM_PRECISION = new Utf8String("precision");
    private final LineHttpProcessorConfiguration configuration;
    private final CairoEngine engine;
    private final int maxResponseContentLength;
    private final int recvBufferSize;
    private LineHttpProcessorState state;

    public LineHttpProcessorImpl(CairoEngine engine, int recvBufferSize, int maxResponseContentLength, LineHttpProcessorConfiguration configuration) {
        this.engine = engine;
        this.recvBufferSize = recvBufferSize;
        this.maxResponseContentLength = maxResponseContentLength;
        this.configuration = configuration;
    }

    @Override
    public AtomicLongGauge connectionCountGauge(Metrics metrics) {
        return metrics.lineMetrics().httpConnectionCountGauge();
    }

    @Override
    public int getConnectionLimit(HttpContextConfiguration configuration) {
        return configuration.getIlpConnectionLimit();
    }

    @Override
    public HttpRequestProcessor getProcessor(HttpRequestHeader requestHeader) {
        return this;
    }

    @Override
    public short getSupportedRequestTypes() {
        return 770;
    }

    @Override
    public void onChunk(long lo, long hi) {
        this.state.parse(lo, hi);
    }

    @Override
    public void onConnectionClosed(HttpConnectionContext context) {
        this.state = LV.get(context);
        if (this.state != null) {
            this.state.onDisconnected();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onHeadersReady(HttpConnectionContext context) {
        int timestampPrecision;
        block7: {
            block8: {
                int len;
                DirectUtf8Sequence precision;
                HttpRequestHeader requestHeader;
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                this.state = LV.get(context);
                                if (this.state == null) {
                                    this.state = new LineHttpProcessorState(this.recvBufferSize, this.maxResponseContentLength, this.engine, this.configuration);
                                    LV.set(context, this.state);
                                } else {
                                    this.state.clear();
                                }
                                requestHeader = context.getRequestHeader();
                                DirectUtf8Sequence encoding = requestHeader.getHeader(CONTENT_ENCODING);
                                if (encoding != null && Utf8s.endsWithAscii((Utf8Sequence)encoding, "gzip")) {
                                    this.state.reject(LineHttpProcessorState.Status.ENCODING_NOT_SUPPORTED, "gzip encoding is not supported", context.getFd());
                                    return;
                                }
                                precision = requestHeader.getUrlParam(URL_PARAM_PRECISION);
                                if (precision == null) break block8;
                                len = precision.size();
                                if ((len != 1 || precision.byteAt(0) != 110) && (len != 2 || precision.byteAt(0) != 110 || precision.byteAt(1) != 115)) break block9;
                                timestampPrecision = 1;
                                break block7;
                            }
                            if ((len != 1 || precision.byteAt(0) != 117) && (len != 2 || precision.byteAt(0) != 117 || precision.byteAt(1) != 115)) break block10;
                            timestampPrecision = 2;
                            break block7;
                        }
                        if (len != 2 || precision.byteAt(0) != 109 || precision.byteAt(1) != 115) break block11;
                        timestampPrecision = 3;
                        break block7;
                    }
                    if (len != 1 || precision.byteAt(0) != 115) break block12;
                    timestampPrecision = 4;
                    break block7;
                }
                if (len == 1 && precision.byteAt(0) == 109) {
                    timestampPrecision = 5;
                    break block7;
                } else if (len == 1 && precision.byteAt(0) == 104) {
                    timestampPrecision = 6;
                    break block7;
                } else {
                    LOG.info().$("unsupported precision [url=").$(requestHeader.getUrl()).$(", precision=").$(precision).I$();
                    this.state.reject(LineHttpProcessorState.Status.PRECISION_NOT_SUPPORTED, "unsupported precision", context.getFd());
                    return;
                }
            }
            timestampPrecision = 1;
        }
        this.state.of(context.getFd(), (byte)timestampPrecision, context.getSecurityContext());
    }

    @Override
    public void onPartBegin(HttpRequestHeader partHeader) {
    }

    @Override
    public void onPartEnd() {
    }

    @Override
    public void onRequestComplete(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.state.onMessageComplete();
        if (this.state.isOk()) {
            this.state.commit();
        }
        if (this.state.isOk()) {
            this.state.setSendStatus(SendStatus.HEADER);
            context.simpleResponse().sendStatusNoContent(204);
        } else {
            this.state.setSendStatus(SendStatus.HEADER);
            this.sendErrorHeader(context);
            this.state.setSendStatus(SendStatus.CONTENT);
            this.sendErrorContent(context);
        }
        this.engine.getMetrics().lineMetrics().totalIlpHttpBytesGauge().add(context.getTotalReceived());
    }

    @Override
    public void resumeRecv(HttpConnectionContext context) {
        this.state = LV.get(context);
    }

    @Override
    public void resumeSend(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.state = LV.get(context);
        assert (this.state != null);
        switch (this.state.getSendStatus()) {
            case HEADER: {
                context.resumeResponseSend();
                if (this.state.isOk()) break;
                this.state.setSendStatus(SendStatus.CONTENT);
                this.sendErrorContent(context);
                break;
            }
            case CONTENT: {
                context.resumeResponseSend();
                break;
            }
            default: {
                throw HttpException.instance("unexpected send status: " + String.valueOf((Object)this.state.getSendStatus()));
            }
        }
    }

    private void sendErrorContent(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException {
        HttpChunkedResponse response = context.getChunkedResponse();
        this.state.formatError(response);
        response.sendChunk(true);
    }

    private void sendErrorHeader(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException {
        HttpChunkedResponse response = context.getChunkedResponse();
        response.status(this.state.getHttpResponseCode(), "application/json; charset=utf-8");
        response.sendHeader();
    }
}

