/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.cairo.VarcharTypeDriver;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.BorrowedArray;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.vm.api.MemoryCR;
import io.questdb.cairo.wal.WalReader;
import io.questdb.std.BinarySequence;
import io.questdb.std.Long256;
import io.questdb.std.Rows;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Sinkable;
import io.questdb.std.str.Utf8Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WalDataRecord
implements Record,
Sinkable {
    private final BorrowedArray array = new BorrowedArray();
    private WalReader reader;
    private long recordIndex = 0L;

    @Override
    public ArrayView getArray(int col, int columnType) {
        int absoluteColumnIndex = WalReader.getPrimaryColumnIndex(col);
        MemoryCR auxMem = this.reader.getColumn(absoluteColumnIndex + 1);
        MemoryCR dataMem = this.reader.getColumn(absoluteColumnIndex);
        this.array.of(columnType, auxMem.addressOf(0L), auxMem.addressHi(), dataMem.addressOf(0L), dataMem.addressHi(), this.recordIndex);
        return this.array;
    }

    @Override
    public BinarySequence getBin(int col) {
        long offset = this.recordIndex * 8L;
        int absoluteColumnIndex = WalReader.getPrimaryColumnIndex(col);
        return this.reader.getColumn(absoluteColumnIndex).getBin(this.reader.getColumn(absoluteColumnIndex + 1).getLong(offset));
    }

    @Override
    public long getBinLen(int col) {
        long offset = this.recordIndex * 8L;
        int absoluteColumnIndex = WalReader.getPrimaryColumnIndex(col);
        return this.reader.getColumn(absoluteColumnIndex).getBinLen(this.reader.getColumn(absoluteColumnIndex + 1).getLong(offset));
    }

    @Override
    public boolean getBool(int col) {
        long offset = this.recordIndex;
        int absoluteColumnIndex = WalReader.getPrimaryColumnIndex(col);
        return this.reader.getColumn(absoluteColumnIndex).getBool(offset);
    }

    @Override
    public byte getByte(int col) {
        long offset = this.recordIndex;
        int absoluteColumnIndex = WalReader.getPrimaryColumnIndex(col);
        return this.reader.getColumn(absoluteColumnIndex).getByte(offset);
    }

    @Override
    public char getChar(int col) {
        long offset = this.recordIndex * 2L;
        int absoluteColumnIndex = WalReader.getPrimaryColumnIndex(col);
        return this.reader.getColumn(absoluteColumnIndex).getChar(offset);
    }

    public long getDesignatedTimestampRowId(int col) {
        long offset = 2L * this.recordIndex * 8L + 8L;
        int absoluteColumnIndex = WalReader.getPrimaryColumnIndex(col);
        return this.reader.getColumn(absoluteColumnIndex).getLong(offset);
    }

    @Override
    public double getDouble(int col) {
        long offset = this.recordIndex * 8L;
        int absoluteColumnIndex = WalReader.getPrimaryColumnIndex(col);
        return this.reader.getColumn(absoluteColumnIndex).getDouble(offset);
    }

    @Override
    public float getFloat(int col) {
        long offset = this.recordIndex * 4L;
        int absoluteColumnIndex = WalReader.getPrimaryColumnIndex(col);
        return this.reader.getColumn(absoluteColumnIndex).getFloat(offset);
    }

    @Override
    public byte getGeoByte(int col) {
        long offset = this.recordIndex * 1L;
        int absoluteColumnIndex = WalReader.getPrimaryColumnIndex(col);
        return offset < 0L ? (byte)-1 : this.reader.getColumn(absoluteColumnIndex).getByte(offset);
    }

    @Override
    public int getGeoInt(int col) {
        long offset = this.recordIndex * 4L;
        int absoluteColumnIndex = WalReader.getPrimaryColumnIndex(col);
        return offset < 0L ? -1 : this.reader.getColumn(absoluteColumnIndex).getInt(offset);
    }

    @Override
    public long getGeoLong(int col) {
        long offset = this.recordIndex * 8L;
        int absoluteColumnIndex = WalReader.getPrimaryColumnIndex(col);
        return offset < 0L ? -1L : this.reader.getColumn(absoluteColumnIndex).getLong(offset);
    }

    @Override
    public short getGeoShort(int col) {
        long offset = this.recordIndex * 2L;
        int absoluteColumnIndex = WalReader.getPrimaryColumnIndex(col);
        return offset < 0L ? (short)-1 : this.reader.getColumn(absoluteColumnIndex).getShort(offset);
    }

    @Override
    public int getIPv4(int col) {
        long offset = this.recordIndex * 4L;
        int absoluteColumnIndex = WalReader.getPrimaryColumnIndex(col);
        return this.reader.getColumn(absoluteColumnIndex).getIPv4(offset);
    }

    @Override
    public int getInt(int col) {
        long offset = this.recordIndex * 4L;
        int absoluteColumnIndex = WalReader.getPrimaryColumnIndex(col);
        return this.reader.getColumn(absoluteColumnIndex).getInt(offset);
    }

    @Override
    public long getLong(int col) {
        long offset = this.recordIndex * 8L;
        int absoluteColumnIndex = WalReader.getPrimaryColumnIndex(col);
        return this.reader.getColumn(absoluteColumnIndex).getLong(offset);
    }

    @Override
    public long getLong128Hi(int col) {
        long offset = this.recordIndex * 16L;
        int absoluteColumnIndex = WalReader.getPrimaryColumnIndex(col);
        return this.reader.getColumn(absoluteColumnIndex).getLong(offset + 8L);
    }

    @Override
    public long getLong128Lo(int col) {
        long offset = this.recordIndex * 16L;
        int absoluteColumnIndex = WalReader.getPrimaryColumnIndex(col);
        return this.reader.getColumn(absoluteColumnIndex).getLong(offset);
    }

    @Override
    public void getLong256(int col, CharSink<?> sink) {
        long offset = this.recordIndex * 32L;
        int absoluteColumnIndex = WalReader.getPrimaryColumnIndex(col);
        this.reader.getColumn(absoluteColumnIndex).getLong256(offset, sink);
    }

    @Override
    public Long256 getLong256A(int col) {
        long offset = this.recordIndex * 32L;
        int absoluteColumnIndex = WalReader.getPrimaryColumnIndex(col);
        return this.reader.getColumn(absoluteColumnIndex).getLong256A(offset);
    }

    @Override
    public Long256 getLong256B(int col) {
        long offset = this.recordIndex * 32L;
        int absoluteColumnIndex = WalReader.getPrimaryColumnIndex(col);
        return this.reader.getColumn(absoluteColumnIndex).getLong256B(offset);
    }

    public long getRecordIndex() {
        return this.recordIndex;
    }

    @Override
    public long getRowId() {
        return Rows.toRowID(0, this.recordIndex);
    }

    @Override
    public short getShort(int col) {
        long offset = this.recordIndex * 2L;
        int absoluteColumnIndex = WalReader.getPrimaryColumnIndex(col);
        return this.reader.getColumn(absoluteColumnIndex).getShort(offset);
    }

    @Override
    public CharSequence getStrA(int col) {
        long offset = this.recordIndex * 8L;
        int absoluteColumnIndex = WalReader.getPrimaryColumnIndex(col);
        return this.reader.getColumn(absoluteColumnIndex).getStrA(this.reader.getColumn(absoluteColumnIndex + 1).getLong(offset));
    }

    @Override
    public CharSequence getStrB(int col) {
        long offset = this.recordIndex * 8L;
        int absoluteColumnIndex = WalReader.getPrimaryColumnIndex(col);
        return this.reader.getColumn(absoluteColumnIndex).getStrB(this.reader.getColumn(absoluteColumnIndex + 1).getLong(offset));
    }

    @Override
    public int getStrLen(int col) {
        long offset = this.recordIndex * 8L;
        int absoluteColumnIndex = WalReader.getPrimaryColumnIndex(col);
        return this.reader.getColumn(absoluteColumnIndex).getStrLen(this.reader.getColumn(absoluteColumnIndex + 1).getLong(offset));
    }

    @Override
    public CharSequence getSymA(int col) {
        return this.reader.getSymbolValue(col, this.getInt(col));
    }

    @Override
    public CharSequence getSymB(int col) {
        return this.getSymA(col);
    }

    @Override
    public long getTimestamp(int col) {
        return col == this.reader.getTimestampIndex() ? this.getDesignatedTimestamp(col) : this.getLong(col);
    }

    @Override
    public long getUpdateRowId() {
        throw new UnsupportedOperationException("UPDATE is not supported in WAL");
    }

    @Override
    @Nullable
    public Utf8Sequence getVarcharA(int col) {
        int absoluteColumnIndex = WalReader.getPrimaryColumnIndex(col);
        return VarcharTypeDriver.getSplitValue(this.reader.getColumn(absoluteColumnIndex + 1), this.reader.getColumn(absoluteColumnIndex), this.recordIndex, 1);
    }

    @Override
    @Nullable
    public Utf8Sequence getVarcharB(int col) {
        int absoluteColumnIndex = WalReader.getPrimaryColumnIndex(col);
        return VarcharTypeDriver.getSplitValue(this.reader.getColumn(absoluteColumnIndex + 1), this.reader.getColumn(absoluteColumnIndex), this.recordIndex, 2);
    }

    @Override
    public int getVarcharSize(int col) {
        int absoluteColumnIndex = WalReader.getPrimaryColumnIndex(col);
        return VarcharTypeDriver.getValueSize(this.reader.getColumn(absoluteColumnIndex + 1), this.recordIndex);
    }

    public void incrementRecordIndex() {
        ++this.recordIndex;
    }

    public void jumpTo(long recordIndex) {
        this.recordIndex = recordIndex;
    }

    public void of(WalReader reader) {
        this.reader = reader;
        this.jumpTo(-1L);
    }

    @Override
    public void toSink(@NotNull CharSink<?> sink) {
        sink.putAscii("WalReaderRecord [recordIndex=").put(this.recordIndex).putAscii(']');
    }

    private long getDesignatedTimestamp(int col) {
        long offset = 2L * this.recordIndex * 8L;
        int absoluteColumnIndex = WalReader.getPrimaryColumnIndex(col);
        return this.reader.getColumn(absoluteColumnIndex).getLong(offset);
    }
}

