/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.mv;

import io.questdb.cairo.mv.SampleByIntervalIterator;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.griffin.model.IntervalUtils;
import io.questdb.std.LongList;
import io.questdb.std.datetime.TimeZoneRules;
import io.questdb.std.datetime.microtime.Timestamps;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TimeZoneIntervalIterator
extends SampleByIntervalIterator {
    private final LongList localShifts = new LongList();
    private long localMaxTimestamp;
    private long localMinTimestamp;
    private long localTimestampHi;
    private int shiftLoIndex;
    private long shiftOffset;
    private TimeZoneRules tzRules;
    private long utcMaxTimestamp;
    private long utcMinTimestamp;
    private long utcTimestampHi;
    private long utcTimestampLo;

    @Override
    public long getMaxTimestamp() {
        return this.utcMaxTimestamp;
    }

    @Override
    public long getMinTimestamp() {
        return this.utcMinTimestamp;
    }

    @Override
    public int getStep() {
        return this.step;
    }

    @Override
    public long getTimestampHi() {
        return this.utcTimestampHi;
    }

    @Override
    public long getTimestampLo() {
        return this.utcTimestampLo;
    }

    public TimeZoneIntervalIterator of(@NotNull TimestampSampler sampler, @NotNull TimeZoneRules tzRules, long fixedOffset, @Nullable LongList intervals, long minTs, long maxTs, int step) {
        super.of(sampler, intervals);
        this.tzRules = tzRules;
        sampler.setStart(fixedOffset);
        long localMinTs = minTs + tzRules.getOffset(minTs);
        this.localMinTimestamp = sampler.round(localMinTs);
        long localMaxTs = maxTs + tzRules.getOffset(maxTs);
        this.localMaxTimestamp = sampler.nextTimestamp(sampler.round(localMaxTs));
        this.localShifts.clear();
        long limitTs = Timestamps.ceilYYYY(this.localMaxTimestamp);
        long ts = tzRules.getNextDST(Timestamps.floorYYYY(this.localMinTimestamp));
        while (ts < limitTs) {
            long localEnd;
            long localStart;
            long offsetBefore = tzRules.getOffset(ts - 1L);
            long offsetAfter = tzRules.getOffset(ts);
            long duration = offsetAfter - offsetBefore;
            if (duration < 0L) {
                localStart = ts + offsetAfter;
                localEnd = localStart - duration;
                this.localShifts.add(localStart, localEnd);
            } else {
                localStart = ts + offsetBefore;
                localEnd = localStart + duration;
                this.localShifts.add(localStart, localEnd + 1L);
            }
            ts = tzRules.getNextDST(ts);
        }
        this.localMinTimestamp = this.adjustLoBoundary(this.localMinTimestamp);
        this.localMaxTimestamp = this.adjustHiBoundary(this.localMaxTimestamp);
        this.utcMinTimestamp = Timestamps.toUTC(this.localMinTimestamp, tzRules);
        this.utcMaxTimestamp = Timestamps.toUTC(this.localMaxTimestamp, tzRules);
        this.toTop(step);
        return this;
    }

    private long adjustHiBoundary(long localTs) {
        int idx = IntervalUtils.findInterval(this.localShifts, localTs);
        if (idx != -1) {
            long shiftLo = IntervalUtils.getEncodedPeriodLo(this.localShifts, idx << 1);
            if (localTs == shiftLo) {
                return localTs;
            }
            long shiftHi = IntervalUtils.getEncodedPeriodHi(this.localShifts, idx << 1);
            return this.sampler.nextTimestamp(this.sampler.round(shiftHi - 1L));
        }
        return localTs;
    }

    private long adjustLoBoundary(long localTs) {
        int idx = IntervalUtils.findInterval(this.localShifts, localTs);
        if (idx != -1) {
            long shiftLo = IntervalUtils.getEncodedPeriodLo(this.localShifts, idx << 1);
            return this.sampler.round(shiftLo);
        }
        return localTs;
    }

    @Override
    protected boolean next0() {
        long shiftLo;
        if (this.localTimestampHi == this.localMaxTimestamp) {
            return false;
        }
        this.utcTimestampLo = this.utcTimestampHi;
        this.localTimestampHi = Math.min(this.sampler.nextTimestamp(this.localTimestampHi, this.step), this.localMaxTimestamp);
        if (this.localTimestampHi == this.localMaxTimestamp) {
            this.utcTimestampHi = this.utcMaxTimestamp;
            return true;
        }
        int n = this.localShifts.size();
        while (this.shiftLoIndex < n && this.localTimestampHi > (shiftLo = this.localShifts.getQuick(this.shiftLoIndex))) {
            long shiftHi = this.localShifts.getQuick(this.shiftLoIndex + 1);
            if (this.localTimestampHi <= shiftHi) {
                this.localTimestampHi = this.sampler.nextTimestamp(this.sampler.round(shiftHi - 1L));
                this.shiftOffset = this.tzRules.getLocalOffset(shiftHi);
                this.shiftLoIndex += 2;
                break;
            }
            this.shiftOffset = this.tzRules.getLocalOffset(shiftHi);
            this.shiftLoIndex += 2;
        }
        this.utcTimestampHi = this.localTimestampHi - this.shiftOffset;
        return true;
    }

    @Override
    protected void toTop0() {
        this.utcTimestampLo = Long.MIN_VALUE;
        this.localTimestampHi = this.localMinTimestamp;
        this.utcTimestampHi = this.utcMinTimestamp;
        this.shiftLoIndex = 0;
        this.shiftOffset = this.tzRules.getLocalOffset(this.localMinTimestamp);
    }
}

