/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.file;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.VarcharTypeDriver;
import io.questdb.cairo.file.AppendableBlock;
import io.questdb.cairo.file.BlockFileUtils;
import io.questdb.cairo.file.WritableBlock;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.cairo.vm.api.MemoryCMARW;
import io.questdb.std.BinarySequence;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Utf8Sequence;
import java.io.Closeable;
import org.jetbrains.annotations.Nullable;

public class BlockFileWriter
implements Closeable {
    private final BlockMemoryHandleImpl blockMemoryHandle = new BlockMemoryHandleImpl();
    private final int commitMode;
    private final FilesFacade ff;
    private int blockCount;
    private long blockOffset;
    private MemoryCMARW file;
    private boolean isCommitted;
    private MemoryCARW memory;

    public BlockFileWriter(FilesFacade ff, int commitMode) {
        assert (commitMode == 0 || commitMode == 2 || commitMode == 1);
        this.ff = ff;
        this.commitMode = commitMode;
    }

    public AppendableBlock append() {
        return this.blockMemoryHandle.reset(0);
    }

    @Override
    public void close() {
        Misc.free(this.memory);
        if (this.file != null) {
            this.file.close(false);
        }
        this.reset();
        this.isCommitted = false;
    }

    public void commit() {
        if (!this.blockMemoryHandle.isCommitted) {
            throw CairoException.critical(0).put("block must be committed before writer commit call");
        }
        if (this.isCommitted) {
            throw CairoException.critical(0).put("duplicate writer commit call");
        }
        long memoryBaseAddress = this.memory.getPageAddress(0);
        long checksumAddress = memoryBaseAddress + 8L + 4L;
        long checksumSize = this.blockOffset - 8L - 4L;
        int checksum = BlockFileUtils.checksum(checksumAddress, checksumSize);
        this.memory.putInt(0L, checksum);
        this.memory.putInt(4L, this.blockCount);
        long currentVersion = this.getVersionVolatile();
        long regionLength = this.blockOffset;
        long currentRegionOffset = this.getRegionOffset(currentVersion);
        long regionWriteOffset = regionLength <= currentRegionOffset ? 0L : currentRegionOffset + this.getRegionLength(currentVersion);
        this.file.jumpTo(regionWriteOffset + 40L + regionLength);
        long fileBaseAddress = this.file.getPageAddress(0);
        Vect.memcpy(fileBaseAddress + regionWriteOffset + 40L, memoryBaseAddress, regionLength);
        this.setRegionOffset(++currentVersion, regionWriteOffset);
        this.setRegionLength(currentVersion, regionLength);
        this.setVersionVolatile(currentVersion);
        if (this.commitMode != 2) {
            this.file.sync(this.commitMode == 0);
        }
        this.reset();
        this.isCommitted = true;
    }

    public long getRegionLength(long version) {
        return this.file.getLong(BlockFileUtils.getRegionLengthOffset(version));
    }

    public long getRegionOffset(long version) {
        return this.file.getLong(BlockFileUtils.getRegionOffsetOffset(version));
    }

    public long getVersionVolatile() {
        return Unsafe.getUnsafe().getLongVolatile(null, this.file.getPageAddress(0) + 0L);
    }

    public void of(LPSZ path) {
        this.of(path, this.ff.getPageSize());
    }

    public void of(LPSZ path, long pageSize) {
        this.close();
        if (this.file == null) {
            this.file = Vm.getCMARWInstance();
        }
        this.file.of(this.ff, path, pageSize, this.ff.length(path), 0, 0);
        if (this.memory == null) {
            this.memory = Vm.getCARWInstance(pageSize, Integer.MAX_VALUE, 19);
        }
        this.memory.jumpTo(8L);
        this.blockOffset = 8L;
        this.blockCount = 0;
    }

    public WritableBlock reserve(int bytes) {
        return this.blockMemoryHandle.reset(bytes);
    }

    private void reset() {
        this.blockOffset = 8L;
        this.blockCount = 0;
    }

    private void setRegionLength(long version, long length) {
        this.file.putLong(BlockFileUtils.getRegionLengthOffset(version), length);
    }

    private void setRegionOffset(long version, long offset) {
        this.file.putLong(BlockFileUtils.getRegionOffsetOffset(version), offset);
    }

    private void setVersionVolatile(long version) {
        Unsafe.getUnsafe().putLongVolatile(null, this.file.getPageAddress(0) + 0L, version);
    }

    private class BlockMemoryHandleImpl
    implements WritableBlock,
    AppendableBlock {
        private boolean isCommitted;
        private long payloadOffset;

        private BlockMemoryHandleImpl() {
        }

        @Override
        public void commit(int blockType) {
            if (this.isCommitted) {
                throw CairoException.critical(0).put("duplicate block commit call");
            }
            int blockLength = this.length() + 8;
            BlockFileWriter.this.memory.putInt(BlockFileWriter.this.blockOffset + 0L, blockLength);
            BlockFileWriter.this.memory.putInt(BlockFileWriter.this.blockOffset + 4L, blockType);
            BlockFileWriter.this.blockOffset += (long)blockLength;
            ++BlockFileWriter.this.blockCount;
            this.isCommitted = true;
        }

        @Override
        public int length() {
            long length = BlockFileWriter.this.memory.getAppendOffset() - this.payloadOffset;
            assert (length <= Integer.MAX_VALUE);
            return (int)length;
        }

        @Override
        public void putBin(long offset, BinarySequence value) {
            assert (!this.isCommitted);
            if (value != null) {
                long len = value.length();
                long addr = BlockFileWriter.this.memory.appendAddressFor(this.payloadOffset + offset, len + 8L);
                Unsafe.getUnsafe().putLong(addr, len);
                value.copyTo(addr + 8L, 0L, len);
            } else {
                BlockFileWriter.this.memory.putNullBin();
            }
        }

        @Override
        public long putBin(BinarySequence value) {
            assert (!this.isCommitted);
            return BlockFileWriter.this.memory.putBin(value);
        }

        @Override
        public void putBool(long offset, boolean value) {
            assert (!this.isCommitted);
            BlockFileWriter.this.memory.putBool(this.payloadOffset + offset, value);
        }

        @Override
        public void putBool(boolean value) {
            assert (!this.isCommitted);
            BlockFileWriter.this.memory.putBool(value);
        }

        @Override
        public void putByte(long offset, byte value) {
            assert (!this.isCommitted);
            BlockFileWriter.this.memory.putByte(this.payloadOffset + offset, value);
        }

        @Override
        public void putByte(byte value) {
            assert (!this.isCommitted);
            BlockFileWriter.this.memory.putByte(value);
        }

        @Override
        public void putChar(long offset, char value) {
            assert (!this.isCommitted);
            BlockFileWriter.this.memory.putChar(this.payloadOffset + offset, value);
        }

        @Override
        public void putChar(char value) {
            assert (!this.isCommitted);
            BlockFileWriter.this.memory.putChar(value);
        }

        @Override
        public void putDouble(long offset, double value) {
            assert (!this.isCommitted);
            BlockFileWriter.this.memory.putDouble(this.payloadOffset + offset, value);
        }

        @Override
        public void putDouble(double value) {
            assert (!this.isCommitted);
            BlockFileWriter.this.memory.putDouble(value);
        }

        @Override
        public void putFloat(long offset, float value) {
            assert (!this.isCommitted);
            BlockFileWriter.this.memory.putFloat(this.payloadOffset + offset, value);
        }

        @Override
        public void putFloat(float value) {
            assert (!this.isCommitted);
            BlockFileWriter.this.memory.putFloat(value);
        }

        @Override
        public void putInt(long offset, int value) {
            assert (!this.isCommitted);
            BlockFileWriter.this.memory.putInt(this.payloadOffset + offset, value);
        }

        @Override
        public void putInt(int value) {
            assert (!this.isCommitted);
            BlockFileWriter.this.memory.putInt(value);
        }

        @Override
        public void putLong(long offset, long value) {
            assert (!this.isCommitted);
            BlockFileWriter.this.memory.putLong(this.payloadOffset + offset, value);
        }

        @Override
        public void putLong(long value) {
            assert (!this.isCommitted);
            BlockFileWriter.this.memory.putLong(value);
        }

        @Override
        public void putShort(long offset, short value) {
            assert (!this.isCommitted);
            BlockFileWriter.this.memory.putShort(this.payloadOffset + offset, value);
        }

        @Override
        public void putShort(short value) {
            assert (!this.isCommitted);
            BlockFileWriter.this.memory.putShort(value);
        }

        @Override
        public void putStr(long offset, CharSequence value) {
            assert (!this.isCommitted);
            BlockFileWriter.this.memory.putStr(this.payloadOffset + offset, value);
        }

        @Override
        public long putStr(CharSequence value) {
            assert (!this.isCommitted);
            return BlockFileWriter.this.memory.putStr(value);
        }

        @Override
        public void putVarchar(long offset, @Nullable Utf8Sequence value) {
            assert (!this.isCommitted);
            long appendOffset = BlockFileWriter.this.memory.getAppendOffset();
            BlockFileWriter.this.memory.jumpTo(this.payloadOffset + offset);
            this.putVarchar(value);
            BlockFileWriter.this.memory.jumpTo(appendOffset);
        }

        @Override
        public long putVarchar(@Nullable Utf8Sequence value) {
            assert (!this.isCommitted);
            VarcharTypeDriver.appendPlainValue(BlockFileWriter.this.memory, value);
            return BlockFileWriter.this.memory.getAppendOffset();
        }

        public BlockMemoryHandleImpl reset(int length) {
            assert (length >= 0);
            BlockFileWriter.this.isCommitted = false;
            this.isCommitted = false;
            this.payloadOffset = BlockFileWriter.this.blockOffset + 8L;
            BlockFileWriter.this.memory.jumpTo(this.payloadOffset + (long)length);
            return this;
        }

        @Override
        public void skip(long bytes) {
            assert (!this.isCommitted);
            BlockFileWriter.this.memory.skip(bytes);
        }
    }
}

