/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.arr;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.BorrowedFlatArrayView;
import io.questdb.cairo.arr.MutableArray;
import io.questdb.cairo.vm.api.MemoryA;
import io.questdb.std.BinarySequence;
import io.questdb.std.IntList;
import io.questdb.std.Long256;
import io.questdb.std.Mutable;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.Utf8Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DirectArray
extends MutableArray
implements Mutable {
    private static final long DOUBLE_BYTES = 8L;
    private static final long LONG_BYTES = 8L;
    private static final int MEM_TAG = 67;
    private final CairoConfiguration configuration;
    private final FlatViewMemory flatViewMemory = new FlatViewMemory();
    private long ptr = 0L;
    private long size;

    public DirectArray(CairoConfiguration configuration) {
        this.flatView = new BorrowedFlatArrayView();
        this.configuration = configuration;
    }

    public DirectArray() {
        this.flatView = new BorrowedFlatArrayView();
        this.configuration = null;
    }

    public void applyShape() {
        this.applyShape(-1);
    }

    public void applyShape(int errorPosition) {
        short elemType = this.getElemType();
        int maxArrayElementCount = this.configuration != null ? this.configuration.maxArrayElementCount() : Integer.MAX_VALUE >> ColumnType.pow2SizeOf(elemType);
        this.resetToDefaultStrides(maxArrayElementCount, errorPosition);
        int byteSize = this.flatViewLength << ColumnType.pow2SizeOf(elemType);
        this.ensureSize(byteSize);
        this.borrowedFlatView().of(this.ptr, elemType, this.flatViewLength);
    }

    @Override
    public void clear() {
        this.strides.clear();
        this.flatViewLength = 0;
        this.borrowedFlatView().reset();
        int n = this.shape.size();
        for (int i = 0; i < n; ++i) {
            this.shape.set(i, 0);
        }
    }

    @Override
    public void close() {
        this.type = 0;
        this.ptr = Unsafe.free(this.ptr, this.size, 67);
        this.flatViewLength = 0;
        this.size = 0L;
        this.shape.clear();
        this.strides.clear();
        assert (this.ptr == 0L);
    }

    public MemoryA copyShapeAndStartMemoryA(ArrayView sourceArray) {
        this.setType(sourceArray.getType());
        this.copyShapeFrom(sourceArray);
        this.applyShape();
        return this.startMemoryA();
    }

    public IntList getShape() {
        return this.shape;
    }

    public void ofNull() {
        this.flatViewLength = 0;
        this.type = 33;
        this.borrowedFlatView().reset();
        this.shape.clear();
        this.strides.clear();
    }

    public long ptr() {
        return this.ptr;
    }

    public void putDouble(int flatIndex, double value) {
        assert (this.getElemType() == 10) : "putting DOUBLE to a non-DOUBLE array";
        assert (flatIndex >= 0) : "negative flatIndex";
        assert (this.ptr > 0L) : "ptr <= 0";
        long offset = (long)flatIndex * 8L;
        assert (this.size >= offset + 8L) : "size < offset + DOUBLE_BYTES";
        Unsafe.getUnsafe().putDouble(this.ptr + offset, value);
    }

    public void putLong(int flatIndex, long value) {
        assert (this.getElemType() == 6) : "putting LONG to a non-LONG array";
        assert (flatIndex >= 0 && flatIndex < this.flatViewLength) : "flatIndex out of bounds";
        long offset = (long)flatIndex * 8L;
        assert (this.size >= offset + 8L) : "size < offset + LONG_BYTES";
        Unsafe.getUnsafe().putLong(this.ptr + offset, value);
    }

    public MemoryA startMemoryA() {
        this.flatViewMemory.appendOffset = 0L;
        return this.flatViewMemory;
    }

    private void ensureSize(long requiredSize) {
        if (requiredSize <= this.size) {
            return;
        }
        if (this.ptr == 0L) {
            this.ptr = Unsafe.malloc(requiredSize, 67);
            Vect.memset(this.ptr, requiredSize, 0);
            this.size = requiredSize;
            return;
        }
        long newSize = this.size;
        while (newSize < requiredSize) {
            if ((newSize = newSize * 3L / 2L) >= 0L) continue;
            throw CairoException.nonCritical().put("array capacity overflow");
        }
        this.ptr = Unsafe.realloc(this.ptr, this.size, newSize, 67);
        long sizeToInitialize = newSize - this.size;
        assert (sizeToInitialize > 0L) : "shrinking array";
        Vect.memset(this.ptr + this.size, sizeToInitialize, 0);
        this.size = newSize;
    }

    private class FlatViewMemory
    implements MemoryA {
        long appendOffset;

        private FlatViewMemory() {
        }

        @Override
        public void close() {
        }

        @Override
        public long getAppendOffset() {
            return this.appendOffset;
        }

        @Override
        public long getExtendSegmentSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void jumpTo(long offset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putArray(ArrayView array) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long putBin(BinarySequence value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long putBin(long from, long len) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putBlockOfBytes(long from, long len) {
            assert (DirectArray.this.ptr != 0L) : "ptr == 0";
            assert (len >= 0L) : "len < 0";
            assert (this.appendOffset <= DirectArray.this.size - len) : "appending beyond limit";
            Vect.memcpy(DirectArray.this.ptr + this.appendOffset, from, len);
            this.appendOffset += len;
        }

        @Override
        public void putBool(boolean value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putByte(byte value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putChar(char value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putDouble(double value) {
            assert (DirectArray.this.ptr != 0L) : "ptr == 0";
            assert (this.appendOffset <= DirectArray.this.size - 8L) : "appending beyond limit";
            Unsafe.getUnsafe().putDouble(DirectArray.this.ptr + this.appendOffset, value);
            this.appendOffset += 8L;
        }

        @Override
        public void putFloat(float value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putInt(int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putLong(long value) {
            assert (DirectArray.this.ptr != 0L) : "ptr == 0";
            assert (this.appendOffset <= DirectArray.this.size - 8L) : "appending beyond limit";
            Unsafe.getUnsafe().putLong(DirectArray.this.ptr + this.appendOffset, value);
            this.appendOffset += 8L;
        }

        @Override
        public void putLong128(long lo, long hi) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putLong256(long l0, long l1, long l2, long l3) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putLong256(Long256 value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putLong256(@Nullable CharSequence hexString) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putLong256(@NotNull CharSequence hexString, int start, int end) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putLong256Utf8(@Nullable Utf8Sequence hexString) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long putNullBin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long putNullStr() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putShort(short value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long putStr(CharSequence value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long putStr(char value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long putStr(CharSequence value, int pos, int len) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long putStrUtf8(DirectUtf8Sequence value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long putVarchar(@NotNull Utf8Sequence value, int lo, int hi) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void skip(long bytes) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void truncate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void zeroMem(int length) {
            throw new UnsupportedOperationException();
        }
    }
}

